<?php
function getItemObj() {
    global $username;
    global $password;
    global $database;
    $z=0;
    $db = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");
    $itemArray =array();
    $stm1 = $db->prepare("SELECT item_id,item_code,name,short_description,long_description,thumbnail_url,item_sku,status FROM Items WHERE item_code='EASY-001-10001' LIMIT 1");
    $stm1-> execute();
    $stm1-> bind_result($itemID,$item_code,$itemName,$shortDes,$des,$imgName,$itemSKU,$status);
    while ($stm1->fetch()) {
        $imagesUrl = getImageForItem($itemID);

        $priceItem = getItemPrice(1,$itemID);
        $stockQty   = getStockItem($itemID);
        if (strcmp($status,'inactive')==0){
            $statusWoocommerce = 'hidden';
        }else{
            $statusWoocommerce = 'visible';
        }

        $itemObj = new stdClass();
        $itemObj->id    = $itemID;
        $itemObj->code  = $item_code;
            $data = array();
            $data["name"] = $itemName;
            $data["type"] = 'simple';
            $data["regular_price"] = "$priceItem";
            $data["description"] = $des;
            $data["short_description"] = $shortDes;
            $data["sku"] = $item_code;
            $data["stock_quantity"] = $stockQty;
            $data["stock_status"] = 'instock';
            $data["categories"] = [];
            $data["images"] = $imagesUrl;
            $data["catalog_visibility"] = $statusWoocommerce;
        $itemObj->data = $data;
        array_push($itemArray,$itemObj);
    }
    $stm1->close();
    return $itemArray;
}

function getImageForItem($itemID){
    global $username;
    global $password;
    global $database;
    $db1 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $imagesUrl = array();
    $stm1 = $db1->prepare("SELECT image_name FROM Item_Images WHERE  item_id='$itemID'");
    $stm1-> execute();
    $stm1-> bind_result($imgName);
    while ($stm1->fetch()) {
        if(strcmp($imgName,'')!=0) {
            $imgUrl = "https://".HTML_PATH."/cop/media/productImages/$imgName.jpg";
            $objImg = array();
            $objImg["src"] = $imgUrl;
            array_push($imagesUrl,$objImg);
        }
    }
    $stm1->close();
    return $imagesUrl;
}
function viewArray($arr){
    echo "<pre>";
    var_dump($arr);
    echo "</pre>";
}

function getStockItem($itemID){
    global $username;
    global $password;
    global $database;
    $stockReturn = 0;
    $db1 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $stm1 = $db1->prepare("SELECT available,reserved FROM Stock WHERE  item_id='$itemID' LIMIT 1");
    $stm1-> execute();
    $stm1-> bind_result($available,$reserved);
    while ($stm1->fetch()) {
        $stockReturn = $available-$reserved;
    }
    $stm1->close();
    return $stockReturn;
}

function getItemPrice($priceCode,$itemID) {
    global $username;
    global $password;
    global $database;
    $z=0;
    $db1 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");
    $stm1 = $db1->prepare("SELECT price FROM Prices WHERE pricetype_id='$priceCode' AND item_id='$itemID' LIMIT 1");
    $stm1-> execute();
    $stm1-> bind_result($counter);
    while ($stm1->fetch()) {
        $z=$counter;
    }
    $stm1->close();
    return $z;
}

function getWoocommerceItem($itemID){
    global $username;
    global $password;
    global $database;
    $z=0;
    $db1 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $woocommerce_item_id = 0;
    $stm1 = $db1->prepare("SELECT woocommerce_item_id FROM ZZ_Woocommerce_Items_Export WHERE item_id='$itemID' LIMIT 1");
    $stm1-> execute();
    $stm1-> bind_result($woocommerce_item_id);
    while ($stm1->fetch()) {}
    $stm1->close();
    return $woocommerce_item_id;
}

function insertItemWoocommerce($itemID,$response,$itemCode){
    global $username;
    global $password;
    global $database;
    $z=0;
    $db = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");

    $jsonDecode = json_decode($response);
    $woocommerceID = $jsonDecode->id;
    try {
        $db->begin_transaction();
        $stmt = $db->prepare("INSERT INTO ZZ_Woocommerce_Items_Export (item_id,woocommerce_item_id,item_code,timestamp)  VALUES(?,?,?,NOW())");
        $stmt->bind_param('iis',$itemID,$woocommerceID,$itemCode);
        $stmt->execute();
        if(strcmp($stmt->error,"")!=0) {throw new Exception();}
        $stmt->close();

        $db->commit(true);
        echo "ok";
    } catch (Exception  $e) {
        echo -1;
        $db->rollback();
    }
}
function getResponse($response){
    $jsonDecode = json_decode($response);
    if (isset($jsonDecode->id) && strcmp("$jsonDecode->id",'')!=0){
        $response = 'Success';
    }else{
        $response = "Failed ".$jsonDecode->message;
    }
    return $response;
}

function itemExists($getwoocommerceItemResponse){
    $jsonDecode = json_decode($getwoocommerceItemResponse);
    if (isset($jsonDecode->id) && strcmp("$jsonDecode->id",'')!=0 && strcmp("$jsonDecode->status",'trash')!=0){
        $response = true;
    }else{
        $response = false;
    }
    return $response;
}

function deleteItem($itemID,$woocommerceItemID){
    global $username;
    global $password;
    global $database;
    $z=0;
    $db = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");

    try {
        $db->begin_transaction();

        $stmt = $db->prepare("DELETE FROM ZZ_Woocommerce_Items_Export WHERE item_id=? AND woocommerce_item_id=?");
        $stmt->bind_param('ii',$itemID,$woocommerceItemID);
        $stmt->execute();
        if(strcmp($stmt->error,"")!=0) {throw new Exception();}
        $stmt->close();

        $db->commit(true);
        echo "ok";
    } catch (Exception  $e) {
        echo 0;
        $db->rollback();
    }
}

?>