<?php
require_once('../BasicAuthClient.php');
require_once('../../../backend/core/model/Database.php');

require_once('../../../backend/core/model/Order.php');
require_once('../../../backend/core/model/OrderItem.php');
require_once('../../../backend/core/model/Item.php');
require_once('../../../backend/core/model/Customer.php');
require_once('../../../backend/core/model/DocumentStatus.php');


function outboundOrders($db, $client)
{
    $orders = $db->getDocumentForExports("Orders", true, "AND order_id > 0 LIMIT 1 ");

    foreach ($orders as $order){
        $customer = $db->getCustomerObjectByID($order->customerID);

        if(strcmp($customer->typeOfBusiness,'LeadERP')==0){
            // send activation
            $activation = new stdClass();
            $activation->DEXT_COPRIMEACTIVE  = 'Y';
            $tempCustomerResponse = $client->sendPatchData("CUSTOMERS('$customer->customerCode')",json_encode($activation));
            $client->complete();

            $newCustomerResponse = $client->requestData('CUSTOMERS?$filter=DEXT_COPRIMENUM%20eq%20\''.$customer->customerCode.'\'');
            $updatedCustomer = $newCustomerResponse->value[0];

            $db->displayObject($updatedCustomer);

            if(strcmp($updatedCustomer->CUSTNAME,'')!=0) {
                $customer->setCustomerCode($updatedCustomer->CUSTNAME);
                $customer->setTypeOfBusiness("$customer->typeOfCustomer");
                $client->log($db->updateCustomerByObjectID($customer, $excludeUpdateColumns = array(), $deleteRecordsNotSent = array()));
                $client->complete();
            }

        }

        $data = new stdClass();
        $data->BOOKNUM      = $order->orderCode;
        $data->CUSTNAME     = $customer->customerCode;
        $data->CURDATE      = $order->orderDate;
        $data->ORDERITEMS_SUBFORM   = array();

        foreach ($order->orderItems as $orderLine) {

            $item = $db->getItemObjectByID($orderLine->itemID);

            $dataItem = new stdClass();
            $dataItem->PARTNAME = $item->itemCode;
            $dataItem->TQUANT   = (float)$orderLine->qty;
            $dataItem->DUEDATE  = $order->orderDate;
            array_push($data->ORDERITEMS_SUBFORM,$dataItem);
        }

        $dataResponse = $client->sendPostData("ORDERS",json_encode($data));

//        if(strcmp($dataResponse->ORDNAME,'')!=0){
//            $client->complete();
//            $confirmation = new stdClass();
//            $confirmation->ORDSTATUSDES  = 'Confirmed';
//            $dataResponse = $client->sendPatchData("ORDERS('$dataResponse->ORDNAME')",json_encode($confirmation));
//        }


        $erpDocumentCode = $dataResponse->ORDNAME;

        if(strcmp($erpDocumentCode,'')!=0){
            $erpErrorStatus = 1;
            $erpErrorMessage = "OK";
        } else {
            $erpErrorStatus = -1;
            $erpErrorMessage = json_encode($dataResponse);
        }

        $documentStatus = new DocumentStatus(
            $id         = $order->orderID,
            $table      = $db->getDocumentStatusTypeByTable("Orders"),
            $status     = $erpErrorStatus,
            $reason     = $erpErrorMessage,
            $exportID   = 0,
            $exportCode = $erpDocumentCode
        );

        $client->log($db->insertUpdateDocumentStatusByObject($documentStatus));
        $client->complete();

    }



}



?>
