<?php

require_once('../../../backend/core/model/Item.php');
require_once('../../../backend/core/model/Category.php');
require_once('../../../backend/core/model/ItemBarcode.php');

function inboundItems($db,$client){

    $filter = '?$since='.$client->getDateFilter().'T00:00:00%2B02:00';
    $filter = str_replace(' ','%20', $filter);

    $response = $client->requestData('LOGPART'.$filter);

    $response = inboundItemsAfterRequestDataBeforeEnteringForeach($response);

    foreach ($response->value as $data){

        $data = inboundItemsAfterForeachLoopBeforeItemObjectCreation($data);

        $itemStatus = 'inactive';
        if(strcmp($data->STATDES,'In Use')==0){$itemStatus='yes';}

        $item = new Item(
            $itemID           = "",
            $itemCode         = "$data->PARTNAME",
            $itemSKU          = "$data->BARCODE",
            $companyID        = "1",
            $vatID            = "1",
            $subunits         = "1",
            $salesUnits       = "$data->UNITNAME",
            $manufacturerID   = "0",
            $name             = "$data->PARTDES",
            $shortDescription = "$data->EPARTDES",
            $longDescription  = "",
            $thumbnailUrl     = "",
            $reorderLevel     = "",
            $targetQty        = "",
            $bundle           = "",
            $maxStock         = "",
            $minStock         = "",
            $packing          = "",
            $stockControl     = "yes",
            $sellable         = "yes",
            $weight           = "$data->MINPRICE",
            $cbm              = "",
            $status           = "$itemStatus"
        );
        $item->addItemCategory(
            new Category(
                $categoryID         = "",
                $categoryCode       = "$data->FAMILY",
                $categoryName       = "$data->FAMILY",
                $description        = "FAMILY",
                $creationDate       = date('Y-m-d'),
                $allowSubcategories = "yes",
                $allowItems         = "yes",
                $level              = "1",
                $customOrder        = "0"
            )
        );


        $item->addItemBarcode(
            new ItemBarcode(
                $barcodeItem    = $item,
                $barcode        = "$data->BARCODE",
                $multiplier     = "1",
                $defaultBarcode = "yes"
            )
        );


        $excludeUpdateColumns = array(
            'Items'        => array('thumbnail_url','vat_id'),
            'Categories'   => array('name','custom_order','level','creation_date'),
            'Item_Barcode' => array()
        );


        $deleteRecordsNotSent = array(
            'Categories'   => true,
            'Item_Barcode' => true
        );


        $item = inboundItemsAfterObjectCreationBeforeDbInsert($data,$item);
        $excludeUpdateColumns = inboundItemsExcludeUpdateColumns($data,$excludeUpdateColumns);
        $deleteRecordsNotSent = inboundItemsDeleteRecordsNotSent($data,$deleteRecordsNotSent);

        $client->log($db->insertUpdateItemByObject($item,$excludeUpdateColumns,$deleteRecordsNotSent),'ITEM');

        $data = inboundItemsAfterItemDbInsertBeforeItemImageDbInsert($data,$item);

        if(strcmp($data->EXTFILENAME,'')!=0) {
            $client->log($db->insertUpdateItemImageByBase64String($db->getItemObjectByCode("$data->PARTNAME")->itemID,"$data->PARTNAME","$data->EXTFILENAME"),'IMAGE');
        }
        $data = inboundItemsAfterItemImageDbInsertBeforeNextItemLoop($data,$item);

        echo "<p>TEST BREAK</p>";
        break;
    }

    $client->complete();
}


/**
 * custom Functions
 */


function inboundItemsAfterObjectCreationBeforeDbInsert($data,$item){
    global $db;
    global $client;

    $file = includeCustomFunctionFile(__FUNCTION__,'inboundCustomCodeTemplates');
    if($file !== false){include "$file";}

    return $item;
}

function inboundItemsAfterItemDbInsertBeforeItemImageDbInsert($data,$item){
    global $db;
    global $client;

    $file = includeCustomFunctionFile(__FUNCTION__,'inboundCustomCodeTemplates');
    if($file !== false){include "$file";}

    return $data;
}

function inboundItemsAfterItemImageDbInsertBeforeNextItemLoop($data,$item){
    global $db;
    global $client;

    $file = includeCustomFunctionFile(__FUNCTION__,'inboundCustomCodeTemplates');
    if($file !== false){include "$file";}

    return $data;
}

function inboundItemsExcludeUpdateColumns($data,$excludeUpdateColumns){
    global $db;
    global $client;

    $file = includeCustomFunctionFile(__FUNCTION__,'inboundCustomCodeTemplates');
    if($file !== false){include "$file";}

    return $excludeUpdateColumns;
}

function inboundItemsDeleteRecordsNotSent($data,$deleteRecordsNotSent){
    global $db;
    global $client;

    $file = includeCustomFunctionFile(__FUNCTION__,'inboundCustomCodeTemplates');
    if($file !== false){include "$file";}

    return $deleteRecordsNotSent;
}

function inboundItemsAfterRequestDataBeforeEnteringForeach($response){
    global $db;
    global $client;

    $file = includeCustomFunctionFile(__FUNCTION__,'inboundCustomCodeTemplates');
    if($file !== false){include "$file";}

    return $response;
}

function inboundItemsAfterForeachLoopBeforeItemObjectCreation($data){
    global $db;
    global $client;

    $file = includeCustomFunctionFile(__FUNCTION__,'inboundCustomCodeTemplates');
    if($file !== false){include "$file";}

    return $data;
}



?>