<?php
//ini_set('display_errors', 1);
//ini_set('display_startup_errors', 1);
//error_reporting(E_ALL);
require_once('../../../backend/core/model/Item.php');
require_once('../../../backend/core/model/Vat.php');
require_once('../../../backend/core/model/Category.php');
require_once('../../../backend/core/model/ItemBarcode.php');
require_once('../../../backend/core/model/PriceType.php');
require_once('../../../backend/core/model/ItemPrice.php');

function inboundItems(Database $db, AuthTokenClient $client){

    $filters = array('Company' => $client->getCompanyCode(), 'LastSyncDate' =>$client->getDateFilter().'T00:00:00');
    $filters = json_encode($filters);

    $response = $client->requestData('Items',$filters);

    $response = inboundItemsAfterRequestDataBeforeEnteringForeach($response);

    foreach ($response->stkItemsList as $data){

        $data = inboundItemsAfterForeachLoopBeforeItemObjectCreation($data);

        $vatID = $db->getVatObjectByCode($data->VatCode)->vatID;

        if((int)$vatID == 0) {
            $vat = new Vat(
                $vatID = "",
                $vatCode = "$data->VatCode",
                $vatDisplayName = "VAT $data->VatRate%",
                $percentage = "$data->VatRate"
            );

            $excludeUpdateColumns = array('Vats' => array('vat_display_name'));
            $deleteRecordsNotSent = array();

            $client->log($db->insertUpdateVatByObject($vat, $excludeUpdateColumns, $deleteRecordsNotSent));

            $vatID = $db->getVatObjectByCode($data->VatCode)->vatID;
        }





        if($data->NonStock == false){$stockControl='no';}else{$stockControl='yes';}
        if($data->Stopped == false){$itemStatus='yes';}else{$itemStatus='inactive';}

        $item = new Item(
            $itemID           = "",
            $itemCode         = "$data->Code",
            $itemSKU          = "$data->ShortCode",
            $companyID        = "1",
            $vatID            = "$vatID",
            $subunits         = "$data->Subunits",
            $salesUnits       = "$data->UOM",
            $manufacturerID   = "0",
            $name             = "$data->Desc1",
            $shortDescription = "$data->Notes",
            $longDescription  = "",
            $thumbnailUrl     = "",
            $reorderLevel     = "",
            $targetQty        = "",
            $bundle           = "",
            $maxStock         = "",
            $minStock         = "",
            $packing          = "",
            $stockControl     = "$stockControl",
            $sellable         = "yes",
            $weight           = "$data->Weight",
            $cbm              = "",
            $status           = "$itemStatus"
        );

        if(strcmp($data->Level1,'')!=0){
            $item->addItemCategory($db->getCategoryObjectByCode("L1".$data->Level1));
        }
        if(strcmp($data->Level2,'')!=0){
            $item->addItemCategory($db->getCategoryObjectByCode("L2".$data->Level2));
        }
        if(strcmp($data->Level3,'')!=0){
            $item->addItemCategory($db->getCategoryObjectByCode("L3".$data->Level3));
        }
        if(strcmp($data->Level4,'')!=0){
            $item->addItemCategory($db->getCategoryObjectByCode("L4".$data->Level4));
        }
        if(strcmp($data->Level5,'')!=0){
            $item->addItemCategory($db->getCategoryObjectByCode("L5".$data->Level5));
        }
        if(strcmp($data->Level6,'')!=0){
            $item->addItemCategory($db->getCategoryObjectByCode("L6".$data->Level6));
        }
        if(strcmp($data->Level7,'')!=0){
            $item->addItemCategory($db->getCategoryObjectByCode("L7".$data->Level7));
        }
        if(strcmp($data->Level8,'')!=0){
            $item->addItemCategory($db->getCategoryObjectByCode("L8".$data->Level8));
        }
        if(strcmp($data->Level9,'')!=0){
            $item->addItemCategory($db->getCategoryObjectByCode("L9".$data->Level9));
        }
        if(strcmp(trim($data->ItemGroupDisc),'')!=0){
            $item->addItemCategory(
                new Category(
                    $categoryID = "",
                    $categoryCode = "$data->ItemGroupDisc",
                    $categoryName = "$data->ItemGroupDisc",
                    $description = "ItemGroupDisc",
                    $creationDate = "",
                    $allowSubcategories = "yes",
                    $allowItems = "yes",
                    $level = "0",
                    $customOrder = "0"
                )
            );
        }

        if(strcmp(trim($data->Barcode),'')!=0) {
            $item->addItemBarcode(
                new ItemBarcode(
                    $barcodeItem = $item,
                    $barcode = "$data->Barcode",
                    $multiplier = "1",
                    $defaultBarcode = "yes"
                )
            );
        }


        $excludeUpdateColumns = array(
            'Items'        => array('thumbnail_url'),
            'Categories'   => array('name','custom_order','level','creation_date'),
            'Item_Barcode' => array()
        );


        $deleteRecordsNotSent = array(
            'Categories'   => true,
            'Item_Barcode' => true
        );


        $item = inboundItemsAfterObjectCreationBeforeDbInsert($data,$item);
        $excludeUpdateColumns = inboundItemsExcludeUpdateColumns($data,$excludeUpdateColumns);
        $deleteRecordsNotSent = inboundItemsDeleteRecordsNotSent($data,$deleteRecordsNotSent);

        $client->log($db->insertUpdateItemByObject($item,$excludeUpdateColumns,$deleteRecordsNotSent),'ITEM');

        $itemObject = $db->getItemObjectByCode("$item->itemCode");

        if($itemObject->itemID > 0) {
            if (strcmp($data->Price1, '') != 0) {
                addEsoftFixedPrice($db, $client, $itemObject, $data->Price1, '1');
            }

            if (strcmp($data->Price2, '') != 0) {
                addEsoftFixedPrice($db, $client, $itemObject, $data->Price2, '2');
            }

            if (strcmp($data->Price3, '') != 0) {
                addEsoftFixedPrice($db, $client, $itemObject, $data->Price3, '3');
            }

            if (strcmp($data->Price4, '') != 0) {
                addEsoftFixedPrice($db, $client, $itemObject, $data->Price4, '4');
            }

            if (strcmp($data->Price5, '') != 0) {
                addEsoftFixedPrice($db, $client, $itemObject, $data->Price5, '5');
            }

            if (strcmp($data->Price6, '') != 0) {
                addEsoftFixedPrice($db, $client, $itemObject, $data->Price6, '6');
            }

            if (strcmp($data->Price7, '') != 0) {
                addEsoftFixedPrice($db, $client, $itemObject, $data->Price7, '7');
            }

            if (strcmp($data->Price8, '') != 0) {
                addEsoftFixedPrice($db, $client, $itemObject, $data->Price8, '8');
            }

            if (strcmp($data->Price9, '') != 0) {
                addEsoftFixedPrice($db, $client, $itemObject, $data->Price9, '9');
            }
        }

    }

    $client->complete();
}


/**
 * custom Functions
 */


function inboundItemsAfterObjectCreationBeforeDbInsert($data,$item){
    global $db;
    global $client;

    $file = includeCustomFunctionFile(__FUNCTION__,'inboundCustomCodeTemplates');
    if($file !== false){include "$file";}

    return $item;
}


function inboundItemsExcludeUpdateColumns($data,$excludeUpdateColumns){
    global $db;
    global $client;

    $file = includeCustomFunctionFile(__FUNCTION__,'inboundCustomCodeTemplates');
    if($file !== false){include "$file";}

    return $excludeUpdateColumns;
}

function inboundItemsDeleteRecordsNotSent($data,$deleteRecordsNotSent){
    global $db;
    global $client;

    $file = includeCustomFunctionFile(__FUNCTION__,'inboundCustomCodeTemplates');
    if($file !== false){include "$file";}

    return $deleteRecordsNotSent;
}

function inboundItemsAfterRequestDataBeforeEnteringForeach($response){
    global $db;
    global $client;

    $file = includeCustomFunctionFile(__FUNCTION__,'inboundCustomCodeTemplates');
    if($file !== false){include "$file";}

    return $response;
}

function inboundItemsAfterForeachLoopBeforeItemObjectCreation($data){
    global $db;
    global $client;

    $file = includeCustomFunctionFile(__FUNCTION__,'inboundCustomCodeTemplates');
    if($file !== false){include "$file";}

    return $data;
}

function addEsoftFixedPrice($db,$client,$itemObject,$price,$priceCode){

    $priceTypeObject = $db->getPriceTypeObjectByCode("$price");

    if((int)$priceTypeObject->priceTypeID == 0){

        $priceType = new PriceType(
            $priceTypeID   = "",
            $priceCode     = "$priceCode",
            $name          = "Price $priceCode",
            $allowDiscount = "",
            $defaultType   = ""
        );

        $excludeUpdateColumns = array('PriceTypes' => array('default_type'));
        $deleteRecordsNotSent = array();

        $client->log($db->insertUpdatePriceTypeByObject($priceType,$excludeUpdateColumns,$deleteRecordsNotSent));

        $priceTypeObject = $db->getPriceTypeObjectByCode("$priceCode");

    }

    $itemPrice = new ItemPrice(
        $item          = $itemObject,
        $priceType     = $priceTypeObject,
        $price         = "$price",
        $allowDiscount = "",
        $incVat        = "no"
    );

    $excludeUpdateColumns = array('Prices' => array());
    $deleteRecordsNotSent = array();

    $client->log($db->insertUpdateItemPriceByObject($itemPrice,$excludeUpdateColumns,$deleteRecordsNotSent));


}



?>