<?php
require_once('../../../backend/core/model/Customer.php');
require_once('../../../backend/core/model/CustomerAddress.php');
require_once('../../../backend/core/model/CustomerGroup.php');
require_once('../../../backend/core/model/PaymentType.php');
require_once('../../../backend/core/model/Schedule.php');
require_once('../../../backend/core/model/ScheduleCustomer.php');
require_once('../../../backend/core/model/ContactPerson.php');
require_once('../../../backend/core/model/Supplier.php');
require_once('../../../backend/core/model/SupplierAddress.php');



function inboundCustomers(Database $db, AuthTokenClient $client)
{

    $filters = array('Company' => $client->getCompanyCode(), 'LastSyncDate' =>$client->getDateFilter().'T00:00:00');
    $filters = json_encode($filters);

    $response = $client->requestData('AccAccounts',$filters);

    foreach ($response->AccountsList as $data){

        if (strpos($data->AccountType, "32")!==false) {

            $balanceFilters = array('Company' => $client->getCompanyCode(), 'AccountCode' => $data->Code);
            $balance = $client->requestData('AccountBalance',$balanceFilters,false)->AccountBalance;

            $typeOfBusinessValue = 'Credit';
            if(strcmp($data->AccountType,'')!=0){$typeOfBusinessValue=$data->AccountType;}

            $customer = new Customer(
                $customerID          = "",
                $customerCode        = "$data->Code",
                $companyName         = "$data->Name1",
                $reportName          = "$data->Name2",
                $logo                = "",
                $registrationCode    = "",
                $mobile              = "",
                $website             = "$data->AccountShort",
                $email               = "",
                $description         = "$data->Notes",
                $typeOfBusiness      = "$typeOfBusinessValue",
                $ticCode             = "",
                $vatCode             = "",
                $creditLimit         = "",
                $typeOfCustomer      = "Credit",
                $balance             = "$balance",
                $addressCodeEurosoft = "$data->AccountType"
            );


            $customer->addCustomerAddress(
                new CustomerAddress(
                    $addressID      = "",
                    $addressCode    = "$data->Code",
                    $customerID     = "",
                    $country        = "".$data->Address->DelCountry,
                    $city           = "".$data->Address->DelCity,
                    $addressLine1   = "".$data->Address->DellAddress1,
                    $addressLine2   = "".$data->Address->DellAddress2,
                    $postcode       = "".$data->Address->DelPostCode,
                    $region         = "".$data->Address->DelTown,
                    $lat            = "",
                    $lng            = "",
                    $pobox          = "".$data->Address->POBOX,
                    $landline       = "".$data->Address->MobilePhone,
                    $fax            = "".$data->Address->Fax,
                    $primaryAddress = "yes"
                )
            );

            $customer->setEmail($data->Address->Email);
            $customer->setMobile($data->Address->WorkPhone);

            if(strcmp(trim($data->AccGroup1),'')!=0) {$customer->addCustomerGroup($db->getCustomerGroupObjectByCode('G1'.$data->AccGroup1));}
            if(strcmp(trim($data->AccGroup2),'')!=0) {$customer->addCustomerGroup($db->getCustomerGroupObjectByCode('G2'.$data->AccGroup2));}
            if(strcmp(trim($data->AccGroup3),'')!=0) {$customer->addCustomerGroup($db->getCustomerGroupObjectByCode('G3'.$data->AccGroup3));}
            if(strcmp(trim($data->AccGroup4),'')!=0) {$customer->addCustomerGroup($db->getCustomerGroupObjectByCode('G4'.$data->AccGroup4));}
            if(strcmp(trim($data->AccGroup5),'')!=0) {$customer->addCustomerGroup($db->getCustomerGroupObjectByCode('G5'.$data->AccGroup5));}
            if(strcmp(trim($data->AccGroup6),'')!=0) {$customer->addCustomerGroup($db->getCustomerGroupObjectByCode('G6'.$data->AccGroup6));}
            if(strcmp(trim($data->AccGroup7),'')!=0) {$customer->addCustomerGroup($db->getCustomerGroupObjectByCode('G7'.$data->AccGroup7));}
            if(strcmp(trim($data->AccGroup8),'')!=0) {$customer->addCustomerGroup($db->getCustomerGroupObjectByCode('G8'.$data->AccGroup8));}
            if(strcmp(trim($data->AccGroup9),'')!=0) {$customer->addCustomerGroup($db->getCustomerGroupObjectByCode('G9'.$data->AccGroup9));}
            if(strcmp(trim($data->AccGroup10),'')!=0) {$customer->addCustomerGroup($db->getCustomerGroupObjectByCode('G10'.$data->AccGroup10));}
            if(strcmp(trim($data->AccGroup11),'')!=0) {$customer->addCustomerGroup($db->getCustomerGroupObjectByCode('G11'.$data->AccGroup11));}
            if(strcmp(trim($data->AccGroup12),'')!=0) {$customer->addCustomerGroup($db->getCustomerGroupObjectByCode('G12'.$data->AccGroup12));}
            if(strcmp(trim($data->AccGroup13),'')!=0) {$customer->addCustomerGroup($db->getCustomerGroupObjectByCode('G13'.$data->AccGroup13));}
            if(strcmp(trim($data->AccGroup14),'')!=0) {$customer->addCustomerGroup($db->getCustomerGroupObjectByCode('G14'.$data->AccGroup14));}
            if(strcmp(trim($data->AccGroup15),'')!=0) {$customer->addCustomerGroup($db->getCustomerGroupObjectByCode('G15'.$data->AccGroup15));}
            if(strcmp(trim($data->AccGroup16),'')!=0) {$customer->addCustomerGroup($db->getCustomerGroupObjectByCode('G16'.$data->AccGroup16));}
            if(strcmp(trim($data->AccGroup17),'')!=0) {$customer->addCustomerGroup($db->getCustomerGroupObjectByCode('G17'.$data->AccGroup17));}
            if(strcmp(trim($data->AccGroup18),'')!=0) {$customer->addCustomerGroup($db->getCustomerGroupObjectByCode('G18'.$data->AccGroup18));}
            if(strcmp(trim($data->AccGroup19),'')!=0) {$customer->addCustomerGroup($db->getCustomerGroupObjectByCode('G19'.$data->AccGroup19));}
            if(strcmp(trim($data->AccGroup20),'')!=0) {$customer->addCustomerGroup($db->getCustomerGroupObjectByCode('G20'.$data->AccGroup20));}

            if(strcmp(trim($data->AccountGroupDisc),'')!=0) {
                $customer->addCustomerGroup(
                    new CustomerGroup(
                        $groupID = "",
                        $groupCode = "$data->AccountGroupDisc",
                        $name = "$data->AccountGroupDisc",
                        $description = "AccountGroupDisc",
                        $creationDate = ""
                    )
                );
            }

            $excludeUpdateColumns = array(
                'Customers'       => array('balance'),
                'CustomerAddress' => array('lat','lng'),
                'CustomerGroups'  => array('creation_date')
            );


            $deleteRecordsNotSent = array(
                'CustomerAddress' => true,
                'CustomerGroups'  => true
            );

            $client->log($db->insertUpdateCustomerByObject($customer,$excludeUpdateColumns,$deleteRecordsNotSent),'CUSTOMERS');

            $data = inboundCustomersAfterDbInsertBeforeNextCustomerLoop($data,$customer);

        }
        else if (strpos($data->AccountType, "42")!==false) {

            $balanceFilters = array('Company' => $client->getCompanyCode(), 'AccountCode' => $data->Code);
            $balance = $client->requestData('AccountBalance',$balanceFilters,false)->AccountBalance;

            $typeOfBusinessValue = 'Credit';
            if(strcmp($data->AccountType,'')!=0){$typeOfBusinessValue=$data->AccountType;}

            $supplier = new Supplier(
                $customerID          = "",
                $customerCode        = "$data->Code",
                $companyName         = "$data->Name1",
                $reportName          = "$data->Name2",
                $logo                = "",
                $registrationCode    = "",
                $mobile              = "",
                $website             = "$data->AccountShort",
                $email               = "",
                $description         = "$data->Notes",
                $typeOfBusiness      = "$typeOfBusinessValue",
                $ticCode             = "",
                $vatCode             = "",
                $creditLimit         = "",
                $typeOfCustomer      = "Credit",
                $balance             = "$balance"
            );


            $supplier->addSupplierAddress(
                new CustomerAddress(
                    $addressID      = "",
                    $addressCode    = "$data->Code",
                    $supplierID     = "",
                    $country        = "".$data->Address->DelCountry,
                    $city           = "".$data->Address->DelCity,
                    $addressLine1   = "".$data->Address->DellAddress1,
                    $addressLine2   = "".$data->Address->DellAddress2,
                    $postcode       = "".$data->Address->DelPostCode,
                    $region         = "".$data->Address->DelTown,
                    $lat            = "",
                    $lng            = "",
                    $pobox          = "".$data->Address->POBOX,
                    $landline       = "".$data->Address->MobilePhone,
                    $fax            = "".$data->Address->Fax,
                    $primaryAddress = "yes"
                )
            );

            $supplier->setEmail($data->Address->Email);
            $supplier->setMobile($data->Address->WorkPhone);


            $excludeUpdateColumns = array(
                'Suppliers'       => array('balance'),
                'SupplierAddress' => array('lat','lng'),
            );


            $deleteRecordsNotSent = array(
                'SupplierAddress' => true
            );

            $client->log($db->insertUpdateSupplierByObject($supplier,$excludeUpdateColumns,$deleteRecordsNotSent),'SUPPLIERS');

            $data = inboundCustomersAfterDbInsertBeforeNextCustomerLoop($data,$supplier);

        }

    }

    $client->complete();
}

/**
 * custom Functions
 */

function inboundCustomersAfterDbInsertBeforeNextCustomerLoop($data,$customer){
    global $db;
    global $client;

    $file = includeCustomFunctionFile(__FUNCTION__,'inboundCustomCodeTemplates');
    if($file !== false){include "$file";}

    return $data;
}

?>