<?php
include_once("../../../../param.php");

global  $username,$password,$database;
$db = new mysqli(localhost,$username,$password,$database);
if (mysqli_connect_errno())
{
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");
$salespersonWithoutCloudOptions = "<option value=''></option>";
$stmt = $db->prepare("SELECT salesperson_id,salesperson_code,first_name,last_name FROM SalesPersons WHERE salesperson_id NOT IN (SELECT id FROM Admin) AND salesperson_id > 0");
$stmt->execute();
$stmt->bind_result($spID,$spCode,$spName,$spSurname);
while ($stmt->fetch()) {

    $salespersonWithoutCloudOptions .= "<option value='$spID'>$spCode - $spName $spSurname</option>";
}
$stmt->close();




?>

<div id="main" role="main">

    <!-- Start CUSTOM CODE-->


    <!-- RIBBON -->
    <div id="ribbon" class="bg-color-blue">

				<span class="ribbon-button-alignment">
					<span id="refresh" class="btn btn-ribbon2" onclick="location.reload(true);" data-title="refresh" rel="tooltip" data-placement="bottom" data-original-title="<i class='text-warning fa fa-warning'></i> Reload Page?" data-html="true">
						<i class="fa fa-refresh"></i>
					</span>
				</span>

        <!-- breadcrumb -->
        <ol class="breadcrumb">
            <li class="txt-color-white"> Cloud Access to User</li>
        </ol>
        <!-- end breadcrumb -->


    </div>
    <!-- END RIBBON -->

    <!-- MAIN CONTENT -->
    <div id="content">
        <!-- row -->
        <div class="row">
            <article class="col-xs-12 col-sm-12 col-md-12 col-lg-6">
                <!-- new widget -->
                <div class="jarviswidget" id="wid-id-0" data-widget-togglebutton="false" data-widget-editbutton="false" data-widget-fullscreenbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

                    <header>
                        <span class="widget-icon"> <i class="fa fa-edit"></i> </span>
                        <h2>Cloud Access to User</h2>
                    </header>

                    <div class="widget-body">

                        <div class="row">

                            <div class="col-sm-12">

                                <form id="pageForm" method="post" class="smart-form" enctype="multipart/form-data">

                                    <fieldset style="padding-top:0px">

                                        <div class="row">

                                            <section class="col-sm-9">
                                                <section>
                                                    <label class="label-bold align-left">Select User to Give Cloud Access: </label>
                                                    <select class="form-control" id="user" >
                                                        <?php echo $salespersonWithoutCloudOptions; ?>
                                                    </select>
                                                </section>
                                                <section>
                                                    <label class="label-bold align-left">Cloud Username: </label>
                                                    <input type="text" maxlength="100" id="username" class="form-control" placeholder="username">
                                                </section>
                                                <section>
                                                    <label class="label-bold align-left">Cloud Password: </label>
                                                    <input type="text" maxlength="100" id="password" class="form-control" placeholder="password">
                                                </section>
                                            </section>
                                        </div>
                                        <section class="col-sm-2 pull-right">
                                            <input type="button" id="PostSubmit" class="btn btn-success pull-right" style="padding: 10px;font-size: 16px;"  value="Grant Cloud Access" onclick="grantCloudAccess()">
                                        </section>
                                    </fieldset>
                                </form>





                            </div>

                        </div>

                    </div>
                    <!-- end widget div -->
                </div>
                <!-- end widget -->

            </article>

        </div>
        <!-- end row -->
    </div>






</div>





<script type="text/javascript">

    function highlightDataError(element,label){
        element.css('border-color','firebrick').css('background-color','#ffd0bd');
        window.setTimeout(function(){element.css('border-color','').css('background-color','');
        },2500);

        $.smallBox({
            title: 'Incomplete '+label+'!',
            content: 'Please add '+label,
            color: "#b22222",
            timeout: 3000,
            icon: "fa fa-user swing animated"
        });
    }

    function grantCloudAccess() {

        var run = true;
        var user = $('#user').val();
        var username = $('#username').val();
        var password = $('#password').val();

        if(!user){highlightDataError($('#s2id_user'),'User');}
        if(!username){highlightDataError($('#username'),'Username');}
        if(!password){highlightDataError($('#password'),'Password');}


        if(!user || !username|| !password) {
            run=false;
        }


        if (run) {
            $.ajax({
                type: 'POST',
                url: '//<?php echo HTML_PATH?>/cop/backend/modules/support/controllers/addAdminUserFromSalesPerson.php',
                dataType: 'html',
                data: {
                    'user': user,
                    'username': username,
                    'password': password
                },
                success: function (result) {
                    if(result == 1){
                        $('#user').val('').trigger('change');
                        $('#username').val('');
                        $('#password').val('');
                        $("#user option[value='"+user+"']").each(function() {$(this).remove();});

                        $.smallBox({
                            title: 'Success!',
                            content: "Cloud Access Granted",
                            color: "#739E73",
                            timeout: 3000,
                            icon: "fa fa-user swing animated"
                        });
                    } else {
                        $.smallBox({
                            title: 'Error!',
                            content: result,
                            color: "#b22222",
                            timeout: 3000,
                            icon: "fa fa-user swing animated"
                        });

                        if(result == 'username exists'){
                            var element = $('#username');
                            element.css('border-color','firebrick').css('background-color','#ffd0bd');
                            window.setTimeout(function(){element.css('border-color','').css('background-color','');
                            },2500);
                        }
                    }


                }
            });
        }
    }


    // End of SavePost()

    $(document).ready(function() {

        pageSetUp();

        $('#user').select2();


    })
</script>

<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/select2/select2.min.js"></script>


?>