<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require_once '../../../../concc/dbinfo.php';

global $username,$password,$database;
$db = new mysqli(localhost,$username,$password,$database);
if (mysqli_connect_errno())
{
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}

$dir = '../../../../concc/dbversions';
$version = ''.$_GET['version'];
$major = 5;
$minor = 1;

if(strcmp("",$version) != 0){
    $major = explode(".",$version)[0];
    $minor = explode(".",$version)[1];

    $major = intval($major);
    $minor = intval($minor);
}

$dbChanges = getDbVersion($dir,$major,$minor);
$executions = explode('<br>', $dbChanges);

foreach ($executions as $execution) {
    $display = '';
    $version = get_string_between($execution, "<u>VERSION ", ":</u>");
    $existQuery = get_string_between($execution, "FIRST{", "}");
    $alterQuery = get_string_between($execution, "THEN{", "}");

    if(strcmp($version, '') != 0){
        echo "<br>VERSION: $version<br>";
    }

    if (strcmp($existQuery, '') != 0) {
        $display .= "VALIDATION: $existQuery ";
        try {
            $validationQuery = $db->query($existQuery);
            if (!$validationQuery) {
                $alter = true;
            } else {
                $alter = false;
            }
        } catch (Exception $e) {
            $display = "<br><span style='color: firebrick'>$alterQuery</span><br><b style='color: firebrick;'>VALIDATION ERROR: </b>" . $e->getMessage() . "<br><br>";
            echo $display;
            continue;
        }
    } else {
        $alter = false;

    }

    if ($alter) {
        echo "ALTER: $alterQuery || ";
        try {
            $alterQuery = $db->query($alterQuery);
            if (!$alterQuery) {
                if(strcmp($db->error,'') != 0){
                    $display .= "<br><span style='color: firebrick'>$alterQuery</span><br><b style='color: firebrick;'>ALTER ERROR: </b>" . $db->error . "<br><br>";
                } else {
                    $display .= "$alterQuery <b style='color: green;'>UPDATED</b><br>";
                }
            }
        } catch (Exception $e) {
            $display = "<br><span style='color: firebrick'>$alterQuery</span><br><b style='color: firebrick;'>ALTER ERROR: </b>" . $e->getMessage() . "<br><br>";
            echo $display;
            continue;
        }
    } else {
        if(strcmp($existQuery, '') != 0) {
            $display .= "<b style='color: goldenrod;'>EXISTS</b><br>";
        }
    }
    echo $display;

}

function getDbVersion($dir,$major,$minor){
    $result = '';
    $lines  = '';
    $fileExists=true;
    $createTable=false;
    while($fileExists){
        $validation = '';
        $file = "$dir/$major.$minor.sql";
        if(file_exists($file)) {

            $result .= "<u>VERSION $major.$minor:</u></br>" ;
//            $result .= "<br/><p style='padding-left: 10px;margin-top: 10px;font-size: 15px;'>";
            foreach(file("$file") as $line) {

                if (strpos($line, 'ALTER TABLE') !== false) {
                    if (strpos($line, 'ADD') !== false) {
                        if (strpos($line, 'INDEX') !== false) {
                            $line = str_replace('ADD INDEX(','ADD INDEX (',$line);
                            $DbTable  = get_string_between($line, 'ALTER TABLE', 'ADD');
                            $DbColumn = get_string_between($line, 'ADD INDEX (', ')');
                            if(strpos($DbColumn, ',') === false){
                                $validation = "SHOW INDEX FROM $DbTable WHERE Key_name='$DbColumn'";
                            }
                            $result.= "FIRST{{$validation}}THEN{{$line}}<br>";
                        } else if (strpos($line, 'PRIMARY') !== false) {
                            $line = str_replace('ADD PRIMARY KEY(', 'ADD PRIMARY KEY (', $line);
                            $DbTable = get_string_between($line, 'ALTER TABLE', 'ADD');
                            $DbColumn = get_string_between($line, 'ADD PRIMARY KEY (', ')');
                            $DbTable = str_replace('DROP PRIMARY KEY,','',$DbTable);
                            if (strpos($DbColumn, ',') !== false) {
                                $validation = "SELECT $DbColumn FROM $DbTable LIMIT 1;";
                            } else {
                                $validation = "SELECT COUNT($DbColumn) FROM $DbTable LIMIT 1;";
                            }
                            $result .= "FIRST{{$validation}}THEN{{$line}}<br>";
                        } else if (strpos($line, 'UNIQUE') !== false) {
                            $line = str_replace('ADD UNIQUE(', 'ADD UNIQUE (', $line);
                            $DbTable = get_string_between($line, 'ALTER TABLE', 'ADD');
                            $DbColumn = get_string_between($line, 'ADD UNIQUE (', ')');
                            if (strpos($DbColumn, ',') !== false) {
                                $validation = "SELECT $DbColumn FROM $DbTable LIMIT 1;";
                            } else {
                                $validation = "SELECT COUNT($DbColumn) FROM $DbTable LIMIT 1;";
                            }
                            $result .= "FIRST{{$validation}}THEN{{$line}}<br>";
                        } else {
                            $DbTable  = get_string_between($line, 'ALTER TABLE', 'ADD');
                            $DbColumn = get_string_between($line, 'ADD ', ' ');
                            $validation = "SELECT COUNT($DbColumn) FROM $DbTable LIMIT 1;";
                            $result.= "FIRST{{$validation}}THEN{{$line}}<br>";
                        }
                    } else if (strpos($line, 'CHANGE') !== false){
                        $DbTable  = get_string_between($line, 'ALTER TABLE', 'CHANGE');
                        $DbColumn = get_string_between($line, 'CHANGE ', ' ');
                        $validation = "SELECT COUNT($DbColumn) FROM $DbTable LIMIT 1;";
                        $result.= "FIRST{{$validation}}THEN{{$line}}<br>";
                    }

                } else if(strpos($line, 'CREATE TABLE') !== false){
                    $DbTable  = get_string_between($line, 'CREATE TABLE ', ' (');
                    $validation = "SELECT 1 FROM $DbTable LIMIT 1;";
                    if(strpos($line, ';') !== false){
                        $createTable = false;
                        $result .= "FIRST{{$validation}}THEN{{$line}}<br>";
                    } else {
                        $createTable = true;
                        $lines = "FIRST{{$validation}}THEN{{$line}";
                    }

                } else if($createTable && strpos($line, ';') !== false){
                    $lines .= $line;
                    $result.= "{$lines}}<br>";
                } else {
                    $lines .= $line;
                }
            }

            $minor++;
        } else {
            $major++;
            $minor=0;
            if(!file_exists("$dir/$major.$minor.sql")) {
                $minor++;
                if(!file_exists("$dir/$major.$minor.sql")) {
                    $fileExists = false;
                    $result .= "<br><u>END OF VERSIONS</u><br>";
                }
            }
        }
    }
    return $result;
}

function get_string_between($string, $start, $end){
    $string = ' ' . $string;
    $ini = strpos($string, $start);
    if ($ini == 0) return '';
    $ini += strlen($start);
    $len = strpos($string, $end, $ini) - $ini;
    return substr($string, $ini, $len);
}
?>