<?php
include_once('../../../../param.php');
$db = new mysqli(localhost,$username,$password,$database);
if (mysqli_connect_errno())
{
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

$batchSchedule=0;
$stm1 = $db->prepare("SELECT MAX(schedule_batch) FROM Firebase_Notifications WHERE notification_type = 'Schedule' LIMIT 1");
$stm1->execute();
$stm1->bind_result($batchSchedule);
while ($stm1->fetch()) {}
$stm1->close();
$batchSchedule++;

$devices = $_POST['devices'];
$title = trim($_POST['title']);
$body = trim($_POST['body']);
$dateFromDisplay = trim($_POST['dateFrom']);
$dateToDisplay = trim($_POST['dateTo']);
$time = $_POST['time'];
$notificationType = "Schedule";
$senderID = $_SESSION['adminID'];

if($senderID > 0) {
    $name='';
    $stm1 = $db->prepare("SELECT CONCAT(salesperson_code,' - ',first_name,' ',last_name) FROM SalesPersons WHERE salesperson_id = '$senderID' LIMIT 1");
    $stm1->execute();
    $stm1->bind_result($name);
    while ($stm1->fetch()) {
        if(strcmp($name,'')!=0){$senderName = $name;}
    }
    $stm1->close();
} else {
    $senderID = 0;
}

if((int)$time < 10){
    $time = '0'.$time;
}
$local_date_from = date('Y-m-d H:i:s', strtotime($dateFromDisplay));
$local_date_to = date('Y-m-d H:i:s', strtotime($dateToDisplay));
$arrayDate = getDatesBetween($local_date_from,$local_date_to);


//foreach ($devices as $device){
//    $deviceExplode = explode('|',$device);
//    $deviceID = $deviceExplode[0];
//    $deviceType = $deviceExplode[1];
//
//    foreach ($arrayDate as $date){
//        $dateTime =  $date." $time:00:00";
//        echo "$senderID -$deviceID - $deviceType - $title - $body - $dateTime -$batchSchedule -$notificationType \n\r";
//    }
//}


try {
    $db->begin_transaction();

    foreach ($devices as $device){
        $deviceExplode = explode('|',$device);
        $deviceID = $deviceExplode[0];
        $deviceType = $deviceExplode[1];

        if(strcmp($deviceType,'pur')==0){
            $deviceTable = 'Devices_Pop';
            $deviceIdColumn = 'device_pop_id';
        } else {
            $deviceTable = 'Devices';
            $deviceIdColumn = 'device_id';
        }

        $stm1 = $db->prepare("SELECT sales_person_id FROM $deviceTable WHERE $deviceIdColumn = $deviceID LIMIT 1");
        $stm1->execute();
        $stm1->bind_result($recipientID);
        while ($stm1->fetch()) {}
        $stm1->close();

        if($recipientID > 0){
            $stm1 = $db->prepare("SELECT CONCAT(salesperson_code,' - ',first_name,' ',last_name) FROM SalesPersons WHERE salesperson_id = '$recipientID' LIMIT 1");
            $stm1->execute();
            $stm1->bind_result($recipientName);
            while ($stm1->fetch()) {}
            $stm1->close();
        }

        foreach ($arrayDate as $date){
            $dateTime =  $date." $time:00:00";
//            echo "$senderID -$deviceID - $deviceType - $title - $body - $dateTime -$batchSchedule -$notificationType \n\r";


            $stmt = $db->prepare("INSERT INTO Firebase_Notifications (device_id, sender_id,coprime_app,title,body,schedule_date,notification_type,schedule_batch,sender_name,recipient_id,recipient_name,timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,?,NOW())");
            $stmt->bind_param('iisssssisis', $deviceID,$senderID , $deviceType, $title, $body, $dateTime,$notificationType,$batchSchedule,$senderName,$recipientID,$recipientName);
            $stmt->execute();
            if(strcmp($stmt->error,"")!=0) {throw new Exception();}
            $stmt->close();
        }
    }

    $db->commit(true);
    echo 1;
} catch (Exception  $e) {
    echo 'error';
    $db->rollback();
}

function getDatesBetween($start, $end) {
    $startDate = new DateTime($start);
    $endDate = new DateTime($end);
    $endDate->modify('+1 day');
    $interval = new DateInterval('P1D'); // 1 day interval
    $dateRange = new DatePeriod($startDate, $interval, $endDate);

    $dates = array();
    foreach ($dateRange as $date) {
        $dates[] = $date->format('Y-m-d');
    }

    return $dates;
}
?>