<?php
include_once("../../../../param.php");
// DB table to use
$table = 'Receipts';
 
// Table's primary key
$primaryKey = "receipt_code";

$settlementID = trim($_POST['settlementID']);
 
// Array of database columns which should be read and sent back to DataTables.
// The `db` parameter represents the column name in the database, while the `dt`
// parameter represents the DataTables column identifier. In this case object
// parameter names
$columns = array(
    array( 'db' => '`r`.`receipt_code`', 'dt' => 'img', 'formatter' => function( $d, $row ) {

        return '<img class="custom-rounded-image receipt center-canvas" src="//' . HTML_PATH . '/cop/backend/themes/' . THEME_NAME . '/img/receipticon.png" width="30" height="30"></td>';},
        'field' => 'receipt_code' ),
     array( 'db' => '`r`.`receipt_code`', 'dt' =>  'code', 'field' =>'receipt_code' ),
       array( 'db' => '`c`.`customer_code`', 'dt' => 'cCode', 'field' => 'customer_code' ),
       array( 'db' => '`r`.`status`', 'dt' => 'status', 'field' => 'status' ),
       array( 'db' => '`c`.`customer_company_name`', 'dt' => 'cName', 'field' => 'customer_company_name' ),
    array( 'db' => '`r`.`receipt_date`', 'dt' => 'date' ,'formatter' => function( $d, $row ) {
        return date('d-m-Y',strtotime($d));}, 'field' => 'receipt_date' ),

            array( 'db' => '`s`.`salesperson_code`', 'dt' => 'salesperson', 'field' => 'salesperson_code' ),
             array( 'db' => '`r`.`amount`', 'dt' => 'amount', 'formatter' => function( $d, $row ) {
                return currencySymbol . number_format($d,'2','.',',');},
          'field' => 'amount' ),
    array( 'db' => '`r`.`cash_discount`', 'dt' => 'cash_discount', 'formatter' => function( $d, $row ) {
        return currencySymbol . number_format($d,'2','.',',');},
        'field' => 'cash_discount' ),
         

array( 'db' => '`r`.`receipt_id`', 'dt' => 'form', 'formatter' => function( $d, $row ) {
                return "<input type='checkbox' class='form-control' name='receipt' id='$d' style='width: 20%;' disabled checked>";},
            'field' => 'receipt_id' )
);
 
// SQL server connection information
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db'   => $database ,
    'host' => 'localhost'
);
 
 
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */
$joinQuery = "FROM `Settlement_Receipt` AS `sr` LEFT JOIN `Receipts` AS `r` ON (`r`.`receipt_id` = `sr`.`receipt_id`) LEFT JOIN `Customers` AS `c` ON (`r`.`customer_id` = `c`.`customer_id`) LEFT JOIN `SalesPersons` AS `s` ON (`r`.`salesperson_id` = `s`.`salesperson_id`)";
$where = " `sr`.`settlement_id` =  '$settlementID' ";
require( ROOT.'backend/core/controllers/ssp2.class.php' );
 
echo json_encode(
       SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns,$joinQuery,$where)
     );
     
     ?>