<?php
include_once("../../../../param.php");
require_once (ROOT . "libs/mPDF/vendor/autoload.php");
require_once(ROOT . "backend/core/model/CustomTable.php");

$contractGroupHeaderID      = $_POST['group_contract_header_id'];
$contractGroupHeaderCode    = $_POST['group_contract_header_code'];
$result                     = generateContractPDF($contractGroupHeaderID,$contractGroupHeaderCode);

$mpdf=new mPDF();
$mpdf->setAutoTopMargin='stretch';
$mpdf->setAutoBottomMargin='stretch';
$mpdf->keep_table_proportions=true;
$mpdf->SetHTMLFooter(" ");

$mpdf->WriteHTML($result);

$mpdf->Output("$contractGroupHeaderCode.pdf","I");

function generateContractPDF($contractGroupHeaderID,$contractGroupHeaderCode){
    $logoDirectory = "//" . HTML_PATH . "/cop/media/pdfimage/logo.png";
    $logoDirectory.= "?".time();
    $displayRightSiteCompanyInfo="ythmstravrides.com";
    $pageTitle="";
    $line1="";

    global $username,$password,$database;
    $db = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno())
    {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");

    $stmt = $db->prepare("SELECT g.title, g.valid_from, g.valid_until, c.customer_company_name, c.tic_code, ca.address_line_1,ca.address_line_2, ca.region,ca.postcode,ca.city,ca.country
                                FROM Group_Contract_Header as g 
                                INNER JOIN Customers as c ON g.customer_id = c.customer_id
                                LEFT JOIN CustomerAddress as ca on ca.customer_id = c.customer_id
                                WHERE g.group_contract_header_id = ? LIMIT 1" );
    $stmt->bind_param('i', $contractGroupHeaderID);
    $stmt->execute();
    $stmt->bind_result($projectName, $validFrom, $validUntil, $companyName, $customerTicCode, $addressLine1,  $addressLine2, $region, $postcode, $city, $country);
    while($stmt->fetch()){}
    $stmt->close();
    $projectName = strtoupper($projectName);
    $validFromDate = new DateTime($validFrom);
    $validUntilDate = new DateTime($validUntil);

    $diff = $validFromDate->diff($validUntilDate);

    if ($diff->y > 0) {
        $numberOfYears = $diff->y . " YEAR(S)";
    } else if ($diff->m > 0) {
        $numberOfYears = $diff->m . " MONTH(S)";
    } else if ($diff->d > 0) {
        $numberOfYears = $diff->d . " DAY(S)";
    }
    else {
        $numberOfYears = "1 DAY";
    }

    if(empty($customerTicCode)) {
        $customerTicCode = "...................";
    }

    $validFrom  = date("d/m/Y", strtotime($validFrom));
    $validUntil  = date("d/m/Y", strtotime($validUntil));

    $addressParts = array_filter([$addressLine1, $addressLine2, $region, $postcode, $city, $country]);  //remove empty values
    $customerAddress =implode(", ", $addressParts);
    if(empty($customerAddress)) {
        $customerAddress = "............................,";
    }


    $custTable = new CustomTable('Group_Contract_Header',$contractGroupHeaderID);
    $custTablesJson = $custTable->getAllCustomTablesWithValues();


    $results =[];
    foreach ($custTablesJson as $formData) {
        $formName = $formData->form;
        foreach ($formData->fields as $fieldData) {
            $fieldName = $fieldData['field'];
            $results[$formName][$fieldName] =$fieldData['value'];
        }
    }

    $normalWorking = $results["Services NORMAL WORKING"];
    $overtimeWorking = $results["Services OVERTIME"];
    $weekendWorking = $results["Services WEEKENDS or PUBLIC HOLIDAYS"];
    $extraInfo = $results["Extra Info"];

    $transportationFee = $extraInfo["Transportation Fee"];
    $emergencyFee =  $extraInfo["Emergency Call Fee"];
    $director =   $extraInfo["Director"];

    if(empty($director)){
        $director = "..................................";
    }

    if(empty($transportationFee)){
        $transportationFee = 80;
    }
    if(empty($emergencyFee)){
        $emergencyFee = 120;
    }

    $report = "  <style>
    body
        {
           font-family: Helvetica Neue, Helvetica, Arial, sans-serif;
        }

        #wrapper
        {
            width:180mm;
            margin:0 15mm;
        }
 
        .page
        {
            height:297mm;
            width:210mm;

            page-break-after:always;
        }
        


       .pagebreak
        {
            page-break-after:always;
        }

        h1.heading
        {
            font-size:14pt;
            color:#000;
            font-weight:normal;
        }

        h2.heading
        {
            font-size:9pt;
            color:#000;
            font-weight:normal;
        }

        hr
        {
            color:#ccc;
            background:#ccc;
        }


        td {
          font-family: Helvetica Neue, Helvetica, Arial, sans-serif;
          padding: 8px;
        }
        

        

        #footer
        {
            width:180mm;
            margin:0 15mm;
            padding-bottom:3mm;
        }
        #footer table
        {
            width:100%;
            background:#eee;

        }
        #footer table td
        {
            width:25%;
            text-align:center;
            font-size:9pt;
        }


        @page
        {
        
             margin-left: 2.0cm;
             margin-right: 2.0cm;
        
            header: html_myHTMLHeader1;
            footer: html_myFooter1;
        }
        
            @page signatures
        {
        
             margin-left: 2.0cm;
             margin-right: 2.0cm;
        
            footer: html_myFooter2;
        }

      

       
        body { 
        font-family: Arial, sans-serif; 
        line-height: 1.6; 
        margin: 40px;
     
         }
        
        .bold-underline {
            font-weight: bold;
            text-decoration: underline;
         }
        .li {
                margin-left: 20px;
            }
            
         #footerSignatures {
            position: fixed;
            bottom: 0;
            }
            
    </style>";

    $signatures ="    
                     <table style='width: 100%'>
                         <tr>
                            <td>Date:___________________</td>
                            <td>Service Provider’s Signature and Stamp:__________________      </td>
                        </tr>
                        <tr>
                            <td>Date:___________________</td>
                            <td>Client’s Signature & Stamp:____________________________       </td>
                        </tr>
                     </table>
               ";

    $report.="<htmlpageheader name='myHTMLHeader1'>
                  <table class='heading' style='width: 100%'>
                  <tr>
                  <td valign='top' style='width:30%'>
                      <img style='display:block;max-width: 200px;' src='$logoDirectory'/>
                  </td>
                  <td  valign='top' style='width:40%' align='center'>
                     <p style='display:block;font-weight:bold; font-size:24px; width:100%'>$pageTitle </p><p style='display:block;font-weight:bold; font-size:14px; width:100%'><br/><br/></p>
                  </td>
                  <td valign='top' style='width:30%' align='right'>
                     <h1 class='heading' style='display:block;padding-top:2px;padding-bottom:2px;text-align: right;'>$line1</h1>
                                $displayRightSiteCompanyInfo
                  </td>
                   </tr>
                  </table>
                
                </htmlpageheader> ";

$report .="
                <br>
                <p>To</p>
                <p class='highlight'>$companyName</p>
                <p>NICOSIA</p>
                <p>Sirs,</p>
                <p class='bold-underline' >SUBJECT: $projectName - PREVENTIVE AND CORRECTIVE MAINTENANCE OF ELECTRICAL INSTALLATIONS AND SYSTEMS FOR THE PERIOD OF $numberOfYears</p>
                <p>According to the subject above, please see the attached cost analysis for the preventive and corrective maintenance for the <span class='highlight'>electrical installations and systems</span> at <span class='highlight'>$projectName</span>.</p>
                <p>Regards,</p>
                <div style='margin-top:100px;'>
                    <p>Thomas Stavrides</p>
                    <p>Director</p>
                    <p>Y.T.M. STAVRIDES LTD</p>
                </div>
               ";

$report.="<div class='pagebreak'></div>";

    $report.="
            <p class='bold-underline' style='text-align: center'>INDEX</p>
            <p class='bold-underline'>$projectName - PREVENTIVE AND CORRECTIVE MAINTENANCE FOR THE PERIOD OF $numberOfYears </p>
              <div class= 'li' style='margin-top: 10px;margin-left:20px;'>1) General Terms & Conditions</div>
                <div class= 'li' style='margin-top: 10px;margin-left:20px;'>2) APPENDIX A: Preventive maintenance schedule of works & cost analysis</div>
                <div class= 'li' style='margin-top: 10px;margin-left:20px;'>3) APPENDIX B: Labour unit prices for scheduled works</div>
                <div class= 'li' style='margin-top: 10px;margin-left:20px;'>4) APPENDIX C: Scope of Work - Checklists</div>
                <div class= 'li' style='margin-top: 10px;margin-left:20px;'>5) APPENDIX D: Sample of Job Instructions Report</div>
                <div class= 'li' style='margin-top: 10px;margin-left:20px;'>6) APPENDIX E: Registration of Company</div>
             
            ";

    $report.="<div class='pagebreak'></div>";

    $report.="
            <p class='bold-underline' style='text-align: center'>GENERAL TERMS AND CONDITIONS </p>
            <p class='bold-underline'>$projectName - PREVENTIVE AND CORRECTIVE MAINTENANCE FOR THE PERIOD OF $numberOfYears </p>
            <p>An agreement dated on ................, between Y.T.M. Stavrides Ltd, a limited 
                liability company incorporated under the laws of the Republic of Cyprus, with 
                registration number HE 66148, having its registered address at 71 Larnakos Avenue, 
                Center Court, 1st Floor, Flat/Office 101, Aglantzia, 2101, Nicosia, Cyprus, represented 
                by its Director, Mr. Thomas Stavrides (hereinafter the “<b>Service Provider</b>”), on the one 
                part</p>
                
                <p>AND</p>
                
                <p>$companyName a limited liability company incorporated under the laws 
                    of the Republic of Cyprus, with registration number HE $customerTicCode, having its 
                    registered office at $customerAddress Cyprus, represented by its Director, 
                    $director the “<b>Client</b>”), on the other part, witness as follows: </p>
                    
             <div>1.</div>
                 <table style='width: 60%;font-weight: bold;'>
                    <tr>
                        <td>Starting Date:</td>
                        <td>$validFrom</td>
                    </tr>
                    <tr>
                        <td>Ending Date:</td>
                        <td>$validUntil</td>
                    </tr>
                    <tr>
                        <td>Agreement Period:</td>
                        <td>$numberOfYears</td>
                    </tr>
                </table>
                
                <p>This agreement will become effective when signed by duly authorized representatives 
                    of both parties and will be in effect until terminated according to its term.  </p>
                    
                <p> <b>2. Payment Conditions </b>  </p>
                <p><b>2.1.</b> Preventive Maintenance charges will occur monthly, twelve (12) times per year. <br>
               <b>2.2.</b> Preventive Maintenance charges will apply at the beginning of each month. All the reports will be sent by the end of each month. <br>  
               <b>2.3.</b> Corrective Maintenance charges commence from the effective date of invoice and shall be payable in 30 days. <br>   </p>
                <p><b>2.4.</b>  The detailed amount for preventive and corrective works excludes any taxes and governmental levies as applicable later due to operation or any existing and new law.      </p>
                ";
    $report.="<div class='pagebreak'></div>";

    $report .= "
               
               <p style='margin-top:20px;'><b>3. &nbsp; Y.T.M. Stavrides Ltd Service Responsibilities: </b></p>
               
                <p><div>  <b>3.1.</b>  Y.T.M. Stavrides Ltd performs scheduled Preventive Maintenance Services on the 
                    equipment & systems and any other equipment within the maintenance period. 
                    The visits are charged per annum as indicated in APPENDIX A and are subject to 
                    the terms and conditions set out below and the reverse side hereof.  
                    Y.T.M. Stavrides Ltd shall maintain the equipment and keep them in good 
                    operating condition as specifically indicated in check lists for systems and 
                    equipment (see APPENDIX C).  <br>
                    During the Preventive maintenance period any materials or spare parts that may 
                    be needed for faulty equipment are not included in the price. Full report along 
                    with the materials, spare parts and labor needed will be given to the Client for 
                    approval after each preventive maintenance visit, in order to proceed with any 
                    additional repairs.  </div>  
                  <div><b>3.2.</b>  Corrective Maintenance Services for specified works or services to any desirous 
                    equipment and systems, should be requested in writing by a fully authorized 
                    representative of the Client. Additionally, it is any approved quotation sent to the 
                    Client for any repairs on the equipment after each preventive maintenance visit. 
                    The response times and costs are indicated in APPENDIX B. </div>  
                    <div><b>3.3.</b> Emergency Call, is determined to be any major fault or failure where the response 
                    must be immediate at the cost and the terms & conditions indicated in  
                    APPENDIX B. </div>  </p>
                    
                      <p> <b>4. Maintenance Calling Process </b>
                      <p>Calling process will be carried out by a fully authorized representative in writing or 
                        email or phone. By the completion of works, an authorized representative will be 
                        asked to sign a Job Instruction Report (see APPENDIX D) where the materials used; 
                        labor and brief description of the works should be clearly indicated, and a copy of the 
                        report will be given to the authorized representative.   </p>";

    $report.="<div class='pagebreak'></div>";

    $report.="
                      
                        <p>Responsible Person A: {$extraInfo['Responsible Person A']} <br>
                        Telephone number:  {$extraInfo['Telephone A']}</p>
                        
                         <p>Responsible Person B:  {$extraInfo['Responsible Person B']} <br>
                        Telephone number:  {$extraInfo['Telephone B']}</p>
                        
                         <p>Responsible Person C:  {$extraInfo['Responsible Person C']} <br>
                        Telephone number:  {$extraInfo['Telephone C']}</p>
                        
                        <p> <b>5. Maintenance Department Contacts  </b>
                        
                        <p>Y.T.M. Stavrides Ltd Maintenance Department provides 24/7 support and can be 
                        reached as follows: 
                       <div><b>• Maintenance Department:</b> 77 77 41 41 (Monday – Friday - 7:00 – 16:00)</div>
                        <div><b>• Electrical Works Emergency Contacts</b> (24/7 support): <br>
                            +357 95100601 (Nicosia, Larnaca, Famagusta) & +357 95100603 (Limassol, Paphos)
                        </div>
                        <div><b>• Systems Works Emergency Contact</b> (24/7 support): +357 95 100602</div>
                        <div><b>• Fax: +357 22332170</b></div>
                        <div><b>• Email:  <u> maintenance@ytmstavrides.com </u> </b></div>
                        </p>
                        
                        <p><b>6.&nbsp; Confidentiality</b></p>
                        <p>The Service Provider agrees to keep and shall cause its employees and agents to keep 
                        any and all information or document it or its employees or agents may come across 
                        during the performance of its services, as confidential and not to retain, copy or 
                        disclose such information or document to any person or use it for any purpose 
                        whatsoever.</p>
                        
                        <p><b>7.&nbsp; Certificates/Licences – Policies </b></p>
                        <p>The Service Provider complies with all legal requirements and local practises, having the following:
                           <div class='li'> <b>• </b>Valid Work Permit Certificate by the Department of Electromechanical Services Cyprus </div>
                          <div  class='li'>   <b>• </b>Licenced personnel for practising as a guard or private security guard by Cyprus Police</div>
                          <div  class='li'>  <b>• </b> Licenced personnel as forklift operators</div>
                          <div class='li'>  <b>• </b>Employer’s Liability Insurance</div>
                          <div class='li'>  <b>• </b>Public Liability Insurance</div>
                          <div  class='li'>  <b>• </b> Health & Safety measurements, incl. H&S plan – Risk Assessment </div>
                          <div  class='li'>  <b>• </b> Certified personnel with First Aid at Work</div>
                         
                        </p>
                ";

    $report.="<div class='pagebreak'></div>";

    $report.="<p><b>8. Termination <b></p>
                <p>Either party may terminate the agreement by giving written notice to the other if (i) 
            the other materially breaches it and does not remedy the breach within 30 days from 
            receipt of the above notice specifying the nature of the breach and requiring it to be 
            remedied, (ii) the other is or appears likely to be unable to pay its debts, as indicated 
            in Clause 2 or becomes insolvent or (iii) the performance of it (incl. the application of 
            any fee arrangements) may breach a legal or regulatory requirement.</p>
            
            <p><b>8. General <b></p>
            <p>The Agreement shall be construed in accordance with the laws of Cyprus and the 
            Courts of Cyprus shall have exclusive jurisdiction in relation to any matters arising 
            out of the Agreement. </p>
            
            <p class='bold-undelrine'> AGREEMENT APPROVAL <br>
             This Agreement binds the parties as well as their Legal successors. </p>
             
             <p>
                <b>Signed by</b><br>
                Name: __________________________<br>
                Signature & Stamp: ______________________<br><br>
            
                Title: ___________________________<br>
                Date: ___________________________<br>
                For and on behalf of <strong>$companyName (“Client”)</strong><br><br>
            
                <b>Witness</b><br>
                Name: __________________________<br>
                Signature: ______________________<br><br>
            
                <b>Signed by</b><br>
                Name: THOMAS STAVRIDES<br>
                Signature & Stamp: __________________<br>
                Title: Director<br>
                Date: __________________________<br>
                For and on behalf of <strong>Y.T.M. STAVRIDES LIMITED(“Service Provider”)</strong> <br><br>
            
                <b>Witness</b><br>
                Name: __________________________<br>
                Signature: ______________________<br>
            </p>
             ";
    $report.="<div class='pagebreak'></div>";

    $report.= "<p class='bold-underline' style='text-align: center'>APPENDIX A – DETAILED SERVICE LEVEL AGREEMENT </p>";

    $report.="<div class='pagebreak'></div>";

    $report.=" <p style='text-align: center' class='bold-underline'>APPENDIX B – LABOUR UNITS PRICES FOR SCHEDULED WORKS</p>
    <p style='text-align: center'  class='bold-underline'>$projectName - CORRECTIVE AND PREVENTIVE MAINTENANCE FOR THE PERIOD OF $numberOfYears</p>
    
    <p  class='bold-underline'>On-Call Services and Labor Costs</p>
    
    <table style='width: 100%; border-collapse: collapse;'>
    <tr>
        <th style='border: 1px solid black;background-color: #E1E1E1;text-align: center;width:10%'>A/A</th>
        <th style='border: 1px solid black;background-color: #E1E1E1;text-align: center;'>DESCRIPTION</th>
        <th style='border: 1px solid black;background-color: #E1E1E1;text-align: center;'>LABOUR DURING NORMAL WORKING HOURS (07:00-15:30)</th>
        <th style='border: 1px solid black;background-color: #E1E1E1;text-align: center;'>LABOUR DURING OVERTIME DAILY HOURS (15:30 – 07:00)</th>
        <th style='border: 1px solid black;background-color: #E1E1E1;text-align: center;'>LABOUR DURING WEEKENDS or PUBLIC HOLIDAYS</th>
    </tr>
    <tr>
        <td style='border: 1px solid black;text-align: center;'>1</td>
        <td style='border: 1px solid black;'>AUTOMATION ENGINEER</td>
        <td style='border: 1px solid black;text-align: center;'>{$normalWorking["AUTOMATION ENGINEER"]}€/H</td>
        <td style='border: 1px solid black;text-align: center;'>{$overtimeWorking["AUTOMATION ENGINEER"]}€/H</td>
        <td style='border: 1px solid black;text-align: center;'>{$weekendWorking["AUTOMATION ENGINEER"]}€/H</td>
    </tr>
    <tr>
        <td style='border: 1px solid black;text-align: center;'>2</td>
        <td style='border: 1px solid black;'>ELECTRICAL OR SYSTEMS ENGINEER</td>
        <td style='border: 1px solid black;text-align: center;'>{$normalWorking["ELECTRICAL OR SYSTEMS ENGINEER"]}€/H</td>
        <td style='border: 1px solid black;text-align: center;'>{$overtimeWorking["ELECTRICAL OR SYSTEMS ENGINEER"]}€/H</td>
        <td style='border: 1px solid black;text-align: center;'>{$weekendWorking["ELECTRICAL OR SYSTEMS ENGINEER"]}€/H</td>
    </tr>
    <tr>
        <td style='border: 1px solid black;text-align: center;'>3</td>
        <td style='border: 1px solid black;'>SUPERVISOR</td>
        <td style='border: 1px solid black;text-align: center;'>{$normalWorking["SUPERVISOR"]}€/H</td>
        <td style='border: 1px solid black;text-align: center;'>{$overtimeWorking["SUPERVISOR"]}€/H</td>
        <td style='border: 1px solid black;text-align: center;'>{$weekendWorking["SUPERVISOR"]}€/H</td>
    </tr>
    <tr>
        <td style='border: 1px solid black;text-align: center;'>4</td>
        <td style='border: 1px solid black;'>FOREMAN</td>
        <td style='border: 1px solid black;text-align: center;'>{$normalWorking["FOREMAN"]}€/H</td>
        <td style='border: 1px solid black;text-align: center;'>{$overtimeWorking["FOREMAN"]}€/H</td>
        <td style='border: 1px solid black;text-align: center;'>{$weekendWorking["FOREMAN"]}€/H</td>
    </tr>
    <tr>
        <td style='border: 1px solid black;text-align: center;'>5</td>
        <td style='border: 1px solid black;'>LABOURER</td>
        <td style='border: 1px solid black;text-align: center;'>{$normalWorking["LABOURER"]}€/H</td>
        <td style='border: 1px solid black;text-align: center;'>{$overtimeWorking["LABOURER"]}€/H</td>
        <td style='border: 1px solid black;text-align: center;'>{$weekendWorking["LABOURER"]}€/H</td>
    </tr>
    <tr>
        <td style='border: 1px solid black;text-align: center;'>6</td>
        <td style='border: 1px solid black;'>HELPER</td>
        <td style='border: 1px solid black;text-align: center;'>{$normalWorking["HELPER"]}€/H</td>
        <td style='border: 1px solid black;text-align: center;'>{$overtimeWorking["HELPER"]}€/H</td>
        <td style='border: 1px solid black;text-align: center;'>{$weekendWorking["HELPER"]}€/H</td>
    </tr>
</table>

    
    <div >
        <p  class='bold-underline'>Notes:</p>
        <div>1) Fixed transportation Fee per call that includes any time spent during our transportation to the facilities: <b>{$transportationFee}€</b>. Fixed fee for any works done during the first hour.</div>
        <br><div>2) Fixed service fee for any works done during the first hour:</div>
        <div class='li'>- Technician Electrician - 30.00 EURO</div>
        <div class='li'>- Assistant Electrician - 25.00 EURO</div>
        <div class='li'>- System’s Technician - 55.00 EURO</div>
        <br><div>3) Our response to all calls are as follows:</div>
        <div class='li'>a) For Emergency calls our attendance will be within 1 hour and is charged at a fixed fee of <b>{$emergencyFee}€</b>.</div>
        <div class='li'>b) For Urgent call our attendance will be within 24 hours.</div>
        <div class='li'>c) For any other calls our attendance will be within 4-7 working days.</div>
        <br><div>4) Validity of Quotation: 3 months</div>
    </div>
    
   ";

    $report.="<div class='pagebreak'></div>";

    $report .="<p style ='text-align: center' class='bold-underline'>APPENDIX C – SCOPE OF WORKS - CHECKLISTS <br>
                $projectName - CORRECTIVE AND PREVENTIVE MAINTENANCE FOR 
                THE PERIOD OF $numberOfYears</p>
                
                <div>
                <b>a) </b>The scope of maintenance works to be performed by Y.T.M. Stavrides Ltd will be the 
                    following: <b>Main Electrical switchboards and distribution boards:</b>
                    <div class='li'>• General Inspection of the main switch board and distribution boards to make sure 
the equipment is clean and free from obstruction </div>
                    <div class='li'>• Inspect for no electrical discharge noise </div>
                    <div class='li'>• Inspect indicator lamps and overheating signs (loose connections)   </div>
                    <div class='li'>• Clean from dust  </div>
                    <div class='li'>• Carry out electrical test of the protective devices   </div>
                    <div class='li'>• Ensure that everything is connected properly based on functionality and safety   </div>
                    <div class='li'>• Inspect for changes on initial installation    </div>
                </div>
                <br>
                <div>
                <b>b) Emergency Lighting </b>
                    <div class='li'>• Inspect that emergency lights function properly after interrupting electrical supply  </div>
                    <div class='li'>• Inspect for burnt lamps  </div>
                    <div class='li'>• Report instantly for any malfunction   </div>
                </div>
                    <br>
                <div>
                <b>c) Power Factor Correction Unit </b>
                    <div class='li'>• Clean from dust </div>
                    <div class='li'>• Individual test on Capacitors </div>
                    <div class='li'>• Ensure that everything is connected properly based on functionality and  Safety    </div>
                </div>
                    <br>
                  <div>
                <b>d) UPS System  </b>
                    <div class='li'>• Inspect the cabinets, batteries, system voltage-current-power-time, connections and damages  </div>
                    <div class='li'>• Firmware Updates     </div>
                    <div class='li'>• Check functionality of the system   </div>
                     <div class='li'>• Run simulation tests </div>
                </div>
                <br>
                
               <div>
                <b>e) Security System/ CCTV/Fire Alarm Detection and Access Control   </b>
                    <div class='li'>• Inspect for any changes of the initial installation </div>
                    <div class='li'>• Inspect devices, power supplies, connections and monitors    </div>
                    <div class='li'>• General inspection for any malfunction of the system  </div>
                     <div class='li'>• Run simulation tests and inspect the devices </div>
                     <div class='li'>• Inspect the main control equipment, batteries and connections </div>
                     <div class='li'>• Inspect the operation of the systems </div>
                </div>
                
                <br>
                
                 <div>
                <b>f) Fire Extinguishing System     </b>
                    <div class='li'>• Inspect for any changes of the initial installation  </div>
                    <div class='li'>•  Inspect devices, power supplies, connections and monitors    </div>
                    <div class='li'>•General inspection for any malfunction of the system </div>
                     <div class='li'>• Run simulation tests and inspect the devices </div>
                     <div class='li'>• Inspect the main control equipment, batteries and connections </div>
                     <div class='li'>• Inspect the operation of the systems </div>
                </div>
                <br>
                
                 <div>
                <b>g) Lightning System      </b>
                    <div class='li'>• Visual Inspection of copper tape junction  </div>
                    <div class='li'>• Measurements of earth loop impedance    </div>
                   
                </div>
                
                <br>
                
                <div>
                    <b>h) Lighting Fittings, Sockets, wiring accessories  </b> includes visual inspection                     
                </div>
                 
                 <br>
                
                 <div>
                    <b>i) Sensi Pro</b> Once a month maintenance check (over the internet) on Servers and software as bellow: 
                        <div class='li'>a. Ensure all meters and sensors communicate with the Servers/Database  </div>
                        <div class='li'>b. Database maintenance    </div>
                        <div class='li'>c. Database Back-Up    </div>
                        <br>
                        <div class='li'>• Twice a year on site maintenance check on Server and software to apply any new updates on Windows and on the SensiPro application   </div>
                        <div class='li'>• Once per year Meter and Sensors (Temperature/Humidity) Verification to insure accurate readings    </div>
                        <div class='li'>• Twice per Year System Test by causing actual events and see system’s response    </div>
                </div>
                
                <br>
                
                 <div>
                 <b>j) Generator  </b>
                        <div class='li'>• Check Engine Parameters   </div>
                        <div class='li'>• Check Generators and Panel Parameters     </div>
                        <div class='li'>Engine Service 1/year or after 250 working hours including Engine Oil, Fuel Filters, Oil Filters, Air filter, Corrosion Inhibitor & antifreeze, Cleaning and Test   </div>
                      
                </div>
                    <br>
                  <div>
                 <b> k) CCU (Close Control Unit) </b>  
                        <div class='li'>• Inspect the cabinets, batteries, system voltage-current-power-time, connections and damages   </div>
                        <div class='li'>• Firmware Updates    </div>
                        <div class='li'>• Check functionality of the system    </div>
                        <div class='li'>• Run simulation tests  </div>       
                </div>
                <br>
                <div>
                      <b> a) Thermography </b> <br>
                      <b> Insert tasks  </b>  
                </div>
                
                     <br>
                <div>
                      <b> m) Photovoltaics 

                </div>
                
                <p class='bold-underline' style='text-align: center'>APPENDIX D – JOB INSTRUCTIONS WORK </p>
               
               
                ";

    $report.="<div class='pagebreak'></div>";

    $report .="    
       <div style='border: 1px solid black; padding: 10px; width: 100%;'>
                 
        <table style='width: 100%; border-collapse: collapse; border: 1px solid black;'>
         <tr>
            <td style='border-right: 1px solid black; width:50%;'> <img src='$logoDirectory' alt='logo' style='height: 35px;'></td>
            <td style='width:50%; '>TECHNICIAN'S SERVICE REPORT</td>
        </tr>
        </table>

        
         <table style='width: 100%; border-collapse: collapse; border: 1px solid black;'>
        <tr>
            <td colspan='2' style='border: 1px solid black; width:50%;'>CUSTOMER DETAILS</td>
            <td colspan='2' style='border: 1px solid black;width:50%; '>Ticket No: CC</td>
        </tr>
        <tr>
            <td style='border: 1px solid black;width:25%; '>Account No:</td>
            <td style='border: 1px solid black;width:25%; '>320</td>
            <td colspan='2' style='border: 1px solid black; width:50%;'>Project:</td>
        </tr>
        <tr>
            <td colspan='2'></td>
            <td style='border: 1px solid black;'>Location:</td>
            <td style='border: 1px solid black;'>Item:</td>
        </tr>
        <tr>
             <td colspan='2'></td>
             <td colspan='2' style='border: 1px solid black;'>Address:</td>
        </tr>
        <tr>
             <td colspan='2'></td>
             <td colspan='2' style='border: 1px solid black;'>Client Contact Person:</td>
        </tr>
        <tr>
             <td colspan='2'></td>
             <td colspan='2' style='border: 1px solid black;'>Client Contact Phone:</td>
        </tr>
        <tr>
             <td colspan='2'></td>
            <td colspan='2' style='border: 1px solid black;'>Resp. Engineer:</td>
        </tr>
        <tr>
            <td colspan='2'></td>
            <td colspan='2' style='border: 1px solid black;'>Technician:</td>
        </tr>
    </table>
    
  
        <table style ='border-collapse: collapse; border: 1px solid black;width:100%; margin-top: 20px;'>
        <tr>
            <td style='width:40%;border-right: 1px solid black;padding:8px;background-color: #e1e1e1'>DETAILS OF SERVICE</td>
            <td style='width:60%'></td>
        </tr>
        </table>
        
   
        
        <table style='width: 100%; border-collapse: collapse; border: 1px solid black; margin-top: 20px;'>
            <tr>
                <td style='border: 1px solid black;background-color: #e1e1e1 '>Item Code</td>
                <td style='border: 1px solid black;background-color: #e1e1e1 '>Description</td>
                <td style='border: 1px solid black;background-color: #e1e1e1 '>UOM</td>
                <td style='border: 1px solid black;background-color: #e1e1e1 '>Qty</td>
            </tr>
            <tr>
                <td style='border: 1px solid black;padding: 15px '></td>
                <td style='border: 1px solid black;padding: 15px; '></td>
                <td style='border: 1px solid black;padding: 15px '></td>
                <td style='border: 1px solid black; padding: 15px'></td>
            </tr>
        </table>
        
        <table style='width: 100%; border-collapse: collapse; margin-top: 20px; border: 1px solid black;'>
            <tr>
                <td style='border: 1px solid black; padding:20px;width:50%;'>Technician's Name: 
                    <br> Date:
                     <br> Arrival Time:
                     <br> Departure Time: 
                 </td>
                <td style='border: 1px solid black;width:50%;vertical-align: top; '> Technician's Signature</td>
          
            </tr>
            <tr>
                <td style='border: 1px solid black;padding:20px;width:50%; '>Customer's Name:
                <br>Customer's Telephone Number:</td>
                <td style='border: 1px solid black;width:50%;vertical-align: top; '>Customer's Signature:</td>
              
            </tr>
        </table>
        
        
                <table style='width: 100%; border-collapse: collapse; margin-top: 20px; border: 1px solid black;'>
                <tr>
                  <td style='border: 1px solid black;' > Report By Technician:</td>
                </tr>
                 <tr>
                <td  style='height:120px'></td>
                </tr>
            </table>
        </div>
    
       
    ";

    $report.="<div class='pagebreak'></div>";

    $report .= "
<p class='bold-underline' style='text-align: center'>APPENDIX E – COMPANY’S CERTIFICATE OF REGISTRATION  </p>
        <p class='bold-underline' style='text-align: center;'>REGISTRATION OF COMPANY TO THE ACCOUNTS SYSTEM</p>

    <div style='width: 80%; margin: 0 auto; padding: 20px; border: 1px solid #ccc;'>
        <p class='bold-underline'>COMPANY DETAILS</p>

        <div >
            <label style='float: left;'>COMPANY NAME:</label>
            <div style='border-bottom: 1px dotted #000;'></div>
        </div>

        <div >
            <label >TAX ID:</label>
            <div style='border-bottom: 1px dotted #000;'></div>
        </div>

        <div >
            <label >VAT REGISTRATION NO:</label>
            <div style=' border-bottom: 1px dotted #000;'></div>
        </div>

        <div >
            <label >RESPONSIBLE PERSON:</label>
            <div style=' border-bottom: 1px dotted #000;'></div>
        </div>

        <div >
            <label  >DEPARTMENT:</label>
            <div style=' border-bottom: 1px dotted #000;'></div>
        </div>

        <div >
            <label >ADDRESS:</label>
            <div style=' border-bottom: 1px dotted #000;'></div>
        </div>

            <div >
                <label  style='width: 100%;'>POST CODE:</label>
                <div style=' border-bottom: 1px dotted #000;'></div>
            </div>
            
            <div>
                <label  style='width: 100%;'>P.O.BOX:</label>
                <div style=' border-bottom: 1px dotted #000;'></div>
            </div>
            
            <div>
                <label  style='width: 100%;'>P.O. BOX CITY:</label>
                <div style=' border-bottom: 1px dotted #000;'></div>
            </div>
    

            <div>
                <label style='width: 100%;'>TELEPHONE NUMBER:</label>
                <div style=' border-bottom: 1px dotted #000;'></div>
            </div>
            <div>
                <label style='width: 100%;'>FAX NO:</label>
                <div style=' border-bottom: 1px dotted #000;'></div>
            </div>
      

        <div >
            <label  >MOBILE NUMBER:</label>
            <div style=' border-bottom: 1px dotted #000;'></div>
        </div>

       <div >
            <label  >ACCOUNTS NO AND RESPONSIBLE PERSON:</label>
            <div style=' border-bottom: 1px dotted #000;'></div>
        </div>

        <div >
            <label  >E-MAIL ADDRESS:</label>
            <div style=' border-bottom: 1px dotted #000;'></div>
        </div>

        <div style=''>
            <p>I hereby confirm that I consent to the processing of my personal data by the
                Company in accordance with the EU Regulations for Data Protection.</p>
        </div>

        <div >
            <label >Signature</label>
            <div style=' border-bottom: 1px dotted #000;'></div>
        </div>

    </div>";

    $report.="<div class='pagebreak'></div>";

    $report .= "
    <p class='bold-underline'>PROCESSING OF PERSONAL DATA – CONSENT FORM </p>
    <p>The Client gives it consent for processing of personal data in compliance with 
    applicable legislation, in particular under Regulation (EU) 2016/679 (“GDPR”) and 
    gives its consent for processing of personal data for the purposes and with the 
    methods indicated in Y.T.M. STAVRIDES LTD privacy policy. </p>
    
    <p>Signature & Stamp _______________________________________ </p>
    <div>For and behalf of Client $companyName _______________________ </div>
     <div>Client Signatory Name __________________________________________________ </div>
      <div>& Title_______________________________________________________________  </div>
       <div>Date________________________________________________________________ </div>
       
        
     <div style='margin-top: 100px;'>
         <table style='width: 100%'>
             <tr>
                <td>Date:___________________</td>
                <td>Service Provider’s Signature and Stamp:__________________      </td>
            </tr>
            <tr>
                <td>Date:___________________</td>
                <td>Client’s Signature & Stamp:____________________________       </td>
            </tr>
         </table>
     </div>
    ";


    return $report;

}


?>