<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ERROR);
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */
include_once("../../../../param.php");
// DB table to use
$table = 'Items';

// Table's primary key
$primaryKey = "item_code";

$filterOptionID = trim($_GET['filterOptionID']);

// Array of database columns which should be read and sent back to DataTables.
// The `db` parameter represents the column name in the database, while the `dt`
// parameter represents the DataTables column identifier. In this case object
// parameter names
$columns=array();

if($_GET['leftJoin']==1)
{
    array_push($columns,array( 'db' => '`f`.`filter_id`', 'dt' => 'image', 'formatter' => function( $d, $row ) {

        $GLOBALS['filterID']=$d;

        return '';},
        'field' => 'filter_id' ));

}

else
{
    array_push($columns,array( 'db' => '`i`.`item_id`', 'dt' => 'image', 'formatter' => function( $d, $row ) {


        return '';},
        'field' => 'item_id' ));
}


array_push($columns, array( 'db' => '`i`.`item_id`', 'dt' => 'image', 'formatter' => function( $d, $row ) {

    $GLOBALS['itemID']=$d;

    global $username, $password, $database;
    $db = new mysqli(localhost, $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");
    $check = false;
    $stm = $db->prepare("SELECT image_name FROM Item_Images WHERE item_id='$d' LIMIT 1");
    $stm->execute();
    $stm->bind_result($imgName);

    while ($stm->fetch()) {
        $d = "//" . HTML_PATH . "/cop/media/productImages/$imgName.jpg";
        if(file_exists(ROOT . "media/productImages/$imgName.jpg")) {
            $check = true;
        }

    }
    $stm->close();
    if(!$check) {
        $d = "//" . HTML_PATH . "/cop/backend/themes/" . THEME_NAME . "/img/itemdefaulticon.jpg";
    }
    return '<img class="img-responsive img-rounded center-canvas" src="'.$d.'" width="32" height="32"></td>';},
    'field' => 'item_id' ));

array_push($columns, array( 'db' => '`i`.`status`', 'dt' => 'status', 'formatter' => function( $d, $row ) {
    if(strcmp($d,'inactive')==0){
        return "<span style='color: firebrick;font-weight: bold'>Inactive</span>";
    } else {
        return "<span style='color: #0ca30a;font-weight: bold'>Active</span>";
    }
}, 'field' => 'status' ));


array_push($columns, array( 'db' => '`i`.`item_code`', 'dt' =>  'code', 'field' =>'item_code' ));
array_push($columns, array( 'db' => '`i`.`name`', 'dt' => 'name', 'field' => 'name' ));
array_push($columns, array( 'db' => '`i`.`item_sku`', 'dt' => 'sku' , 'field' => 'item_sku' ));



if($_GET['leftJoin']==1)
{
    array_push($columns, array( 'db' => '`f`.`filter_option_id`', 'dt' => 'position', 'formatter' => function( $d, $row ) {

        $GLOBALS['filterOptionID'] = $d;
        global $username, $password, $database;
        $db = new mysqli(localhost, $username, $password, $database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $db->set_charset("utf8");
        $stm = $db->prepare("SELECT option_name FROM Filter_Options WHERE filter_option_id='$d' LIMIT 1");
        $stm->execute();
        $stm->bind_result($optionName);
        while ($stm->fetch()) {}
        $stm->close();
        return "$optionName";

    } , 'field' => 'filter_option_id' ));

}

else
{
    array_push($columns, array( 'db' => '`i`.`item_id`', 'dt' => 'position', 'formatter' => function( $d, $row ) {



        return '';

    } , 'field' => 'item_id' ));
}


array_push($columns,   array( 'db' => '`i`.`item_id`', 'dt' => 'form', 'formatter' => function( $d, $row ) use ($filterOptionID) {

    global $username,$password,$database;
    $filterID = $_GET['filterID'];
    $db = new mysqli(localhost, $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");

    $selectedFilterOptionID = $GLOBALS['filterOptionID'];

    $stm = $db->prepare("SELECT option_name FROM Filter_Options WHERE filter_option_id='$filterOptionID' LIMIT 1");
    $stm->execute();
    $stm->bind_result($optionName);
    while ($stm->fetch()) {}
    $stm->close();

    $stm = $db->prepare("SELECT COUNT(*) FROM Filter_Item WHERE filter_id='$filterID' AND filter_option_id='$filterOptionID' AND item_id='$d' LIMIT 1");
    $stm->execute();
    $stm->bind_result($counter);
    while ($stm->fetch()) {}
    $stm->close();

    $existsInOtherOption = false;
    if($selectedFilterOptionID != $filterOptionID && $counter > 0){
        if($selectedFilterOptionID > 0) {
            $stm = $db->prepare("SELECT COUNT(*) FROM Filter_Item WHERE filter_id='$filterID' AND filter_option_id='$selectedFilterOptionID' AND item_id='$d' LIMIT 1");
            $stm->execute();
            $stm->bind_result($counter2);
            while ($stm->fetch()) { if($counter2 > 0){$existsInOtherOption = true;}}
            $stm->close();
        }

        $counter = 0;
    }

    if($counter>0)
    {
        return '
			<button   id="'.$d.'" class="btn btn-danger" onclick="deactivateButtonClicked('.$d.');" >Remove From '.$optionName.'</button>
			';
    }
    else if(!$existsInOtherOption){
        return '
			<button  id="'.$d.'"  class="btn btn-success" onclick="activateButtonClicked('.$d.');"  >Add to '.$optionName.'</button>
			';
    } else {
        return '<b>Already in '.$optionName.'</b>';
    }



},
    'field' => 'item_id' ));




// SQL server connection information
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db'   => $database ,
    'host' => 'localhost'
);

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */
if($_GET['leftJoin']==1)
{
    $filterID = $_GET['filterID'];
    $joinQuery = "FROM `Filter_Item` AS `f` LEFT JOIN `Items` AS `i` ON (`i`.`item_id` = `f`.`item_id`)";
    $where ="`f`.`filter_id`='$filterID'";
}
else
{
    $joinQuery = "FROM `Items` AS `i`";
    $where ="";
}

if(isset($_GET['statusFilter']) && strcmp($_GET['statusFilter'],'')!=0){
    if(strcmp($where,'')!=0){ $where .= " AND ";}
    if(strpos(strtolower($_GET['statusFilter']), 'in') !== false) {
        $where .= " `i`.`status` = 'inactive'";
    } else {
        $where .= " NOT `i`.`status` = 'inactive'";
    }

}

require( ROOT.'backend/core/controllers/ssp2.class.php' );

echo json_encode(
    SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns,$joinQuery,$where)
);

?>