<?php

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */
include_once('../../../../param.php');
// DB table to use
$table = 'ERP_Import';

// Table's primary key
$primaryKey = "erp_import_id";

// Array of database columns which should be read and sent back to DataTables.
// The `db` parameter represents the column name in the database, while the `dt`
// parameter represents the DataTables column identifier. In this case object
// parameter names
$columns = array(

    array( 'db' => '`erp`.`type`', 'dt' =>  'type', 'formatter' => function( $d, $row ) {
        switch ($d){
            case 'inbound':
                $icon = "<i class='fa fa-download' style='font-size:26px;color: #0a6ebd'></i>";
                break;
            case 'outbound':
                $icon = "<i class='fa fa-upload' style='font-size:26px;color: #0e6f5c'></i>";
                break;
            default:
                $icon = "<i class='fa fa-info' style='font-size:26px;color: black'></i>";
        }
        $GLOBALS['icon']=$icon;
        return $d;
    }, 'field' =>'type' ),

    array( 'db' => '`erp`.`erp_import_id`', 'dt' =>  'id', 'formatter' => function( $d, $row ) {
        $GLOBALS['importID']=$d;
        $icon = $GLOBALS['icon'];
        return "<div onclick='getErpDrillDown($d)'>$icon</div>";
    }, 'field' =>'erp_import_id' ),

    array( 'db' => '`erp`.`erp_import_id`', 'dt' =>  'runStatus', 'formatter' => function( $d, $row ) {
        $GLOBALS['importID']=$d;
        $icon = $GLOBALS['icon'];

        global $username;
        global $password;
        global $database;
        $db1 = new mysqli(localhost,$username,$password,$database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }

        $db1->set_charset("utf8");
        $stm1 = $db1->prepare("SELECT SUM(affected_records),SUM(deleted_records),SUM(delete_statements),MIN(start_time),MAX(end_time),COUNT(DISTINCT(status)),MAX(status),MAX(timestamp) FROM ERP_Import WHERE parent_id='$d'");
        $stm1-> execute();
        $stm1-> bind_result($affected,$deleted,$deleteStatements,$startTime,$endTime,$statusCount,$ERPstatus,$maxTimestamp);
        while ($stm1->fetch()) {
            if($affected==0){$affected='-';}
            if($deleted==0){$deleted='-';}
            if($deleteStatements==0){$deleteStatements='-';}
        }
        $stm1->close();


        $serverTimePlus = date('Y-m-d H:i:s',strtotime(date('Y-m-d H:i:s') . "-125 minutes"));
        if($maxTimestamp < $serverTimePlus && $statusCount > 1){
            $status = "<span  style='color: firebrick'><i class='fa fa-exclamation' style='font-size: 16px;'><b>&nbsp;Expired</b></i></span>";
        } else {
            if($statusCount > 1){
                $status = "<span  style='color: darkgoldenrod'><i class='fa fa-refresh' style='font-size: 16px;'><b>&nbsp;Running</b></i></span>";
            } else {
                if(strcmp($ERPstatus,'Complete')==0) {
                    $status = "<span  style='color: darkgreen'><i class='fa fa-check' style='font-size: 16px;'><b>&nbsp;Done</b></i></span>";
                }

            }
        }

        $GLOBALS['affected']=$affected;
        $GLOBALS['deleted']=$deleted;
        $GLOBALS['deleteStatements']=$deleteStatements;
        $GLOBALS['maxEndTime']=$endTime;

        return "$status";
    }, 'field' =>'erp_import_id' ),


    array( 'db' => '`erp`.`start_time`', 'dt' =>  'start', 'formatter' => function( $d, $row ) {
        if(strcmp($d,'0000-00-00 00:00:00')==0){
            $date = '-';
        } else {
            $timezone = 'Europe/Athens';
            date_default_timezone_set($timezone);
            $timestamp = strtotime($d);
            $local_time = $timestamp + date('Z');
            $date = date('d-m-Y H:i:s', $local_time);
            $date = str_replace(' ','<br>',$date);
        }
        return $date;
    }, 'field' =>'start_time' ),

    array( 'db' => '`erp`.`end_time`', 'dt' =>  'end', 'formatter' => function( $d, $row ) {
        if(strcmp($GLOBALS['maxEndTime'],'0000-00-00 00:00:00')==0){
            $date = '-';
        } else {
            $timezone = 'Europe/Athens';
            date_default_timezone_set($timezone);
            $timestamp = strtotime($GLOBALS['maxEndTime']);
            $local_time = $timestamp + date('Z');
            $date = date('d-m-Y H:i:s', $local_time);
            $date = str_replace(' ','<br>',$date);
        }
        return $date;
    }, 'field' =>'end_time' ),

    array( 'db' => '`erp`.`name`', 'dt' =>  'name', 'formatter' => function( $d, $row ) {
        return $d;
    }, 'field' =>'name' ),


    array( 'db' => '`erp`.`affected_records`', 'dt' =>  'affected', 'formatter' => function( $d, $row ) {
        return $GLOBALS['affected'];
    }, 'field' =>'affected_records'),

    array( 'db' => '`erp`.`deleted_records`', 'dt' =>  'deleted', 'formatter' => function( $d, $row ) {

        return $GLOBALS['deleted'];
    }, 'field' =>'deleted_records'),

    array( 'db' => '`erp`.`delete_statements`', 'dt' =>  'deleteStatements', 'formatter' => function( $d, $row ) {
        return $GLOBALS['deleteStatements'];
    }, 'field' =>'delete_statements'),

    array( 'db' => '`erp`.source_name', 'dt' =>  'source_name', 'formatter' => function( $d, $row ) {
        return $d;
    }, 'field' =>'source_name'),

    array( 'db' => '`erp`.source_method', 'dt' =>  'source_method', 'formatter' => function( $d, $row ) {
        return str_replace('_',' ',$d);
    }, 'field' =>'source_method'),

    array( 'db' => '`erp`.source_ip', 'dt' =>  'ip', 'formatter' => function( $d, $row ) {
        return $d;
    }, 'field' =>'source_ip'),

    array( 'db' => '`erp`.status', 'dt' =>  'status', 'formatter' => function( $d, $row ) {
        if(strcmp($d,'Refused')==0){
            $result = "<b style='color: firebrick'>$d</b>";
        } else {
            $result = "$d";
        }
        return $result;
    }, 'field' =>'status'),

);
global $username,$password,$database;
// SQL server connection information
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db'   => $database ,
    'host' => 'localhost'
);


$db = new mysqli(localhost,$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$importsArray = array();
$db->set_charset("utf8");
$stm = $db->prepare("SELECT erp_import_id FROM ERP_Import WHERE parent_id=erp_import_id ORDER BY erp_import_id DESC LIMIT 500");
$stm-> execute();
$stm-> bind_result($importID);
while ($stm->fetch()) {array_push($importsArray,$importID);}
$stm->close();
$importsFilter = implode(',',$importsArray);


$where = ' erp_import_id = parent_id ';

if(strcmp($importsFilter,'')!=0){
    $where.= "AND erp_import_id IN ($importsFilter)";
}

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */
$joinQuery = "FROM `ERP_Import` AS `erp` ";
require( ROOT.'backend/core/controllers/ssp2.class.php' );

echo json_encode(
    SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns,$joinQuery,$where)
);

?>