<?php
class ContractSchedule{

    public $displayProcess;
    public $contractDatesLock;

    public function __construct($contractDatesLock = false,$displayProcess = false){
        $this->displayProcess = $displayProcess;
        $this->contractDatesLock = $contractDatesLock;
    }

    public function getContractSchedulesForExecution($db,$currentDate){

        $contractDatesLock = $this->contractDatesLock;
        $contractDatesFilter = "";
        $contractSchedules = array();

        if($contractDatesLock) {
            $contractDatesFilter .= "AND (DATE(Contracts.start_date) >= DATE('$currentDate') OR Contracts.start_date = '0000-00-00')";
            $contractDatesFilter .= "AND (DATE(Contracts.end_date) >= DATE('$currentDate') OR Contracts.end_date = '0000-00-00')";
        }

        $csStmt = $db->prepare("SELECT contract_schedule_id,Contract_Schedules.contract_id, service_call_id, Contract_Schedules.contract_type_id, assign_salesperson_id, type_of_schedule, Contract_Schedules.start_date, start_time, end_time, days, months, days_of_month, last_run_date, next_run_date, details, schedule_status,serial_number_id,customer_id,service_call_type_id,referred_salespersons,valid,schedule_status 
                                   FROM Contract_Schedules,Contracts 
                                  WHERE Contract_Schedules.contract_id = Contracts.contract_id 
                                    AND DATE(Contract_Schedules.start_date) <= DATE('$currentDate') 
                                    $contractDatesFilter
                                    AND valid='yes' 
                                    AND schedule_status = 'Active'
                               ORDER BY Contract_Schedules.type_of_schedule ASC");
        $csStmt->execute();
        $csStmt->bind_result($contractScheduleID, $contractID, $serviceCallID, $contractTypeID, $assignSalespersonID, $typeOfSchedule, $startDate, $startTime, $endTime, $days, $months, $daysOfMonth, $lastRunDate, $nextRunDate, $details, $scheduleStatus, $serialNumberID, $customerID, $scTypeID, $referredSalespersons,$valid,$scheduleStatus);
        while ($csStmt->fetch()) {

            if(strcmp("$valid",'yes') != 0){$validContract = true;} else {$validContract = false;}
            if(strcmp("$scheduleStatus",'Active') == 0){$active = true;} else {$active = false;}

            $match = $this->matchContractScheduleByDate($currentDate,$startDate,$typeOfSchedule,$months,$days,$daysOfMonth,$details);

            if($match){
                $contractSchedule = new stdClass();
                $contractSchedule->contractScheduleID = $contractScheduleID;
                $contractSchedule->contractID = $contractID;
                $contractSchedule->serviceCallID = $serviceCallID;
                $contractSchedule->contractTypeID = $contractTypeID;
                $contractSchedule->assignSalespersonID = $assignSalespersonID;
                $contractSchedule->typeOfSchedule = $typeOfSchedule;
                $contractSchedule->startDate = $startDate;
                $contractSchedule->startTime = $startTime;
                $contractSchedule->endTime = $endTime;
                $contractSchedule->days = $days;
                $contractSchedule->months = $months;
                $contractSchedule->daysOfMonth = $daysOfMonth;
                $contractSchedule->lastRunDate = $lastRunDate;
                $contractSchedule->nextRunDate = $nextRunDate;
                $contractSchedule->details = $details;
                $contractSchedule->scheduleStatus = $scheduleStatus;
                $contractSchedule->serialNumberID = $serialNumberID;
                $contractSchedule->customerID = $customerID;
                $contractSchedule->scTypeID = $scTypeID;
                $contractSchedule->referredSalespersons = $referredSalespersons;
                $contractSchedule->validContract = $validContract;
                $contractSchedule->active = $active;
                array_push($contractSchedules, $contractSchedule);

            }


        }
        $csStmt->close();

        return $contractSchedules;

    }

    public function getContractScheduleByID($db,$contractScheduleID){

        $contractSchedule = new stdClass();
        $contractSchedule->contractScheduleID = $contractScheduleID;
        $contractSchedule->contractID = 0;
        $contractSchedule->validContract = false;
        $contractSchedule->active = false;

        $csStmt = $db->prepare("SELECT contract_schedule_id,Contract_Schedules.contract_id, service_call_id, Contract_Schedules.contract_type_id, assign_salesperson_id, type_of_schedule, Contract_Schedules.start_date, start_time, end_time, days, months, days_of_month, last_run_date, next_run_date, details, schedule_status,serial_number_id,customer_id,service_call_type_id,referred_salespersons,valid,schedule_status
                                   FROM Contract_Schedules,Contracts 
                                  WHERE Contract_Schedules.contract_id = Contracts.contract_id 
                                    AND contract_schedule_id = ?");
        $csStmt->bind_param('i', $contractScheduleID);
        $csStmt->execute();
        $csStmt->bind_result($contractScheduleID, $contractID, $serviceCallID, $contractTypeID, $assignSalespersonID, $typeOfSchedule, $startDate, $startTime, $endTime, $days, $months, $daysOfMonth, $lastRunDate, $nextRunDate, $details, $scheduleStatus, $serialNumberID, $customerID, $scTypeID, $referredSalespersons,$valid,$scheduleStatus);
        while ($csStmt->fetch()) {

            if(strcmp("$valid",'yes') != 0){$validContract = true;} else {$validContract = false;}
            if(strcmp("$scheduleStatus",'Active') == 0){$active = true;} else {$active = false;}

            $contractSchedule->contractScheduleID = $contractScheduleID;
            $contractSchedule->contractID = $contractID;
            $contractSchedule->serviceCallID = $serviceCallID;
            $contractSchedule->contractTypeID = $contractTypeID;
            $contractSchedule->assignSalespersonID = $assignSalespersonID;
            $contractSchedule->typeOfSchedule = $typeOfSchedule;
            $contractSchedule->startDate = $startDate;
            $contractSchedule->startTime = $startTime;
            $contractSchedule->endTime = $endTime;
            $contractSchedule->days = $days;
            $contractSchedule->months = $months;
            $contractSchedule->daysOfMonth = $daysOfMonth;
            $contractSchedule->lastRunDate = $lastRunDate;
            $contractSchedule->nextRunDate = $nextRunDate;
            $contractSchedule->details = $details;
            $contractSchedule->scheduleStatus = $scheduleStatus;
            $contractSchedule->serialNumberID = $serialNumberID;
            $contractSchedule->customerID = $customerID;
            $contractSchedule->scTypeID = $scTypeID;
            $contractSchedule->referredSalespersons = $referredSalespersons;
            $contractSchedule->validContract = $validContract;
            $contractSchedule->active = $active;


        }
        $csStmt->close();

        return $contractSchedule;

    }

    public function getContractScheduleServiceCallsByID($db,$contractScheduleID,$date){

        $date = date_format(date_create($date), "Y-m-d");
        $scArray = array();

        $csStmt = $db->prepare("SELECT service_call_id FROM Contract_Schedule_Service_calls WHERE contract_schedule_id = ? AND creation_date = ?");
        $csStmt->bind_param('is', $contractScheduleID,$date);
        $csStmt->execute();
        $csStmt->bind_result($serviceCallID);
        while ($csStmt->fetch()) {

            array_push($scArray, $serviceCallID);

        }
        $csStmt->close();

        return $scArray;

    }

    public function calculateNextExecutionDateByContractScheduleID($db,$contractScheduleID){

        $date = '';

        $csStmt = $db->prepare("SELECT start_date,type_of_schedule,months,days,days_of_month,details FROM Contract_Schedules WHERE contract_schedule_id = ? LIMIT 1");
        $csStmt->bind_param('i', $contractScheduleID);
        $csStmt->execute();
        $csStmt->bind_result($startDate,$typeOfSchedule,$months,$days,$daysOfMonth,$details);
        while ($csStmt->fetch()) {
            $date = $this->calculateNextExecutionDate($startDate,$typeOfSchedule,$months,$days,$daysOfMonth,$details);
        }
        $csStmt->close();


        return "$date";
    }

    public function contractScheduleHasServiceCall($db,$contractScheduleID,$date){

        $date = date_format(date_create($date), "Y-m-d");
        $result = false;

        $csStmt = $db->prepare("SELECT service_call_id FROM Contract_Schedule_Service_calls WHERE contract_schedule_id = ? AND creation_date = ? LIMIT 1");
        $csStmt->bind_param('is', $contractScheduleID,$date);
        $csStmt->execute();
        $csStmt->bind_result($serviceCallID);
        while ($csStmt->fetch()) {
            if(intval($serviceCallID) > 0){$result = true;}
        }
        $csStmt->close();

        return $result;

    }

    public function calculateNextExecutionDate($startDate,$typeOfSchedule,$months,$days,$daysOfMonth,$details=''){

        if(is_array($months)){$months = implode(',',$months);}
        if(is_array($days)){$days = implode(',',$days);}
        if(is_array($daysOfMonth)){$daysOfMonth = implode(',',$daysOfMonth);}

        $currentDate = date('Y-m-d');
        $startDate   = date_format(date_create($startDate), "Y-m-d");
        if($currentDate < $startDate){$currentDate = $startDate;}

        for ($i = 0; $i < 366; $i++) {
            $calculatedDate = date('Y-m-d', strtotime($currentDate . " +$i day"));
            $match = $this->matchContractScheduleByDate($calculatedDate,$startDate,$typeOfSchedule,$months,$days,$daysOfMonth,$details);

            if ($match) {
                return "$calculatedDate";
            }
        }
        return "";
    }

    public function matchContractScheduleByDate($currentDate,$startDate,$typeOfSchedule,$months,$days,$daysOfMonth,$details){

        $currentMonth = intval(date('m', strtotime($currentDate)));
        $currentDayDate = intval(date('d', strtotime($currentDate)));
        $currentDayNumber = intval(date('N', strtotime($currentDate)));
        $displayProcess = $this->displayProcess;
        $processLog = '';
        $match = false;

        switch ($typeOfSchedule) {
            case 'Single Date':
                $processLog = "$currentDate <=> $startDate";
                if(strcmp("$currentDate","$startDate") == 0){
                    $match = true;
                }
                break;
            case 'Daily':
                $processLog = "MONTH $currentMonth IN MONTHS [$months] OR MONTHS == ''";
                if(strcmp("$months",'') == 0 || in_array($currentMonth,explode(',',$months))){
                    $match = true;
                }
                break;
            case 'Weekly':
                $processLog = "MONTH $currentMonth IN MONTHS [$months] OR MONTHS == '' && NUMERIC DAY $currentDayNumber IN DAYS [$days] OR DAYS == '' AND NUMERIC DAY $currentDayNumber == 1";
                if(strcmp("$months",'') == 0 || in_array($currentMonth,explode(',',$months))){
                    if(strcmp("$days",'') == 0 && $currentDayNumber == 1 || in_array($currentDayNumber,explode(',',$days))) {
                        $match = true;
                    }
                }
                break;
            case 'Monthly':
                $processLog = "MONTH $currentMonth IN MONTHS [$months] OR MONTHS == '' && DATE OF MONTH $currentDayDate IN DATES OF MONTH [$daysOfMonth] OR DATES OF MONTH == '' AND DATE OF MONTH $currentDayDate == 1";
                if(strcmp("$months",'') == 0 || in_array($currentMonth,explode(',',$months))){
                    if(strcmp("$daysOfMonth",'') == 0 && $currentDayDate == 1 || in_array($currentDayDate,explode(',',$daysOfMonth))) {
                        $match = true;
                    }
                }
                break;
            default:
                break;

        }

        if($displayProcess) {
            if($match){$style = "background-color: #daf9d9;";} else {$style = "";}
            echo "<table style='width: fit-content;white-space: nowrap;border-collapse: collapse;'>";
            echo "<tr>";
            echo "<th style='border: 1px solid grey;padding: 10px;'>START DATE</th>";
            echo "<th style='border: 1px solid grey;padding: 10px;'>TYPE</th>";
            echo "<th style='border: 1px solid grey;padding: 10px;'>TITLE</th>";
            echo "<th style='border: 1px solid grey;padding: 10px;'>PROCESS</th>";
            echo "<th style='border: 1px solid grey;padding: 10px;'>DATE</th>";
            echo "<th style='border: 1px solid grey;padding: 10px;'>RESULT</th>";
            echo "</tr>";
            echo "<tr style='$style'>";
            echo "<td style='border: 1px solid grey;padding: 10px;'>$startDate</td>";
            echo "<td style='border: 1px solid grey;padding: 10px;'>$typeOfSchedule</td>";
            echo "<td style='border: 1px solid grey;padding: 10px;'>$details</td>";
            echo "<td style='border: 1px solid grey;padding: 10px;'>$processLog</td>";
            if ($match) {
                echo "<td style='border: 1px solid grey;padding: 10px;font-weight: bold;color: #0aa66e'>$currentDate</td>";
                echo "<td style='border: 1px solid grey;padding: 10px;font-weight: bold;color: #0aa66e'>MATCH</td>";
            } else {
                echo "<td style='border: 1px solid grey;padding: 10px;font-weight: bold;color: #ff0000'>$currentDate</td>";
                echo "<td style='border: 1px solid grey;padding: 10px;font-weight: bold;color: #ff0000'>NO MATCH</td>";
            }
            echo "</td>";
            echo "</tr>";
            echo "</table>";
        }

        return $match;
    }

    public function insertContractScheduleServiceCallRecord($db,$contractScheduleID,$serviceCallID,$date){

        $csStmt = $db->prepare("INSERT INTO Contract_Schedule_Service_calls (contract_schedule_id,service_call_id,creation_date,timestamp) VALUES(?,?,?,NOW())");
        $csStmt->bind_param('iis', $contractScheduleID, $serviceCallID, $date);
        $csStmt->execute();
        $error = $csStmt->error;
        $csStmt->close();

        if(strcmp($error,"")!=0) {
            return false;
        } else{
            return true;
        }


    }

    public function updateContractSchedule($db,$contractScheduleID,$currentDate,$nextRunDate,$startDateTime,$endDateTime){

        $startTime   = date_format(date_create($startDateTime), "H:i");
        $endTime     = date_format(date_create($endDateTime), "H:i");
        $nextStartDate = date_format(date_create($nextRunDate), "Y-m-d");

        $nextStartTime = $nextStartDate.' '.$startTime;
        $nextEndTime   = $nextStartDate.' '.$endTime;

        $csStmt = $db->prepare("UPDATE Contract_Schedules SET  last_run_date=?, next_run_date=?,start_time=?,end_time=? WHERE contract_schedule_id=?");
        $csStmt->bind_param('ssssi', $currentDate, $nextRunDate,$nextStartTime,$nextEndTime,$contractScheduleID);
        $csStmt->execute();
        $error = $csStmt->error;
        $csStmt->close();

        if(strcmp($error,"")!=0) {
            return false;
        } else{
            return true;
        }

    }
}