<?php
require("./concc/dbinfo.php");
if(!isset($_SESSION['adminID']) ) {
    redirect("../../../login.php");
}



function redirect($url)
{
    if (headers_sent())
    {
        die('<script type="text/javascript">window.location.href="' . $url . '";</script>');
    }
    else
    {
        header('Location: ' . $url);
        die();
    }
}



global $username,$password,$database;
$db = new mysqli(localhost,$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

$stm = $db->prepare("SELECT product_details_configuration_json FROM B2B_Page_Catalogue");
$stm-> execute();
$stm-> bind_result($pageConfigJson);
while ($stm->fetch()) {}
$stm-> close();

if (isset($_GET['field']) && strcmp($_GET['field'],'')!=0){
    $fieldString = $_GET['field'];
}else{
    $fieldString = "Item Name,Category,SKU";
}

if(strcmp($pageConfigJson,'')==0) {
    $pageConfigJson = '{
    "name":{"name":"name","visible_login":"yes","visible_logout":"yes","position":"1","hide_Empty":"yes","show_label":"yes","show_box":"no","primary_Language":"","alter_Language":""},
    "category":{"name":"category","visible_login":"yes","visible_logout":"yes","position":"2","hide_Empty":"yes","show_label":"yes","show_box":"yes","primary_Language":"","alter_Language":""},
    "code":{"name":"code","visible_login":"yes","visible_logout":"yes","position":"3","hide_Empty":"yes","show_label":"yes","show_box":"no","primary_Language":"","alter_Language":""},
    "sku":{"name":"sku","visible_login":"yes","visible_logout":"yes","position":"4","hide_Empty":"yes","show_label":"yes","show_box":"no","primary_Language":"","alter_Language":""},
    "barcode":{"name":"barcode","visible_login":"yes","visible_logout":"yes","position":"5","hide_Empty":"yes","show_label":"yes","show_box":"no","primary_Language":"","alter_Language":""},
    "packing":{"name":"packing","visible_login":"yes","visible_logout":"yes","position":"6","hide_Empty":"yes","show_label":"yes","show_box":"no","primary_Language":"","alter_Language":""},
    "custom_form":{"name":"Custom Form","visible_login":"yes","visible_logout":"yes","position":"7","hide_Empty":"yes","show_label":"yes","show_box":"no","primary_Language":"","alter_Language":""},
    "brochures":{"name":"brochures","visible_login":"yes","visible_logout":"yes","position":"8","hide_Empty":"yes","show_label":"yes","show_box":"no","primary_Language":"","alter_Language":""},
    "videos":{"name":"videos","visible_login":"yes","visible_logout":"yes","position":"9","hide_Empty":"yes","show_label":"yes","show_box":"no","primary_Language":"","alter_Language":""},
    "contract_prices":{"name":"Pricing","visible_login":"yes","visible_logout":"yes","position":"10","hide_Empty":"yes","show_label":"yes","show_box":"no","primary_Language":"","alter_Language":""},
    "stock":{"name":"Stock","visible_login":"yes","visible_logout":"yes","position":"11","hide_Empty":"yes","show_label":"yes","show_box":"no","primary_Language":"","alter_Language":""},
    "price":{"name":"Price","visible_login":"yes","visible_logout":"yes","position":"12","hide_Empty":"yes","show_label":"yes","show_box":"no","primary_Language":"","alter_Language":""},
    "recommended_price":{"name":"Recommended Retail Price","visible_login":"yes","visible_logout":"yes","position":"13","hide_Empty":"yes","show_label":"yes","show_box":"no","primary_Language":"","alter_Language":""},
    "short_description":{"name":"short description","visible_login":"yes","visible_logout":"yes","position":"14","hide_Empty":"yes","show_label":"yes","show_box":"no","primary_Language":"","alter_Language":""},
    "button":{"name":"long description","visible_login":"yes","visible_logout":"yes","position":"15","hide_Empty":"yes","show_label":"yes","show_box":"no","primary_Language":"","alter_Language":""},
    "long_description":{"name":"long description","visible_login":"yes","visible_logout":"yes","position":"16","hide_Empty":"yes","show_label":"yes","show_box":"no","primary_Language":"","alter_Language":""}
    }';

}


?>


<div id="main" role="main">

    <!-- Start CUSTOM CODE-->
    <!-- RIBBON -->
    <div id="ribbon" class="bg-color-blue">

				<span class="ribbon-button-alignment">
					<span id="refresh" class="btn btn-ribbon2" onclick="location.reload(true);" data-title="refresh" rel="tooltip" data-placement="bottom" data-original-title="<i class='text-warning fa fa-warning'></i> Reload Page?" data-html="true">
						<i class="fa fa-refresh"></i>
					</span>
				</span>

        <!-- breadcrumb -->
        <ol class="breadcrumb">
            <li class="txt-color-white"> B2B Page Product Details</li>
        </ol>
        <!-- end breadcrumb -->


    </div>
    <!-- END RIBBON -->

    <!-- MAIN CONTENT -->
    <div id="content" style="padding-top: 0;">
        <div class="row">
            <div class="col-xs-12 col-sm-7 col-md-7 col-lg-8">
                <h1 class="page-title txt-color-blueDark"><i class="fa-fw fa fa-gears"></i> Page Product Details</h1>
            </div>
            <div class="col-xs-12 col-sm-5 col-md-5 col-lg-2">

            </div>
            <div class="col-xs-12 col-sm-5 col-md-5 col-lg-2">
                    <span class="pull-right show-stat-buttons">
                        <span> <button id="saveButton" onclick="saveChanges();" class="btn btn-success btn-block" style="margin-top: 15px;">
                                <i class="fa fa-check"></i>&nbsp; Save Field Options</button>
                        </span>
                    </span>
            </div>
        </div>


        <!-- widget grid -->
        <section id="widget-grid" class="">
            <div class="row">

                <!-- widget sliders -->
                <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12" >
                    <div  class="jarviswidget jarviswidget-color-blueDark" id="wid-id-0" data-widget-editbutton="false" data-widget-deletebutton="false">
                        <header>
                            <span class="widget-icon"> <i class="fa fa-gears"></i> </span>
                            <h2>Manage Page Product Details </h2>
                        </header>
                        <!-- widget div-->

                        <!-- widget content -->
                        <div class="" style="padding: 10px; 10px; 10px; 10px;" >
                            <div class="">
                                <table class="table table-dark" style="width: 100%">
                                    <tr class="table-primary">
                                        <td style=""><b>Element</b></td>
                                        <td style=""><b>Position</b></td>
                                        <td style=""><b>Show On Login</b></td>
                                        <td style=""><b>Show On Logout</b></td>
                                        <td style=""><b>Hide If Empty</b></td>
                                        <td style=""><b>Show Label</b></td>
                                        <td style=""><b>Colored Box</b></td>
                                        <td style=""><b>Primary Language</b></td>
                                        <td style=""><b>Alter Language</b></td>
                                    </tr>
                                    <?php
                                    $pageElements = (array)json_decode($pageConfigJson);
                                    $maxPosition = count($pageElements);



                                    uasort($pageElements, function ($a, $b) {
                                        return intval($a->position) - intval($b->position);
                                    });



                                    foreach ($pageElements as $field => $object){

                                        $fieldIDforHtmlElement = str_replace(' ', '_', $field);
                                        $fieldName  = ucwords(str_replace('_', ' ', $field));

                                        if(strcmp($object->visible_login,'no')==0){$visible_login_no = "selected";$visible_login_style='background-color:#f6c6c1;';}else{$visible_login_no = "";$visible_login_style='background-color:#AFE1AF;';}
                                        if(strcmp($object->visible_logout,'no')==0){$visible_logout_no = "selected";$visible_logout_style='background-color:#f6c6c1;';}else{$visible_logout_no = "";$visible_logout_style='background-color:#AFE1AF;';}
                                        if(strcmp($object->hide_Empty,'no')==0){$hide_empty_no = "selected";$hide_empty_style='background-color:#f6c6c1;';}else{$hide_empty_no = "";$hide_empty_style='background-color:#AFE1AF;';}
                                        if(strcmp($object->show_label,'no')==0){$show_label_no = "selected";$show_label_style='background-color:#f6c6c1;';}else{$show_label_no = "";$show_label_style='background-color:#AFE1AF;';}
                                        if(strcmp($object->show_box,'no')==0){$show_box_no = "selected";$show_box_style='background-color:#f6c6c1;';}else{$show_box_no = "";$show_box_style='background-color:#AFE1AF;';}

                                        echo "
                                         <tr>
                                            <td style=''>$fieldName</td>
                                            <td style=''>
                                                <input type='number' class='form-control text-center' id='position_$fieldIDforHtmlElement' min='0' max='$maxPosition' step='1' value='$object->position' oninput='(validity.valid)||(value=\"$maxPosition\");'>
                                            </td>
                                            <td style=''>
                                                <select class='form-control text-center' id='visibleLogin_$fieldIDforHtmlElement' style='$visible_login_style'>
                                                    <option value='yes'>Yes</option>
                                                    <option value='no' $visible_login_no>No</option>
                                                </select>
                                            </td>
                                            <td style=''>
                                                <select class='form-control text-center' id='visibleLogOut_$fieldIDforHtmlElement' style='$visible_logout_style'>
                                                    <option value='yes'>Yes</option>
                                                    <option value='no' $visible_logout_no>No</option>
                                                </select>
                                            </td>
                                            <td style=' '>
                                                <select class='form-control text-center' id='hideEmpty_$fieldIDforHtmlElement' style='$hide_empty_style'>
                                                    <option value='yes'>Yes</option>
                                                    <option value='no' $hide_empty_no>No</option>
                                                </select>
                                            </td>
                                            <td style=''>
                                                <select class='form-control text-center' id='showLabel_$fieldIDforHtmlElement' style='$show_label_style'>
                                                    <option value='yes'>Yes</option>
                                                    <option value='no' $show_label_no>No</option>
                                                </select>
                                            </td>
                                            <td style=''>
                                                <select class='form-control text-center' id='showBox_$fieldIDforHtmlElement' style='$show_box_style'>
                                                    <option value='yes'>Yes</option>
                                                    <option value='no' $show_box_no>No</option>
                                                </select>
                                            </td>
                                            <td style=''>
                                               <input type='text' class='form-control text-center' value='$object->primary_Language' id='primaryLanguage_$fieldIDforHtmlElement'>
                                            </td>
                                            <td style=''>
                                               <input type='text' class='form-control text-center' value='$object->alter_Language'  id='alterLanguage_$fieldIDforHtmlElement'>
                                            </td>
                                         </tr>
                                    ";
                                    }

                                    ?>

                                </table>
                            </div>
                        </div>
                    </div>
                </article>
            </div>
        </section>
    </div>
</div>








<script src="./js/plugin/dropzone/dropzone.min.js"></script>


<script type="text/javascript">


    function saveChanges(){
        var table = <?php echo json_encode(array_keys((array)json_decode($pageConfigJson))); ?>;
        var jsonArr = {};
        for (let i = 0; i < table.length; i++) {
            var idHTMLelement = table[i].replace(/\s/g, '');
            jsonArr[idHTMLelement] = {
                    name: table[i],
                    visible_login:$('#visibleLogin_'+idHTMLelement).val(),
                    visible_logout:$('#visibleLogOut_'+idHTMLelement).val(),
                    position:$('#position_'+idHTMLelement).val(),
                    hide_Empty:$('#hideEmpty_'+idHTMLelement).val(),
                    show_label:$('#showLabel_'+idHTMLelement).val(),
                    show_box:$('#showBox_'+idHTMLelement).val(),
                    alter_Language:$('#alterLanguage_'+idHTMLelement).val(),
                    primary_Language:$('#primaryLanguage_'+idHTMLelement).val(),
            };
        }

        var productPageJson = JSON.stringify(jsonArr);

        $.ajax({
            type: "POST",
            url: './concc/edit_product_details.php',
            data: {
                'productPageJson':productPageJson
            },
            success: function (result) {

                $.smallBox({
                    title : "Success!",
                    content : "Configuration saved",
                    color : "#739E73",
                    timeout: 3000,
                    icon : "fa fa-gift swing animated"
                });
                location.reload(true);
            }
        });

    }





    // End of SavePost()

    $(document).ready(function() {

        $('select').on('change', function (){
            var bull = $(this).val();
            if(bull == 'no'){
                $(this).css('background-color','#f6c6c1');
            }else{
                $(this).css('background-color','#AFE1AF');
            }
        });
        pageSetUp();
    });
</script>

<script src="js/plugin/select2/select2.min.js"></script>



