<?php
require("./concc/dbinfo.php");
if(!isset($_SESSION['adminID']) ) {
    redirect("../../../login.php");
}



function redirect($url)
{
    if (headers_sent())
    {
        die('<script type="text/javascript">window.location.href="' . $url . '";</script>');
    }
    else
    {
        header('Location: ' . $url);
        die();
    }
}



?>

<div id="main" role="main">

    <!-- Start CUSTOM CODE-->


    <!-- RIBBON -->
    <div id="ribbon" class="bg-color-blue">

				<span class="ribbon-button-alignment">
					<span id="refresh" class="btn btn-ribbon2" onclick="location.reload(true);" data-title="refresh" rel="tooltip" data-placement="bottom" data-original-title="<i class='text-warning fa fa-warning'></i> Reload Page?" data-html="true">
						<i class="fa fa-refresh"></i>
					</span>
				</span>

        <!-- breadcrumb -->
        <ol class="breadcrumb">
            <li class="txt-color-white"> Add Coupons</li>
        </ol>
        <!-- end breadcrumb -->


    </div>
    <!-- END RIBBON -->

    <!-- MAIN CONTENT -->
    <div id="content">
        <!-- row -->
        <div class="row">
            <article class="col-xs-12 col-sm-12 col-md-12 col-lg-6">
                <!-- new widget -->
                <div class="jarviswidget" id="wid-id-0" data-widget-togglebutton="false" data-widget-editbutton="false" data-widget-fullscreenbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

                    <header>
                        <span class="widget-icon"> <i class="fa fa-edit"></i> </span>
                        <h2>Add Coupons</h2>
                    </header>

                    <div class="widget-body">

                        <div class="row">

                            <div class="col-sm-12">

                                <form id="pageForm" method="post" class="smart-form" enctype="multipart/form-data">

                                    <fieldset style="padding-top:0px">
                                        <section>
                                            <h2 style="font-weight:bold;"></h2>
                                        </section>
                                        <div class="row">

                                            <section class="col-sm-11">
                                                <section>
                                                    <label class="label-bold  align-left">Promotion Type: </label>
                                                    <select class="form-control" id="promoType" >
                                                        <option value="4">(One Time) Percentage Discount</option>
                                                        <option value="5">(One Time) Amount Discount</option>
                                                        <option value="6">(One Time Per User) Percentage Discount</option>
                                                        <option value="7">(One Time Per User) Amount Discount</option>
                                                        <option value="9" >Competition</option>
                                                    </select>
                                                </section>
                                                <section>
                                                    <label class="label-bold align-left">Promotion Name: </label>
                                                    <input type="text" class="form-control"  id="promoName" value=""/>
                                                </section>
                                                <section>
                                                    <label class="label-bold align-left" id="promoAmountPercentLabel">Promotion Discount Amount/Percentage: </label>
                                                    <input type="text" class="form-control"  id="couponsAmountPercentage" value="0" />
                                                </section>
                                                <section>
                                                    <label class="label-bold align-left" id="numberOfCouponsLabel">Number of Coupons to Generate: </label>
                                                    <input type="number" class="form-control"  id="numberOfCoupons" value="1" />
                                                </section>
                                                <section>
                                                    <label class="label-bold align-left" id="couponsPrefixLabel">Coupons Prefix: </label>
                                                    <input type="text" class="form-control"  id="couponsPrefix" value="" maxlength="5" />
                                                </section>
                                                <section>
                                                    <label class="label-bold align-left">Valid From: </label>
                                                    <table style="width: 100%">
                                                        <tr>
                                                            <td style="width: 50%">
                                                                <input type="date" class="form-control" id="validFromDate" value="<?php echo date('Y-m-d');?>"/>
                                                            </td>
                                                            <td style="width: 50%">
                                                                <input type="time" class="form-control" id="validFromTime" value="00:00"/>
                                                            </td>
                                                        </tr>
                                                    </table>
                                                </section>
                                                <section>
                                                    <label class="label-bold align-left">Valid Until: </label>
                                                    <table style="width: 100%">
                                                        <tr>
                                                            <td style="width: 50%">
                                                                <input type="date" class="form-control" id="validUntilDate" value="<?php echo date('Y-m-d');?>"/>
                                                            </td>
                                                            <td style="width: 50%">
                                                                <input type="time" class="form-control" id="validUntilTime" value="23:59"/>
                                                            </td>
                                                        </tr>
                                                    </table>
                                                </section>
                                            </section>

                                        </div>
                                    </fieldset>
                                </form>


                                <footer>
                                    <input type="button" id="PostSubmit" class="btn btn-primary"  style="font-weight:400;font-size:15px;margin-top:30px;float:right;margin-right:10px;width:150px;" value="Add Coupons" onclick="addCoupons()">
                                </footer>

                            </div>

                        </div>

                    </div>
                    <!-- end widget div -->
                </div>
                <!-- end widget -->

            </article>

        </div>
        <!-- end row -->
    </div>






</div>





<script type="text/javascript">

    function filterInputsByType(type){
        if(type == 4){
            $('#couponsPrefixLabel').html("Coupons Prefix (Max 5 Characters):");
            $('#promoAmountPercentLabel').html("Promotion Discount Percentage (%):");
            $('#promoAmountPercentLabel').show();
            $('#couponsAmountPercentage').show();
            $('#numberOfCouponsLabel').show();
            $('#numberOfCoupons').show();
            $('#couponsPrefix').attr('maxlength','5').val('');
        } else if (type == 5){
            $('#couponsPrefixLabel').html("Coupons Prefix (Max 5 Characters):");
            $('#promoAmountPercentLabel').html("Promotion Discount Amount:");
            $('#promoAmountPercentLabel').show();
            $('#couponsAmountPercentage').show();
            $('#numberOfCouponsLabel').show();
            $('#numberOfCoupons').show();
            $('#couponsPrefix').attr('maxlength','5').val('');
        } else if(type == 6){
            $('#couponsPrefixLabel').html("Coupon Code (Max 10 Characters):");
            $('#promoAmountPercentLabel').html("Promotion Discount Percentage (%):");
            $('#promoAmountPercentLabel').show();
            $('#couponsAmountPercentage').show();
            $('#numberOfCouponsLabel').hide();
            $('#numberOfCoupons').val(1).hide();
            $('#couponsPrefix').attr('maxlength','10').val('');
        } else if(type == 7){
            $('#couponsPrefixLabel').html("Coupon Code (Max 10 Characters):");
            $('#promoAmountPercentLabel').html("Promotion Discount Amount:");
            $('#promoAmountPercentLabel').show();
            $('#couponsAmountPercentage').show();
            $('#numberOfCouponsLabel').hide();
            $('#numberOfCoupons').val(1).hide();
            $('#couponsPrefix').attr('maxlength','10').val('');
        } else if(type == 9){
            $('#couponsPrefixLabel').html("Competition Code (Max 10 Characters):");
            $('#promoAmountPercentLabel').hide();
            $('#couponsAmountPercentage').hide();
            $('#numberOfCouponsLabel').hide();
            $('#numberOfCoupons').hide();
            $('#couponsPrefix').attr('maxlength','10').val('');
        }
    }

    function addCoupons() {

        var promoType               = $('#promoType').val();
        var promoName               = $('#promoName').val();
        var couponsAmountPercentage = $('#couponsAmountPercentage').val();
        var numberOfCoupons         = $('#numberOfCoupons').val();
        var couponsPrefix           = $('#couponsPrefix').val();
        var validFrom               = $('#validFromDate').val()+'T'+$('#validFromTime').val();
        var validUntil              = $('#validUntilDate').val()+'T'+$('#validUntilTime').val();

        var validFromDate           = $('#validFromDate').val();
        var validUntilDate          = $('#validUntilDate').val();
        var validFromTime           = $('#validFromTime').val();
        var validUntilTime          = $('#validUntilTime').val();


        var run = false;

        $('#promoType').css('border-color','').css('background-color','');
        $('#promoName').css('border-color','').css('background-color','');
        $('#couponsAmountPercentage').css('border-color','').css('background-color','');
        $('#numberOfCoupons').css('border-color','').css('background-color','');
        $('#couponsPrefix').css('border-color','').css('background-color','');
        $('#validFromDate').css('border-color','').css('background-color','');
        $('#validUntilDate').css('border-color','').css('background-color','');
        $('#validFromTime').css('border-color','').css('background-color','');
        $('#validUntilTime').css('border-color','').css('background-color','');

        if(promoType.localeCompare('')==0){$('#promoType').css('border-color','firebrick').css('background-color','lightsalmon'); run = false;}
        else if(promoName.localeCompare('')==0){$('#promoName').css('border-color','firebrick').css('background-color','lightsalmon'); run = false;}
        else if(couponsAmountPercentage.localeCompare('')==0 || +couponsAmountPercentage <=0){$('#couponsAmountPercentage').css('border-color','firebrick').css('background-color','lightsalmon'); run = false;}
        else if(numberOfCoupons.localeCompare('')==0 || +numberOfCoupons <=0){$('#numberOfCoupons').css('border-color','firebrick').css('background-color','lightsalmon'); run = false;}
        else if(couponsPrefix.localeCompare('')==0){$('#couponsPrefix').css('border-color','firebrick').css('background-color','lightsalmon'); run = false;}
        else if(validFromDate.localeCompare('')==0){$('#validFromDate').css('border-color','firebrick').css('background-color','lightsalmon'); run = false;}
        else if(validUntilDate.localeCompare('')==0){$('#validUntilDate').css('border-color','firebrick').css('background-color','lightsalmon'); run = false;}
        else if(validFromTime.localeCompare('')==0){$('#validFromTime').css('border-color','firebrick').css('background-color','lightsalmon'); run = false;}
        else if(validUntilTime.localeCompare('')==0){$('#validUntilTime').css('border-color','firebrick').css('background-color','lightsalmon'); run = false;}
        else {
            run = true;
        }

        if(run){
            var d1 = Date.parse(validFromDate);
            var d2 = Date.parse(validUntilDate);
            if (d2 < d1) {
                run = false;
                $('#validFromDate').css('border-color','firebrick').css('background-color','lightsalmon');
                $('#validUntilDate').css('border-color','firebrick').css('background-color','lightsalmon');
            } else if(d2 == d1 && validUntilTime <= validFromTime){
                $('#validFromTime').css('border-color','firebrick').css('background-color','lightsalmon');
                $('#validUntilTime').css('border-color','firebrick').css('background-color','lightsalmon');
                run = false;
            }
        }

        if(numberOfCoupons.length > 0 && run) {

            $.ajax({
                type: 'POST',
                url: './concc/add_promotion_coupons.php',
                dataType: 'html',
                data: {
                    'promoType': promoType,
                    'promoName': promoName,
                    'couponsAmountPercentage': couponsAmountPercentage,
                    'numberOfCoupons': numberOfCoupons,
                    'couponsPrefix': couponsPrefix,
                    'validFrom': validFrom,
                    'validUntil':validUntil
                },
                success: function (result) {

                    $.smallBox({
                        title: 'Success!',
                        content: "Coupons successfully entered",
                        color: "#739E73",
                        timeout: 3000,
                        icon: "fa fa-user swing animated"
                    });
                    setTimeout(function(){window.history.back();}, 1000);
                }
            });
        }

    }

    // End of SavePost()

    $(document).ready(function() {

       pageSetUp();

       filterInputsByType($('#promoType').val());

       $('#promoType').on('change', function() {

           filterInputsByType($(this).val());

       });

    })
</script>

<script src="js/plugin/select2/select2.min.js"></script>



?>