<?php
if(!isset($_SESSION['adminID']) ) {
    redirect("../../../login.php");
}

include_once("../../../param.php");

global $username,$password,$database;
$db = new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");
$stm = $db->prepare("SELECT B2B_User.b2b_user_id,B2B_User.first_name,B2B_User.last_name,B2B_User.username,customer_code,customer_company_name
                            FROM Customers,B2B_User WHERE Customers.customer_id=B2B_User.customer_id 
                            ORDER BY Customers.customer_code, Customers.customer_company_name,B2B_User.first_name,B2B_User.last_name,B2B_User.username ");
$stm-> execute();
$stm-> bind_result($userID, $firstName, $lastName,$userName,$customerCode,$customerName);
$customerSelection = "<option value=''>Select User</option>";
while ($stm->fetch()) {
    $customerSelection .= "<option value='$userID'>$customerCode - $customerName ($firstName $lastName - $userName)</option>";
}

$stm->close();
function redirect($url)
{
    if (headers_sent())
    {
        die('<script type="text/javascript">window.location.href="' . $url . '";</script>');
    }
    else
    {
        header('Location: ' . $url);
        die();
    }
}
?>
<div id="main" role="main" class="background-color-whitish">

    <!-- Start CUSTOM CODE-->


    <!-- RIBBON -->
    <div id="ribbon" class="bg-color-blue">

				<span class="ribbon-button-alignment">
					<span id="refresh" class="btn btn-ribbon2" onclick="location.reload(true);" data-title="refresh" rel="tooltip" data-placement="bottom" data-original-title="<i class='text-warning fa fa-warning'></i> Reload Page?" data-html="true">
						<i class="fa fa-refresh"></i>
					</span>
				</span>

        <!-- breadcrumb -->
        <ol class="breadcrumb">
            <li class="txt-color-white">Home / B2B Favorites</li>
        </ol>
        <!-- end breadcrumb -->

    </div>
    <!-- END RIBBON -->

    <!-- MAIN CONTENT -->
    <div id="content">

        <div class="row">
            <div class="col-xs-12 col-sm-6 col-md-6 col-lg-6">
                <h3 style="display:inline;margin-left:10px;" class="page-title txt-color-blueDark header-margin">
                    <i class="fa fa-heart"></i>
                    Manage Favorites
                </h3>
            </div>
        </div>

        <!-- row -->
        <section id="widget-grid" class="" style="margin-top:10px;">
            <!-- row -->
            <div class="row">

                <!-- NEW WIDGET START -->
                <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

                    <div class="jarviswidget jarviswidget-color-blueDark" data-widget-editbutton="false" data-widget-deletebutton="false">
                        <header>
                            <span class="widget-icon"> <i class="fa fa fa-table"></i> </span>
                            <h2>User Form</h2>
                        </header>
                        <!-- widget div-->
                        <div>
                            <!-- widget content -->
                            <div class="widget-body" style="overflow-x:scroll">

                                <label style="display: block; margin-top: 10px"><b>Select B2B User:</b></label>
                                <select  name="userSearch" id="userSearch" class="form-control text-center" style="width: 40%;">
                                    <?php echo $customerSelection; ?>
                                </select>
<!--                                <input type="text" name="userSearch" id="userSearch" class=" text-center form-control" style="width: 40%;">-->

<!--                                <label style="display: block; margin-top: 10px"><b> User:</b></label>-->
<!--                                <select id="userSearch" name="userSearch" class="userSearch  text-center form-control" style="width: 40%;">-->
<!--                                </select>-->


                            </div>
                            <!-- end widget content -->

                        </div>
                        <!-- end widget div -->

                    </div>
                    <!-- end widget -->
                </article>
                <!-- NEW WIDGET END -->

                <!-- NEW WIDGET START -->
<!--                style="display: none;"-->
                <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12"   >
                    <div style="display: none;" class="productTableWidget jarviswidget jarviswidget-color-blueDark" id="wid-id-1" data-widget-editbutton="false" data-widget-deletebutton="false">
                        <header>
                            <span class="widget-icon"> <i class="fa fa-table"></i> </span>
                            <h2>Product Table </h2>
                        </header>
                        <!-- widget div-->
                        <div>
                            <!-- widget content -->
                            <div class="widget-body no-padding">

                                <table id="datatable_fixed_column" class="table table-striped table-hover dataTable" width="100%">
                                    <thead>
                                    <tr>
                                        <th ></th>
<!--                                        <th class="hasinput" style="width:8%" >-->
<!--                                            <center>-->
<!--                                                <button   id="removeAllButton" class="btn btn-danger" onclick="removeAllFavorites();" >-->
<!--                                                    Remove All-->
<!--                                                </button>-->
<!--                                            </center>-->
<!--                                        </th>-->
                                        <th class="hasinput" style="width:15%" >
                                            <input type="text" class="form-control text-center" placeholder="Filter Code" id="codeFilter"/>
                                        </th>
                                        <th class="hasinput" style="width:30%" >
                                            <input class="form-control text-center" placeholder="Filter Name" type="text" id="nameFilter"/>
                                        </th>

                                        <th class="hasinput" style="width:24%"  >
                                            <input type="text" class="form-control text-center" placeholder="Filter Sku" id="skuFilter"/>
                                        </th>
                                        <th class="hasinput"  style="width:10%">
                                            <input type="text" class="form-control text-center" placeholder="Filter Status" id="statusFilter"/>
                                        </th>
                                        <th class="hasinput" style="width:20%" >
                                            <center><button   id="showAllButton" class="btn btn-primary" onclick="showAllProducts(1);" >Show All Products</button></center>
                                        </th>
                                    </tr>
                                    <tr>
                                        <th class='text-center'>Image</th>
                                        <th class='text-center'>Item Code</th>
                                        <th class='text-center'>Name</th>
                                        <th class='text-center'>Item Sku</th>
                                        <th class='text-center'>Status</th>
                                        <th class='text-center'>Actions</th>
                                    </tr>
                                    </thead>

                                </table>

                            </div>
                            <!-- end widget content -->
                            <table id="copyFavorites" class="table">
                                <tbody>
                                <tr>
                                    <td  style="width: 40%;">
                                        <button class="btn btn-primary" onclick="copyFavorites()" style="width: 90%;">Copy Favorites To</button>
                                    </td>
                                    <td><i class="fw fa fa-arrow-right"></i></td>
                                    <td style="width: 50%;">
                                        <select id = "copyToUserSelection" name="copyToUserSelection" class="form-control  text-center " style="width: 90%;">
                                            <?php echo $customerSelection; ?>
                                        </select>
                                    </td>
                                </tr>
                                </tbody>
                            </table>

                        </div>
                        <!-- end widget div -->

                    </div>
                    <!-- end widget -->


                </article>
                <!-- NEW WIDGET END -->

            </div>


    </div>
    <!-- end widget content -->

    <!-- end row -->
    </section>

</div>

<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/DataTables/datatables.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatables/dataTables.colVis.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatables/dataTables.tableTools.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatables/dataTables.bootstrap.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatable-responsive/datatables.responsive.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/select2/select2.min.js"></script>


<script type="text/javascript">

    var otableItems;
    var showAll=0;

    function showAllProducts(value){

        var userID = $("#userSearch").val();

        if(showAll === 0){
            showAll=1;
            $('#showAllButton').html("Show Favorite Products").attr("onclick","showAllProducts(1);");
            otableItems.ajax.url("./concc/getFavoriteItems.php?userID="+userID+"&showAll="+showAll);

        } else {
            showAll=0;
            $('#showAllButton').html("Show All Products").attr("onclick","showAllProducts(0);");
            otableItems.ajax.url("./concc/getFavoriteItems.php?userID="+userID+"&showAll="+showAll);

        }
        otableItems.ajax.reload();
    }

    function activateButtonClicked(itemID) {
        var userID = $('#userSearch').val();
        $.ajax({
            type: "POST",
            url: "./concc/addFavoriteItem.php" ,
            data: {
                'itemID': itemID,
                'userID': userID
            },
            success: function(result) {
                if(result==0){
                    return;
                }

                $('#action-btn-' + itemID ).text('Remove')
                    .removeClass('btn-success')
                    .addClass('btn-danger')
                    .unbind('click')
                    .click(function() {
                        deactivateButtonClicked(itemID);
                    });


            }
        });
    }

    function deactivateButtonClicked(itemID) {
        var userID = $('#userSearch').val();
        $.ajax({
            type: "POST",
            url: "./concc/removeFavoriteItem.php",
            data: {
                'itemID': itemID,
                'userID': userID
            },
            success: function(result) {
                if(result==0){
                    return;
                }
                $('#action-btn-' +  itemID).text('Add')
                    .removeClass('btn-danger')
                    .addClass('btn-success')
                    .unbind('click')
                    .click(function() {
                        activateButtonClicked(itemID);
                    });
            }
        });
    }

    function copyFavorites(){
        var copyToUserSelection = $('#copyToUserSelection').val();
        if(copyToUserSelection===""){
            $.smallBox({
                title: "Warning!",
                content: "Select B2B User to copy.",
                color: '#b22222',
                timeout: 3000,
                icon: "fa fa-user swing animated"
            });
            return;
        }
        var fromUserID = $('#userSearch').val();

        $.ajax({
            type: "POST",
            url: './concc/copyFavoriteItemsToB2BUser.php',
            data: {
                'fromUser': fromUserID,
                'toUser': copyToUserSelection
            },
            success: function(result) {
                if(result==1){
                    $.smallBox({
                        title: "Success!",
                        content: "Favorite items have been successfully copied to the user.",
                        color: '#739E73',
                        timeout: 3000,
                        icon: "fa fa-user swing animated"
                    });
                }
                else{
                    $.smallBox({
                        title: "Warning!",
                        content: "Something went wrong!",
                        color: '#b22222',
                        timeout: 3000,
                        icon: "fa fa-user swing animated"
                    });
                }
            },
            error: function() {
                $.smallBox({
                    title: "Warning!",
                    content: "Something went wrong! Contact us.",
                    color: '#b22222',
                    timeout: 3000,
                    icon: "fa fa-user swing animated"
                });
            }
        });
    }

    function initProductTable(){

        var responsiveHelper_datatable_fixed_column = undefined;

        var breakpointDefinition = {
            tablet: 1024,
            phone: 480
        };

        /* COLUMN FILTER  */
         otableItems = $('#datatable_fixed_column').DataTable({
            "sDom": "<'dt-toolbar'<'col-xs-6 col-sm-6'f><'col-sm-6 col-xs-6 hidden-xs' B C l>r>" +
                "t" +
                "<'dt-toolbar-footer'<'col-sm-6 col-xs-12 hidden-xs'i><'col-sm-6 col-xs-12'p>>",
            "autoWidth": true,
            "processing": false,
            "serverSide": true,
            "ajax": {
                "url": "./concc/getFavoriteItems.php?userID=0&showAll=0",
            },
            "columns": [
                { "data": "image" },
                { "data": "code" },
                { "data": "name" },
                { "data": "sku" },
                { "data": "status" },
                { "data": "form" }
            ],
            "deferRender": true,
            "autoWidth": true,
            "buttons": [
                "copyHtml5",
                "excelHtml5",
                "csvHtml5",
                {
                    extend: 'pdfHtml5',
                    orientation: 'landscape',
                    pageSize: 'LEGAL'
                }
            ],
            "preDrawCallback": function() {
                // Initialize the responsive datatables helper once.
                if (!responsiveHelper_datatable_fixed_column) {
                    responsiveHelper_datatable_fixed_column = new ResponsiveDatatablesHelper($('#datatable_fixed_column'), breakpointDefinition);
                }
            },
            "rowCallback": function(nRow) {
                responsiveHelper_datatable_fixed_column.createExpandIcon(nRow);
            },
            "drawCallback": function(oSettings) {
                responsiveHelper_datatable_fixed_column.respond();
            }
        });

        // Apply the filter
        $("#datatable_fixed_column thead th input[type=text]").on('keyup change', function() {
            otableItems
                .column($(this).parent().index() + ':visible')
                .search(this.value)
                .draw();
        });

    }

    $(document).ready(function() {

        pageSetUp();
        initProductTable();
        $('#userSearch').select2();
        $('#copyToUserSelection').select2();


        $("#userSearch").on("change", function () {
            var userID = $("#userSearch").val().trim();
            $(".productTableWidget").hide();
            if (userID !== "" &&  userID !== 0 && userID!=null) {
                otableItems.ajax.url("./concc/getFavoriteItems.php?userID=" + userID + "&showAll=" + showAll);
                otableItems.ajax.reload();
                $(".productTableWidget").show();
            }

        });


    });



</script>


