<?php
if(!isset($_SESSION['adminID']) ) {
   redirect("../../../login.php");
}
$companyID = $_SESSION['companyID'];

function redirect($url)
{
	if (headers_sent())
	{
		die('<script type="text/javascript">window.location.href="' . $url . '";</script>');
	}
	else
	{
		header('Location: ' . $url);
		die();
	}    
}

?>
		<div id="main" role="main">
			<!-- Start CUSTOM CODE-->
			<!-- RIBBON -->
			<div id="ribbon" class="order">

				<span class="ribbon-button-alignment"> 
					<span id="refresh" class="btn btn-ribbon2" onclick="location.reload(true);" data-title="refresh" rel="tooltip" data-placement="bottom" data-original-title="<i class='text-warning fa fa-warning'></i> Reload Page?" data-html="true">
						<i class="fa fa-refresh"></i>
					</span> 
				</span>

				<!-- breadcrumb -->
				<ol class="breadcrumb">
					<li class="txt-color-white">Home / Manage B2B Account Requests</li>
				</ol>
				<!-- end breadcrumb -->

			</div>
			<!-- END RIBBON -->

			<!-- MAIN CONTENT -->
			<div id="content">

<div class="row">
	<div class="col-xs-12 col-sm-6 col-md-6 col-lg-6">
		<h3 class="page-title txt-color-blueDark" style="margin-top: 5px;margin-bottom: 15px;">
			<img style="display:inline;"class="custom-rounded-image order" src="./img/customersicon.png" width="30" height="30">&nbsp;
            B2B Account Requests
						</h3>
				</div>
</div>

<!-- row -->
<section id="widget-grid" class="">
					<!-- row -->
					<div class="row">
						<!-- NEW WIDGET START -->
						<article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
											
							<div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-1" data-widget-editbutton="false" data-widget-deletebutton="false">																
								<header>
									<span class="widget-icon"> <i class="fa fa-table"></i> </span>
									<h2>Requests Table </h2>
								</header>
				
								<!-- widget div-->
								<div>
									<!-- widget content -->
									<div class="widget-body no-padding">
				
										<table id="datatable_fixed_column" class="table table-striped table-hover dataTable" width="100%">
					
									        <thead>
												<tr>
													<th class="hasinput" style="width:5%"></th>
													<th class="hasinput" >
														<input type="text" class="form-control text-center" placeholder="Filter Company" />
													</th>
                                                    <th class="hasinput" >
                                                        <input type="text" class="form-control text-center" placeholder="Filter Name" />
                                                    </th>
                                                    <th class="hasinput" >
                                                        <input type="text" class="form-control text-center" placeholder="Filter Last" />
                                                    </th>
                                                    <th class="hasinput" >
                                                        <input type="text" class="form-control text-center" placeholder="Filter email" />
                                                    </th>
                                                    <th class="hasinput" >
                                                        <input type="text" class="form-control text-center" placeholder="Filter Phone" />
                                                    </th>
                                                    <th class="hasinput" >
                                                        <input type="text" class="form-control text-center" placeholder="Filter Address" />
                                                    </th>
                                                    <th class="hasinput" >
                                                    </th>
													

												</tr>
									            <tr>
													<th class='text-center'></th>
								                    <th class='text-center'>Company</th>
                                                    <th class='text-center'>First Name</th>
                                                    <th class='text-center'>Last Name</th>
								                    <th class='text-center'>Email</th>
								                    <th class='text-center'>Phone</th>
								                    <th class='text-center' data-hide="phone,tablet">Address</th>
								                    <th class='text-center' data-hide="phone,tablet">Actions</th>
									            </tr>
									        </thead>
										</table>
									</div>
									<!-- end widget content -->
								</div>
								<!-- end widget div -->
							</div>
							<!-- end widget -->
						</article>
						<!-- WIDGET END -->
					</div>
					<!-- end row -->
				</section>
	</div>
	</div>

    <!--Modal-->
    <div class="modal fade" id="createModal" tabindex="-1" role="dialog" aria-labelledby="appInfoLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                        <h4 class="modal-title" style="margin-left:10px;">
                            <i class="fa fa-plus"></i><strong style="padding-left:5px;"> Create B2B Account</strong>
                            <button onclick="$('#createModal').modal('toggle');" class="btn btn-default pull-right" type="button" style="margin-right:10px;"><i class="fa fa-times"></i></button>
                        </h4>

                </div>

                <div class="modal-body" id="createModalBody" style="margin-top:5px;padding-top:5px;">

                    <label class="label-bold">Create account for Customer:</label>
                    <input type='hidden' placeholder="Select Customer" id='customerSearch' name='customerSearch' class="form-control" />

                </div>

                <footer class="modal-footer">
                    <button onclick="" class="btn btn-default pull-left" type="button" id="createCustomerButton" style="margin-right:10px;"><i class="fa fa-plus"></i>&nbsp; Create Customer</button>
                    <button onclick="" class="btn btn-success pull-right" type="button" id="createAccountButton" style="margin-right:10px;"><i class="fa fa-check"></i>&nbsp; Create Account</button>
                </footer>
            </div><!--/.modal-content-->
        </div><!--/.modal-dialog-->
    </div><!--/.modal-->

	<script src="js/plugin/datatables/jquery.dataTables.min.js"></script>
    <script src="js/plugin/datatables/dataTables.colVis.min.js"></script>
	<script src="js/plugin/datatables/dataTables.tableTools.min.js"></script>
	<script src="js/plugin/datatables/dataTables.bootstrap.min.js"></script>
	<script src="js/plugin/datatable-responsive/datatables.responsive.min.js"></script>
		
	<script type="text/javascript">

        function initCustomerAutocomplete(){
            $("#customerSearch").select2({
                minimumInputLength: 2,
                ajax: {
                    url: "//<?php echo HTML_PATH ?>/cop/backend/core/controllers/search/customerSearch.php",
                    dataType: "json",
                    type: "GET",
                    data: function (term, page) {
                        return {
                            query: term
                            //page: page,
                            // pageLimit: 25
                        };
                    },
                    results: function (data) {
                        return {
                            results: $.map(data, function (item) {
                                return {
                                    text: item.name,
                                    id: item.id
                                }
                            })
                        };
                    }
                }
            });

        }

        function createUser(request){
            $('#createCustomerButton').attr("onclick","createCustomer("+request+")");
            $('#createAccountButton').attr("onclick","createAccount("+request+")");
            $('#customerSearch').val('').select2("val", "");

            $('#createModal').modal('toggle');
        }

        function createCustomer(request){
            window.open('//<?php echo HTML_PATH; ?>/cop/backend/core/views/addedit/new_customer.php?b2bAccountRequest='+request, '_blank');
        }

        function createAccount(request){
            var customerForAccount = $('#customerSearch').val();
            if(customerForAccount && customerForAccount > 0) {
                window.open('//<?php echo HTML_PATH; ?>/cop/backend/modules/b2bAdmin/edit_b2b_user_privileges.php?cid=' + customerForAccount + '&b2bAccountRequest=' + request, '_blank');
            } else {
                $('#s2id_customerSearch').css('border','3px solid firebrick');
                setTimeout(function(){$('#s2id_customerSearch').css('border','');}, 2000);

            }
        }

        function deleteRequest(request){
            $.ajax({
                type: "POST",
                url: './concc/deletelAccountRequest.php',
                data: {'request' : request},
                success: function (result) {
                    $.smallBox({
                        title: "Success!",
                        content: "Request Marked as Deleted",
                        color: "#739E73",
                        timeout: 3000,
                        icon: "fa fa-user swing animated"
                    });

                    $('#datatable_fixed_column').DataTable().ajax.reload(null,false);

                }
            });
        }
		
		$(document).ready(function() {
			
			pageSetUp();
            initCustomerAutocomplete();
			

				var responsiveHelper_datatable_fixed_column = undefined;

				var breakpointDefinition = {
					tablet : 1024,
					phone : 480
				};

			/* COLUMN FILTER  */
		    var otable = $('#datatable_fixed_column').DataTable({
				"sDom": "<'dt-toolbar'<'col-xs-6 col-sm-6'f><'col-sm-6 col-xs-6 hidden-xs' T C l>r>"+
						"t"+
						"<'dt-toolbar-footer'<'col-sm-6 col-xs-12 hidden-xs'i><'col-sm-6 col-xs-12'p>>",
				"autoWidth" : true,
				"processing": false,

        "serverSide": true,

        "ajax": "./concc/getAllAccountRequests.php",

        "columns": [
			{ "data": "img" },
            { "data": "company" },
            { "data": "name" },
            { "data": "last" },
            { "data": "email" },
            { "data": "mobile" },
            { "data": "address" },
            { "data": "form" }
        ],
				"deferRender": true,
				 "order": [[ 3, "desc" ]],
 "oTableTools": {
		        	 "aButtons": [
		             "copy",
		             "csv",
		             "xls",
		                {
		                    "sExtends": "pdf",
		                    "sTitle": "Coprime PDF",
		                    "sPdfMessage": "Coprime PDF Export",
		                    "sPdfSize": "letter"
		                },
		             	{
	                    	"sExtends": "print",
	                    	"sMessage": "Generated by Coprime<i>(press Esc to close)</i>"
	                	}
		             ],
		            "sSwfPath": "js/plugin/datatables/swf/copy_csv_xls_pdf.swf"
		        },
				"preDrawCallback" : function() {
					// Initialize the responsive datatables helper once.
					if (!responsiveHelper_datatable_fixed_column) {
						responsiveHelper_datatable_fixed_column = new ResponsiveDatatablesHelper($('#datatable_fixed_column'), breakpointDefinition);
					}
				},
				"rowCallback" : function(nRow) {
					responsiveHelper_datatable_fixed_column.createExpandIcon(nRow);
				},
				"drawCallback" : function(oSettings) {
					responsiveHelper_datatable_fixed_column.respond();
				}

		    });

		    // Apply the filter
		    $("#datatable_fixed_column thead th input[type=text]").on( 'keyup change', function () {

		        otable
		            .column( $(this).parent().index()+':visible' )
		            .search( this.value )
		            .draw();

		    } );
		    /* END COLUMN FILTER */

            setInterval( function () {
                otable.ajax.reload();
            }, 60000 );
		})

		</script>