<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ERROR);
include_once("../../../param.php");

$userSpecific  = trim($_POST['userSpecific']);
$filterProductStatus = trim($_POST['filterProductStatus']);

switch($filterProductStatus){
    case "active":
        $filterProductStatus = " AND NOT status='inactive'";
        break;
    case "inactive":
        $filterProductStatus = " AND status='inactive'";
        break;
    default:
        $filterProductStatus = "";
}

switch ($userSpecific) {
    case "only":
        $showUserSpecific = true;
        $onlySpecific = true;
        break;
    case "yes":
        $showUserSpecific = true;
        $onlySpecific = false;
        break;
    default:
        $showUserSpecific = false;
        $onlySpecific = false;

}

global $username,$password,$database;
$db = new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

$b2bCategories = getB2BCategories($db);
$b2bUserCategories = getB2BUserCategories($db);

$commonUsersAndB2B = array_intersect($b2bCategories,$b2bUserCategories);
$onlyForUsers = array_diff($b2bUserCategories,$b2bCategories);

$specificUserCategoryItems = array();
$categoryCustomers = array();
$categoryNames = array();

if(count($onlyForUsers)>0 && $showUserSpecific){
    $userCategoriesFilter = implode(",",$onlyForUsers);

    $stm = $db->prepare("SELECT B2B_Allow_Categories_User.category_id,CONCAT(customer_code, ' - ',customer_company_name) FROM B2B_Allow_Categories_User,B2B_User,Customers WHERE B2B_Allow_Categories_User.b2b_user_id=B2B_User.b2b_user_id AND Customers.customer_id=B2B_User.customer_id AND B2B_Allow_Categories_User.category_id IN($userCategoriesFilter) GROUP BY B2B_Allow_Categories_User.category_id,B2B_User.customer_id");
    $stm->execute();
    $stm->bind_result( $categoryID,$customer);
    while ($stm->fetch()) {
        if(!array_key_exists($categoryID,$categoryCustomers)){$categoryCustomers[$categoryID] = array();}
        array_push($categoryCustomers[$categoryID],$customer);
    }
    $stm->close();

    $stm = $db->prepare("SELECT Items.item_id,category_id FROM Items,Category_Item WHERE Items.item_id=Category_Item.item_id AND category_id IN($userCategoriesFilter) GROUP BY Items.item_id");
    $stm->execute();
    $stm->bind_result( $itemID,$categoryID);
    while ($stm->fetch()) {
        if(!array_key_exists($itemID,$specificUserCategoryItems)){$specificUserCategoryItems[$itemID] = array();}
        array_push($specificUserCategoryItems[$itemID],$categoryID);
    }
    $stm->close();

    $stm = $db->prepare("SELECT category_id,CONCAT(category_code,' - ',name) FROM Categories WHERE category_id IN($userCategoriesFilter)");
    $stm->execute();
    $stm->bind_result( $categoryID,$categoryName);
    while ($stm->fetch()) {
        $categoryNames[$categoryID] = $categoryName;
    }
    $stm->close();
}

//if($showUserSpecific) {
//    if(!$onlySpecific) {
//        echo "B2B Categories: " . count($b2bCategories) . "<br>";
//    }
//    echo "User Specific Categories: " . count($onlyForUsers) . "<br>";
//}

if($onlySpecific) {
    echo "<center><h3>Products Only For Specific Customers</h3></center>";
} else if($showUserSpecific) {
    echo "<center><h3>Products not in B2B Categories (inc. Specific Customers)</h3></center>";
} else {
    echo "<center><h3>Products not in B2B Categories</h3></center>";
}
echo "<style>table td{border: 1px solid gray;}</style>";
echo "<table class='table table-bordered ' style='width: 100%;border-collapse: collapse;'>";
echo "<tr style='background-color: #cbdbf3 !important;'>";
echo "<th><center>Item Code</center></th>";
echo "<th><center>Item Name</center></th>";
echo "<th><center>SKU</center></th>";
if($showUserSpecific) {
    echo "<th style='width: fit-content;white-space: nowrap;'><center>Specific Categories</center></th>";
    echo "<th style='width: fit-content;white-space: nowrap;'><center>Specific Customers</center></th>";
}
echo "</tr>";

$categoriesFilter = implode(",",$b2bCategories);
$stm = $db->prepare("SELECT item_id,item_code,item_sku,name,status FROM Items WHERE item_id NOT IN (SELECT item_id FROM Category_Item WHERE category_id IN($categoriesFilter)) $filterProductStatus ORDER BY item_code");
$stm->execute();
$stm->bind_result( $itemID,$itemCode,$itemSKU,$itemName,$status);
while ($stm->fetch()) {
    $style = "";
    $categoryCustomersList = "";
    $categoriesList = "";
    $userSpecificCategoriesCounter = count($specificUserCategoryItems[$itemID]);

    if($userSpecificCategoriesCounter>0){
        $style = "background-color: goldenrod;border-color: darkgoldenrod;color: white;";

        foreach($specificUserCategoryItems[$itemID] as $categoryID){
            $categoryCustomersList = implode("<br>",$categoryCustomers[$categoryID]);
            $categoriesList .= $categoryNames[$categoryID]."<br>";
        }
    }

    if($onlySpecific && $userSpecificCategoriesCounter==0){continue;}

    if(strcmp("$status","inactive")==0){
        $itemName .= " <span style='color: firebrick;font-weight: bold;'>(Inactive)</span>";
    }

    echo "<tr style='$style'>";
    echo "<td>$itemCode</td>";
    echo "<td>$itemName</td>";
    echo "<td>$itemSKU</td>";
    if($showUserSpecific) {
        echo "<td style='width: fit-content;white-space: nowrap;'>$categoriesList</td>";
        echo "<td style='width: fit-content;white-space: nowrap;'>$categoryCustomersList</td>";
    }
    echo "</tr>";
}
$stm->close();

echo "</table>";

function getB2BUserCategories($db){

    $categoriesArray = array();
    $categoryID = 0;

    $query="SELECT Categories.category_id FROM Categories INNER JOIN B2B_Allow_Categories_User ON(Categories.category_id=B2B_Allow_Categories_User.category_id) WHERE 1=1 GROUP BY Categories.category_id ";

    $stm = $db->prepare($query);
    $stm-> execute();
    $stm-> bind_result($categoryID);
    while ($stm->fetch()) {
        $categoriesArray = array_unique(array_merge($categoriesArray,getSubCategories($categoryID,$categoriesArray)));
    }
    $stm->close();

    return $categoriesArray;
}
function getB2BCategories($db){

    $categoriesArray = array();
    $categoryID = 0;

    $query="SELECT Categories.category_id FROM Categories,B2B_Categories WHERE Categories.category_id=B2B_Categories.category_id AND Categories.category_id > 100 ORDER BY B2B_Categories.position,category_code";

    $stm = $db->prepare($query);
    $stm-> execute();
    $stm-> bind_result($categoryID);
    while ($stm->fetch()) {
        $categoriesArray = array_unique(array_merge($categoriesArray,getSubCategories($categoryID,$categoriesArray)));
    }
    $stm->close();

    return $categoriesArray;
}

function getSubCategories($categoryID,$categoriesArray){

    if(!in_array($categoryID,$categoriesArray)){
        array_push($categoriesArray,$categoryID);
    }

    global $username,$password,$database;
    $db2 = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }

    $db2->set_charset("utf8");
    $stm2 = $db2->prepare("SELECT Categories.category_id FROM Categories,Subcategories WHERE  Subcategories.category_id =\"$categoryID\" AND Categories.category_id=Subcategories.subcategory_id ");
    $stm2-> execute();
    $stm2-> bind_result($subCategoryID);
    while ($stm2->fetch()) {
        if(!in_array($subCategoryID,$categoriesArray)){
            array_push($categoriesArray,$subCategoryID);
            $categoriesArray = array_unique(array_merge($categoriesArray,getSubCategories($subCategoryID,$categoriesArray)));
        }
    }
    $stm2-> close();

    return $categoriesArray;

}
?>