<?php
require("./concc/dbinfo.php");
if(!isset($_SESSION['adminID']) ) {
    redirect("login.php");
}


function redirect($url)
{
    if (headers_sent())
    {
        die('<script type="text/javascript">window.location.href="' . $url . '";</script>');
    }
    else
    {
        header('Location: ' . $url);
        die();
    }
}

function endsWith($haystack, $needle)
{
    $length = strlen($needle);
    if ($length == 0) {
        return true;
    }

    return (substr($haystack, -$length) === $needle);
}

if(isset($_POST['area_id'])){

    $isEdit      = true;
    $areaID      = trim($_POST['area_id']);
    $pageStatus  = 'Edit';
    $postURL     = 'edit_holyday_time_slots_post.php';

    global $username,$password,$database;
    $db = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");
    $stm = $db->prepare("SELECT holiday_slots_id,date,zip_code_id,time_slots,next_day_delivery_after_time FROM ZZ_Holiday_Time_Slots WHERE holiday_slots_id='$areaID'");
    $stm-> execute();
    $stm-> bind_result($areaID,$date,$zipCodeID,$timeSlots,$nextDayAfter);
    while ($stm->fetch()) {}
    $stm-> close();





} else {
    $isEdit      = false;
    $pageStatus  = 'New';
    $postURL     = 'add_holyday_time_slots_post.php';
    $date        = date('Y-m-d',strtotime(date('Y-m-d') . "-1 days"));
    $nextDayAfter= '23:59';
}
?>

<div id="main" role="main">

    <!-- Start CUSTOM CODE-->


    <!-- RIBBON -->
    <div id="ribbon" class="bg-color-blue">

				<span class="ribbon-button-alignment">
					<span id="refresh" class="btn btn-ribbon2" onclick="location.reload(true);" data-title="refresh" rel="tooltip" data-placement="bottom" data-original-title="<i class='text-warning fa fa-warning'></i> Reload Page?" data-html="true">
						<i class="fa fa-refresh"></i>
					</span>
				</span>

        <!-- breadcrumb -->
        <ol class="breadcrumb">
            <li class="txt-color-white"> <?php echo $pageStatus?> Holiday Time Slots</li>
        </ol>
        <!-- end breadcrumb -->


    </div>
    <!-- END RIBBON -->

    <!-- MAIN CONTENT -->
    <div id="content">
        <!-- row -->
        <div class="row">
            <article class="col-xs-12 col-sm-12 col-md-12 col-lg-6">
                <!-- new widget -->
                <div class="jarviswidget" id="wid-id-0" data-widget-togglebutton="false" data-widget-editbutton="false" data-widget-fullscreenbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

                    <header>
                        <span class="widget-icon"> <i class="fa fa-edit"></i> </span>
                        <h2><?php echo $pageStatus?> Holiday Time Slots</h2>
                    </header>

                    <div class="widget-body">

                        <div class="row">

                            <div class="col-sm-12">

                                <form id="pageForm" method="post" class="smart-form" enctype="multipart/form-data">

                                    <fieldset style="padding-top:0px">
                                        <section>
                                            <h2 style="font-weight:bold;"></h2>
                                        </section>
                                        <div class="row">

                                            <section class="col-sm-11">
                                                <section>
                                                    <label class="label-bold align-left">Select Area: </label>
                                                    <?php 
                                                    echo "<select id='zipCodesID' name='zipCodesID' class='form-control'>";
                                                    echo "<option value='0' selected></option>";
                                                    global $username,$password,$database;
                                                    $db = new mysqli('localhost',$username,$password,$database);
                                                    if (mysqli_connect_errno()) {
                                                        printf("Connect failed: %s\n", mysqli_connect_error());
                                                        exit();
                                                    }
                                                    $db->set_charset("utf8");
                                                    $stm = $db->prepare("SELECT zip_code_id,zip_code_region FROM ZZ_Zip_Codes WHERE 1=1");
                                                    $stm-> execute();
                                                    $stm-> bind_result($areaOptionID,$areaOptionName);
                                                    while ($stm->fetch()) {
                                                        
                                                        if($areaOptionID == $zipCodeID){
                                                            echo "<option value='$areaOptionID' selected>$areaOptionName</option>";
                                                        } else {
                                                            echo "<option value='$areaOptionID' >$areaOptionName</option>";

                                                        }
                                                        
                                                    }
                                                    $stm-> close();
                                                    
                                                    echo "</select>";
                                                    
                                                    ?>
                                                </section>
                                                <section>
                                                    <label class="label-bold align-left">Select Holiday (Date): </label>
                                                    <input type="date" class="form-control"  id="date"  value="<?php echo $date;?>"/>
                                                </section>
                                                <section>
                                                    <label class="label-bold align-left">Next Day Delivery After Time: </label>
                                                    <input type="time" class="form-control"  id="nextDayAfterTime"  value="<?php echo $nextDayAfter;?>"/>
                                                </section>
                                                <section>
                                                    <label class="label-bold align-left">Time Slots : </label>
                                                    <input type="text" class="form-control"  id="timeSlots" value="<?php echo $timeSlots?>"/>
                                                </section>
                                                <section>
                                                    <input type="hidden" class="form-control" id="areaID" value="<?php echo $areaID?>"/>
                                                </section>


                                            </section>

                                        </div>
                                    </fieldset>
                                </form>


                                <footer>
                                    <?php if($isEdit){echo '<input type="button" id="PostDelete" class="btn btn-danger pull-left"  style="font-weight:400;font-size:15px;margin-top:30px;float:right;margin-right:10px;width:250px;" value="Delete Holiday" onclick="deletePage()">';}?>
                                    <input type="button" id="PostSubmit" class="btn btn-primary"  style="font-weight:400;font-size:15px;margin-top:30px;float:right;margin-right:10px;width:250px;" value="Save Holiday Slots" onclick="savePost()">
                                </footer>

                            </div>

                        </div>

                    </div>
                    <!-- end widget div -->
                </div>
                <!-- end widget -->

            </article>

        </div>
        <!-- end row -->
    </div>






</div>





<script type="text/javascript">

    

    function deletePage(){
        var areaID       = $('#areaID').val();

        if(areaID > 0) {

            $.ajax({
                type: 'POST',
                url: './concc/remove_holiday.php',
                dataType: 'html',
                data: {
                    'areaID': areaID


                },
                success: function (result) {
                    $('#pageName').val('');
                    $('#pageName').trigger('change');
                    $('#position').val('');
                    $('#position').trigger('change');
                    $.smallBox({
                        title: 'Page Deleted!',
                        content: "Post successfully entered",
                        color: "#B22222",
                        timeout: 3000,
                        icon: "fa fa-user swing animated"
                    });
                    setTimeout(function(){window.close();}, 1000);
                }
            });
        }

    }

    function savePost() {

        var areaID       = $('#areaID').val();
        var date         = $('#date').val();
        var zipCodesID        = $('#zipCodesID').val();
        var nextDayAfterTime = $('#nextDayAfterTime').val();
        var timeSlots     = $('#timeSlots').val();



        if(zipCodesID > 0) {

            $.ajax({
                type: 'POST',
                url: './concc/<?php echo $postURL?>',
                dataType: 'html',
                data: {
                    'areaID': areaID,
                    'date': date,
                    'zipCodesID': zipCodesID,
                    'nextDayAfterTime': nextDayAfterTime,
                    'timeSlots': timeSlots

                },
                success: function (result) {

                    $.smallBox({
                        title: 'Success!',
                        content: "Holiday successfully entered",
                        color: "#739E73",
                        timeout: 3000,
                        icon: "fa fa-user swing animated"
                    });

                    setTimeout(location.reload(), 3000);
                }
            });
        } else {
            $.smallBox({
                title: 'Incomplete Data!',
                content: "Please Select Area",
                color: "firebrick",
                timeout: 3000,
                icon: "fa fa-user swing animated"
            });

        }
    }

    // End of SavePost()

    $(document).ready(function() {

       pageSetUp();

    });
</script>

<script src="js/plugin/select2/select2.min.js"></script>



?>