<?php
include_once("../../../param.php");

$edit = false;

global $username, $password, $database;
$db = new mysqli(localhost, $username, $password, $database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}


if(isset($_POST['grid_menu_id'])) {

    $isEdit       = true;
    $pageStatus   = 'Edit';
    $postURL      = 'edit_grid_menu_post.php';
    $menuItemID   = trim($_POST['grid_menu_id']);

    $db->set_charset("utf8");
    $stm = $db->prepare("SELECT title, url, icon, position, class_outer, class_inner, parent_id, hover_text,level FROM B2B_Grid_Menu WHERE b2b_grid_menu_id=" . $menuItemID);
    $stm->execute();
    $stm->bind_result($ItemTitle,$url,$icon, $position,$classOuter,$classInner,$parentID, $hoverTxt, $level);
    while ($stm->fetch()) {}
    $stm->close();

    $db->set_charset("utf8");
    $stm2 = $db->prepare("SELECT b2b_grid_menu_id, title FROM B2B_Grid_Menu WHERE b2b_grid_menu_id NOT LIKE ".$menuItemID);
    $stm2->execute();
    $stm2->bind_result($parentItemID, $parentTitle);
    while ($stm2->fetch()) {
        $selections = $selections.'<option value="'.$parentItemID.'" > '. $parentTitle .'</option>';
    }
    $stm2->close();

    $db->set_charset("utf8");
    $stm3 = $db->prepare("SELECT b2b_grid_menu_id, title FROM B2B_Grid_Menu WHERE b2b_grid_menu_id LIKE ".$parentID);
    $stm3->execute();
    $stm3->bind_result($selectedParentItemID, $selectedParentTitle);
    while ($stm3->fetch()) {
        $selections = $selections.'<option value="'.$selectedParentItemID.'" selected> '. $selectedParentTitle .'</option>';
    }
    $stm3->close();



} else {

    $db->set_charset("utf8");
    $stm = $db->prepare("SELECT b2b_grid_menu_id, title FROM B2B_Grid_Menu  ");
    $stm->execute();
    $stm->bind_result($ParentItemID, $ParentTitle);
    while ($stm->fetch()) {
        $selections = $selections.'<option value="'.$ParentItemID.'" > '. $ParentTitle .'</option>';
    }
    $stm->close();

    $isEdit      = false;
    $pageStatus  = 'New';
    $postURL     = 'add_grid_menu_post.php';
}

$ItemTitle = str_replace("'","’",$ItemTitle);
$hoverTxt  = str_replace("'","’",$hoverTxt);


//Get a list of file paths using the glob function.
$fileList = glob(ROOT.'b2b/assets/img/*');

//Loop through the array that glob returned.
foreach($fileList as $filename){
    $fileTitle =basename($filename);
    $icon=str_replace("./assets/img/","",$icon);
    $fileUrl = "//".HTML_PATH."/cop/b2b/assets/img/".$fileTitle;

    $fileName = explode(".",$fileTitle)[0];
    $fileName = str_replace("-"," ",$fileName);
    $fileName = str_replace("_"," ",$fileName);
    $fileName = str_replace("icon"," icon",$fileName);
    $fileName = str_replace("cardpayment","Card Payment",$fileName);
    $fileName = ucwords($fileName);

    if(strpos(' '.$fileTitle,'icon')>0 ) {
        if (strcmp($icon, $fileTitle) == 0) {
            $imgList .= '<option filename="' . $fileUrl . '"value="' . $fileTitle . '" selected>' . $fileName . '</option>';
        } else {
            $imgList .= '<option filename="' . $fileUrl . '"value="' . $fileTitle . '">' . $fileName . '</option>';
        }
    }
}

$fileList = glob(ROOT.'b2b/categoryImages/*');

foreach($fileList as $filename){
    $fileTitle =basename($filename);
    $icon=str_replace("categoryImages/","",$icon);
    $fileUrl = "//".HTML_PATH."/cop/b2b/categoryImages/".$fileTitle;

    $fileName = explode(".",$fileTitle)[0];
    $fileName = str_replace("-"," ",$fileName);
    $fileName = str_replace("_"," ",$fileName);
    $fileName = str_replace("icon"," icon",$fileName);
    $fileName = str_replace("cardpayment","Card Payment",$fileName);
    $fileName = ucwords($fileName);

    if(true) {
        if (strcmp($icon, $fileTitle) == 0) {
            $imgList .= '<option filename="' . $fileUrl . '"value="' . $fileTitle . '" selected>' . $fileName . '</option>';
        } else {
            $imgList .= '<option filename="' . $fileUrl . '"value="' . $fileTitle . '">' . $fileName . '</option>';
        }
    }
}

if(isset($level) && intval($level)==999){
    $isCategoryImage = true;
//    $preselectedCategoryID = intval(substr($menuItemID, 3));
    $preselectedCategoryID = $menuItemID;
} else {
    $level = 0;
    $isCategoryImage = false;
}

$categorySearch ='';
$db->set_charset("utf8");
$stm2 = $db->prepare("SELECT category_id, CONCAT(category_code, ' - ' ,name) FROM Categories ORDER BY category_code ASC");
$stm2-> execute();
$stm2-> bind_result($categoryID,$categoryName);
while ($stm2->fetch()) {
    if($categoryID == $preselectedCategoryID) {
        $categorySearch .= "<option value='$categoryID' selected>$categoryName</option>";
    } else {
        $categorySearch .= "<option value='$categoryID' >$categoryName</option>";

    }
}
$stm2-> close();
?>
<div id="main" role="main">

    <!-- Start CUSTOM CODE-->
    <!-- RIBBON -->
    <div id="ribbon" class="bg-color-blue">

				<span class="ribbon-button-alignment">
					<span id="refresh" class="btn btn-ribbon2" onclick="location.reload(true);" data-title="refresh" rel="tooltip" data-placement="bottom" data-original-title="<i class='text-warning fa fa-warning'></i> Reload Page?" data-html="true">
						<i class="fa fa-refresh"></i>
					</span>
				</span>
        <!-- breadcrumb -->
        <ol class="breadcrumb">
            <li class='txt-color-white'>Home / B2B <?php echo $pageStatus?> Grid Menu</li>";
        </ol>
        <!-- end breadcrumb -->
    </div>
    <!-- END RIBBON -->

    <!-- MAIN CONTENT -->
    <article id="content">

        <div class="row">
            <div class="col-xs-12 col-sm-6 col-md-6 col-lg-10">
                <h3 class="page-title txt-color-blueDark header-margin">
                    <i class="fa-fw fa fa-info-circle"></i>
                    B2B <?php echo $pageStatus?> Grid Menu
                </h3>
            </div>
        </div>

        <!-- NEW WIDGET START -->
        <section id="widget-grid" class="col-xs-12 col-sm-12 col-md-12 col-lg-7">

                <div class="jarviswidget jarviswidget-color-white" id="wid-id-1" data-widget-editbutton="false" data-widget-deletebutton="false">

                    <header>
                        <span class="widget-icon"> <i class="fa fa-edit"></i> </span>
                        <h2><?php echo $pageStatus?> Menu Item</h2>
                    </header>

                    <!-- row -->
                    <div class="row">
                    <article class="">

                        <form method="post" class="smart-form" enctype="multipart/form-data">
                            <section class="col-sm-12">
                                <section>
                                    <label class="label-bold align-left">Menu Item Type:</label>
                                    <select class="form-control"  id="level"  >
                                        <option value="0">Grid Menu Item</option>
                                        <option value="999">Category Image (App)</option>
                                    </select>
                                </section>
                                <section class="category-image-app-element">
                                    <label class="label-bold align-left">Select Category:</label>
                                    <select class="form-control"  id="categorySearch"  >
                                        <?php echo $categorySearch; ?>
                                    </select>
                                </section>
                                <section class="grid-menu-item-element">
                                    <label class="label-bold align-left">Menu Item Position:</label>
                                    <input type="number" class="form-control"  id="position" value="<?php echo $position?>" />
                                </section>
                                <section class="grid-menu-item-element">
                                    <label class="label-bold align-left">Item's Outer Class:</label>
<!--                                    <input type="text" class="form-control"  id="classOuter" />-->
                                    <select class="form-control"  id="classOuter">
                                        <option value="theme_color">Theme Color</option>
                                        <option value="report_stock_button_outer">Light Green</option>
                                        <option value="report_schedules_button_outer">Light Red</option>
                                        <option value="report_sales_button_outer">Light Blue</option>
                                        <option value="report_product_button_outer">Light Gray</option>
                                        <option value="report_customers_button_outer">Light Orange</option>
                                        <option value="report_salesperson_button_outer">Dark Gray</option>
                                    </select>
                                </section>
                                <section class="grid-menu-item-element">
                                    <label class="label-bold align-left">Item's Inner Class:</label>
<!--                                    <input type="text" class="form-control"  id="classInner"  />-->
                                    <select class="form-control"  id="classInner">
                                        <option value="report_big_image_button_inner">Big Image</option>
                                        <option value="report_stock_button_inner">Round Green</option>
                                        <option value="report_schedules_button_inner">Round Red</option>
                                        <option value="report_sales_button_inner">Round Blue</option>
                                        <option value="report_product_button_inner">Round Gray</option>
                                        <option value="report_customers_button_inner">Round Orange</option>
                                        <option value="report_salesperson_button_inner">Round Gray</option>
                                    </select>
                                </section>
                                <section class="grid-menu-item-element">
                                    <label class="label-bold align-left">Select Parent Item:</label>
                                        <select name="parentID" id="parentID"  class="form-control" >
                                            <option value="0" selected> -- No Parent -- </option>
                                            <?php echo $selections; ?>
                                        </select>
                                </section>
                                <section class="grid-menu-item-element">
                                    <label class="label-bold align-left">URL Link: </label>
                                    <input type="text" class="form-control" id="linkURL" value="<?php echo $url?>" />
                                </section>
                                <section class="grid-menu-item-element">
                                    <label class="label-bold align-left">Item Title: </label>
                                    <textarea class="form-control" id="summernote_title" name="titledata" ></textarea>
                                </section>
                                <section class="grid-menu-item-element">
                                    <label class="label-bold align-left">Hover Text: </label>
                                    <textarea class="form-control" id="summernote_hover_text" name="hoverdata" ></textarea>
                                </section>
                        </form>
                                <section>
                                    <table style="width: 100%;"  >
                                        <tr >
                                            <td style="width: 60%;" class="grid-menu-item-element">
                                                <label class="label-bold align-left pull-left" >Select Icon:</label><br>
                                                <select name="icon" id="icon"  class="form-control" style="width: 100%; height: 50px;" >
                                                    <?php echo $imgList; ?>
                                                </select>
                                            </td>
                                            <td rowspan="3" <?php if(!$isEdit){echo "class='grid-menu-item-element'";}?>>
                                                <center>
                                                <div id='iconImgOuter' style="width: 80%;">
                                                    <div id='iconImgInner' style="width: 200px;height: 250px;">
                                                        <img id="iconImg" class="img-rounded img-responsive center-canvas " src="" style="height: 80%; width: auto;" />
                                                    </div>
                                                </div>
                                                </center>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="width: 60%;" class="grid-menu-item-element" > <label class="label-bold text-center" >OR</label></td>
                                            <td></td>
                                        </tr>

                                        <tr>
                                            <td <?php if($isEdit){echo "style='width: 60%;'";}?> >
                                                <label class="label-bold align-left pull-left" >Upload Icon:</label><br>
                                                <form  style="margin-top:10px;height:120px;min-height: 0px !important;"  enctype= "multipart/form-data" class="dropzone" id="gridLogoUploadDropzone"></form>
                                            </td>
                                            <td></td>
                                        </tr>
                                    </table>


                                </section>
                                <footer>
                                    <input type="button" id="PostSubmit" class="btn btn-success"  style="font-weight:400;font-size:15px;margin-top:30px;float:right;margin-right:10px;width:180px;" value="Save Menu Item" >
                                    <button id="removePromotion" type="button" class="btn btn-danger" onclick="deleteMenuItem()" style="font-weight:400;font-size:15px;margin-top:30px;float:left;margin-left:1px;width:180px;" >Remove Menu Item</button>
                                </footer>
                            </section>




                    </article>
                </div>
            </div>
            <!-- end row -->

        </section>

</div>





<script type="text/javascript">




    function deleteMenuItem(){
        var menuItemID  = '<?php echo $menuItemID;?>';

        if(menuItemID .length > 0) {

            $.ajax({
                type: 'POST',
                url: './concc/remove_grid_menu_item.php',
                dataType: 'html',
                data: {
                    'menuItemID': menuItemID


                },
                success: function (result) {

                    $.smallBox({
                        title: 'Menu Item Deleted!',
                        content: "Post successfully Removed",
                        color : "#739E73",
                        timeout: 3000,
                        icon: "fa fa-user swing animated"
                    });
                    setTimeout(function(){window.history.back();}, 1000);
                }
            });
        }

    }
    function savePost()
    {
        var title      = $('#summernote_title').summernote('code');
        var hoverText  = $('#summernote_hover_text').summernote('code');
        var position   = $('#position').val();
        var innerClass = $('#classInner').val();
        var outerClass = $('#classOuter').val();
        var parent     = $('#parentID').val();
        var url        = $('#linkURL').val();
        var icon       = $('#icon').val();
        var level      = $('#level').val();
        var categorySearch      = $('#categorySearch').val();
        var menuItemID = '<?php echo $menuItemID?>';

        $.ajax({
            type: "POST",
            url: './concc/<?php echo $postURL?>',
            data: {
                'menuItemID':menuItemID,
                'icon':icon,
                'url':url,
                'parent':parent,
                'outerClass':outerClass,
                'innerClass':innerClass,
                'hoverText':hoverText,
                'position':position,
                'level':level,
                'categorySearch':categorySearch,
                'title':title
            },

            success: function (result) {

                $.smallBox({
                    title : "Success!",
                    content : "Post successfully saved",
                    color : "#739E73",
                    timeout: 3000,
                    icon : "fa fa-gift swing animated"
                });

                setTimeout(function(){window.history.back();}, 1000);
            }

        });
    }

    $(document).ready(function() {

        pageSetUp();

        $('#level').on('change', function() {
            var value = $(this).val();
            if (value == 999) {
                $('.grid-menu-item-element').hide();
                $('.category-image-app-element').show();
            } else {
                $('.grid-menu-item-element').show();
                $('.category-image-app-element').hide();
            }
        });

        $('#level').val('<?php echo $level?>').trigger('change');

        $('#categorySearch').select2();

        <?php
        if(strcmp($classOuter,'')!=0){
            echo "$('#classOuter').val('".$classOuter."').trigger('change');";
        }

        if(strcmp($classInner,'')!=0){
            echo "$('#classInner').val('".$classInner."').trigger('change');";
        }

        ?>

        $('#iconImgOuter').addClass($('#classOuter option:selected').val());
        $('#iconImgInner').addClass($('#classInner option:selected').val());

        $('#classOuter').change(function() {
            $('#iconImgOuter').removeClass();
            $('#iconImgOuter').addClass($('#classOuter option:selected').val());
            $('#iconImgOuter').addClass('img-rounded');
            $('#iconImgOuter').addClass('img-responsive');
            $('#iconImgOuter').addClass('center-canvas');

        });

        $('#classInner').change(function() {
            $('#iconImgInner').removeClass();
            $('#iconImgInner').addClass($('#classInner option:selected').val());


        });

        document.getElementById("iconImg").src = $('#icon option:selected').attr('filename');

        $('#icon').change(function() {
            document.getElementById("iconImg").src = $('#icon option:selected').attr('filename');

        });
        $('#summernote_title').summernote({
            height: 20,                 // set editor height
            minHeight: 20,             // set minimum height of editor
            maxHeight: null,            // set maximum height of editor
            focus: true,                // set focus to editable area after initializing summernote
            table: 'table table-striped'

        });

        $('#summernote_title').summernote('code', '<?php echo $ItemTitle ?>');

        $('#summernote_hover_text').summernote({
            height: 50,                 // set editor height
            minHeight: 50,             // set minimum height of editor
            maxHeight: null,            // set maximum height of editor
            focus: true,                // set focus to editable area after initializing summernote
            table: 'table table-striped'

        });

        $('#summernote_hover_text').summernote('code', '<?php echo $hoverTxt ?>');


        Dropzone.autoDiscover = false;
        $("#gridLogoUploadDropzone").dropzone({
            url: "./concc/<?php echo $postURL?>",
            maxFiles: 1,
            addRemoveLinks : true,
            maxFileSize: 10,
            dictResponseError: 'Error uploading file!',
            autoProcessQueue:false,
            uploadMultiple: true,
            paramName: 'gridLogoUpload',
            acceptedFiles: ".png,.jpg,.gif,.bmp,.jpeg",

            init: function() {

                var thisDropzone = this;


                dzClosure = this; // Makes sure that 'this' is understood inside the functions below.

                // for Dropzone to process the queue (instead of default form behavior):
                document.getElementById("PostSubmit").addEventListener("click", function(e) {
                    // Make sure that the form isn't actually being sent.
                    e.preventDefault();
                    e.stopPropagation();
                    var isEdit = "<?php echo $isEdit; ?>";
                    if (dzClosure.getQueuedFiles().length > 0) {
                        dzClosure.processQueue();
                    } else {
                        savePost();
                    }
                });


                //send all the form data along with the files:
                this.on("sendingmultiple", function(data, xhr, formData) {


                    formData.append("menuItemID" , '<?php echo $menuItemID?>');
                    formData.append("title"      , $('#summernote_title').summernote('code'));
                    formData.append("hoverText"  , $('#summernote_hover_text').summernote('code'));
                    formData.append("position"   , $("#position").val());
                    formData.append("innerClass" , $("#classInner").val());
                    formData.append("outerClass" , $("#classOuter").val());
                    formData.append("parent"     , $("#parentID").val());
                    formData.append("url"        , $("#linkURL").val());
                    formData.append("icon"       , $("#icon").val());
                    formData.append("level"      , $("#level").val());
                    formData.append("categorySearch"      , $("#categorySearch").val());


                });

                this.on("success", function(file, responseText) {
                    this.removeAllFiles(true);

                    $.smallBox({
                        title: "Success!",
                        content: "Post successfully entered",
                        color: "#739E73",
                        timeout: 3000,
                        icon: "fa fa-user swing animated"
                    });
                    setTimeout(function(){window.history.back();}, 1000);

                });

            },
            removedfile: function(file) {
                var _ref;
                return (_ref = file.previewElement) != null ? _ref.parentNode.removeChild(file.previewElement) : void 0;
            }
        }).get(0).dropzone.on("addedfile", function(file)
        {

        });


    });



</script>


<script src="js/notification/SmartNotification.min.js"></script>



<!-- include summernote css/js -->
<link rel="stylesheet" href="//<?php echo HTML_PATH ?>/cop/libs/summernote/dist/summernote.css">
<script type="text/javascript" src="//<?php echo HTML_PATH ?>/cop/libs/summernote/dist/summernote.js"></script>
<script src="./js/plugin/dropzone/dropzone.min.js"></script>
