<?php
require("./concc/dbinfo.php");
if(!isset($_SESSION['adminID']) ) {
    redirect("login.php");
}


function redirect($url)
{
    if (headers_sent())
    {
        die('<script type="text/javascript">window.location.href="' . $url . '";</script>');
    }
    else
    {
        header('Location: ' . $url);
        die();
    }
}

function endsWith($haystack, $needle)
{
    $length = strlen($needle);
    if ($length == 0) {
        return true;
    }

    return (substr($haystack, -$length) === $needle);
}

if(isset($_POST['holidayID'])){

    $isEdit      = true;
    $holidayID   = trim($_POST['holidayID']);
    $pageStatus  = 'Edit';
    $postURL     = 'edit_b2b_scheduled_holiday_post.php';

    global $username,$password,$database;
    $db = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");
    $stm = $db->prepare("SELECT date, time_slots, next_day_delivery_after_time FROM B2B_Scheduled_Holidays WHERE holiday_id='$holidayID'");
    $stm-> execute();
    $stm-> bind_result($date,$timeSlots,$nextDayAfter);
    while ($stm->fetch()) {}
    $stm-> close();





} else {
    $isEdit      = false;
    $pageStatus  = 'New';
    $postURL     = 'add_b2b_scheduled_holiday_post.php';
    $date        = date('Y-m-d',strtotime(date('Y-m-d') . "-1 days"));
    $nextDayAfter= '00:00';
}
?>

<div id="main" role="main">

    <!-- Start CUSTOM CODE-->


    <!-- RIBBON -->
    <div id="ribbon" class="bg-color-blue">

				<span class="ribbon-button-alignment">
					<span id="refresh" class="btn btn-ribbon2" onclick="location.reload(true);" data-title="refresh" rel="tooltip" data-placement="bottom" data-original-title="<i class='text-warning fa fa-warning'></i> Reload Page?" data-html="true">
						<i class="fa fa-refresh"></i>
					</span>
				</span>

        <!-- breadcrumb -->
        <ol class="breadcrumb">
            <li class="txt-color-white"> <?php echo $pageStatus?> Schedule Holiday</li>
        </ol>
        <!-- end breadcrumb -->


    </div>
    <!-- END RIBBON -->

    <!-- MAIN CONTENT -->
    <div id="content">
        <!-- row -->
        <div class="row">
            <article class="col-xs-12 col-sm-12 col-md-12 col-lg-6">
                <!-- new widget -->
                <div class="jarviswidget" id="wid-id-0" data-widget-togglebutton="false" data-widget-editbutton="false" data-widget-fullscreenbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

                    <header>
                        <span class="widget-icon"> <i class="fa fa-edit"></i> </span>
                        <h2><?php echo $pageStatus?> Schedule Holiday</h2>
                    </header>

                    <div class="widget-body">

                        <div class="row">

                            <div class="col-sm-12">

                                <form id="pageForm" method="post" class="smart-form" enctype="multipart/form-data">

                                    <fieldset style="padding-top:0px">
                                        <section>
                                            <h2 style="font-weight:bold;"></h2>
                                        </section>
                                        <div class="row">

                                            <section class="col-sm-11">
                                                <section>

                                                <section>
                                                    <label class="label-bold align-left">Select Holiday (Date): </label>
                                                    <input type="date" class="form-control"  id="date"  value="<?php echo $date;?>"/>
                                                </section>
                                                <section>
                                                    <label class="label-bold align-left">Next Day Delivery After Time: </label>
                                                    <input type="time" class="form-control"  id="nextDayAfterTime"  value="<?php echo $nextDayAfter;?>"/>
                                                </section>
                                                <section style="display: none;">
                                                    <label class="label-bold align-left">Time Slots : </label>
                                                    <input type="text" class="form-control"  id="timeSlots" value="<?php echo $timeSlots?>"/>
                                                </section>
                                                <section>
                                                    <input type="hidden" class="form-control" id="holidayID" value="<?php echo $holidayID?>"/>
                                                </section>


                                            </section>

                                        </div>
                                    </fieldset>
                                </form>


                                <footer>
                                    <?php if($isEdit){echo '<input type="button" id="PostDelete" class="btn btn-danger pull-left"  style="font-weight:400;font-size:15px;margin-top:30px;float:right;margin-right:10px;width:250px;" value="Delete Holiday" onclick="deletePage()">';}?>
                                    <input type="button" id="PostSubmit" class="btn btn-primary"  style="font-weight:400;font-size:15px;margin-top:30px;float:right;margin-right:10px;width:250px;" value="Save Holiday" onclick="savePost()">
                                </footer>

                            </div>

                        </div>

                    </div>
                    <!-- end widget div -->
                </div>
                <!-- end widget -->

            </article>

        </div>
        <!-- end row -->
    </div>






</div>





<script type="text/javascript">

    

    function deletePage(){
        var holidayID = $('#holidayID').val();

        if(holidayID > 0) {

            $.ajax({
                type: 'POST',
                url: './concc/remove_b2b_schedule_holiday.php',
                dataType: 'html',
                data: {
                    'holidayID': holidayID
                },
                success: function (result) {
                    $('#pageName').val('');
                    $('#pageName').trigger('change');
                    $('#position').val('');
                    $('#position').trigger('change');
                    $.smallBox({
                        title: 'Date Deleted!',
                        content: "Date successfully removed",
                        color: "#B22222",
                        timeout: 3000,
                        icon: "fa fa-user swing animated"
                    });
                    setTimeout(function () {window.history.back();}, 1000);
                }
            });
        }

    }

    function savePost() {

        var holidayID       = $('#holidayID').val();
        var date         = $('#date').val();
        var nextDayAfterTime = $('#nextDayAfterTime').val();
        var timeSlots     = $('#timeSlots').val();

        $.ajax({
            type: 'POST',
            url: './concc/<?php echo $postURL?>',
            dataType: 'html',
            data: {
                'holidayID': holidayID,
                'date': date,
                'nextDayAfterTime': nextDayAfterTime,
                'timeSlots': timeSlots

            },
            success: function (result) {

                if(result == 'Duplicate') {
                    $.smallBox({
                        title: 'Error!',
                        content: "Duplicate Date",
                        color: "#C46A69",
                        timeout: 3000,
                        icon: "fa fa-user swing animated"
                    });
                    return;
                } else {
                    $.smallBox({
                        title: 'Success!',
                        content: "Holiday successfully entered",
                        color: "#739E73",
                        timeout: 3000,
                        icon: "fa fa-user swing animated"
                    });

                    setTimeout(function () {window.history.back();}, 1000);
                }

            }
        });

    }

    // End of SavePost()

    $(document).ready(function() {

       pageSetUp();

    });
</script>

<script src="js/plugin/select2/select2.min.js"></script>



?>