<?php
include_once("../../../../param.php");

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */
include_once('dbinfo.php');
// DB table to use
$table = 'B2C_Payment_Methods';

// Table's primary key
$primaryKey = "payment_method_id";

// Array of database columns which should be read and sent back to DataTables.
// The `db` parameter represents the column name in the database, while the `dt`
// parameter represents the DataTables column identifier. In this case object
// parameter names
$columns = array(
    array('db' => '`s`.`logo`', 'dt' => 'image', 'formatter' => function ($d, $row) {
        if (isset($d) && $d != '') {
            return '<img class="img-rounded img-responsive center-canvas" src="//' . HTML_PATH . '/cop/b2b/assets/img/'. $d .'" width="45" height="45"></td>';
        } else {
            return '';
        }
    }, 'field' => 'logo'),
    array('db' => '`s`.`payment_method_code`',      'dt' => 'code',      'field' => 'payment_method_code'),
    array('db' => '`s`.`active`',      'dt' => 'active',      'field' => 'active'),
    array('db' => '`s`.`name`',      'dt' => 'title',     'field' => 'name'),
    array('db' => '`s`.`position`',      'dt' => 'positionDisplay',     'field' => 'position'),
    array('db' => '`s`.`payment_method_id`', 'dt' => 'position', 'formatter' => function( $d, $row ) {

        require("dbinfo.php");
        $db = new mysqli(localhost, $username, $password, $database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }


        $stm2 = $db->prepare("SELECT  position FROM B2C_Payment_Methods WHERE payment_method_id='$d'");
        $stm2->execute();
        $stm2->bind_result($position);
        while ($stm2->fetch()) {
        }
        $stm2->close();

        return "<input type='number' value='$position' id='$d' onchange='changePaymentPosition($d)' class='form-control' style='text-align: center;width: 100%; border: 2px solid lightgrey;'>";},
        'field' => 'payment_method_id' ),
    array('db' => '`s`.`allow_credit`',  'dt' => 'link',      'formatter' => function( $d, $row ) {
        if(strcmp($d,'yes')==0){
            return 'yes';
        } else {
            return 'no';
        }
        }, 'field' => 'allow_credit'),

    array('db' => '`s`.`timestamp`',            'dt' => 'time',      'field' => 'timestamp'),
    array('db' => '`s`.`payment_method_id`', 'dt' => 'form', 'formatter' => function( $d, $row ) {


        return '<form id="'.$d.'"action="edit_b2c_payment_method.php" method="post">
           		<input type="hidden" name="payment_method_id" value="'.$d.'">	           			                   
			<input style="font-size:13px;" type="submit" class="btn btn-primary" value="Edit" style="width:60px">
			</form>';},
        'field' => 'payment_method_id' )

);

// SQL server connection information
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db'   => $database,
    'host' => 'localhost'
);


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */
$joinQuery = "FROM `B2C_Payment_Methods` AS `s` ";
require('ssp2.class.php');

echo json_encode(
    SSP::simple($_GET, $sql_details, $table, $primaryKey, $columns, $joinQuery)
);

