<?php
include_once("../../../param.php");
require("./concc/dbinfo.php");
if(!isset($_SESSION['adminID']) ) {
    redirect("../../../login.php");
}



function redirect($url)
{
    if (headers_sent())
    {
        die('<script type="text/javascript">window.location.href="' . $url . '";</script>');
    }
    else
    {
        header('Location: ' . $url);
        die();
    }
}

function endsWith($haystack, $needle)
{
    $length = strlen($needle);
    if ($length == 0) {
        return true;
    }

    return (substr($haystack, -$length) === $needle);
}


    $db = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");
    $stm = $db->prepare("SELECT `b2c_customer_code_suffix`, 
                                       `b2c_customer_code_number`, 
                                       `customer_activation_method`, 
                                       `show_balance`, 
                                       `new_user_show_stock`, 
                                       `new_user_show_prices`, 
                                       `delivery_method_category_id`, 
                                       `ERP_order_salesperson_id`, 
                                       `add_customer_to_group`, 
                                       `customer_group_id`, 
                                       `use_coupons`
                                FROM `B2C_Configuration` 
                                WHERE b2c_confuguration_id=1 LIMIT 1");
    $stm->execute();
    $stm->bind_result($customerCodeSuffix, $customerCodeNumber, $customerActivationMethod, $showBalance, $newUserShowStock, $newUserShowPrices, $deliveryMethodCategoryID, $ERPorderSalesPersonID,$addCustomerToGroup,$customerGroupID,$useCoupons);
    while ($stm->fetch()) {}
    $stm-> close();


    $db->set_charset("utf8");
    $stm2 = $db->prepare("SELECT b2c_price_list,b2c_offer_price_list,use_as_b2c,anonymous_order,anonymous_quotation,anonymous_checkout,anonymous_checkout_customer_id FROM `B2B_Configuration` LIMIT 1");
    $stm2->execute();
    $stm2->bind_result($b2bRetailPrice, $b2bOfferPrice,$useAsB2C,$anonymousOrder,$anonymousQuotation,$anonymousCheckout,$anonymousCheckoutCustomerID);
    while ($stm2->fetch()) {}
    $stm2-> close();

    if($anonymousCheckoutCustomerID > 0){
        $db->set_charset("utf8");
        $stm3 = $db->prepare("SELECT CONCAT(customer_code,' - ' ,customer_company_name)  FROM Customers WHERE customer_id='$anonymousCheckoutCustomerID'");
        $stm3->execute();
        $stm3->bind_result($anonymousCheckoutCustomerName);
        while ($stm3->fetch()) {}
        $stm3->close();
    } else {
        $anonymousCheckoutCustomerID = 0;
        $anonymousCheckoutCustomerName = "";
    }

    $db->set_charset("utf8");
    $stm3 = $db->prepare("SELECT `pricetype_id`, CONCAT(`price_code`,' - ' ,`name`) codename  FROM `PriceTypes`");
    $stm3->execute();
    $stm3->bind_result($priceTypeID, $priceTypeNameCode);

    // Selection for Retail Price if No Price is selected
    if(strcmp($b2bRetailPrice,'0')==0) {
        $b2bPriceSelect = $b2bPriceSelect . '<option value="' . $b2bRetailPrice . '" selected > - Default Price List - </option>';
    } else {
        $b2bPriceSelect = $b2bPriceSelect . '<option value=" " > - No Price - </option>';
    }

    while ($stm3->fetch()) {

        // Selection for Offer Price
        if(strcmp($priceTypeID,$b2bRetailPrice)==0) {
            $b2bPriceSelect = $b2bPriceSelect . '<option value="' . $priceTypeID . '" selected >' . $priceTypeNameCode . '</option>';
        } else {
            $b2bPriceSelect = $b2bPriceSelect . '<option value="' . $priceTypeID . '" >' . $priceTypeNameCode . '</option>';
        }
    }

    $stm3-> close();

    $db->set_charset("utf8");
    $stm3 = $db->prepare("SELECT `pricetype_id`, CONCAT(`price_code`,' - ' ,`name`) codename  FROM `PriceTypes`");
    $stm3->execute();
    $stm3->bind_result($priceTypeID, $priceTypeNameCode);

    // Selection for Recommended Retail Price if No Price is selected
    if(strcmp($b2bOfferPrice,'0')==0) {
        $b2bOfferPriceSelect = $b2bOfferPriceSelect . '<option value="' . $b2bOfferPrice . '" selected > - No Offer Prices - </option>';
    } else {
        $b2bOfferPriceSelect = $b2bOfferPriceSelect . '<option value=" " > - No Price - </option>';
    }

    while ($stm3->fetch()) {

        // Selection for Recommended Retail Price
        if(strcmp($priceTypeID,$b2bOfferPrice)==0) {
            $b2bOfferPriceSelect = $b2bOfferPriceSelect . '<option value="' . $priceTypeID . '" selected >' . $priceTypeNameCode . '</option>';
        } else {
            $b2bOfferPriceSelect = $b2bOfferPriceSelect . '<option value="' . $priceTypeID . '" >' . $priceTypeNameCode . '</option>';
        }
    }

    $stm3-> close();


    $categorySearch ='';
    $db->set_charset("utf8");
    $stm2 = $db->prepare("SELECT category_id, CONCAT(category_code, ' - ' ,name) FROM Categories ORDER BY category_code ASC");
    $stm2-> execute();
    $stm2-> bind_result($categoryID,$categoryName);
    while ($stm2->fetch()) {
        if($categoryID == $deliveryMethodCategoryID) {
            $categorySearch .= "<option value='$categoryID' selected>$categoryName</option>";
        } else {
            $categorySearch .= "<option value='$categoryID' >$categoryName</option>";

        }
    }
    $stm2-> close();

    $groupSearch ='';
    $db->set_charset("utf8");
    $stm3 = $db->prepare("SELECT group_id, CONCAT(group_code, ' - ' ,name) FROM CustomerGroups ORDER BY group_code ASC");
    $stm3-> execute();
    $stm3-> bind_result($groupID,$groupName);
    while ($stm3->fetch()) {
        if($groupID == $customerGroupID) {
            $groupSearch .= "<option value='$groupID' selected>$groupName</option>";
        } else {
            $groupSearch .= "<option value='$groupID' >$groupName</option>";

        }
    }
    $stm3-> close();

    if(strcmp($showBalance,        'no')==0){$showBalanceNo         = 'selected';}
    if(strcmp($newUserShowStock,   'no')==0){$newUserShowStockNo    = 'selected';}
    if(strcmp($newUserShowPrices,  'no')==0){$newUserShowPricesNo   = 'selected';}
    if(strcmp($useCoupons,         'no')==0){$useCouponsNo          = 'selected';}
    if(strcmp($addCustomerToGroup, 'no')==0){$addCustomerToGroupNo  = 'selected';}

    if(strcmp($customerActivationMethod,   'email')==0){$activationMethodEmail    = 'selected';}
    if(strcmp($customerActivationMethod, 'contact')==0){$activationMethodContact  = 'selected';}

    if(strcmp($anonymousOrder, 'yes')==0){$anonymousOrderSelected  = 'selected';}
    if(strcmp($anonymousCheckout, 'yes')==0){$anonymousCheckoutSelected  = 'selected';}
    if(strcmp($anonymousQuotation, 'yes')==0){$anonymousQuotationSelected  = 'selected';}

    $B2CRegisteredCustomers = (int)$customerCodeNumber - 1;



?>

<div id="main" role="main">

    <!-- Start CUSTOM CODE-->


    <!-- RIBBON -->
    <div id="ribbon" class="bg-color-blue">

				<span class="ribbon-button-alignment">
					<span id="refresh" class="btn btn-ribbon2" onclick="location.reload(true);" data-title="refresh" rel="tooltip" data-placement="bottom" data-original-title="<i class='text-warning fa fa-warning'></i> Reload Page?" data-html="true">
						<i class="fa fa-refresh"></i>
					</span>
				</span>

        <!-- breadcrumb -->
        <ol class="breadcrumb">
            <li class="txt-color-white"> Home / B2C General </li>
        </ol>
        <!-- end breadcrumb -->


    </div>
    <!-- END RIBBON -->

    <!-- MAIN CONTENT -->
    <div id="content">


        <div class="row">
            <div class="col-xs-12 col-sm-6 col-md-6 col-lg-10">
                <h3 class="page-title txt-color-blueDark header-margin">
                    <i class="fa-fw fa fa-info-circle"></i>
                    B2C General
                </h3>
            </div>

            <div class="col-xs-12 col-sm-4 col-md-3 col-lg-2">
                    <span class="pull-right show-stat-buttons">
                        <span> <button id="PostSubmit1" class="btn btn-success btn-block" onclick="savePost()">
                                <i class="fa fa-check"></i>&nbsp; Save Configuration</button>
                        </span>
                    </span>
            </div>
        </div>

        <!-- NEW WIDGET START -->
        <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12 ">
        <!-- row -->
            <div class="row">

                <!-- new widget -->
                <div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-1" data-widget-togglebutton="false" data-widget-editbutton="false" data-widget-fullscreenbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

                    <header>
                        <span class="widget-icon"> <i class="fa fa-edit"></i> </span>
                        <h2>General Settings</h2>
                    </header>

                    <div class="widget-body">

                        <div class="row">

                            <div class="col-sm-12">

                                <form id="sliderForm" method="post" class="smart-form" enctype="multipart/form-data">

                                    <fieldset style="padding-top:0px">
                                        <section>
                                            <h2 style="font-weight:bold;"></h2>
                                        </section>

                                        <section class="col-sm-12">
                                            <section class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
                                                <section>
                                                    <div align="center">
                                                    <label class="label-bold align-left">B2C Customers Registered: </label>
                                                    <label class="label-bold align-left ">&nbsp;&nbsp;<strong><?php echo $B2CRegisteredCustomers ?> </label>
                                                </section>
                                                <section class="col-xs-6 col-sm-6 col-md-6 col-lg-6">
                                                    <label class="label-bold align-left">B2C Customer Suffix </label>
                                                    <input type="text" class="form-control"  id="b2cCustomerSuffix" value="<?php echo $customerCodeSuffix?>" placeholder="B2C00" />
                                                </section>
                                                <section class="col-xs-6 col-sm-6 col-md-6 col-lg-6">
                                                    <div style="margin-left: 4%;">
                                                    <label class="label-bold  align-left">Customer Activation Method: </label>
                                                    <select  class="form-control" id="activationMethod">
                                                        <option value="immediate" >On register (Immediate)</option>
                                                        <option value="email" <?php echo $activationMethodEmail;?>>Email Authentication</option>
                                                        <option value="contact" <?php echo $activationMethodContact;?>>Manual Authentication</option>
                                                    </select>
                                                    </div>
                                                </section>
                                                <section  class="col-xs-6 col-sm-6 col-md-6 col-lg-6">
                                                    <label class="label-bold  align-left">Show B2C Customer Credit Balance &nbsp;&nbsp;</label>
                                                    <select  class="form-control" id="showBalance">
                                                        <option value="yes" >yes</option>
                                                        <option value="no" <?php echo $showBalanceNo;?>>no</option>
                                                    </select>
                                                </section>
                                                <section  class="col-xs-6 col-sm-6 col-md-6 col-lg-6">
                                                    <div style="margin-left: 4%;">
                                                        <table  style="margin-left:;width: 100%;">
                                                            <tr>
                                                                <td style="width: 30%;"><div align="left"> <label class="label-bold  align-left">Add B2C Customers to a Group: </label></td>
                                                                <td style="height: 10px;width: 2%;"> </td>
                                                                <td><div align="left"> <label class="label-bold  align-left">Select B2C Customers Group: </label></td>
                                                            </tr>
                                                            <tr>
                                                                <td style="width: 50%;"><div align="left">
                                                                        <select  class="form-control" id="customerToGroup">
                                                                            <option value="yes" >yes</option>
                                                                            <option value="no" <?php echo $addCustomerToGroupNo;?>>no</option>
                                                                        </select>
                                                                </td>
                                                                <td style="height: 10px;width: 2%;"> </td>
                                                                <td><div align="left">
                                                                        <select  class="form-control" id="customerGroupID">
                                                                            <?php echo $groupSearch;?>
                                                                        </select>
                                                                </td>
                                                            </tr>
                                                        </table>
                                                    </div>
                                                </section>
                                                <table  style="width: 100%;margin-bottom: 10px;">
                                                    <tr>
                                                        <td style="width: 30%;"><div align="left">
                                                            <label class="label-bold  align-left" >B2C Price List: </label>
                                                        </td>
                                                        <td style="height: 10px;width: 2%;"> </td>
                                                        <td><div align="left">
                                                             <label class="label-bold  align-left" style="margin-left: 5px;">B2C Offer Price List: </label>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td style="width: 50%;"><div align="left">
                                                            <select  class="form-control" id="b2cRetailPrice">
                                                                   <?php echo $b2bPriceSelect; ?>
                                                            </select>
                                                        </td>
                                                        <td style="height: 10px;width: 2%;"> </td>
                                                        <td><div align="left">
                                                            <select  class="form-control" id="b2cOfferPrice">
                                                                   <?php echo $b2bOfferPriceSelect; ?>
                                                            </select>
                                                        </td>
                                                    </tr>
                                                </table>

                                                <section style="display: none" >
                                                    <label class="label-bold  align-left">Delivery Methods Category: </label>
                                                    <select  class="form-control" id="deliveryMethodsCategory">
                                                        <?php echo $categorySearch;?>
                                                    </select>
                                                </section>

                                                <section>
                                                    <table  style="width: 100%; margin-top: 5px;">
                                                        <tr>
                                                            <td colspan="5" style="border-bottom: 1px solid lightgray;">
                                                                <div align="left"><label class="label-bold  align-left">On New Customer Registration Set Defaults </label>
                                                            </td>
                                                        </tr>
                                                        <tr><td colspan="5" style="height: 10px;border-right: 1px solid lightgray;border-left: 1px solid lightgray;"> </td></tr>
                                                        <tr>
                                                            <td style="width: 30%;">
                                                                <div align="right" style="padding-left:5px;border-left: 1px solid lightgray;"><label class="label-bold  align-left">Show Stock Default &nbsp;&nbsp;</label>
                                                            </td>
                                                            <td style="width: 10%;">
                                                                <select  class="form-control" id="showStock">
                                                                    <option value="yes" >yes</option>
                                                                    <option value="no" <?php echo $newUserShowStockNo;?>>no</option>
                                                                </select>
                                                            </td>
                                                            <td style="width: 30%;">
                                                                <div align="right" style="padding-left:5px;"><label class="label-bold  align-left">Show Prices Default &nbsp;&nbsp;</label>
                                                            </td>
                                                            <td style="width: 10%;">
                                                                <select  class="form-control" id="showPrices">
                                                                    <option value="yes" >yes</option>
                                                                    <option value="no" <?php echo $newUserShowPricesNo;?>>no</option>
                                                                </select>
                                                            </td>
                                                            <td style="border-right: 1px solid lightgray;border-left: 1px solid lightgray;"> </td>
                                                        </tr>
                                                        <tr><td colspan="5" style="height: 10px;border-bottom: 1px solid lightgray;border-right: 1px solid lightgray;border-left: 1px solid lightgray;"> </td></tr>
                                                    </table>

                                                </section>
                                                <section>
                                                    <table  style="width: 100%; margin-top: 5px;background-color: whitesmoke;border: 1px solid lightgray;">
                                                        <tr>
                                                            <td colspan="4" style="border-bottom: 1px solid lightgray;">
                                                                <div align="center"><label style="font-weight: bolder"><br>Actions Without Customer Registration<br><br></label>
                                                            </td>
                                                        </tr>
                                                        <tr><td colspan="3" style="height: 10px;border-right: 1px solid lightgray;border-left: 1px solid lightgray;"> </td></tr>
                                                        <tr>
                                                            <td style="width: 25%;border-left: 1px solid lightgray;">
                                                                <div align="center" style="padding-left:5px;"><label class="label-bold">Enable Shopping Cart &nbsp;&nbsp;</label>
                                                            </td>
                                                            <td style="width: 25%;">
                                                                <div align="center" style="padding-left:5px;"><label class="label-bold  align-left">Allow Anonymous Quotation &nbsp;&nbsp;</label>
                                                            </td>
                                                            <td style="width: 25%;">
                                                                <div align="center" style="padding-left:5px;"><label class="label-bold  align-left">Allow Anonymous Checkout &nbsp;&nbsp;</label>
                                                            </td>
                                                            <td style="width: 25%;border-right: 1px solid lightgray;">
                                                                <div align="center" style="padding-left:5px;"><label class="label-bold">Select Anonymous Customer &nbsp;&nbsp;</label>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td style="width: 25%;">
                                                                <center>
                                                                <select  class="form-control text-center" id="anonymousOrder" style="width: 95%">
                                                                    <option value="no" >On Login Only</option>
                                                                    <option value="yes" <?php echo $anonymousOrderSelected;?>>On Login & Log out</option>
                                                                </select>
                                                            </td>
                                                            <td style="width: 25%;">
                                                                <center>
                                                                <select  class="form-control text-center" id="anonymousQuotation" style="width: 95%">
                                                                    <option value="no" >no</option>
                                                                    <option value="yes" <?php echo $anonymousQuotationSelected;?>>yes</option>

                                                                </select>
                                                            </td>
                                                            <td style="width: 25%;">
                                                                <center>
                                                                    <select  class="form-control text-center" id="anonymousCheckout" style="width: 95%">
                                                                        <option value="no" >no</option>
                                                                        <option value="yes" <?php echo $anonymousCheckoutSelected;?>>yes</option>

                                                                    </select>
                                                            </td>
                                                            <td style="width: 25%;border-right: 1px solid lightgray;">
                                                                <center>
                                                                <input type="hidden" id="useCoupons" value="<?php echo $useCoupons; ?>"/>
                                                                <input type="hidden" id="anonymousCustomerID" value="<?php echo $anonymousCheckoutCustomerID; ?>"/>
                                                                <input style='display:inline;' class='form-control text-center' id='customerSearch' name='customerSearch' type='text' value='<?php {echo "$anonymousCheckoutCustomerName"; }?>' placeholder="Select Anonymous Checkout Customer">
                                                            </td>

                                                        </tr>
                                                        <tr><td colspan="3" style="height: 10px;border-bottom: 1px solid lightgray;border-right: 1px solid lightgray;border-left: 1px solid lightgray;"> </td></tr>
                                                    </table>

                                                </section>
                                            </section>
                                        </section>
                                    </fieldset>
                                </form>

                            <footer>

                            </footer>

                            </div>

                        </div>

                    </div>
                    <!-- end widget div -->
                </div>
                <!-- end widget -->

                <!-- new widget -->
                <div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-2" data-widget-togglebutton="false" data-widget-editbutton="false" data-widget-fullscreenbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

                </div>
                <!-- end widget -->
            </div>

        </article>

        <!-- end row -->
    </div>

</div>




<script src="./js/plugin/dropzone/dropzone.min.js"></script>


<script type="text/javascript">

    function initCustomerAutocomplete(){
        $("#customerSearch").autocomplete({
            source: "//<?php echo HTML_PATH ?>/cop/backend/core/controllers/autocomplete/customer_autocomplete.php",
            autoFocus: true,
            select: function (event, ui) {
                $('#anonymousCustomerID').val(ui.item.customer_id);
                return true;
            }
        });
    }

    function savePost() {

       var b2cCustomerSuffix       = $('#b2cCustomerSuffix').val();
       var activationMethod        = $('#activationMethod').val();
       var customerToGroup         = $('#customerToGroup').val();
       var customerGroupID         = $('#customerGroupID').val();
       var showBalance             = $('#showBalance').val();
       var showStock               = $('#showStock').val();
       var showPrices              = $('#showPrices').val();
       var deliveryMethodsCategory = $('#deliveryMethodsCategory').val();
       var useCoupons              = $('#useCoupons').val();
       var b2cRetailPrice          = $('#b2cRetailPrice').val();
       var b2cOfferPrice           = $('#b2cOfferPrice').val();
       var anonymousOrder          = $('#anonymousOrder').val();
       var anonymousCheckout       = $('#anonymousCheckout').val();
       var anonymousQuotation      = $('#anonymousQuotation').val();
       var anonymousCustomerID     = $('#anonymousCustomerID').val();
       var anonymousCustomerName   = $("#customerSearch").val();

       if(anonymousCustomerName.localeCompare('')===0){anonymousCustomerID=0;}



           $.ajax({
               type: 'POST',
               url: './concc/edit_b2c_general.php',
               dataType: 'html',
               data: {
                   'b2cCustomerSuffix': b2cCustomerSuffix,
                   'activationMethod': activationMethod,
                   'customerToGroup': customerToGroup,
                   'customerGroupID': customerGroupID,
                   'showBalance': showBalance,
                   'showStock': showStock,
                   'showPrices': showPrices,
                   'deliveryMethodsCategory': deliveryMethodsCategory,
                   'b2cRetailPrice': b2cRetailPrice,
                   'b2cOfferPrice': b2cOfferPrice,
                   'anonymousOrder': anonymousOrder,
                   'anonymousCheckout': anonymousCheckout,
                   'anonymousQuotation': anonymousQuotation,
                   'anonymousCustomerID': anonymousCustomerID,
                   'useCoupons': useCoupons

               },
               success: function (result) {
                   $.smallBox({
                       title: 'Success!',
                       content: "Configuration Saved",
                       color: "#739E73",
                       timeout: 3000,
                       icon: "fa fa-user swing animated"
                   });
                   setTimeout(function(){location.reload();}, 10);
               }
           });

    }

    // End of SavePost()

    $(document).ready(function() {
        initCustomerAutocomplete();
        pageSetUp();
    });

</script>

<script src="js/plugin/select2/select2.min.js"></script>



