<?php
include_once("../../../../param.php");
require_once (ROOT . "libs/phpSpreadsheet/vendor/autoload.php");

global $username, $password, $database;
$db = new mysqli(localhost, $username, $password, $database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

$categorySelection = "<option value='' selected>All</option>";
$stm = $db->prepare("SELECT CONCAT(category_code, ' - ',name), category_id FROM Categories  ORDER BY category_code ASC");
$stm-> execute();
$stm-> bind_result($categoryInfo, $salesPersonID);
while ($stm->fetch()) {
    $categorySelection .= "<option value='$salesPersonID'>$categoryInfo</option>";
}
$stm-> close();

$todayYear = date("Y");
$yearOptions = '';
for ( $y = $todayYear; $y > $todayYear-20; $y-- ) {
    $yearOptions.= "<option value='$y'>$y</option>";
}


?>

<div id="main" role="main" class="background-color-whitish">

    <!-- Start CUSTOM CODE-->


    <!-- RIBBON -->
    <div id="ribbon" class="bg-color-blue">

				<span class="ribbon-button-alignment">
					<span id="refresh" class="btn btn-ribbon2" onclick="location.reload(true);" data-title="refresh" rel="tooltip" data-placement="bottom" data-original-title="<i class='text-warning fa fa-warning'></i> Reload Page?" data-html="true">
						<i class="fa fa-refresh"></i>
					</span>
				</span>

        <!-- breadcrumb -->
        <ol class="breadcrumb">
            <li class="txt-color-white">Home / Reports / Customer Visits  Report</li>
        </ol>
        <!-- end breadcrumb -->

    </div>
    <!-- END RIBBON -->

    <!-- MAIN CONTENT -->
    <div id="content">

        <div class="row">
            <div class="col-xs-12 col-sm-6 col-md-6 col-lg-6">
                <span>  <a onclick="backToReports()" class="btn btn-primary"><i class="fa fa-arrow-left"></i>&nbsp; Back to Reports</a> </span>
                <h3 style="display:inline;margin-left:10px;" class="page-title txt-color-blueDark header-margin">
                    <i class="fa-fw fa fa-signal"></i>
                    Reports
                </h3>
            </div>
        </div>

        <!-- row -->
        <section id="widget-grid" class="" style="margin-top:10px;">
            <!-- row -->
            <div class="row">

                <!-- NEW WIDGET START -->
                <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

                    <div class="jarviswidget jarviswidget-color-blueDark" data-widget-editbutton="false" data-widget-deletebutton="false">
                        <header>
                            <span class="widget-icon"> <i class="fa fa fa-table"></i> </span>
                            <h2>Business Review</h2>
                        </header>
                        <!-- widget div-->
                        <div>
                            <!-- widget content -->
                            <div class="widget-body" style="overflow-x:scroll">
                                <label style="display: block; margin-top: 10px"><b> Sales Person:</b></label>
                                <input type="text" id="salesPersonSelection" class="form-control"  style="width:30%;overflow: hidden; height: auto;" value="" >


                                <label style="display: block; margin-top: 10px"><b> Year:</b></label>
                                <select id="yearSelection" class="form-control" style="width:30%;">
                                    <?php echo $yearOptions ?>
                                </select>

                                <br><br>
                                <button type="button" name="generateExcel"  id="generateExcel"  class="btn btn-waybill" onclick="exportXLS()" >Export to Excel</button>

                            </div>
                            <!-- end widget content -->

                        </div>
                        <!-- end widget div -->

                    </div>
                    <!-- end widget -->
                </article>
                <!-- NEW WIDGET END -->

                <!-- NEW WIDGET START -->
                <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

                    <div class="jarviswidget jarviswidget-color-blueDark" data-widget-editbutton="false" data-widget-deletebutton="false">
                        <header>
                            <span class="widget-icon"> <i class="fa fa fa-table"></i> </span>
                            <h2>Business Review Report</h2>
                        </header>
                        <!-- widget div-->
                        <div>
                            <!-- widget content -->
                            <div class="widget-body" style="overflow-x:scroll">

                                <div name="reportResult" id="reportResult"></div>
                                <form method="POST" action="#" name="xlsForm" id="xlsForm" >
                                    <input type="hidden" name="inputResult" id="inputResult" value=""/>
                                    <input type="hidden" name="orientation" id="orientation" value="landscape"/>
                                    <input type="hidden" name="inputTitle" id="inputTitle" value="SingleProductSalesPurchases"/>
                                </form>

                            </div>
                            <!-- end widget content -->

                        </div>
                        <!-- end widget div -->

                    </div>
                    <!-- end widget -->
                </article>
                <!-- NEW WIDGET END -->

            </div>


    </div>
    <!-- end widget content -->

    <!-- end row -->
    </section>

</div>

<script type="text/javascript">
    function initSalesPersonSelection(){

        $("#salesPersonSelection").select2({
            multiple: true,
            minimumInputLength: 3,
            minimumResultsForSearch: 1,
            ajax: {
                url: "//<?php echo HTML_PATH ?>/cop/backend/core/controllers/search/salespersonSearch.php",
                dataType: "json",
                type: "GET",
                data: function (term, page) {
                    return {
                        query: term
                    };
                },
                results: function (data) {
                    return {
                        results: $.map(data, function (item) {
                            return {
                                text: item.name,
                                id: item.id
                            };
                        })
                    };
                }
            }
        });
    }



    $(document).ready(function() {
        pageSetUp();
        initSalesPersonSelection();

    });



    function exportXLS(){
        var salesPersonIDs = $('#salesPersonSelection').val();
        var year = $('#yearSelection').val();


        $('#reportResult').html('<center><b>Generating Report..</b></center>');

        $.ajax({
            type: "POST",
            url: '//<?php echo HTML_PATH ?>/cop/backend/core/views/reports/generateCustomerVisitsReport.php',
            data: {
                'salesPersonIDs':salesPersonIDs,
                'year':year
            },

            success: function (result) {
                var linkSource = 'data:application/vnd.openxmlformats-officedocument.spreadsheetml.sheet;base64,'+ result ;
                var downloadLink = document.createElement("a");
                var fileName = 'VisitsAnalysisReport.xlsx';

                downloadLink.href = linkSource;
                downloadLink.download = fileName;
                downloadLink.click();
                $('#reportResult').html("<center><h2 style='color:green;'>Success!!</h2></center>");


            }
        });


    }


    function backToReports() {
        try {
            $(".swLinkMenu")[0].click();
        }
        catch(err)
        {

        }

        setTimeout(function() {
            window.location = "reports_list.php";
        }, 1000);


    }




</script>


