<?php
include_once("../../../../param.php");

$dateFrom       = $_POST['dateFrom'];
$dateTo         = $_POST['dateTo'];
$salesPerson    = $_POST['salesPerson'];
$transferType   = $_POST['transferType'];
$fromWH         = $_POST['fromWH'];
$toWH           = $_POST['toWH'];
$showItem       = $_POST['showItem'];
$itemIDFind     = $_POST['itemIDFind'];
$itemIDFind     = explode(',',$itemIDFind)[0];
$warehouseArray = getWarehouseArray($dateFrom,$dateTo,$salesPerson,$transferType,$fromWH,$toWH,$showItem,$itemIDFind);
if (count($warehouseArray)>0){
    $htmlCode = getHtmlCode($warehouseArray,$showItem,$itemIDFind);
    echo $htmlCode;
}else{
    echo "<center><b>No Data found </b></center>";
}

function getHtmlCode($warehouseArray,$showItem,$itemIDFind){
    $result = "<style>
                table {
                    width:100%;
                    border-collapse: collapse;
                }
                td{
                    border: 1px solid black;
                    padding: 4px;
                    vertical-align: middle !important;
                    padding:10px !important;
                }
            </style>";
    $result .= "<table class='table'>";
    $result .="<tr>";
        $result .="<td style='text-align:center !important;background-color: #A9CFFF;font-weight: bold;height: 50px;text-align: center;'><b>#<b></td>";
        $result .="<td style='text-align:center !important;background-color: #A9CFFF;font-weight: bold;height: 50px;text-align: center;'><b>Transaction Date<b></td>";
        $result .="<td style='text-align:center !important;background-color: #A9CFFF;font-weight: bold;height: 50px;text-align: center;'><b>Type<b></td>";
        $result .="<td style='text-align:center !important;background-color: #A9CFFF;font-weight: bold;height: 50px;text-align: center;'><b>Transaction Code<b></td>";
        $result .="<td style='text-align:center !important;background-color: #A9CFFF;font-weight: bold;height: 50px;text-align: center;'><b>From WH<b></td>";
        $result .="<td style='text-align:center !important;background-color: #A9CFFF;font-weight: bold;height: 50px;text-align: center;'><b>To WH<b></td>";
        $result .="<td style='text-align:center !important;background-color: #A9CFFF;font-weight: bold;height: 50px;text-align: center;'><b>Salesperson<b></td>";
    $result .="</tr>";
    $counter = 0;
    foreach ($warehouseArray as $transfer){
        $arrayWithItems = $transfer->itemsArray;
        $counter++;

        if (strcmp($showItem,'yes')==0 && $counter > 1){
            $result .="<tr>";
                $result .="<td colspan='7' style='text-align:center !important;background-color: ;font-weight: bold;height: 30px;text-align: center;border-right: 2px solid transparent;border-left: 2px solid transparent;'><b><b></td>";
            $result .="</tr>";
            $result .="<tr>";
                $result .="<td style='text-align:center !important;background-color: #A9CFFF;font-weight: bold;height: 50px;text-align: center;'><b>#<b></td>";
                $result .="<td style='text-align:center !important;background-color: #A9CFFF;font-weight: bold;height: 50px;text-align: center;'><b>Transaction Date<b></td>";
                $result .="<td style='text-align:center !important;background-color: #A9CFFF;font-weight: bold;height: 50px;text-align: center;'><b>Type<b></td>";
                $result .="<td style='text-align:center !important;background-color: #A9CFFF;font-weight: bold;height: 50px;text-align: center;'><b>Transaction Code<b></td>";
                $result .="<td style='text-align:center !important;background-color: #A9CFFF;font-weight: bold;height: 50px;text-align: center;'><b>From WH<b></td>";
                $result .="<td style='text-align:center !important;background-color: #A9CFFF;font-weight: bold;height: 50px;text-align: center;'><b>To WH<b></td>";
                $result .="<td style='text-align:center !important;background-color: #A9CFFF;font-weight: bold;height: 50px;text-align: center;'><b>Salesperson<b></td>";
            $result .="</tr>";
        }

        $rowSpanFilter = '';
        if (strcmp($showItem,'yes')==0){
            $linesAnalyticCounter = count($arrayWithItems);
            $rowSpanCounter = $linesAnalyticCounter+2;
            $rowSpanFilter = "rowspan='$rowSpanCounter'";
        }
        $result .="<tr>";
            $result .="<td style='text-align:center !important;background-color: ;font-weight: bold;height: 50px;text-align: center;' $rowSpanFilter><b>$counter<b></td>";
            $result .="<td style='text-align:center !important;background-color: ;font-weight: bold;height: 50px;text-align: center;'>$transfer->dateTransactionFormat</td>";
            $result .="<td style='text-align:center !important;background-color: ;font-weight: bold;height: 50px;text-align: center;'>$transfer->typeTransaction</td>";
            $result .="<td style='text-align:center !important;background-color: ;font-weight: bold;height: 50px;text-align: center;'>$transfer->wh_transactionCode</td>";
            $result .="<td style='text-align:center !important;background-color: ;font-weight: bold;height: 50px;text-align: center;'>$transfer->wh_from_info</td>";
            $result .="<td style='text-align:center !important;background-color: ;font-weight: bold;height: 50px;text-align: center;'>$transfer->wh_to_info</td>";
            $result .="<td style='text-align:center !important;background-color: ;font-weight: bold;height: 50px;text-align: center;'>$transfer->salespersonInfo</td>";
        $result .="</tr>";
        if (strcmp($showItem,'yes')==0){

            $result .="<tr>";
                $result .="<td  style='text-align:center !important;background-color:#cbdbf3;font-weight: bold;height: 50px;text-align: center;'><b>Item Code<b></td>";
                $result .="<td  style='text-align:center !important;background-color:#cbdbf3;font-weight: bold;height: 50px;text-align: center;'><b>Item Name<b></td>";
                $result .="<td  style='text-align:center !important;background-color:#cbdbf3;font-weight: bold;height: 50px;text-align: center;'><b>Batch Number<b></td>";
                $result .="<td  style='text-align:center !important;background-color:#cbdbf3;font-weight: bold;height: 50px;text-align: center;'><b>Bin Location<b></td>";
                $result .="<td  style='text-align:center !important;background-color:#cbdbf3;font-weight: bold;height: 50px;text-align: center;'><b>Qty<b></td>";
                $result .="<td  style='text-align:center !important;background-color:#cbdbf3;font-weight: bold;height: 50px;text-align: center;'><b>Serial Number<b></td>";
            $result .="</tr>";
            foreach ($arrayWithItems as $itemObj){
                if ($itemObj->id==$itemIDFind){
                    $colorSearch = 'color:#ac2021;font-weight: bold;';
                }else{
                    $colorSearch='';
                }
                $result .="<tr>";
                    $result .="<td  style='text-align:center !important;background-color:;height: 50px;text-align: center;$colorSearch'>$itemObj->code</td>";
                    $result .="<td  style='text-align:center !important;background-color:;height: 50px;text-align: center;$colorSearch'>$itemObj->name</td>";
                    $result .="<td  style='text-align:center !important;background-color:;height: 50px;text-align: center;$colorSearch'>$itemObj->batchNumber</td>";
                    $result .="<td  style='text-align:center !important;background-color:;height: 50px;text-align: center;$colorSearch'>$itemObj->binLocation</td>";
                    $result .="<td  style='text-align:center !important;background-color:;height: 50px;text-align: center;$colorSearch'>$itemObj->qty</td>";
                    $result .="<td  style='text-align:center !important;background-color:;height: 50px;text-align: center;$colorSearch'>$itemObj->serial_num</td>";
                $result .="</tr>";
            }
        }

    }

    $result .="</table>";
    return $result;
}

function getWarehouseArray($dateFrom,$dateTo,$salesPerson,$transferType,$fromWH,$toWH,$showItem,$itemIDFind){
    global $username,$password,$database;
    $db = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");

    $filterQuery = '';
    $first       = '';
    if (strcmp("".$dateFrom,'')!=0 && strcmp("".$dateTo,'')!=0){
        $filterQuery .= " $first transaction_date>='$dateFrom' AND transaction_date<='$dateTo'";
        $first = 'AND';
    }
    if ($salesPerson>0){
        $filterQuery .= " $first salesperson_id=$salesPerson";
        $first = 'AND';
    }
    if (strcmp("".$transferType,'')!=0 && strcmp("".$transferType,'all')!=0){
        $filterQuery .= " $first type='$transferType'";
        $first = 'AND';
    }
    if ($fromWH>0){
        $filterQuery .= " $first warehouse_id_from=$fromWH";
        $first = 'AND';
    }
    if ($toWH>0){
        $filterQuery .= " $first warehouse_id_to=$toWH";
    }
    if (strcmp($showItem,'yes')==0 || $itemIDFind>0){
        $showItemAnalysis = true;
    }else{
        $showItemAnalysis = false;
    }
//    echo "$filterQuery";
    $arrayReturn = array();
    $stm = $db->prepare("SELECT warehouse_transaction_id,warehouse_transaction_code,warehouse_id_from,warehouse_id_to,salesperson_id,type,transaction_date FROM Warehouse_Transactions WHERE $filterQuery");
    $stm-> execute();
    $stm-> bind_result($whTransactionID, $whTransactionCode,$whIDfrom,$whIDto,$salesPersonID,$typeTransaction,$transactionDate);
    while ($stm->fetch()) {
        $itemsArrayObj = array();
        $objTransfer = new stdClass();
        $objTransfer->wh_transactionID          = $whTransactionID;
        $objTransfer->wh_transactionCode        = $whTransactionCode;
        $objTransfer->wh_IDfrom                 = $whIDfrom;
        $objTransfer->wh_IDto                   = $whIDto;
        $objTransfer->salespersonID             = $salesPersonID;
        $objTransfer->typeTransaction           = $typeTransaction;
        $objTransfer->transactionDate           = $transactionDate;
        $objTransfer->salespersonInfo           = getSalespersonInfo($salesPersonID);
        $objTransfer->dateTransactionFormat     = date('d/m/Y',strtotime($transactionDate));
        $objTransfer->wh_from_info              = getWarehouseInfo($whIDfrom);
        $objTransfer->wh_to_info                = getWarehouseInfo($whIDto);
        if ($showItemAnalysis){
            $itemsArrayObjAll = getItemsArrayObj($whTransactionID);
            $itemsArrayObj = $itemsArrayObjAll[0];
        }
        if ($itemIDFind>0){
            $itemsArrayFindItems = $itemsArrayObjAll[1];
            if (!in_array($itemIDFind,$itemsArrayFindItems)){
                continue;
            }
        }
        $objTransfer->itemsArray                = $itemsArrayObj;
        array_push($arrayReturn,$objTransfer);
    }
    $stm-> close();

    return $arrayReturn;
}

function getItemsArrayObj($whTransactionID){
    global $username,$password,$database;
    $db1 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $itemsWarehouseTransaction=array();
    $arrayWithIDs=array();
    $stm = $db1->prepare("SELECT item_id,batch_number,qty,serialnumber FROM Warehouse_Transaction_Item WHERE warehouse_transaction_id='$whTransactionID'");
    $stm-> execute();
    $stm-> bind_result($itemID,$batchNumber,$qty,$serialNumber);
    while ($stm->fetch()) {

        $binLocation = '';
        if(strpos($batchNumber, ';BIN;') !== false){
            $batchNumberBinLocationArray = explode(';BIN;',$batchNumber);
            $batchNumber = $batchNumberBinLocationArray[0];
            $binLocation = $batchNumberBinLocationArray[1];
        }

        if(strcmp("$batchNumber","0")==0){$batchNumber = '';}
        if(strcmp("$binLocation","0")==0){$binLocation = '';}

        $objItemInfo          = getItemInfo($itemID);
        $itemObj = new stdClass();
        $itemObj->id            = $itemID;
        $itemObj->code          = $objItemInfo->code;
        $itemObj->name          = $objItemInfo->name;
        $itemObj->batchNumber   = $batchNumber;
        $itemObj->binLocation   = $binLocation;
        $itemObj->qty           = $qty;
        $itemObj->serial_num    = $serialNumber;

        if($qty > 0){
            array_push($arrayWithIDs,$itemID);
            array_push($itemsWarehouseTransaction,$itemObj);
        }
    }
    $stm-> close();
    return [$itemsWarehouseTransaction,$arrayWithIDs];
}


function getItemInfo($itemID){
    global $username,$password,$database;
    $db2 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db2->set_charset("utf8");

    $stm2 = $db2->prepare("SELECT item_code,name FROM Items WHERE item_id='$itemID' LIMIT 1");
    $stm2-> execute();
    $stm2-> bind_result($itemCode,$itemName);
    while ($stm2->fetch()) {
        $objItemInfo = new stdClass();
        $objItemInfo->code = $itemCode;
        $objItemInfo->name = $itemName;
    }
    $stm2-> close();
    return $objItemInfo;
}

function getSalespersonInfo($salespersonID){
    global $username,$password,$database;
    $db1 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $salespersonInfo="";
    $stm = $db1->prepare("SELECT salesperson_code,first_name,last_name FROM SalesPersons WHERE salesperson_id='$salespersonID' LIMIT 1");
    $stm-> execute();
    $stm-> bind_result($salespersonCode,$first,$last);
    while ($stm->fetch()) {
        $salespersonInfo = "$salespersonCode-$first $last";
    }
    $stm-> close();
    return $salespersonInfo;
}

function getWarehouseInfo($whIDto){
    global $username,$password,$database;
    $db1 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $warehouseInfo = '';
    $stm = $db1->prepare("SELECT CONCAT(warehouse_code, ' - ',name) FROM Warehouses WHERE warehouse_id='$whIDto' LIMIT 1");
    $stm-> execute();
    $stm-> bind_result($warehouseInfo);
    while ($stm->fetch()) {
        $warehouseInfo = $warehouseInfo;
    }
    $stm-> close();

    return $warehouseInfo;
}
function viewArray($arr){
    echo "<pre>";
    var_dump($arr);
    echo "</pre>";
}
?>