<?php
include_once("../../../../param.php");
require(ROOT . 'libs/phpexcel/vendor/autoload.php');

$suppliers    = $_POST['supplier'];
$dateFrom     = trim($_POST['dateFrom']);
$dateTo       = trim($_POST['dateTo']);
$typeReport   = $_POST['typeReport'];
if(strcmp($dateTo,'')==0){$dateTo = date('Y-m-d');}
if(strcmp($dateFrom,'')==0){$dateFrom = date('Y-m-d');}
$displayDateTo = date_format( date_create_from_format('Y-m-d', $dateTo), 'd/m/Y');
$displayDateFrom = date_format( date_create_from_format('Y-m-d', $dateFrom), 'd/m/Y');

$arraySupplierOrder = getArraySupplierOrder($suppliers,$dateFrom,$dateTo);
$supplierItem   = $arraySupplierOrder[0];
$orderItem      = $arraySupplierOrder[1];
$htmlCode = getHtmlCode($supplierItem,$orderItem);
if (strcmp($typeReport,'excel')==0){
    exportXLSfile($htmlCode);
}else{
    echo $htmlCode;
}


function exportXLSfile($htmlExcelCode){
    $filename = "SupplierOrderReport.xlsx";
    $tmpfile = tempnam(sys_get_temp_dir(), 'html');
    file_put_contents($tmpfile, $htmlExcelCode);

    $objPHPExcel     = new PHPExcel();
    $excelHTMLReader = PHPExcel_IOFactory::createReader('HTML');
    $excelHTMLReader->loadIntoExisting($tmpfile, $objPHPExcel);
    $objPHPExcel->getActiveSheet()->setTitle('Excel Export'); // Change sheet's title if you want

    foreach(range('B','Z') as $columnID) {
        $objPHPExcel->getActiveSheet()->getColumnDimension($columnID)
            ->setAutoSize(true);
    }
    unlink($tmpfile);
    ob_start();
    $writer = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
    $writer->save('php://output');
    $ret = base64_encode(ob_get_contents());
    ob_end_clean();
    echo $ret;
}

function getHtmlCode($supplierItem,$orderItem){
    $result = "<table class='table' style='width: 100%'>";
        $result .="<tr>";
            $result .="<td  style='text-align:center !important;background-color:#cbdbf3;font-weight: bold;height: 50px;text-align: center;width: 100px'><b>Item Code<b></td>";
            $result .="<td  style='text-align:center !important;background-color:#cbdbf3;font-weight: bold;height: 50px;text-align: center;width: 300px'><b>Item Name<b></td>";
            $result .="<td  style='text-align:center !important;background-color:#cbdbf3;font-weight: bold;height: 50px;text-align: center;width: 200px'><b>Supplier Code<b></td>";
            $result .="<td  style='text-align:center !important;background-color:#cbdbf3;font-weight: bold;height: 50px;text-align: center;width: 200px'><b>Supplier Name<b></td>";
            $result .="<td  style='text-align:center !important;background-color:#cbdbf3;font-weight: bold;height: 50px;text-align: center;width: 200px'><b>Qty<b></td>";
        $result .="</tr>";
        foreach ($orderItem as $item=>$qtyItem){
            $itemObj = getItemObj($item);
            $itemCode = $itemObj->code;
            $itemName = $itemObj->name;
            $supplierArrayIDs  = $supplierItem["$item"];
            $supplierCodeAll = '';
            $supplierNameAll = '';
            $checkExistSupplier = false;
            foreach ($supplierArrayIDs as $supplierID){
                if ($supplierID>0){
                    $checkExistSupplier=true;
                    $supplierObj = getSupplierObj($supplierID);
                    $supplierCode = $supplierObj->code;
                    $supplierName = $supplierObj->name;
                }
                if (strcmp($supplierCodeAll,'')!=0){
                    $supplierCodeAll .=" / $supplierCode";
                    $supplierNameAll .= " / $supplierName";
                }else{
                    $supplierCodeAll .="$supplierCode";
                    $supplierNameAll .= "$supplierName";
                }
            }
            if (!$checkExistSupplier){continue;}
            $result .="<tr>";
                $result .="<td  style='text-align:center !important;text-align: center;width: 100px'><b>$itemCode<b></td>";
                $result .="<td  style='text-align:center !important;text-align: center;width: 300px'><b>$itemName<b></td>";
                $result .="<td  style='text-align:center !important;text-align: center;width: 200px'><b>$supplierCodeAll<b></td>";
                $result .="<td  style='text-align:center !important;text-align: center;width: 200px'><b>$supplierNameAll<b></td>";
                $result .="<td  style='text-align:center !important;text-align: center;width: 200px'><b>$qtyItem<b></td>";
            $result .="</tr>";
        }
    $result .="</table>";

    return $result;
}


function getSupplierObj($suuplierID){
    global $username,$password,$database;
    $db = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");

    $objReturn = new stdClass();
    $stm = $db->prepare("SELECT customer_code,customer_company_name FROM Suppliers WHERE customer_id='$suuplierID'");
    $stm->execute();
    $stm->bind_result($customerCode,$customerName);
    while ($stm->fetch()) {
        $objReturn->code = $customerCode;
        $objReturn->name = $customerName;
    }
    $stm->close();

    return $objReturn;
}

function getItemObj($itemID){
    global $username,$password,$database;
    $db = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");
    $objReturn = new stdClass();
    $stm = $db->prepare("SELECT item_code,name FROM Items WHERE item_id='$itemID'");
    $stm->execute();
    $stm->bind_result($itemCode,$itemName);
    while ($stm->fetch()) {
        $objReturn->code = $itemCode;
        $objReturn->name = $itemName;
    }
    $stm->close();

    return $objReturn;
}
function getArraySupplierOrder($suppliers,$dateFrom,$dateTo){
    global $username,$password,$database;
    $db = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");

    $where = '';
    if (is_array($suppliers))
    $suppliers = implode(',',$suppliers);
    if(strcmp($suppliers,'')!=0){$where = "  AND supplier_id IN ($suppliers) ";}

    $itemSupplier = array();
    $stm = $db->prepare("SELECT supplier_id,item_id FROM Item_Supplier WHERE 1=1 $where ");
    $stm->execute();
    $stm->bind_result($supplierID,$supplierItemID);
    while ($stm->fetch()) {
        if (!is_array($itemSupplier["$supplierItemID"])){
            $itemSupplier["$supplierItemID"] = array();
            array_push($itemSupplier["$supplierItemID"],$supplierID);
        }else{
            array_push($itemSupplier["$supplierItemID"],$supplierID);
        }
    }
    $stm->close();

    $itemOrder = array();
    $stm = $db->prepare("SELECT SUM(qty),item_id FROM Orders,Order_Item WHERE Orders.order_id=Order_Item.order_id AND order_date>='$dateFrom' AND order_date<='$dateTo' AND NOT status='Canceled' GROUP BY item_id");
    $stm->execute();
    $stm->bind_result($totalQty,$itemID);
    while ($stm->fetch()) {
        $itemOrder["$itemID"] = $totalQty;
    }
    $stm->close();

    return [$itemSupplier,$itemOrder];
}


function viewArray($arr){
    echo "<pre>";
    var_dump($arr);
    echo "</pre>";
}


 ?>