<?php
include_once("../../../../param.php");
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ERROR);
require(ROOT . 'libs/phpexcel/vendor/autoload.php');
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Reader\Html;
include_once '../../../../libs/phpSpreadsheet/vendor/autoload.php';

$dateFrom               = $_POST['dateFrom'];
$dateTo                 = $_POST['dateTo'];
$customerSearch         = $_POST['customerSearch'];
$customerGroupSearch    = $_POST['customerGroupSearch'];
$itemSearch             = $_POST['itemSearch'];
$salespersonSearch      = $_POST['salespersonSearch'];
$categories             = $_POST['categories'];
$typeRequest            = $_POST['typeRequest'];
$typeReport             = $_POST['typeReport'];
$extraData              = $_POST['extraAnalysis'];

$customerGroupArrayImplode  = "";
$categoriesItemArrayImplode = "";

if (strcmp($customerGroupSearch,'')!=0){
    $customerGroupArray  = getCustomerGroup($customerGroupSearch);
    if (count($customerGroupArray)>0){
        $customerGroupArrayImplode = implode(',',$customerGroupArray);
    }
}
if (strcmp($categories,'')!=0){
    $categoriesItemArray = getItemsFromCategory($categories);
    if (count($categoriesItemArray)>0){
        $categoriesItemArrayImplode = implode(',',$categoriesItemArray);
    }
}

$arrayWithReturns = getReturnsArray($dateFrom,$dateTo,$typeRequest,$customerSearch,$customerGroupArrayImplode,$itemSearch,$salespersonSearch,$categoriesItemArrayImplode);
//viewArray($arrayWithReturns);
$htmlCode = getHtmlCode($arrayWithReturns,$typeRequest,$extraData);
if (strcmp($typeReport,'excel')==0){
    exportXLSfileNew($htmlCode);
}else{
    echo $htmlCode;
}

function exportXLSfileNew($htmlString){
    $spreadsheet = new Spreadsheet();
    $reader = new Html();
    $spreadsheet = $reader->loadFromString($htmlString);
    $writer = new Xlsx($spreadsheet);

    ob_start();
    $writer->save('php://output');
    $ret = base64_encode(ob_get_contents());
    ob_end_clean();
//    $filename = "Warehouse_Compare_file_report.xlsx";
//    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
//    header('Content-Disposition: attachment;filename="' . time() . '_' . $filename . '"');
//    header('Cache-Control: max-age=0');

    echo $ret;

}
function exportXLSfile($htmlExcelCode){
    $tmpfile = tempnam(sys_get_temp_dir(), 'html');
    file_put_contents($tmpfile, $htmlExcelCode);

    $objPHPExcel     = new PHPExcel();
    $excelHTMLReader = PHPExcel_IOFactory::createReader('HTML');
    $excelHTMLReader->loadIntoExisting($tmpfile, $objPHPExcel);
    $objPHPExcel->getActiveSheet()->setTitle('Excel Export'); // Change sheet's title if you want

    foreach(range('B','Z') as $columnID) {
        $objPHPExcel->getActiveSheet()->getColumnDimension($columnID)
            ->setAutoSize(true);
    }
    unlink($tmpfile);


    ob_start();

    $writer = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
    $writer->save('php://output');
    $ret = base64_encode(ob_get_contents());
    ob_end_clean();
    echo $ret;
}

function getHtmlCode($arrayWithReturnsALL,$typeRequest,$extraData){
    $arrayWithReturns = $arrayWithReturnsALL->basicArray;
    $arrayWithExtra   = $arrayWithReturnsALL->extraArray;
    if (strcmp($typeRequest,'Customer')==0){
        $typeRequestSecond = 'Item';
    }else{
        $typeRequestSecond = 'Customer';
    }

    $result  = "<table style='border-collapse: collapse;width: 100%'>";
    $result .="<tr>";
    $result .="<td style='text-align:center !important;background-color: #A9CFFF;font-weight: bold;height: 50px;text-align: center;border: 1px solid black;'><b>#<b></td>";
    $result .="<td style='text-align:center !important;background-color: #A9CFFF;font-weight: bold;height: 50px;text-align: center;border: 1px solid black;'><b>$typeRequest Code<b></td>";
    $result .="<td style='text-align:center !important;background-color: #A9CFFF;font-weight: bold;height: 50px;text-align: center;border: 1px solid black;'><b>$typeRequest Name<b></td>";
    $result .="<td style='text-align:center !important;background-color: #A9CFFF;font-weight: bold;height: 50px;text-align: center;border: 1px solid black;'><b>Qty<b></td>";
    $result .="<td style='text-align:center !important;background-color: #A9CFFF;font-weight: bold;height: 50px;text-align: center;border: 1px solid black;'><b>Amount<b></td>";
    $result .="</tr>";
    $counter = 0;
    foreach ($arrayWithReturns as $level1 => $arrlevel1) {
        foreach ($arrlevel1 as $level2 => $arrlevel2) {
            $extraHtml = '';
            $secondCounter = 0;
            $counter++;
            $first = true;
            if (strcmp($extraData,'yes')==0){
                foreach ($arrayWithExtra["$level2"] as $extra){
                    $amount = number_format(floatVal($extra["amount"]),2);
                    $qty    = $extra["qty"];
                    $code   = $extra["code"];
                    $name   = $extra["name"];
                    $secondCounter++;
                    if ($first){
                        $extraHtml .="<tr>";
                        $extraHtml .= "<td style='text-align:center !important;background-color: #b8e0bb;font-weight: bold;height: 25px;text-align: center;border: 1px solid black;'><b>#<b></td>";
                        $extraHtml .="<td style='text-align:center !important;background-color: #b8e0bb;font-weight: bold;height: 25px;text-align: center;border: 1px solid black;'><b>$typeRequestSecond Code<b></td>";
                        $extraHtml .="<td style='text-align:center !important;background-color: #b8e0bb;font-weight: bold;height: 25px;text-align: center;border: 1px solid black;'><b>$typeRequestSecond Name<b></td>";
                        $extraHtml .="<td style='text-align:center !important;background-color: #b8e0bb;font-weight: bold;height: 25px;text-align: center;border: 1px solid black;'><b>Qty<b></td>";
                        $extraHtml .="<td style='text-align:center !important;background-color: #b8e0bb;font-weight: bold;height: 25px;text-align: center;border: 1px solid black;'><b>Amount<b></td>";
                        $extraHtml .="</tr>";
                    }
                    $first = false;
                    $extraHtml .="<tr>";
                    $extraHtml .="<td style='text-align:center !important;font-weight: bold;height: 25px;text-align: center;border: 1px solid black;'><b>$counter.$secondCounter</b></td>";
                    $extraHtml .="<td style='text-align:center !important;font-weight: bold;height: 25px;text-align: center;border: 1px solid black;'>$code</td>";
                    $extraHtml .="<td style='text-align:center !important;font-weight: bold;height: 25px;text-align: center;border: 1px solid black;'>$name</td>";
                    $extraHtml .="<td style='text-align:center !important;font-weight: bold;height: 25px;text-align: center;border: 1px solid black;'>$qty</td>";
                    $extraHtml .="<td style='text-align:center !important;font-weight: bold;height: 25px;text-align: center;border: 1px solid black;'>$amount</td>";
                    $extraHtml .="</tr>";
                }
                $colorSecondHeader = 'background-color:#FFDBBB';
            }else{
                $colorSecondHeader = 'background-color:';
            }

            $amount = number_format(floatVal($arrlevel2["amount"]),2);
            $qty    = $arrlevel2["qty"];
            $code   = $arrlevel2["code"];
            $name   = $arrlevel2["name"];
            $result .="<tr>";
            $result .="<td style='text-align:center !important;font-weight: bold;height: 50px;text-align: center;border: 1px solid black;$colorSecondHeader'>$counter<b></td>";
            $result .="<td style='text-align:center !important;font-weight: bold;height: 50px;text-align: center;border: 1px solid black;$colorSecondHeader'>$code</td>";
            $result .="<td style='text-align:center !important;font-weight: bold;height: 50px;text-align: center;border: 1px solid black;$colorSecondHeader'>$name</td>";
            $result .="<td style='text-align:center !important;font-weight: bold;height: 50px;text-align: center;border: 1px solid black;$colorSecondHeader'>$qty</td>";
            $result .="<td style='text-align:center !important;font-weight: bold;height: 50px;text-align: center;border: 1px solid black;$colorSecondHeader'>$amount</td>";
            $result .="</tr>$extraHtml";
        }
    }
    $result .="</table>";

    return $result;
}

function getReturnsArray($dateFrom,$dateTo,$typeRequest,$customerSearch,$customerGroupArray,$itemSearch,$salespersonSearch,$categoriesItemArray){
    global $username,$password,$database;
    $db1 = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $filter = "";
    if (strcmp($customerSearch,'')!=0){
        $filter .= " AND customer_id IN($customerSearch) ";
    }
    if (strcmp($customerGroupArray,'')!=0){
        $filter .= " AND customer_id IN($customerGroupArray) ";
    }
    if (strcmp($itemSearch,'')!=0){
        $filter .= " AND item_id IN($itemSearch) ";
    }
    if (strcmp($categoriesItemArray,'')!=0){
        $filter .= " AND item_id IN($categoriesItemArray) ";
    }
    if (strcmp($salespersonSearch,'')!=0){
        $filter .= " AND salesperson_id IN($salespersonSearch) ";
    }

    $returnArray     = array();
    $arrayQuick      = array();
    $arrayQuickSecond = array();
    $extraDetails = array();
    if (strcmp($typeRequest,'Customer')==0){
        $stm = $db1->prepare(" SELECT customer_id,item_id,qty,unit_price FROM Returns,Return_Item WHERE Returns.return_id=Return_Item.return_id 
                                                         AND return_date>='$dateFrom' AND return_date<='$dateTo' $filter");
        $stm->execute();
        $stm->bind_result($customerID,$itemID,$qty,$unitPrice);
        while ($stm->fetch()) {
            if (!in_array($customerID,$arrayQuick)){
                $cusObj = getCustomerObj($customerID);
                $cusCode = $cusObj->code;
                $cusName = $cusObj->name;
                $returnArray["customers"]["$customerID"]["code"]    =  $cusCode;
                $returnArray["customers"]["$customerID"]["name"]    =  $cusName;
                array_push($arrayQuick,$itemID);
            }
            if (!in_array($itemID,array_keys($arrayQuickSecond))){
                $itemObj = getItemObj($itemID);
                $itemCode = $itemObj->code;
                $itemName = $itemObj->name;
                $extraDetails["$customerID"]["$itemID"]["code"]    =  $itemCode;
                $extraDetails["$customerID"]["$itemID"]["name"]    =  $itemName;
                $objItem = new stdClass();
                $objItem->code = $itemCode;
                $objItem->name = $itemName;
                $arrayQuickSecond["$itemID"] = $objItem;
//                array_push($arrayQuickSecond,$itemID);
            }else{
                $dataItem = $arrayQuickSecond["$itemID"];
                $extraDetails["$customerID"]["$itemID"]["code"]    =  $dataItem->code;
                $extraDetails["$customerID"]["$itemID"]["name"]    =  $dataItem->name;
            }
            $extraDetails["$customerID"]["$itemID"]["amount"] +=  $qty*$unitPrice;
            $extraDetails["$customerID"]["$itemID"]["qty"]    +=  $qty;

            $returnArray["customers"]["$customerID"]["amount"] +=  $qty*$unitPrice;
            $returnArray["customers"]["$customerID"]["qty"]    +=  $qty;
        }
        $stm->close();
    }elseif(strcmp($typeRequest,'Item')==0){
        $stm = $db1->prepare(" SELECT item_id,qty,unit_price,customer_id FROM Returns,Return_Item WHERE Returns.return_id=Return_Item.return_id 
                                                         AND return_date>='$dateFrom' AND return_date<='$dateTo' $filter");
        $stm->execute();
        $stm->bind_result($itemID,$qty,$unitPrice,$customerID);
        while ($stm->fetch()) {
            if (!in_array($itemID,$arrayQuick)){
                $itemObj = getItemObj($itemID);
                $itemCode = $itemObj->code;
                $itemName = $itemObj->name;
                $returnArray["items"]["$itemID"]["code"]    =  $itemCode;
                $returnArray["items"]["$itemID"]["name"]    =  $itemName;
                array_push($arrayQuick,$itemID);
            }
            if (!in_array($customerID,array_keys($arrayQuickSecond))){
                $cusObj = getCustomerObj($customerID);
                $cusCode = $cusObj->code;
                $cusName = $cusObj->name;
                $extraDetails["$itemID"]["$customerID"]["code"]    =  $cusCode;
                $extraDetails["$itemID"]["$customerID"]["name"]    =  $cusName;
                $objCustomer = new stdClass();
                $objCustomer->code = $cusCode;
                $objCustomer->name = $cusName;
                $arrayQuickSecond["$customerID"] = $objCustomer;
            }else{
                $dataCustomers = $arrayQuickSecond["$customerID"];
                $extraDetails["$itemID"]["$customerID"]["code"]    =  $dataCustomers->code;
                $extraDetails["$itemID"]["$customerID"]["name"]    =  $dataCustomers->name;
            }

            $extraDetails["$itemID"]["$customerID"]["amount"] +=  $qty*$unitPrice;
            $extraDetails["$itemID"]["$customerID"]["qty"]    +=  $qty;

            $returnArray["items"]["$itemID"]["amount"] +=  $qty*$unitPrice;
            $returnArray["items"]["$itemID"]["qty"]    +=  $qty;
        }
        $stm->close();
    }

    $objReturnFunction = new stdClass();
    $objReturnFunction->basicArray = $returnArray;
    $objReturnFunction->extraArray = $extraDetails;

    return $objReturnFunction;
}

function getItemObj($itemID){
    global $username,$password,$database;
    $db1 = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $stm = $db1->prepare(" SELECT item_code,name FROM Items WHERE item_id='$itemID'");
    $stm->execute();
    $stm->bind_result($itemCode,$itemName);
    while ($stm->fetch()) {

    }
    $stm->close();

    $funObj = new stdClass();
    $funObj->code = $itemCode;
    $funObj->name = $itemName;
    return $funObj;
}

function getCustomerObj($customID){
    global $username,$password,$database;
    $db1 = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $stm = $db1->prepare(" SELECT customer_code,customer_company_name FROM Customers WHERE customer_id='$customID'");
    $stm->execute();
    $stm->bind_result($customerCode,$customerName);
    while ($stm->fetch()) {

    }
    $stm->close();

    $funObj = new stdClass();
    $funObj->code = $customerCode;
    $funObj->name = $customerName;
    return $funObj;
}

function getCustomerGroup($customerGroupSearch){
    global $username,$password,$database;
    $db1 = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $customersFromGroupsArray = array();
    $stm = $db1->prepare(" SELECT DISTINCT(customer_id) FROM Customer_CustomersGroup WHERE group_id IN($customerGroupSearch)");
    $stm->execute();
    $stm->bind_result($customersFromGroup);
    while ($stm->fetch()) {
        array_push($customersFromGroupsArray,$customersFromGroup);
    }
    $stm->close();

    return $customersFromGroupsArray;
}

function getItemsFromCategory($categoryFilter){
    global $username,$password,$database;
    $db1 = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $itemsFromCategoryArray = array();
    $stm = $db1->prepare(" SELECT DISTINCT(item_id) FROM Category_Item WHERE category_id IN($categoryFilter)");
    $stm->execute();
    $stm->bind_result($itemFromCategory);
    while ($stm->fetch()) {
        array_push($itemsFromCategoryArray,$itemFromCategory);
    }
    $stm->close();

    return $itemsFromCategoryArray;
}

function viewArray($arr){
    echo "<pre>";
    var_dump($arr);
    echo "</pre>";
}
?>