<?php
include_once("../../../../param.php");

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

$where   = "WHERE NOT Contracts.valid = 'deleted'";

$dateFrom     = trim($_POST['dateFrom']);
$dateTo       = trim($_POST['dateTo']);
$dateFilterType  = trim($_POST['dateFilterType']);
$customerSearch  = $_POST['customerSearch'];
$customerGroupSearch  = $_POST['customerGroupSearch'];
$serialNumberSearch  = $_POST['serialNumberSearch'];
$itemSearch  = $_POST['itemSearch'];
$salespersonSearch  = $_POST['salespersonSearch'];
$techSearch  = $_POST['techSearch'];
$activeContract  = trim($_POST['activeContract']);

global $username,$password,$database;
$db = new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}

if(isset($_SESSION['Allow_Customers']) && strcmp($_SESSION['Allow_Customers'],'')!=0) {
    $Allow_Customers = "AND Customers.customer_id IN(".$_SESSION['Allow_Customers'].")";
}


if(strcmp($dateFrom,'')==0){
    $dateFrom = date('Y-m-d');
}

if(strcmp($dateTo,'')==0){
    $dateTo = date('Y-m-d');
}


if(strcmp($dateFilterType,'startDate')==0){
    $where .= " AND Contracts.start_date BETWEEN '$dateFrom' AND '$dateTo'";
} else {
    $where .= " AND Contracts.end_date BETWEEN '$dateFrom' AND '$dateTo'";
}

if(strcmp($activeContract,'yes')==0){
    $where .= " AND Contracts.valid = 'yes'";
} else if(strcmp($activeContract,'no')==0){
    $where .= " AND NOT Contracts.valid = 'yes'";
}

if(strcmp($customerGroupSearch,'')!=0){

    $customersFromGroupsArray = array();
    $db->set_charset("utf8");
    $stm = $db->prepare(" SELECT DISTINCT(customer_id) FROM Customer_CustomersGroup WHERE group_id IN($customerGroupSearch)");
    $stm->execute();
    $stm->bind_result($customersFromGroup);
    while ($stm->fetch()) {array_push($customersFromGroupsArray,$customersFromGroup);}
    $stm->close();
    if(!empty($customersFromGroupsArray)){
        $customersFromGroupsFilter = implode(',',$customersFromGroupsArray);
        if(strcmp($customerSearch,'')!=0){$customerSearch .= ','.$customersFromGroupsFilter;}
        else {$customerSearch = $customersFromGroupsFilter;}
    }
}


if(strcmp($customerSearch,'')!=0){$where .= " AND Contracts.customer_id IN ($customerSearch)";}
if(strcmp($serialNumberSearch,'')!=0){$where .= " AND Contracts.serial_number_id IN ($serialNumberSearch)";}
if(strcmp($itemSearch,'')!=0){$where .= " AND Contracts.item_id IN ($itemSearch)";}
if(strcmp($salespersonSearch,'')!=0){$where .= " AND Contracts.salesperson_id IN ($salespersonSearch)";}
if(strcmp($techSearch,'')!=0){$where .= " AND Contracts.technician_id IN ($techSearch)";}


$customForms = array();
$db->set_charset("utf8");
$stm = $db->prepare(" SELECT custom_form_id FROM ZA_Custom_Form_Usage WHERE linked_table='Contracts'");
$stm->execute();
$stm->bind_result($customFormID);
while ($stm->fetch()) {
    $customForm = new stdClass();
    $customForm->id = $customFormID;
    $customForm->fields = array();
    array_push($customForms,$customForm);
}
$stm->close();

$customFields = array();
foreach ($customForms as $customForm){

    $db->set_charset("utf8");
    $stm = $db->prepare(" SELECT ZA_Custom_Form_Custom_Field.custom_field_id,ZA_Custom_Field_Definition.custom_field_name FROM ZA_Custom_Form_Custom_Field,ZA_Custom_Field_Definition WHERE ZA_Custom_Form_Custom_Field.custom_field_id=ZA_Custom_Field_Definition.custom_field_id AND custom_form_id='$customForm->id'");
    $stm->execute();
    $stm->bind_result($customFieldID,$customFieldName);
    while ($stm->fetch()) {
        $customField = new stdClass();
        $customField->id = $customFieldID;
        $customField->name = $customFieldName;
        array_push($customForm->fields,$customField);
    }
    $stm->close();

}


$report = '';
$reportLines = '';
$lineCounter = 0;
$stm = $db->prepare(" SELECT Contracts.contract_id,Customers.customer_code,Customers.customer_company_name,Items.item_code,Items.name,Serial_Numbers.serial_number,start_date,end_date,valid,Contracts.notes,contract_type_name,price,salesperson_id,technician_id FROM Contracts 
                            LEFT JOIN Customers ON (Customers.customer_id=Contracts.customer_id) 
                            LEFT JOIN Items ON (Items.item_id=Contracts.item_id) 
                            LEFT JOIN Serial_Numbers ON (Serial_Numbers.serial_number_id=Contracts.serial_number_id) 
                            LEFT JOIN Contract_Types ON (Contract_Types.contract_type_id=Contracts.contract_type_id) 
                            $where");
$stm->execute();
$stm->bind_result( $contractID,$customerCode,$customerName,$itemCode,$itemName,$serialNumber,$startDate,$endDate,$valid,$notes,$contractType,$price,$salespersonID,$techID);
while ($stm->fetch()) {
    $lineCounter++;

    if(strcmp($startDate,'0000-00-00')!=0) {
        $displayStartDate = date_format(date_create_from_format('Y-m-d', $startDate), 'd-m-Y');
    } else {
        $displayStartDate = '';
    }

    if(strcmp($endDate,'0000-00-00')!=0) {
        $displayEndDate = date_format( date_create_from_format('Y-m-d', $endDate), 'd-m-Y');
    } else {
        $displayEndDate = '';
    }

    $salesperson = getSalespersonDetails($salespersonID);
    $tech = getSalespersonDetails($techID);
    $price = number_format((float)$price, 2, '.', '');


    $reportLines .= "<tr style='font-size: 11px;'>";

    $reportLines .= "<td>";
    $reportLines .= "$lineCounter";
    $reportLines .= "</td>";

    $reportLines .= "<td>";
    $reportLines .= "$customerCode";
    $reportLines .= "</td>";

    $reportLines .= "<td>";
    $reportLines .= "$customerName";
    $reportLines .= "</td>";

    $reportLines .= "<td>";
    $reportLines .= "$itemCode";
    $reportLines .= "</td>";

    $reportLines .= "<td>";
    $reportLines .= "$itemName";
    $reportLines .= "</td>";

    $reportLines .= "<td>";
    $reportLines .= "$serialNumber";
    $reportLines .= "</td>";

    $reportLines .= "<td>";
    $reportLines .= "$contractType";
    $reportLines .= "</td>";

    $reportLines .= "<td>";
    $reportLines .= "$salesperson";
    $reportLines .= "</td>";

    $reportLines .= "<td>";
    $reportLines .= "$tech";
    $reportLines .= "</td>";

    $reportLines .= "<td>";
    $reportLines .= "$displayStartDate";
    $reportLines .= "</td>";

    $reportLines .= "<td>";
    $reportLines .= "$displayEndDate";
    $reportLines .= "</td>";

    $reportLines .= "<td>";
    $reportLines .= "$valid";
    $reportLines .= "</td>";

    $reportLines .= "<td>";
    $reportLines .= "$price";
    $reportLines .= "</td>";

    $reportLines .= "<td>";
    $reportLines .= "$notes";
    $reportLines .= "</td>";

    global $username,$password,$database;
    $db2 = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }

    foreach ($customForms as $customForm){
        foreach ($customForm->fields as $customField){
            $db2->set_charset("utf8");
            $stm2 = $db2->prepare(" SELECT value FROM ZA_Custom_Field_Object,ZA_Custom_Form_Object WHERE ZA_Custom_Field_Object.custom_form_object_id=ZA_Custom_Form_Object.custom_form_object_id AND ZA_Custom_Form_Object.custom_form_id='$customForm->id' AND ZA_Custom_Field_Object.custom_field_id='$customField->id' AND linked_table_id='$contractID' LIMIT 1");
            $stm2->execute();
            $stm2->bind_result($value);
            while ($stm2->fetch()) {}
            $stm2->close();

            $reportLines .= "<td>";
            $reportLines .= "$value";
            $reportLines .= "</td>";
        }
    }

    $reportLines .= "<td>";
    $reportLines .= "<a class='btn btn-primary' href='//".HTML_PATH."/cop/backend/core/views/addedit/new_contract.php?contract_id=$contractID' target='_blank' title='View Contract'><i class='fa fa-eye'></i></a>";
    $reportLines .= "</td>";

    $reportLines .= "</tr>";

}
$stm->close();

if($lineCounter > 0){

    $report .= "<table class='table table-bordered' style='width: 100%'>";
    $report .= "<tr style='background-color: lightblue;font-weight: bolder;font-size: 11px;'>";

    $report .= "<td>";
    $report .= "#";
    $report .= "</td>";

    $report .= "<td>";
    $report .= "Customer Code";
    $report .= "</td>";

    $report .= "<td>";
    $report .= "Customer Name";
    $report .= "</td>";

    $report .= "<td>";
    $report .= "Item code";
    $report .= "</td>";

    $report .= "<td>";
    $report .= "Item Name";
    $report .= "</td>";

    $report .= "<td>";
    $report .= "Serial Number";
    $report .= "</td>";

    $report .= "<td>";
    $report .= "Type of Contract";
    $report .= "</td>";

    $report .= "<td>";
    $report .= "Assigned Salesperson";
    $report .= "</td>";

    $report .= "<td>";
    $report .= "Assigned Technician";
    $report .= "</td>";

    $report .= "<td style='width: 8%'>";
    $report .= "Start Date";
    $report .= "</td>";

    $report .= "<td style='width: 8%'>";
    $report .= "End Date";
    $report .= "</td>";

    $report .= "<td>";
    $report .= "Active";
    $report .= "</td>";

    $report .= "<td>";
    $report .= "Price of Contract";
    $report .= "</td>";

    $report .= "<td>";
    $report .= "Remarks";
    $report .= "</td>";

    foreach ($customForms as $customForm){
        foreach ($customForm->fields as $customField){
            $report .= "<td>";
            $report .= "$customField->name";
            $report .= "</td>";
        }
    }

    $report .= "<td>";
    $report .= "";
    $report .= "</td>";

    $report .= "</tr>";

    $report .= "$reportLines";

    $report .= "</table>";
}

if(strcmp($report,'')==0) {
    $report = "<center><b>No Data found </b></center>";
}

$report = "<style>


        body
        {
           font-family: Helvetica Neue, Helvetica, Arial, sans-serif;
           

        }

        p
        {

        }

        #wrapper
        {
            width:180mm;
            margin:0 15mm;
        }

        .page
        {
            height:297mm;
            width:210mm;

            page-break-after:always;
        }
        

        table.bordered
        {
            border-left: 1px solid #ddd;
            border-top: 1px solid #ddd;

            border-spacing:0;
            border-collapse: collapse;

        }
       

        table.bordered td
        {
            border-right: 1px solid #ddd;
            border-bottom: 1px solid #ddd;
            padding: 2mm;
        }

        table.heading
        {

        }

        h1.heading
        {
            font-size:14pt;
            color:#000;
            font-weight:normal;
        }

        h2.heading
        {
            font-size:9pt;
            color:#000;
            font-weight:normal;
        }

        hr
        {
            color:#ccc;
            background:#ccc;
        }

        #invoice_body
        {

        }

        td {
          font-family: Helvetica Neue, Helvetica, Arial, sans-serif;
        }

        #invoice_body , #invoice_total, #tableHeader
        {
            width:100%;
        }
        #invoice_body table , #tableHeader table
        {
            width:100%;
            border-left: 1px solid #ccc;
            border-top: 1px solid #ccc;
        }

        #invoice_total table {
          width:100%;
        }

        #invoice_body table td , #tableHeader table td
        {
            text-align:center;
            font-size: 11px;
            border-right: 1px solid #ccc;
            border-bottom: 1px solid #ccc;
            padding:2mm 0;
        }

        #invoice_body table td.mono  , #invoice_total table td.mono, #tableHeader table td.mono
        {
            font-family: Helvetica Neue, Helvetica, Arial, sans-serif;
            text-align:right;
            padding-right:3mm;
            font-size:10pt;
        }

        #footer
        {
            width:180mm;
            margin:0 15mm;
            padding-bottom:3mm;
        }
        #footer table
        {
            width:100%;
            background:#eee;

        }
        #footer table td
        {
            width:25%;
            text-align:center;
            font-size:9pt;
        }


        @page
        {
        
             margin-left: 1.4cm;
             margin-right: 1.4cm;
        
            header: html_myHTMLHeader1;
            footer: html_myFooter1;
        }

        .customer {
           font-family: 'Helvetica Neue', Helvetica, Arial, sans-serif;
           font-weight: 400;
        }

        #table_info td {
           font-size: 12px;
           padding:0;

        }

    </style>
    <htmlpageheader name='myHTMLHeader1'></htmlpageheader>

".$report;

echo $report;
return $report;

function getSalespersonDetails($salespersonID){
    $z = '';
    global $username,$password,$database;
    $db1 = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }

    $db1->set_charset("utf8");
    $stm21 = $db1->prepare(" SELECT CONCAT(first_name,' ',last_name) FROM SalesPersons WHERE salesperson_id='$salespersonID' LIMIT 1");
    $stm21->execute();
    $stm21->bind_result($value);
    while ($stm21->fetch()) {if(strcmp($value,'')!=0 && $salespersonID > 0){$z = $value;}}
    $stm21->close();

    return $z;

}

?>

