
<?php
include_once("../../../../param.php");

global $username, $password, $database;
$db = new mysqli(localhost, $username, $password, $database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

$customerSelection = '';
$stm = $db->prepare("SELECT CONCAT(customer_code,' - ',customer_company_name), customer_id FROM Customers");
$stm-> execute();
$stm-> bind_result($customerName,$customerID);
while ($stm->fetch()) {
    $customerSelection .= "<option value='$customerID'>$customerName</option>";
}
$stm-> close();

?>

<div id="main" role="main" class="background-color-whitish">

    <!-- Start CUSTOM CODE-->


    <!-- RIBBON -->
    <div id="ribbon" class="bg-color-blue">

				<span class="ribbon-button-alignment">
					<span id="refresh" class="btn btn-ribbon2" onclick="location.reload(true);" data-title="refresh" rel="tooltip" data-placement="bottom" data-original-title="<i class='text-warning fa fa-warning'></i> Reload Page?" data-html="true">
						<i class="fa fa-refresh"></i>
					</span>
				</span>

        <!-- breadcrumb -->
        <ol class="breadcrumb">
            <li class="txt-color-white">Home / View Customer Schedules</li>
        </ol>
        <!-- end breadcrumb -->

    </div>
    <!-- END RIBBON -->

    <!-- MAIN CONTENT -->
    <div id="content">

        <div class="row">
            <div class="col-xs-12 col-sm-6 col-md-6 col-lg-6">
<!--                <span>  <a onclick="backToReports()" class="btn btn-primary"><i class="fa fa-arrow-left"></i>&nbsp; Back to Reports</a> </span>-->
                <h3 style="display:inline;margin-left:10px;" class="page-title txt-color-blueDark header-margin">
                    <i class="fa-fw fa fa-calendar"></i>
                    Customer Schedules

                </h3>
            </div>


        </div>

        <!-- row -->
        <section id="widget-grid" class="" style="margin-top:10px;">
            <!-- row -->
            <div class="row">

                <!-- NEW WIDGET START -->
                <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

                    <div class="jarviswidget jarviswidget-color-blueDark" data-widget-editbutton="false" data-widget-deletebutton="false">
                        <header>
                            <span class="widget-icon"> <i class="fa fa fa-table"></i> </span>
                            <h2>Customer Schedules Form</h2>
                        </header>
                        <!-- widget div-->
                        <div>
                            <!-- widget content -->
                            <div class="widget-body" style="overflow-x:scroll">
                              

                                <label style="display: block; margin-top: 10px"><b>Select Customer:</b></label>
                                <select type="text" name="customerSearch" id="customerSearch" class="form-control" style="width: 30%">
                                    <?php echo $customerSelection; ?>
                                </select>


                                <br><br>
                                <button type="button" name="generateReport" id="generateReport" class="btn btn-primary" onclick="getReport()" >Generate Report</button>
                                <button type="button" name="generateExcel"  id="generateExcel"  class="btn btn-waybill" onclick="exportXLS()" >Export to Excel</button>
                                <button type="button" name="generatePDF"    id="generatePDF"    class="btn btn-danger"  onclick="exportPDF()" >Export PDF</button>

                            </div>
                            <!-- end widget content -->

                        </div>
                        <!-- end widget div -->

                    </div>
                    <!-- end widget -->
                </article>
                <!-- NEW WIDGET END -->

                <!-- NEW WIDGET START -->
                <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

                    <div class="jarviswidget jarviswidget-color-blueDark" data-widget-editbutton="false" data-widget-deletebutton="false">
                        <header>
                            <span class="widget-icon"> <i class="fa fa fa-table"></i> </span>
                            <h2>Customer Report</h2>
                        </header>
                        <!-- widget div-->
                        <div>
                            <!-- widget content -->
                            <div class="widget-body" style="overflow-x:scroll">

                                <div name="reportResult" id="reportResult"></div>
                                <form method="POST" action="#" name="xlsForm" id="xlsForm" >
                                    <input type="hidden" name="inputResult" id="inputResult" value=""/>
                                    <input type="hidden" name="inputTitle" id="inputTitle" value="CustomerSchedules"/>
                                </form>

                            </div>
                            <!-- end widget content -->

                        </div>
                        <!-- end widget div -->

                    </div>
                    <!-- end widget -->
                </article>
                <!-- NEW WIDGET END -->

            </div>


    </div>
    <!-- end widget content -->

    <!-- end row -->
    </section>

</div>

<script type="text/javascript">



    $(document).ready(function() {
        pageSetUp();

        $("#customerSearch").select2({
            minimumInputLength: 2
        });

    });

    function getReport(){

        var customerID = $('#customerSearch').val();
        $('#reportResult').html('<center><b>Generating Report..</b></center>');

        $.ajax({
            type: "POST",
            url: '//<?php echo HTML_PATH ?>/cop/backend/core/views/reports/getCustomerSchedulesReport.php',
            data: {
                'customerID':customerID
            },

            success: function (result) {
                $('#reportResult').html(result);
            }
        });

    }

    function exportXLS(){

        var customerID = $('#customerSearch').val();
        var typeReport = 'excel';
        $('#reportResult').html('<center><b>Generating Report..</b></center>');

        $.ajax({
            type: "POST",
            url: '//<?php echo HTML_PATH ?>/cop/backend/core/views/reports/getCustomerSchedulesReport.php',
            data: {
                'customerID':customerID,
                'typeReport':typeReport
            },

            success: function (result) {
                $('#reportResult').html(result);
                $('#inputResult').val(result);
                $('#xlsForm').attr('action','//<?php echo HTML_PATH ?>/cop/backend/core/templates/xls/generateGeneralXLS.php').submit();
            }
        });


    }

    function exportPDF(){

        var customerID = $('#customerSearch').val();


        $('#reportResult').html('<center><b>Generating Report..</b></center>');

        $.ajax({
            type: "POST",
            url: '//<?php echo HTML_PATH ?>/cop/backend/core/views/reports/getCustomerSchedulesReport.php',
            data: {
                'customerID':customerID

            },

            success: function (result) {
                $('#reportResult').html(result);
                $('#inputResult').val(result);
                $('#xlsForm').attr('action','//<?php echo HTML_PATH ?>/cop/backend/core/templates/pdf/generatePDFFromHTML.php').submit();
            }
        });


    }


</script>


