<?php
include_once("../../../../param.php");
?>
<div id="main" role="main">
    <!-- Start CUSTOM CODE-->

    <!-- RIBBON -->
    <div id="ribbon" class="bg-color-blue">
        <span class="ribbon-button-alignment">
            <span id="refresh" class="btn btn-ribbon2" onclick="location.reload(true);" data-title="refresh" rel="tooltip" data-placement="bottom" data-original-title="<i class='text-warning fa fa-warning'></i> Reload Page?" data-html="true">
                <i class="fa fa-refresh"></i>
            </span>
        </span>
        <!-- breadcrumb -->
        <ol class="breadcrumb">
            <li class="txt-color-white">Home / Manage Price Group Definitions</li>
        </ol>
        <!-- end breadcrumb -->
    </div>
    <!-- END RIBBON -->





    <!-- MAIN CONTENT -->
    <div id="content">

        <div class="row">
            <div class="col-xs-12 col-sm-8 col-md-9 col-lg-10">
                <h3 class="page-title txt-color-blueDark" style="margin-top: 5px; margin-bottom: 15px;">
                    <i class="fa fa-fw fa-money"></i> &nbsp; Price Group Definitions

                </h3>
            </div>
            <div class="col-xs-12 col-sm-4 col-md-3 col-lg-2">
                <span class="pull-right show-stat-buttons"><span> <a  class="btn btn-primary btn-block"  onclick = "$('#newPriceGroup').modal('show');"> <i class="fa fa-plus"></i>&nbsp; New Price Group Definition</a> </span> </span>

            </div>
        </div>

        <!-- row -->
        <section id="widget-grid" class="">

            <!-- row -->
            <div class="row">
                <!-- NEW WIDGET START -->
                <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

                    <div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-1" data-widget-editbutton="false" data-widget-deletebutton="false">
                        <header>
                            <span class="widget-icon"> <i class="fa fa-table"></i> </span>
                            <h2>Price Group Definition Table </h2>
                        </header>
                        <!-- widget div-->
                        <div>

                            <!-- widget content -->
                            <div class="widget-body no-padding">
                                <table id="datatable_fixed_column" class="table table-striped table-hover dataTabl" width="100%">
                                    <thead>
                                    <tr>
                                        <th class="hasinput">
                                            <input type="text" class="form-control text-center" placeholder="Filter Code" />
                                        </th>
                                        <th class="hasinput">
                                            <input type="text" class="form-control text-center" placeholder="Filter Name" />
                                        </th>
                                        <th class="hasinput">
                                            <input type="text" class="form-control text-center" placeholder="Filter Type" />
                                        </th>

                                    </tr>
                                    <tr>
                                        <th class="text-center">Code</th>
                                        <th class="text-center">Name</th>
                                        <th class="text-center">Type</th>
                                    </tr>
                                    </thead>
                                </table>
                            </div>
                            <!-- end widget content -->

                        </div>
                        <!-- end widget div -->

                    </div>
                    <!-- end widget -->
                </article>
                <!-- WIDGET END -->
            </div>
            <!-- end row -->
        </section>

    </div>
</div>



<!-- Modal (New  X)-->
<div class="modal fade" id="newPriceGroup" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" >
    <div class="modal-dialog" role="document" >
        <div class="modal-content">
            <div class="modal-header">
                <center>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close" style="font-size: 30px;">
                        <span aria-hidden="true">&times;</span>
                    </button>
                    <h4 class="modal-title"  style="display: inline-block;">
                        <i class=" fa fa-money"></i>&nbsp;<strong >New Price Group</strong></h4>
                </center>
            </div>
            <div class="modal-body">
                <table class="table table-bordered">
                    <tr>
                        <td>Code:</td>
                        <td><input class="form-control text-center" type="text" id="priceGroupCode"></td>
                    </tr>
                    <tr>
                        <td>Name:</td>
                        <td><input class="form-control text-center" type="text" id="priceGroupName"></td>
                    </tr>

                    <tr>
                        <td>Type:</td>
                        <td><input class="form-control text-center" type="text" id="priceGroupType"></td>
                    </tr>
                </table>

                <br>
                <center>
                    <button type="button" id = "saveButton" class="btn btn-success" onclick="savePriceGroup()">Save</button>
                </center>
            </div>

        </div>
    </div>
</div>



<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/DataTables/datatables.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatables/dataTables.colVis.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatables/dataTables.tableTools.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatables/dataTables.bootstrap.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatable-responsive/datatables.responsive.min.js"></script>

<script type="text/javascript">

    function  closeEditFields(suffix){
        $('#input' + suffix).hide();
        $('#value' + suffix).show();
        $('#pen' + suffix).show();
        $('#save' + suffix).hide();
    }

    function savePriceGroupField(id, elementName, newValue, suffix) {

        if(elementName==="code" && newValue === ""){
            $.smallBox({
                title: "Warning!",
                content: "The Code cannot be empty.",
                color: '#b22222',
                timeout: 3000,
                icon: "fa fa-exclamation-triangle swing animated"
            });
            closeEditFields(suffix);
            return;
        }


        if(elementName==="name" && newValue === ""){
            $.smallBox({
                title: "Warning!",
                content: "The Name cannot be empty.",
                color: '#b22222',
                timeout: 3000,
                icon: "fa fa-exclamation-triangle swing animated"
            });
            closeEditFields(suffix);
            return;
        }

        $.ajax({
            type: "POST",
            url: "//<?php echo HTML_PATH; ?>/cop/backend/core/controllers/edit/edit_price_group_definition.php",
            data: {
                'id': id,
                'fieldName': elementName,
                'fieldValue': newValue
            }
            ,
            success: function(result) {
                if (result.localeCompare('existingCode') === 0 ) {
                    $.smallBox({
                        title: "Warning!",
                        content: "Existing Price Group Code.",
                        color: '#b22222',
                        timeout: 3000,
                        icon: "fa fa-exclamation-triangle swing animated"
                    });


                } else {
                    $.smallBox({
                        title: "Success!",
                        content: "Field successfully updated.",
                        color: "#739E73",
                        timeout: 2000,
                        icon: "fa fa-check swing animated"
                    });

                    $('#value' + suffix).html(newValue);
                    closeEditFields(suffix);
                    $('#datatable_fixed_column').DataTable().draw(null, false);

                }
            }
        });
    }

    function openEditField(id, elementName){

        var suffix = '-' + elementName + '-' + id;
        var value  = $('#value' + suffix).html();

        if (value === '&nbsp;' ) {
            value = '';
        }

        $('#value' + suffix).hide();
        $('#pen' + suffix).hide();
        $('#input' + suffix).val(value);
        $('#input' + suffix).show();
        $('#input' + suffix).focus();
        $('#save' + suffix).show();

        $('#save' + suffix).unbind().on('click', function() {
            var newValue = $('#input' + suffix).val().trim();
            if(value.localeCompare(newValue)!=0 ){
                savePriceGroupField(id, elementName, newValue,suffix);
            }
            else {
                closeEditFields(suffix);
            }
        });


        $('#input' + suffix).focusout(function(){
            if (!$(event.relatedTarget).is($('#save' + suffix))) {
                closeEditFields(suffix);
            }
        });


    }

    function savePriceGroup(){

        var name = $('#priceGroupName').val().trim();
        var code = $('#priceGroupCode').val().trim();
        var type = $('#priceGroupType').val().trim();

        if(code ==='' ){
            $.smallBox({
                title: "Warning!",
                content: "The  Code cannot be empty.",
                color: '#b22222',
                timeout: 3000,
                icon: "fa fa-exclamation-triangle swing animated"
            });
            highlightDataError($('#priceGroupCode'));

            return;
        }

        if( name === ""){
            $.smallBox({
                title: "Warning!",
                content: "The  Name cannot be empty.",
                color: '#b22222',
                timeout: 3000,
                icon: "fa fa-exclamation-triangle swing animated"
            });
            highlightDataError($('#priceGroupName'));

            return;
        }


        $.ajax({
            type: "POST",
            url: '//<?php echo HTML_PATH?>/cop/backend/core/controllers/add/addPriceGroupDefinition.php',
            data: {
                'name': name,
                'code': code,
                'type': type,
            },
            success: function(result) {
                if (result.localeCompare('existingCode') == 0) {

                    $.smallBox({
                        title: "Warning!",
                        content: "Existing Code.",
                        color: '#b22222',
                        timeout: 3000,
                        icon: "fa fa-exclamation-triangle swing animated"
                    });

                    highlightDataError($('#priceGroupCode'));

                    $('#saveButton').show();
                    $('#saveButton').prop("disabled", false);

                } else {

                    $.smallBox({
                        title: "Success!",
                        content: "Price Group successfully entered.",
                        color: "#739E73",
                        timeout: 3000,
                        icon: "fa fa-check swing animated"
                    });

                    $('#datatable_fixed_column').DataTable().draw(null, false);
                    $('#newPriceGroup').modal('hide');
                    clearModalFields();

                }
            }
        });

    }

    function clearModalFields(){

        $('priceGroupName').val('');
        $('priceGroupCode').val('');
        $('priceGroupType').val('');

    }

    function highlightDataError(element, error) {
        element.css('border-color', 'firebrick').css('background-color', '#ffd0bd');
        window.setTimeout(function() {
            element .css('border-color', '').css('background-color', '');
            element.next('.error-message').fadeOut(500);
        }, 2500);
    }

    $(document).ready(function() {

        pageSetUp();


        var responsiveHelper_datatable_fixed_column = undefined;

        var breakpointDefinition = {
            tablet: 1024,
            phone: 480
        };

        /* COLUMN FILTER  */
        var otable = $('#datatable_fixed_column').DataTable({
            "sDom": "<'dt-toolbar'<'col-xs-6 col-sm-6'f><'col-sm-6 col-xs-6 hidden-xs' B C l>r>" +
                "t" +
                "<'dt-toolbar-footer'<'col-sm-6 col-xs-12 hidden-xs'i><'col-sm-6 col-xs-12'p>>",
            "autoWidth": true,
            "processing": false,
            "serverSide": true,
            "ajax": {
                "type": "GET",
                "url": "//<?php echo HTML_PATH ?>/cop/backend/core/controllers/getAll/getAllPriceGroupDefinitions.php",
            },
            "columns": [
                { "data": "code" },
                { "data": "name" },
                { "data": "type" }
            ],
            "deferRender": true,
            "autoWidth": true,
            "buttons": [
                "copyHtml5",
                "excelHtml5",
                "csvHtml5",
                {
                    extend: 'pdfHtml5',
                    orientation: 'landscape',
                    pageSize: 'LEGAL'
                }
            ],
            "preDrawCallback": function() {
                // Initialize the responsive datatables helper once.
                if (!responsiveHelper_datatable_fixed_column) {
                    responsiveHelper_datatable_fixed_column = new ResponsiveDatatablesHelper($('#datatable_fixed_column'), breakpointDefinition);
                }
            },
            "rowCallback": function(nRow) {
                responsiveHelper_datatable_fixed_column.createExpandIcon(nRow);
            },
            "drawCallback": function(oSettings) {
                responsiveHelper_datatable_fixed_column.respond();
            }
        });

        // Apply the filter
        $("#datatable_fixed_column thead th input[type=text]").on('keyup change', function() {
            otable
                .column($(this).parent().index() + ':visible')
                .search(this.value)
                .draw();
        });
    });
</script>
