<?php
include_once("../../../../param.php");

global $username, $password, $database;
$db = new mysqli(localhost, $username, $password, $database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

$customerSelection = "<option value='0'></option>";
$stm = $db->prepare("SELECT customer_id,customer_code,customer_company_name FROM Customers");
$stm-> execute();
$stm-> bind_result($customerID,$customerCode,$customerName);
while ($stm->fetch()) {
    $customerSelection.= "<option value='$customerID'>$customerCode - $customerName</option>";

}
$stm-> close();

$categorySelection = "<option value='0'></option>";
$stm = $db->prepare("SELECT category_id,category_code,name FROM Categories");
$stm-> execute();
$stm-> bind_result($categoryID,$categoryCode,$categoryName);
while ($stm->fetch()) {
    $categorySelection.= "<option value='$categoryID'>$categoryCode - $categoryName</option>";

}
$stm-> close();
?>
<div id="main" role="main" class="background-color-whitish">
    <!-- Start CUSTOM CODE-->

    <!-- RIBBON -->
    <div id="ribbon" class="bg-color-blue">

				<span class="ribbon-button-alignment">
					<span id="refresh" class="btn btn-ribbon2" onclick="location.reload(true);" data-title="refresh" rel="tooltip" data-placement="bottom" data-original-title="<i class='text-warning fa fa-warning'></i> Reload Page?" data-html="true">
						<i class="fa fa-refresh"></i>
					</span>
				</span>

        <!-- breadcrumb -->
        <ol class="breadcrumb">
            <li class="txt-color-white">Home / Allow Categories Customers</li>
        </ol>
        <!-- end breadcrumb -->
    </div>
    <!-- END RIBBON -->
    <!-- MAIN CONTENT -->
    <div id="content">

        <div class="row">
            <div class="col-xs-12 col-sm-4 col-md-8 col-lg-8">
                <h3 class="page-title txt-color-blueDark" style="margin-top: 5px;margin-bottom: 15px;">
                    <i class="fa fa-group "></i>
                    Allow Categories Customers
                </h3>
            </div>

            <div class="col-xs-12 col-sm-4 col-md-2 col-lg-2">
            </div>

            <div class="col-xs-12 col-sm-4 col-md-2 col-lg-2">
		<span class="pull-right show-stat-buttons"> <span > <a onclick="openNewModal()" class="btn btn-primary btn-block"><i class="fa fa-plus"></i>&nbsp; New Category Customer</a> </span>

            </div>

        </div>

        <!-- row -->
        <section id="widget-grid" class="">
            <!-- row -->
            <div class="row">
                <!-- NEW WIDGET START -->
                <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
                    <div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-1089" data-widget-editbutton="false" data-widget-deletebutton="false">
                        <header>
                            <span class="widget-icon"> <i class="fa fa-table"></i> </span>
                            <h2>Allow Categories Customers Table </h2>
                        </header>
                        <!-- widget div-->
                        <div>
                            <!-- widget content -->
                            <div class="widget-body no-padding">

                                <table id="datatable_fixed_column" class="table table-striped table-hover dataTable" width="100%">
                                    <thead>
                                    <tr>

                                        <th class="hasinput" >
                                            <input type="text" class="form-control text-center" placeholder="Filter Customer "  />
                                        </th>
                                        <th class="hasinput" >
                                            <input type="text" class="form-control text-center" placeholder="Filter Category"  />
                                        </th>
                                        <th class="hasinput" >
                                            <input type="text" class="form-control text-center" placeholder="Filter Cycle Type"  />
                                        </th>
                                        <th class="hasinput" >
                                            <input type="text" class="form-control text-center" placeholder="Filter Days"  />
                                        </th>
                                        <th class="hasinput" >
                                            <input type="text" class="form-control text-center" placeholder="Filter Date "  />
                                        </th>
                                        <th class="hasinput" >
                                            <input type="text" class="form-control text-center" placeholder="Filter  Date"  />
                                        </th>
                                        <th class="hasinput" >
                                            <input type="text" class="form-control text-center" placeholder="Filter Rating"  />
                                        </th>
                                        <th class="hasinput" >
                                            <input type="text" class="form-control text-center" placeholder="Filter Target"  />
                                        </th>
                                        <th class="hasinput" >
                                            <input type="text" class="form-control text-center" placeholder="Filter Notes"  />
                                        </th>
                                        <th class="hasinput" style="width:8%" >
                                        </th>

                                    </tr>
                                    <tr>
                                        <th class='text-center'>Customer</th>
                                        <th class='text-center'>Category</th>
                                        <th class='text-center'> Cycle Type</th>
                                        <th class='text-center'> Visit Cycle In Days</th>
                                        <th class='text-center'> Last Visit Date</th>
                                        <th class='text-center'> Last Action Date</th>
                                        <th class='text-center'> Rating</th>
                                        <th class='text-center'> Target</th>
                                        <th class='text-center'> Notes</th>
                                        <th class='text-center'></th>
                                    </tr>
                                    </thead>

                                </table>

                            </div>
                            <!-- end widget content -->

                        </div>
                        <!-- end widget div -->

                    </div>
                    <!-- end widget -->

                </article>
                <!-- WIDGET END -->

            </div>

            <!-- end row -->

        </section>
    </div>


</div>

<!-- Modal -->
<div class="modal fade" id="myModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close" style="font-size: 30px;">
                    <span aria-hidden="true" id="closeModalBtn">×</span>
                </button>
                <h4 class="modal-title" style="text-align: center" id="myModalLabel">New Allow Category Customer</h4>
            </div>
            <div class="modal-body">
                <input class="form-control text-center" type="hidden" id="oldCustomerID">
                <input class="form-control text-center" type="hidden" id="oldCategoryID">
                <table class="table table-bordered">
                    <tr>
                        <td>Customer:</td>
                        <td id ="customerCell">
                            <select class="form-control text-center" type="text" id="customer">
                                <?php echo $customerSelection; ?>
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <td>Category:</td>
                        <td id ="categoryCell">
                            <select class="form-control text-center" type="text" id="category">
                                <?php echo $categorySelection; ?>
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <td>Cycle Type:</td>
                        <td><input class="form-control text-center" type="text" id="cycleType"></td>
                    </tr>
                    <tr>
                        <td>Visit Cycle (Days):</td>
                        <td><input class="form-control text-center" type="number" id="visitCycleDays"></td>
                    </tr>
                    <tr>
                        <td>Last Visit Date:</td>
                        <td><input class="form-control text-center" type="date" id="lastVisitDate"></td>
                    </tr>
                    <tr>
                        <td>Last Action Date:</td>
                        <td><input class="form-control text-center" type="date" id="lastActionDate"></td>
                    </tr>
                    <tr>
                        <td>Rating:</td>
                        <td><input class="form-control text-center" type="text" id="rating"></td>
                    </tr>
                    <tr>
                        <td>Target:</td>
                        <td><input class="form-control text-center" type="number" id="target"></td>
                    </tr>
                    <tr>
                        <td>Notes:</td>
                        <td><textarea class="form-control text-center" id="notes" rows="3"></textarea></td>
                    </tr>
                </table>

                <br>
                <center>
                    <button type="button" class="btn btn-success" id="saveButton" onclick="save('add')">Save</button>
                </center>
            </div>
        </div>
    </div>
</div>


<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/DataTables/datatables.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatables/dataTables.colVis.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatables/dataTables.tableTools.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatables/dataTables.bootstrap.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatable-responsive/datatables.responsive.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/select2/select2.min.js"></script>

<script type="text/javascript">
    var currentMode = 'add';

    function openEditModal( customer, category, cycleType, visitCycleDays, lastVisitDate, lastActionDate, rating, target, notes) {
        // $('#customer').prop('disabled', true);
        // $('#category').prop('disabled', true);
        $('#oldCategoryID').val(category);
        $('#oldCustomerID').val(customer);


        $('#customer').val(customer).trigger("change");
        $('#category').val(category).trigger("change");
        $('#cycleType').val(cycleType);
        $('#visitCycleDays').val(visitCycleDays);
        $('#lastVisitDate').val(lastVisitDate);
        $('#lastActionDate').val(lastActionDate);
        $('#rating').val(rating);
        $('#target').val(target);
        $('#notes').val(notes);
        currentMode = 'edit';

        $('#myModal .modal-title').html('<strong>Edit Category Customer</strong>');
        $('#saveButton').text('Update');
        $('#myModal').modal('show');
    }
    function openNewModal(){
        clearModalFields();
        $('#myModal .modal-title').html('<strong>New Category Customer</strong>');
        $('#saveButton').text('Save');
        currentMode = 'add';
        $('#myModal').modal('show');
    }

    function clearModalFields() {
        $('#oldCategoryID').val('0');
        $('#oldCustomerID').val('0');
        $('#customer').val('0').trigger("change");
        $('#category').val('0').trigger("change");
        $('#cycleType').val('');
        $('#visitCycleDays').val('');
        $('#lastVisitDate').val('');
        $('#lastActionDate').val('');
        $('#rating').val('');
        $('#target').val('');
        $('#notes').val('');
        $('#customerID').val('');
    }
    function save() {
        var customer = $('#customer').val();
        var category = $('#category').val();
        var cycleType = $('#cycleType').val();
        var visitCycleDays = $('#visitCycleDays').val();
        var lastVisitDate = $('#lastVisitDate').val();
        var lastActionDate = $('#lastActionDate').val();
        var rating = $('#rating').val();
        var target = $('#target').val();
        var notes = $('#notes').val();
        var oldCustomerID = $('#oldCustomerID').val();
        var oldCategoryID = $('#oldCategoryID').val();

        var emptyValues = false;
        if (!customer || customer==0) {
            highlightDataError($('#customerCell'));
            emptyValues = true;
        }
        if (!category  || category==0) {
            highlightDataError($('#categoryCell'));
            emptyValues = true;
        }

        if (emptyValues) {
            $.smallBox({
                title: "Warning!",
                content: "Please fill in the required fields",
                color: "#b22222",
                timeout: 3000,
                icon: "fa fa-exclamation-triangle swing animated"
            });
            return;
        }

        var data;
        var message='entered';
        var url="//<?php echo HTML_PATH ?>/cop/backend/core/controllers/add/add_allow_category_customer.php";

        if(currentMode ==="edit"){
            message = " updated";
            url = "//<?php echo HTML_PATH ?>/cop/backend/core/controllers/edit/edit_allow_category_customer.php";
        }


        $.ajax({
            url: url,
            type: "POST",
            data: {
                customer: customer,
                category: category,
                cycleType: cycleType,
                visitCycleDays: visitCycleDays,
                lastVisitDate: lastVisitDate,
                lastActionDate: lastActionDate,
                rating: rating,
                target: target,
                notes: notes,
                oldCustomerID:oldCustomerID,
                oldCategoryID,oldCategoryID
            },
            success: function(result) {
                if (result.localeCompare('error') == 0) {
                    $.smallBox({
                        title: "Warning!",
                        content: "Something went wrong.",
                        color: "#b22222",
                        timeout: 3000,
                        icon: "fa fa-exclamation-triangle swing animated"
                    });
                } else if (result.localeCompare('existing') == 0) {
                    $.smallBox({
                        title: "Warning!",
                        content: "Existing Customer-Category.",
                        color: '#b22222',
                        timeout: 3000,
                        icon: "fa fa-exclamation-triangle swing animated"
                    });
                } else {
                    $.smallBox({
                        title: "Success!",
                        content: "Customer successfully" + message + ".",
                        color: "#739E73",
                        timeout: 3000,
                        icon: "fa fa-check swing animated"
                    });
                    $('#myModal').modal('hide'); 
                    clearModalFields();
                    $('#datatable_fixed_column').DataTable().draw(null, false);
                }
            }
        });
    }

    function highlightDataError(element){
        element.css('border-color','firebrick').css('background-color','#ffd0bd');
        window.setTimeout(function(){
            element.css('border-color','').css('background-color','');
        },3000);
    }


    $(document).ready(function() {

        pageSetUp();

        $('#customer').select2({
            minimumInputLength: 2
        });

        $('#category').select2({
            minimumInputLength: 2
        });

        $('#closeModalBtn').on('click', function() {
            $('#myModal').modal('hide');
        });

        var responsiveHelper_datatable_fixed_column = undefined;
        var breakpointDefinition = {
            tablet : 1024,
            phone : 480
        };

        /* COLUMN FILTER  */
        var otable = $('#datatable_fixed_column').DataTable({
            "sDom": "<'dt-toolbar'<'col-xs-6 col-sm-6'f><'col-sm-6 col-xs-6 hidden-xs' B C l>r>"+
                "t"+
                "<'dt-toolbar-footer'<'col-sm-6 col-xs-12 hidden-xs'i><'col-sm-6 col-xs-12'p>>",
            "processing": false,
            "serverSide": true,
            "ajax": "//<?php echo HTML_PATH . "/cop/backend/core/controllers/getAll/getAllAllowCategoriesCustomers.php";?>",
            "columns": [
                { "data": "customer" },
                { "data": "category" },
                { "data": "cycleType" },
                { "data": "visitCycleDays" },
                { "data": "lastVisitDate" },
                { "data": "lastActionDate" },
                { "data": "rating" },
                { "data": "target" },
                { "data": "notes" },
                { "data": "form" }
            ],
            "deferRender": true,
            "autoWidth" : true,
            "buttons": [
                "copyHtml5",
                "excelHtml5",
                "csvHtml5",
                {
                    extend: 'pdfHtml5',
                    orientation: 'landscape',
                    pageSize: 'LEGAL'
                }
            ],
            "preDrawCallback" : function() {
                if (!responsiveHelper_datatable_fixed_column) {
                    responsiveHelper_datatable_fixed_column = new ResponsiveDatatablesHelper($('#datatable_fixed_column'), breakpointDefinition);
                }
            },
            "rowCallback" : function(nRow) {
                responsiveHelper_datatable_fixed_column.createExpandIcon(nRow);
            },
            "drawCallback" : function(oSettings) {
                responsiveHelper_datatable_fixed_column.respond();
            }
        });

        // Apply the filter
        $("#datatable_fixed_column thead th input[type=text]").on( 'keyup change', function () {
            otable
                .column( $(this).parent().index()+':visible' )
                .search( this.value )
                .draw();
        } );
        /* END COLUMN FILTER */

    })

</script>