<?php
include_once("../../../../param.php");
require_once(ROOT . "backend/core/model/CustomForm.php");
require_once(ROOT . "backend/core/model/CustomTable.php");

$serviceCallID=0;
$fromServiceCall=false;
if(isset($_GET['service_call_id']))
{
    require_once(ROOT . "concc/dbhelpers/classes/DBCustomer.php");

    $serviceCallID=$_GET['service_call_id'];
    $customerID= $_GET['customer_id'];
    $fromServiceCall=true;

    $dbHelbelCustomer= new DBCustomer();
    $customer=$dbHelbelCustomer->getCustomerByID($customerID);

    $stm = $db->prepare("SELECT customer_address_id,address_code,country,city,address_line_1,address_line_2,postcode,region,lat,lng,pobox,landline,fax,primary_address,timestamp FROM CustomerAddress WHERE customer_id ='$customerID' AND primary_address='yes' LIMIT 1 ");
    $stm->execute();
    $stm->bind_result($customerAddressID, $addressCode,$country, $city, $addressLine1, $addressLine2, $postcode, $region, $lat, $lng, $pobox, $landline, $fax, $primaryAddress, $timestamp);
    while ($stm->fetch()) {
        $receiptAddress = $addressLine1 . ", " . $addressLine2 . ", " . $city;
    }
    $stm->close();

    $customerName =  $customer->companyName;
    $customerCode = $customer->customerCode;
    $customerBalance = $customer->balance;

    $salespersonID = $_SESSION['adminID'];
    if(strcmp($salespersonID,'')!=0){
        $stm = $db->prepare("SELECT salesperson_code,first_name,last_name,warehouse_code, Warehouses.name,Warehouses.warehouse_id FROM SalesPersons,Warehouses WHERE Warehouses.warehouse_id=SalesPersons.default_warehouse_id AND SalesPersons.salesperson_id='$salespersonID'");
        $stm->execute();
        $stm->bind_result($salespersonCode,$firstName,$lastName,$warehouseCode,$warehouseName,$warehouseID);
        while ($stm->fetch()) {}
        $stm->close();
    }
    $salesPersons = "<option value='$salespersonID' selected>$salespersonCode - $firstName $lastName</option>";
}

if(isset($_GET['receipt_id']))
{

    $receiptID=$_GET['receipt_id'];
    $_POST['receipt_id'] = $receiptID;
    $edit = true;
    $linked=false;
}

if(isset($_POST['receipt_id']))
{

    $receiptID=$_POST['receipt_id'];
    $_SESSION['receipt_id'] = $receiptID;
    $edit = true;
    $linked=false;
} else {
    $edit = false;
    $linked=false;
}

global $username,$password,$database;
$db = new mysqli(localhost,$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}

$fromInvoice = false;
if(isset($_POST['invoice_id'])){
    $postInvoiceID = $_POST['invoice_id'];
    $stm = $db->prepare("SELECT invoice_id,customer_id,grand_total FROM Invoices WHERE invoice_id='$postInvoiceID' LIMIT 1");
    $stm->execute();
    $stm->bind_result($postInvoiceID, $customerID,$invoiceGrandTotal);
    while ($stm->fetch()) {}
    $stm->close();

    require_once(ROOT . "concc/dbhelpers/classes/DBCustomer.php");
    $dbHelbelCustomer= new DBCustomer();
    $customer=$dbHelbelCustomer->getCustomerByID($customerID);

    $stm = $db->prepare("SELECT customer_address_id,address_code,country,city,address_line_1,address_line_2,postcode,region,lat,lng,pobox,landline,fax,primary_address,timestamp FROM CustomerAddress WHERE customer_id ='$customerID' AND primary_address='yes' LIMIT 1 ");
    $stm->execute();
    $stm->bind_result($customerAddressID, $addressCode,$country, $city, $addressLine1, $addressLine2, $postcode, $region, $lat, $lng, $pobox, $landline, $fax, $primaryAddress, $timestamp);
    while ($stm->fetch()) {
        $receiptAddress = $addressLine1 . ", " . $addressLine2 . ", " . $city;
    }
    $stm->close();

    $customerName =  $customer->companyName;
    $customerCode = $customer->customerCode;
    $customerBalance = $customer->balance;


    $stm2 = $db->prepare("SELECT  sum(Invoice_Receipt.amount) FROM Invoice_Receipt, Receipts WHERE Receipts.receipt_id = Invoice_Receipt.receipt_id AND Invoice_Receipt.invoice_id='$postInvoiceID' AND NOT Receipts.status ='Canceled'");
    $stm2->execute();
    $stm2->bind_result($paidAmount);
    while ($stm2->fetch()) {}
    $stm2->close();

    $amount = $invoiceGrandTotal - $paidAmount;
    if($amount < 0){$amount = 0;}
    $fromInvoice = true;
}

if($edit) {

    $db->set_charset("utf8");
    $stm = $db->prepare("SELECT receipt_id,receipt_code,customer_id,company_id,salesperson_id,order_id,invoice_id,address_id,amount,payment_method,cash_discount,bank,branch,cheque_number,cheque_date,receipt_date,notes,status,timestamp FROM Receipts WHERE receipt_id='$receiptID'");
    $stm->execute();
    $stm->bind_result($receiptID, $recieptCode, $customerID, $companyID, $salepersonID, $orderID, $invoiceID, $addressID, $amount, $paymentMethod, $cashDiscount, $bank, $branch, $chequeNumber, $chequeDate, $receiptDate, $notes, $status, $timestamp);
    while ($stm->fetch()) {

        $db2 = new mysqli(localhost, $username, $password, $database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $db2->set_charset("utf8");


        $stm2 = $db2->prepare("SELECT  COUNT(*) FROM Invoice_Receipt, Invoices WHERE Invoices.invoice_id = Invoice_Receipt.invoice_id AND receipt_id='$receiptID'");
        $stm2->execute();
        $stm2->bind_result($linkedInvoices);
        while ($stm2->fetch()) {
        }
        $stm2->close();

        if($linkedInvoices > 0){
            $linked=true;
        }else{
            $linked=false;
        }

        $stm3 = $db2->prepare("SELECT customer_code,customer_company_name,balance FROM Customers WHERE customer_id='$customerID'");
        $stm3->execute();
        $stm3->bind_result($customerCode, $customerName, $customerBalance);
        while ($stm3->fetch()) {


        }
        $stm3->close();

        $stm4 = $db2->prepare("SELECT customer_address_id,address_code,customer_id,country,city,address_line_1,address_line_2,postcode,region,lat,lng,pobox,landline,fax,primary_address,timestamp FROM CustomerAddress WHERE customer_address_id ='$addressID'");
        $stm4->execute();
        $stm4->bind_result($customerAddressID, $addressCode, $acustomerID, $country, $city, $addressLine1, $addressLine2, $postcode, $region, $lat, $lng, $pobox, $landline, $fax, $primaryAddress, $timestamp);
        while ($stm4->fetch()) {

            $receiptAddress = $addressLine1 . ", " . $addressLine2 . ", " . $city;


        }
        $stm4->close();

        $stm5 = $db2->prepare("SELECT CONCAT(salesperson_code ,' - ',first_name,' ',last_name) FROM SalesPersons WHERE salesperson_id ='$salepersonID'");
        $stm5->execute();
        $stm5->bind_result($salesPersonName);
        while ($stm5->fetch()) {

        }
        $stm5->close();

        $banks = "<option value='$bank' selected>$bank</option>";
        $salesPersons = "<option value='$salepersonID' selected>$salesPersonName</option>";

    }
    $stm->close();

    if (strcmp($paymentMethod,'Multiple')==0){
        $stm = $db->prepare("SELECT SUM(amount),SUM(cash_discount) FROM Receipt_Item WHERE receipt_id='$receiptID'");
        $stm->execute();
        $stm->bind_result( $amount,$cashDiscount);
        while ($stm->fetch()) {}
        $stm->close();
    }

    switch ($paymentMethod) {
        case 'Cash':
            $MethodSelectionCA = 'selected';
            break;
        case 'Cheque':
            $MethodSelectionCH = 'selected';
            break;
        case 'Bank Transfer':
            $MethodSelectionBT = 'selected';
            break;
        case 'Credit Card':
            $MethodSelectionCC = 'selected';
            break;
        case 'Credit Note':
            $MethodSelectionCN = 'selected';
            break;
        case 'Coupon':
            $MethodSelectionCO = 'selected';
            break;
        case 'Multiple':
            $MethodSelectionMU = 'selected';
            break;

    }
}

if(!$linked) {
    $banks .= "<option value='$bank' selected>$bank</option>";
    $stm = $db->prepare("SELECT name FROM Banks WHERE status LIKE 'yes' AND name NOT LIKE '$bank' ORDER BY name ASC ");
    $stm->execute();
    $stm->bind_result($bankSelect);
    while ($stm->fetch()) {

        $banks .= "<option value='$bankSelect'>$bankSelect</option>";

    }
    $stm->close();
    $banks .= "<option value='Other'>Other Bank</option>";
}
$where = '';
if(isset($_SESSION['Allow_Salespersons']) && strcmp($_SESSION['Allow_Salespersons'],'')!=0){
    if(strcmp($where,'')!=0){$where.= " AND ";}
    $where .= " AND salesperson_id IN (".$_SESSION['Allow_Salespersons'].")";
}
$stm = $db->prepare("SELECT salesperson_id,CONCAT(salesperson_code ,' - ',first_name,' ',last_name) FROM SalesPersons WHERE salesperson_id NOT LIKE '$salepersonID' $where");
$stm->execute();
$stm->bind_result($salepersonIDs,$salesPersonNames);
while ($stm->fetch()) {

    $salesPersons.= "<option value='$salepersonIDs'>$salesPersonNames</option>";

}
$stm->close();

if($linked){
    $disabled = "disabled";
}
$accepted = false;
$canceled = false;
$multiple = false;

if(strcmp($status,'Canceled') == 0){
    $canceled = true;
    $disabled = "disabled";
}
if(strcmp($status,'Accepted') == 0){
    $accepted = true;
    $disabled = "disabled";
}
if (strcmp($paymentMethod,'Multiple') == 0){
    $multiple = true;
    $disabled = "disabled";
}

$includeScLink = false;
$custForm = new CustomForm('Receipts',$receiptID);
$custTable = new CustomTable('Receipts',$receiptID);

?>

<div id="main" role="main">

    <!-- Start CUSTOM CODE-->


    <!-- RIBBON -->
    <div id="ribbon" class="bg-color-blue">

				<span class="ribbon-button-alignment">
					<span id="refresh" class="btn btn-ribbon2" onclick="location.reload(true);" data-title="refresh" rel="tooltip" data-placement="bottom" data-original-title="<i class='text-warning fa fa-warning'></i> Reload Page?" data-html="true">
						<i class="fa fa-refresh"></i>
					</span>
				</span>

        <!-- breadcrumb -->
        <ol class="breadcrumb">
            <li class="txt-color-white">Home /
                <?php
                if($edit){
                    echo ' Edit Receipt';
                } else {
                    echo ' Add Receipt';
                }
                ?>
            </li>
        </ol>
        <!-- end breadcrumb -->


    </div>
    <!-- END RIBBON -->

    <!-- MAIN CONTENT -->
    <div id="content">

        <div class="row">
            <div class="col-xs-12 col-sm-8 col-md-9 col-lg-6">
                <h3 class="page-title txt-color-blueDark header-margin">
                    <img class="custom-rounded-image-padding receipt" style="display:inline;" src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/img/receipticon.png" width="30" height="30">
                    <?php
                    if($edit){
                        echo ' Edit Receipt';
                    } else {
                        echo ' Add Receipt';
                    }
                    ?>
                </h3>
            </div>
            <?php

            if ($fromServiceCall || $hasServiceCall) {
                $scRedirect = " <form method='POST' action='//" . HTML_PATH . "/cop/backend/modules/service/views/service_call.php' >
                                <input type='hidden' name='service_call_id' value='$serviceCallID'/>
                                <input type='submit' class='show-stat-buttons btn btn-return' style='text-transform: capitalize;'id='orderPDFButton' value='Back To Service Call'/>
                                </form>";
            } else {
                if($edit) {
                    $stm = $db->prepare("SELECT service_call_id FROM Service_Call_Reply WHERE reply_type_id='3' AND document_type='Receipts' AND document_id='$receiptID'");
                    $stm->execute();
                    $stm->bind_result($serviceCallID);
                    while ($stm->fetch()) {
                    }
                    $stm->close();

                    if ($serviceCallID > 0) {
                        $scRedirect = "<form method='POST' action='//" . HTML_PATH . "/cop/backend/modules/service/views/service_call.php' >
                                    <input type='hidden' name='service_call_id' value='$serviceCallID'/>
                                    <input type='submit' class='show-stat-buttons btn btn-return' style='text-transform: capitalize;'id='orderPDFButton' value='Related Service Call'/>
                                    </form>";
                    } else {
                        if($edit) {
                            $includeScLink = true;
                            include_once(ROOT . "backend/core/model/linkActionToSc.php");
                            $scLink = new linkActionToSc();
                            $scLink->setAction($receiptID,"Receipts");
                            $scRedirect = $scLink->scLinkModal();
                        }
                    }
                }
            }

            if($edit && !$canceled ){
                echo "<div class='col-xs-12 col-sm-4 col-md-3 col-lg-2'>
                        $scRedirect
                      </div>
                      <div class='col-xs-12 col-sm-4 col-md-3 col-lg-2'>
                        <form style='margin:0' method='POST' action='//" . HTML_PATH . "/cop/backend/core/templates/pdf/generateReceiptPDF.php' target='_blank' >
                            <input type='hidden' name='receiptID' value='$receiptID'/>
                            <input type='hidden' name='receiptCode' value='$recieptCode'/>
                            <input type='submit' class='show-stat-buttons btn btn-tender btn-block' style='text-transform: capitalize;'id='invoicePDFButton' value='Create PDF'/>
                        </form>
                      </div>";
            } else {
                echo "<div class='col-xs-12 col-sm-4 col-md-3 col-lg-2'></div>
                      <div class='col-xs-12 col-sm-4 col-md-3 col-lg-2'>
                        $scRedirect
                      </div>";
            }
            ?>
            <div class="col-xs-12 col-sm-4 col-md-3 col-lg-2">
                <span class="pull-right show-stat-buttons">
                <?php
                if($canceled){
                    echo "<h4 style='color: firebrick;' class='pull-right'><b>Receipt Canceled</b></h4>";
                }elseif ($accepted){
                    echo "<h4 style='color: darkgreen;' class='pull-right'><b>Receipt Accepted</b></h4>";
                } else {
                    if ($edit && $linked) {
                        echo '<button id="saveButton" onclick="unlinkReceipt();" class="btn btn-primary btn-block"> Unlink Invoices</button>';
                    } else {
                        echo '<button id="saveButton" onclick="saveReceipt();" class="btn btn-success btn-block"><i class="fa fa-check"></i>&nbsp; Place Receipt</button>';
                    }
                }
                ?>
                 </span>
            </div>
        </div>

        <!-- row -->
        <section id="widget-grid" class="">
            <!-- row -->
            <div class="row">
                <!-- NEW WIDGET START -->
                <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

                    <div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-0" data-widget-editbutton="false" data-widget-deletebutton="false">

                        <header>
                            <span class="widget-icon"> <i class="fa fa-table"></i> </span>
                            <h2>Receipt Details</h2>
                        </header>

                        <!-- widget div-->
                        <div>
                            <!-- widget content -->
                            <div class="widget-body">
                                <?php if($linked && !$canceled && !$accepted){
                                    echo ' <header>
                            
                            <h3 style="color: firebrick">The current receipt is linked with Invoice Documents therefore the editing feature is not allowed.<br/> In order to make any changes you will need to Unlink Invoices </h3>
                        </header>';
                                }?>
                                <form action="" id="checkout-form" class="smart-form" <?php if($canceled){echo 'style="background-color: firebrick"';}if($accepted){echo 'style="background-color: #8ED17D"';}?>>
                                    <fieldset>

                                        <div class="row">
                                            <section class="col col-4">
                                                <section>
                                                    <img class="custom-rounded-image-padding receipt" style="display:inline;" src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/img/receipticon.png" width="30" height="30">
                                                    <h1 style="display: inline;margin-left:6px;vertical-align: middle"> Receipt Details</h1>
                                                </section>
                                                <section >
                                                    <label class="label-bold form-label-space" >Receipt Number: </label>
                                                    <input type="text"   id="receiptCode" name="receiptCode" class="form-control text-center" value="<?php if($edit) {echo $recieptCode;}?>" style="width: 50%;display: inline-block;" value readonly <?php echo $disabled?>/>
                                                    <input type="hidden" id="receiptID" name="receiptID" value="<?php if($edit) {echo $receiptID;}?>" />
                                                </section>
                                                <section >
                                                    <label class="label-bold form-label-space" >Receipt Date:</label>
                                                    <input type="date" id="receiptDate" name="receiptDate" class="form-control" value="<?php if($edit) {echo $receiptDate;} else {echo date("Y-m-d");}?>" style="width: 50%;display: inline-block;" <?php echo $disabled?>/>
                                                </section>
                                                <section >
                                                    <label class="label-bold form-label-space" >Payment Method: </label>
                                                    <select id="paymentMethod" name="paymentMethod" class="form-control"  style="width: 50%;display: inline-block;"  <?php echo $disabled?>>
                                                        <option value="Cash"          <?php if($edit) {echo $MethodSelectionCA;} ?>>Cash         </option>
                                                        <option value="Cheque"        <?php if($edit) {echo $MethodSelectionCH;} ?>>Cheque       </option>
                                                        <option value="Credit Card"   <?php if($edit) {echo $MethodSelectionCC;} ?>>Credit Card  </option>
                                                        <option value="Bank Transfer" <?php if($edit) {echo $MethodSelectionBT;} ?>>Bank Transfer</option>
                                                        <option value="Credit Note"   <?php if($edit) {echo $MethodSelectionCN;} ?>>Credit Note  </option>
                                                        <option value="Coupon"        <?php if($edit) {echo $MethodSelectionCO;} ?>>Coupon       </option>
                                                        <?php
                                                            if ($edit && strcmp($paymentMethod,'Multiple')==0){
                                                                echo "<option value=\"Multiple\" selected>Multiple</option>";
                                                            }
                                                        ?>

                                                    </select>
                                                </section>
                                                <section >
                                                    <label class="label-bold form-label-space" >Sales Person: </label>
                                                    <select id="salesperson" name="salesperson" class="form-control"  style="width: 50%;display: inline-block;"  <?php echo $disabled?>>
                                                        <?php echo $salesPersons ?>
                                                    </select>
                                                </section>
                                                <section >
                                                    <label class="label-bold form-label-space" >Amount:</label>
                                                    <input type="number" id="amount" name="amount" min="0.01" class="form-control" placeholder="0.00" value="<?php if($edit||$fromInvoice) {echo $amount; }?>" style="width: 50%;display: inline-block;" step="0.01"  <?php echo $disabled?>/>
                                                </section>
                                                <section >
                                                    <label class='label-bold form-label-space'><strong> Cash Discount: </strong></label>
                                                    <input type="number" id="cashDiscount" name="cashDiscount" min="0.01" class="form-control" placeholder="0.00" value="<?php if($edit) {echo $cashDiscount; }?>" style="width: 50%;display: inline-block;" step="0.01"  <?php echo $disabled?>/>
                                                </section>
                                                <section >
                                                    <label class="label-bold form-label-space"> Notes:</label>
                                                    <textarea id="notes" name="notes" class="form-control"  style="width: 83%;" rows="4"  <?php echo $disabled?>><?php if($edit) {echo str_replace("null","",$notes);}?></textarea>

                                                </section>



                                            </section>
                                            <section class="col col-4" style="padding-left:20px;border-left:1px dotted #ADD8E6;border-right:1px dotted #ADD8E6;">
                                                <section>
                                                    <img style="display:inline;" src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/img/customerdefault.jpg" width="40" height="40">
                                                    <h1 style="display: inline;margin-left:6px;vertical-align: middle"> Customer Details</h1>
                                                    <input type='hidden' name='serviceCallID' id="serviceCallID" value='<?php echo $serviceCallID;?>'/>
                                                </section>
                                                <section style="margin-bottom: 20px;">
                                                    <label class="label-bold form-label-space" >Find Customer:  </label>
                                                    <input style='display:inline;' class='text-center form-control' id='customerSearch' name='customerSearch' type='text' value='<?php if($edit||$fromServiceCall||$fromInvoice) { echo "$customerCode - $customerName";}?>'  <?php echo $disabled?>>
                                                    <input type="hidden" id="customerID" value="<?php if($edit||$fromServiceCall||$fromInvoice) {echo $customerID;}?>" />
                                                </section>
                                                <section >
                                                    <label class="label-bold form-label-space" >Customer Code: </label>
                                                    <label class="label-text" id="customerCode"><?php if($edit||$fromServiceCall||$fromInvoice) {echo $customerCode;}?> </label>
                                                </section>

                                                <section >
                                                    <label class="label-bold form-label-space"> Customer Name: </label>
                                                    <label class="label-text" id="customerName"> <?php if($edit||$fromServiceCall||$fromInvoice) {echo $customerName;}?> </label>
                                                </section>
                                                <section >
                                                    <label class="label-bold form-label-space"> Customer Balance: </label>
                                                    <label class="label-text" id="customerBalance"> <?php if($edit||$fromServiceCall||$fromInvoice) {echo number_format($customerBalance,2);}?> </label>
                                                </section>
                                                <section >
                                                    <label class="label-bold" style="margin-right: 20px;">Receipt Address: </label>
                                                    <select class="form-control" id="receiptAddress" name="receiptAddress" style="width: 100%;display: inline-block;"  <?php echo $disabled?>>
                                                        <option value="<?php if($edit||$fromServiceCall) {echo $addressID;}?>"><?php if($edit||$fromServiceCall||$fromInvoice) {echo $receiptAddress;}?></option>
                                                    </select>
                                                </section>
                                            </section>
                                            <section class="col col-4 no-margin" style="padding-left:20px;">
                                                <section style="margin-bottom: 20px;">
                                                    <h1 style="display: inline;vertical-align: middle;" id="chequeTransferDetails">Cheque Details</h1>
                                                </section>

                                                <section >
                                                    <label class='label-bold form-label-space' > Bank: </label>
                                                    <select id='bank' name='bank' class='form-control'style="width: 50%;display: inline-block;"  <?php echo $disabled?>>
                                                        <?php echo $banks?>
                                                    </select>
                                                </section>
                                                <section class="otherBank">
                                                    <label class='label-bold form-label-space' > Bank Name: </label>
                                                    <input type="text" id="otherBank" name="otherBank" class="form-control" value="" style="width: 50%;display: inline-block;"  <?php echo $disabled?>/>
                                                </section>
                                                <section >
                                                    <label class='label-bold form-label-space' > Branch No: </label>
                                                    <input type="text" id="branch" name="branch" class="form-control" value="<?php if($edit) {echo $branch;}?>" style="width: 50%;display: inline-block;"  <?php echo $disabled?>/>
                                                </section>
                                                <section >
                                                    <label class='label-bold form-label-space' > Cheque No: </label>
                                                    <input type="number" id="chequeNumber" name="chequeNumber" class="form-control" value="<?php if($edit) {echo $chequeNumber;}?>" style="width: 50%;display: inline-block;"  <?php echo $disabled?>/>
                                                </section >
                                                <section >
                                                    <label class='label-bold form-label-space'> Cheque Date:</label>
                                                    <input type="date" id="chequeDate" name="chequeDate" class="form-control" value="<?php if($edit) {echo $chequeDate;}?>" style="width: 50%;display: inline-block;"  <?php echo $disabled?>/>
                                                </section>

                                                <!-- Custom Fields-->
                                                <section>
                                                    <?php

                                                    if($canceled || $accepted){
                                                        $custTable->disabledCustomTableValues();
                                                        $custForm->disabledCustomFormValues();
                                                    } else {
                                                        $custTable->editCustomTableValues();
                                                        $custForm->editCustomFormValues();
                                                    }
                                                    ?>

                                                </section>
                                                <!-- Custom Fields/-->

                                            </section>


                                        </div>

                                    </fieldset>
                                </form>

                            </div>
                            <!-- end widget content -->


                        <!-- end widget div -->


                    <!-- end widget -->



                <!-- NEW WIDGET START -->
<!--                        EDIT MULTIPLE RECEIPT LINES-->
                            <style>
                                table#datatable_fixed_column_1 tr td img { display:none;}
                                table#datatable_fixed_column_1 tr:hover td img { display:inline-block;}

                                table#datatable_fixed_column_1 {
                                    border: solid 1px #aa701b;
                                }

                                table#datatable_fixed_column_1{
                                    box-shadow: #ffb38a 0px 0px 0px;
                                }

                                table#datatable_fixed_column_1 thead  {
                                    /*border: solid 1px #aa701b;*/
                                }

                                table#datatable_fixed_column_1 thead th {
                                    background-color: #aa701b ;
                                    color: white;
                                    font-family: arial, sans-serif;
                                }
                            </style>
                            <?php
                            if($paymentMethod == "Multiple" ) {
                                echo "<section class='col col-12' style='padding-left:15px;'>
                                                            <section class='no-margin'>
                                                                <br>
									                            			
                                                            </section>	
									                        <section class='no-margin'>
                                                                <table id='datatable_fixed_column_1' class='table table-striped table-hover dataTable' width='100%'>
					                                                <caption><h3> <b>Receipt Lines</b> </h3></caption>
                                                                    <thead>
                                                                        <tr>
                                                                            <th class='text-center' style='width: 3%;'>#</th>                
                                                                            <th class='text-center' style='width: 3%;display: none;'>receiptLineID</th>                
                                                                            <th class='text-center' style='width: 10%;'>Type</th>                
                                                                            <th class='text-center'>Amount</th>
                                                                            <th class='text-center'>Cash Discount</th>
                                                                            <th class='text-center'>Bank</th>   
                                                                            <th class='text-center'>Branch</th>    
                                                                            <th class='text-center'>Cheque Number</th>      
                                                                            <th class='text-center'>Cheque Date</th>            									  
                                                                            <th class='text-center'>Notes</th>   								  
                                                                        </tr>
                                                                    </thead>";

                                global $username, $password, $database;
                                include_once(ROOT . "concc/dbhelpers/functions/subunitsFunctions.php");

                                $db = new mysqli(localhost, $username, $password, $database);
                                if (mysqli_connect_errno()) {
                                    printf("Connect failed: %s\n", mysqli_connect_error());
                                    exit();
                                }
                                $db->set_charset("utf8");
                                // WHERE compani code in  Session
                                $stm = $db->prepare("SELECT receipt_item_id,payment_method,amount,cash_discount,bank,branch,cheque_number,cheque_date,notes FROM Receipt_Item WHERE receipt_id='$receiptID'");
                                $stm->execute();
                                $stm->bind_result( $receiptItemID,$payment_method,$item_amount,$cash_discount,$bank,$branch,$cheque_number,$cheque_date,$notes);
                                while ($stm->fetch()) {
                                    $cash_discountFormat = number_format($cash_discount,2);
                                    $item_amountFormat   = number_format($item_amount,2);
                                    $cheque_dateFormat = date('d-m-Y',strtotime($cheque_date));
                                    $cashPayment = '';
                                    $checkPayment = '';
                                    $creditPayment = '';
                                    $tranferPayment = '';
                                    $creditNotePayment = '';
                                    $couponPayment = '';
                                    switch ($payment_method){
                                        case 'Cash':{
                                            $cashPayment = 'selected';
                                            break;
                                        }
                                        case 'Cheque' :{
                                            $checkPayment = 'selected';
                                            break;
                                        }
                                        case 'Credit Card' :{
                                            $creditPayment = 'selected';
                                            break;
                                        }
                                        case 'Bank Transfer' :{
                                            $tranferPayment = 'selected';
                                            break;
                                        }
                                        case 'Credit Note' :{
                                            $creditNotePayment = 'selected';
                                            break;
                                        }
                                        case 'Coupon' : {
                                            $couponPayment = 'selected';
                                            break;
                                        }
                                    }
                                    $selectedPaymentMethod = "
                                                    <select id='paymentMethodTypes' name='' class='form-control text-center'  style=''>
                                                        <option value='Cash' $cashPayment>Cash</option>
                                                        <option value='Cheque' $checkPayment>Cheque</option>
                                                        <option value='Credit Card' $creditPayment>Credit Card</option>
                                                        <option value='Bank Transfer' $tranferPayment>Bank Transfer</option>
                                                        <option value='Credit Note' $creditNotePayment>Credit Note</option>
                                                        <option value='Coupon' $couponPayment>Coupon</option>
                                                    </select>";
                                    $findSelectBank = false;
                                    $banksReceiptLines = "<select id='banksReceiptLines' name='' class='form-control text-center'>";
                                    $db1 = new mysqli(localhost, $username, $password, $database);
                                    if (mysqli_connect_errno()) {
                                        printf("Connect failed: %s\n", mysqli_connect_error());
                                        exit();
                                    }
                                    $db1->set_charset("utf8");
                                    $stm1 = $db1->prepare("SELECT name FROM Banks  ORDER BY name ASC ");
                                    $stm1->execute();
                                    $stm1->bind_result($bankSelect);
                                    while ($stm1->fetch()) {
                                        if ($bankSelect == $bank){
                                            $findSelectBank = true;
                                            $banksReceiptLines .= "<option value='$bankSelect' selected>$bankSelect</option>";
                                        }else{
                                            $banksReceiptLines .= "<option value='$bankSelect'>$bankSelect</option>";
                                        }
                                    }
                                    $stm1->close();
//                                    if ($findSelectBank){
//                                        $banksReceiptLines .= "<option value='Other'>Other Bank</option></select>";
//                                    }else{
//                                        $banksReceiptLines .= "<option value='Other' selected>Other Bank</option></select>";
//                                    }




                                    echo "<tr>
                                                <td><img class='deletRowButton' src='//" . HTML_PATH . "/cop/backend/themes/" . THEME_NAME . "/img/deleteicon.png' style='width:20px;height:20px;'/></td>
                                                <td style='display: none;'><input   id='receiptLineID' name='receiptLineID' type='hidden' value='$receiptItemID' ></td>
                                                <td>$selectedPaymentMethod</td>
                                                <td><input type='number' id='amountReceiptLine' value='$item_amount' class='form-control text-center'></td>
                                                <td><input type='number' id='cashdiscountReceiptLine' value='$cash_discount' class='form-control text-center'></td>
                                                <td>$banksReceiptLines</td>
                                                <td><input type='text' id='branchReceiptLine' value='$branch' class='form-control'></td>
                                                <td><input type='number' id='checkNumberReceiptLine' value='$cheque_number' class='form-control text-center'></td>
                                                <td><input type='date' id='checkDateReceiptLine' value='$cheque_date' class='form-control'></td>
                                                <td><input type='text' id='notesReceiptLine' value='$notes' class='form-control'></td>
                                         </tr>";
                                }
                                $stm->close();
                                echo " 
                                
                                                   <tbody></tbody>
                                                                </table>
                                                                <span class='col-sm-2' style='margin: 10px;margin-top: 3px;'>
        <button id='newLineButton' class='btn btn-orange btn-block' onclick=\"addNewLine();\" style='padding:5px;'> <i class='fa fa-plus '></i>&nbsp; Add Receipt Line</button>  </span>
                                                            <br> <br> <br> <br></section></section>
                                                             ";
                            }
                            ?>


                        <!-- widget div-->

                            <!-- widget content -->
                            <?php if(!$canceled && !$accepted){

                            echo '
                            <div class="widget-body no-padding">

                                <table id="datatable_fixed_column" class="table table-striped table-hover dataTable" width="100%">

                                    <thead>
                                    <tr>
                                        <th class="hasinput" style="width:5%">
                                            
                                        </th>
                                        <th class="hasinput" style="width:10%">
                                            
                                        </th>
                                        <th class="hasinput" style="width:10%" >
                                            
                                        </th>
                                        <th class="hasinput" style="width:10%">
                                            
                                        </th>
                                        <th class="hasinput" style="width:12%">
                                            
                                        </th>
                                        <th class="hasinput" style="width:10%">

                                        </th>
                                        <th class="hasinput" style="width:14%">

                                        </th>
                                        <th class="hasinput" style="width:10%">

                                        </th>
                                        <th class="hasinput" style="width:14%">

                                        </th>
                                    </tr>
                                    <tr>
                                        <th class="text-center"></th>
                                        <th class="text-center">Invoice Code</th>
                                        <th class="text-center">Invoice Date</th>
                                        <th class="text-center" data-hide="phone">Salesperson</th>
                                        <th class="text-center" data-hide="phone">Invoice Type</th>
                                        <th class="text-center" data-hide="phone,tablet">Grand Total</th>
                                        <th class="text-center" data-hide="phone,tablet">Status</th>
                                        <th class="text-center" data-hide="phone,tablet">Remaining</th>
                                        <th class="text-center" data-hide="phone,tablet">Actions</th>
                                    </tr>
                                    </thead>
                                </table>

                            </div>
                            '; }
                            ?>
                            <!-- end widget content -->

                        </div>
                        <!-- end widget div -->

                    </div>
                    <!-- end widget -->

                </article>
            </div>

            <!-- end row -->


        </section>

    </div>
</div>

<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/jquery.tabletojson.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/select2/select2.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatables/jquery.dataTables.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatables/dataTables.colVis.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatables/dataTables.tableTools.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatables/dataTables.bootstrap.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatable-responsive/datatables.responsive.min.js"></script>

<script type="text/javascript">
    function addNewLine()
    {
        $lastTr = $('tr:last', $('#datatable_fixed_column_1'));
        $lastTd = $('td:last', $lastTr);
        $newTr = $lastTr.clone();
        $lastTr.after($newTr);
        $newTr.find("input").val("");
        $newTr.find("textarea").text("");
        $newTr.find("#vat").text("");
        $i = $newTr.find("td.index").text();
        $i++;
        $newTr.find("td.index").text($i);

        $( ".deletRowButton" ).click(function() {
            deleteRow(this);
        });
    }

    $( ".deletRowButton" ).click(function() {
        deleteRow(this);
    });

    function deleteRow(row)
    {
        var rowCount = $('#datatable_fixed_column_1 tr').length;

        if (rowCount > 2) {
            $(row).parents('tr').remove();
        }
    }

    function inputValidation()
    {

        var valid  = false;
        var amount = $('#amount').val();

        if($("#receiptDate").val() != '' && $("#amount").val() != '' && $("#customerID").val() != '' && amount > 0.009){

            var method = $("#paymentMethod").val();
            var bank   = $("#bank").val();
            var other  = 'Other';
            var cheque = 'Cheque';

            if(method.localeCompare(cheque) == 0){

                if($("#bank").val() != '' && $("#chequeNumber").val() != '' && $("#chequeDate").val() != ''){

                    if (bank.localeCompare(other) != 0) {
                        valid = true;
                    } else {
                        if(bank.localeCompare(other) == 0 && $("#otherBank").val() != ''){
                            valid = true;
                        } else {
                            valid = false;

                            highlightDataError($('#otherBank'));
                        }
                    }

                } else {
                    valid = false;

                    var bank =$('#bank').val();
                    var chequeNumber =$('#chequeNumber').val();
                    var chequeDate =$('#chequeDate').val();

                    if(!bank){highlightDataError($('#bank'));}
                    if(!chequeNumber){highlightDataError($('#chequeNumber'));}
                    if(!chequeDate){highlightDataError($('#chequeDate'));}
                }

            } else {
                valid = true;
            }

        } else {
            valid = false;

            var customerID =$('#customerID').val();
            var receiptDate =$('#receiptDate').val();
            var amount =$('#amount').val();

            if(!customerID){highlightDataError($('#customerSearch'));}
            if(!receiptDate){highlightDataError($('#receiptDate'));}
            if(!amount || amount <= 0.009){highlightDataError($('#amount'));}
        }

        return valid;
    }

    function highlightDataError(element){
        element.css('border-color','firebrick').css('background-color','#ffd0bd');
        window.setTimeout(function(){element.css('border-color','').css('background-color','');
        },2500);
    }

    function saveReceipt()
    {
        $("#saveButton").attr("disabled", true);

        var valid = inputValidation();

        if(valid){

            var checkedInvoices = [];
            $("input[name='invoice']:checked").each(
                function(){
                    var id = this.id;
                    checkedInvoices.push(id);
                }
            );


            var bank           = $('#bank').val();
            var notes          = $('#notes').val();
            var branch         = $('#branch').val();
            var amount         = $('#amount').val();
            var receiptID      = $('#receiptID').val();
            var otherBank      = $('#otherBank').val();
            var chequeDate     = $('#chequeDate').val();
            var customerID     = $('#customerID').val();
            var receiptCode    = $('#receiptCode').val();
            var salesperson    = $('#salesperson').val();
            var receiptDate    = $('#receiptDate').val();
            var chequeNumber   = $('#chequeNumber').val();
            var cashDiscount   = $('#cashDiscount').val();
            var paymentMethod  = $('#paymentMethod').val();
            var receiptAddress = $('#receiptAddress').val();
            var serviceCallID  = $('#serviceCallID').val();
            var receiptItems = $('#datatable_fixed_column_1').tableToJSON(
                {
                    ignoreColumns: [0],
                    textExtractor : {
                        0 : function(cellIndex, $cell) {
                            return $cell.find('input').val();
                        },
                        1 : function(cellIndex, $cell) {
                            return $cell.find('input').val();
                        },
                        2 : function(cellIndex, $cell) {
                            return $cell.find('#paymentMethodTypes').val();
                        },
                        3 : function(cellIndex, $cell) {
                            return $cell.find('input').val();
                        },
                        4 : function(cellIndex, $cell) {
                            return $cell.find('input').val();
                        },
                        5 : function(cellIndex, $cell) {
                            return $cell.find('#banksReceiptLines').val();
                        },
                        6 : function(cellIndex, $cell) {
                            return $cell.find('input').val();
                        },
                        7 : function(cellIndex, $cell) {
                            return $cell.find('input').val();
                        },
                        8 : function(cellIndex, $cell) {
                            return $cell.find('input').val();
                        },
                        9 : function(cellIndex, $cell) {
                            return $cell.find('input').val();
                        }
                    },
                    ignoreHiddenRows: false,
                    ignoreEmptyRows: false
                }
            );
            // console.log(receiptMultipleLines);

            <?php $custForm->declareJsonVariables();?>
            <?php $custTable->declareCustomTableJsonVariables();?>


            if(otherBank){
                bank = otherBank;
            }

            $.ajax({
                type: "POST",

                <?php
                if($edit)
                {
                    echo "url: '//" . HTML_PATH . "/cop/backend/core/controllers/edit/edit_receipt.php',";
                }
                else
                {
                    echo "url: '//" . HTML_PATH . "/cop/backend/core/controllers/add/add_receipt.php',";
                }
                ?>

                data: {
                    'bank'           : bank,
                    'notes'          : notes,
                    'branch'         : branch,
                    'amount'         : amount,
                    'receiptID'      : receiptID,
                    'chequeDate'     : chequeDate,
                    'customerID'     : customerID,
                    'salesperson'    : salesperson,
                    'receiptCode'    : receiptCode,
                    'receiptDate'    : receiptDate,
                    'chequeNumber'   : chequeNumber,
                    'cashDiscount'   : cashDiscount,
                    'paymentMethod'  : paymentMethod,
                    'serviceCallID'  : serviceCallID,
                    'receiptAddress' : receiptAddress,
                    'checkedInvoices': checkedInvoices,
                    'receiptItems': receiptItems
                    <?php $custForm->passJsonVariables();?>
                    <?php $custTable->passCustomTableJsonVariables();?>
                },

                success: function (result) {

                    $.smallBox({
                        title: "Success!",
                        content: "Receipt successfully created",
                        color: "#739E73",
                        timeout: 3000,
                        icon: "fa fa-user swing animated"
                    });

                    window.location.replace("//<?php echo HTML_PATH ?>/cop/backend/core/views/addedit/create_receipt.php?receipt_id=" + result);
                }

            });

        } else {

            $.smallBox({
                title: "Error!",
                content: "Please complete Receipt data",
                color: "#b22222",
                timeout: 3000,
                icon: "fa fa-user swing animated"
            });
            $("#saveButton").attr("disabled", false);

        }



    }

    function initCustomerCodeAutocomplete()
    {
        $("#customerSearch").autocomplete({
            source: "//<?php echo HTML_PATH ?>/cop/backend/core/controllers/autocomplete/customer_autocomplete.php",
            autoFocus: true,
            select: function (event, ui) {

                var bal = parseFloat(ui.item.balance).toFixed( 2 );

                $('#customerID').val(ui.item.id);
                $('#datatable_fixed_column').DataTable().ajax.reload();
                $('#customerCode').text(ui.item.customer_code);
                $('#customerName').text(ui.item.customer_company_name);
                $('#customerBalance').text(bal);

                var optionsAsString = "";
                for(var i = 0; i < ui.item.addresses.length; i++) {
                    if(i==0)
                    {
                        optionsAsString += "<option value=\"" + ui.item.addresses[i].id + "\" selected>" + ui.item.addresses[i].addressLine1 + ", " + ui.item.addresses[i].addressLine2 + ", " + ui.item.addresses[i].city + "</option>";
                    }
                    else{
                        optionsAsString += "<option value=\"" + ui.item.addresses[i].id + "\">" + ui.item.addresses[i].addressLine1 + ", " + ui.item.addresses[i].addressLine2 + ", " + ui.item.addresses[i].city + "</option>";
                    }
                }
                $("select[name='receiptAddress']").find('option').remove().end().append($(optionsAsString));
                return true;
            }

        });
    }

    function viewPDF(url)
    {
        if(urlExists(url))
        {
            window.open(url, '_blank');
        }
        else
        {
            alert("PDF not created on the Mobile Device, please create the PDF and then sync to the Cloud");
        }
    }

    function urlExists(url)
    {
        var http = new XMLHttpRequest();
        http.open('HEAD', url, false);
        http.send();
        return http.status!=404;
    }

    function initPaymentMethodCheck()
    {
        var method = $("#paymentMethod").val();
        var cheque = 'Cheque';
        var bankTransfer = 'Bank Transfer';

        if(method.localeCompare(cheque) == 0){

            initOtherBankCheck();
            $('#chequeTransferDetails').html('Cheque Details');
            $('#bank').val("");
            $('#bank option:selected').remove();
            $("#bank").val($("#bank option:first").val()).trigger('change');
            $('#bank').attr("disabled", false);
            $("#branch").prop('readonly', false);
            $("#chequeNumber").prop('readonly', false);
            $("#chequeDate").prop('readonly', false);

        } else if(method.localeCompare(bankTransfer) == 0){

            initOtherBankCheck();
            $('#chequeTransferDetails').html('Bank Transfer Details');
            $('#bank').val("");
            $('#bank option:selected').remove();
            $("#bank").val($("#bank option:first").val()).trigger('change');
            $('#bank').attr("disabled", false);
            $("#branch").prop('readonly', true);
            $("#chequeNumber").val(null).prop('readonly', true);
            $("#chequeDate").val(null).prop('readonly', true);

        } else {
            $('#chequeTransferDetails').html('Cheque Details (N/A)');
            $('#bank').val("");
            $('#bank option:selected').remove();
            $('#bank').attr("disabled", true).append(`<option value=""></option>`).val("").trigger('change');
            $("#branch").val(null).prop('readonly', true);
            $("#chequeNumber").val(null).prop('readonly', true);
            $("#chequeDate").val(null).prop('readonly', true);
        }
    }

    function initOtherBankCheck()
    {

        var bank  = $("#bank").val();
        var other = 'Other';

        if(bank.localeCompare(other) == 0){
            $("#otherBank").prop('readonly', false);
            $(".otherBank").prop('hidden', false);
        } else {
            $("#otherBank").val('');
            $("#otherBank").prop('readonly', true);
            $(".otherBank").prop('hidden', true);
        }
    }

    function unlinkReceipt(){
        var receiptid = $('#receiptID').val();

        $("#cancelReceiptButton").hide();

        $.ajax({
            type: "POST",
            url: "//<?php echo HTML_PATH ?>/cop/backend/core/controllers/delete/unlinkReceiptInvoices.php",
            data: {receiptID:receiptid},
            success: function(result){
                $.smallBox({
                    title : "Success!",
                    content : "Invoices Successfully Unlinked",
                    color : "#739E73",
                    timeout: 3000,
                    icon : "fa fa-user swing animated"
                });
                window.location.replace("//<?php echo HTML_PATH ?>/cop/backend/core/views/addedit/create_receipt.php?receipt_id="+result);
            }});
    }

    <?php if($includeScLink){echo $scLink->linkScFunction();} ?>

    $(document).ready(function() {

        pageSetUp();
        initCustomerCodeAutocomplete();
        initOtherBankCheck();
        <?php if(!$linked){echo 'initPaymentMethodCheck();';}?>

        <?php
        if(strcmp(strtolower($status),'canceled')==0 || strcmp(strtolower($status),'cancelled')==0){
            echo '$("#main :input").attr("disabled", true);';
            echo '$("#main").css("background-color", "#F3CFC6");';
            echo '$("#newLineButton").attr("disabled", true);';
        }

        ?>

        $("#paymentMethod").change(function(){  initPaymentMethodCheck(); });

        $("#bank").change(function(){ initOtherBankCheck(); });


        $("#chooseParentSelect").select2({
            placeholder: "No Parent Selected",
            allowClear: true

        });

        var responsiveHelper_dt_basic = undefined;
        var responsiveHelper_datatable_fixed_column = undefined;
        var responsiveHelper_datatable_col_reorder = undefined;
        var responsiveHelper_datatable_tabletools = undefined;

        var breakpointDefinition = {
            tablet : 1024,
            phone : 480
        };


        /* COLUMN FILTER  */
        var otable = $('#datatable_fixed_column').DataTable({
            "sDom": "t"+ "<'dt-toolbar-footer'<'col-sm-6 col-xs-12 hidden-xs'i><'col-sm-6 col-xs-12'p>>",
            "autoWidth" : true,
            "order": [[ 1, "desc" ],[ 2, "asc" ]],
            "processing": false,
            "serverSide": true,
            "ajax":{
                <?php
                if($linked || $canceled){
                    echo '"url" : "//' . HTML_PATH . '/cop/backend/core/controllers/getAll/getAllLinkedInvoicesToReceipt.php",
                          "data": function ( data ) { data.receiptID = $(\'#receiptID\').val();}';
                } else if($fromInvoice){
                    echo '"url" : "//' . HTML_PATH . '/cop/backend/core/controllers/getAll/getAllInvoicesForReceipts.php",
                          "data": function ( data ) { data.customerID = $(\'#customerID\').val();d.invoiceID = \'$postInvoiceID\';}';
                } else {
                    echo '"url" : "//' . HTML_PATH . '/cop/backend/core/controllers/getAll/getAllInvoicesForReceipts.php",
                          "data": function ( data ) { data.customerID = $(\'#customerID\').val();}';
                }
                ?>

            },

            "columns": [
                { "data": "img" },
                { "data": "code" },
                { "data": "date" },
                { "data": "salesperson" },
                { "data": "type" },
                { "data": "grand" },
                { "data": "status" },
                { "data": "remaining" },
                { "data": "form" }
            ],
            "deferRender": true,
            "oTableTools": {
                "aButtons": [
                    "copy",
                    "csv",
                    "xls",
                    {
                        "sExtends": "pdf",
                        "sTitle": "Coprime PDF",
                        "sPdfMessage": "Coprime PDF Export",
                        "sPdfSize": "letter"
                    },
                    {
                        "sExtends": "print",
                        "sMessage": "Generated by Coprime<i>(press Esc to close)</i>"
                    }
                ],
                "sSwfPath": "js/plugin/datatables/swf/copy_csv_xls_pdf.swf"
            },
            "preDrawCallback" : function() {
                // Initialize the responsive datatables helper once.
                if (!responsiveHelper_datatable_fixed_column) {
                    responsiveHelper_datatable_fixed_column = new ResponsiveDatatablesHelper($('#datatable_fixed_column'), breakpointDefinition);
                }
            },
            "rowCallback" : function(nRow) {
                responsiveHelper_datatable_fixed_column.createExpandIcon(nRow);
            },
            "drawCallback" : function(oSettings) {
                responsiveHelper_datatable_fixed_column.respond();
            }

        });

        // Apply the filter
        $("#datatable_fixed_column thead th input[type=text]").on( 'keyup change', function () {

            otable
                .column( $(this).parent().index()+':visible' )
                .search( this.value )
                .draw();

        } );
        /* END COLUMN FILTER */

        <?php if($includeScLink){echo $scLink->initScDataTable();} ?>



    })

</script>



