<?php

error_reporting(100);
include_once("../../../../param.php");
require_once(ROOT . 'libs/phpexcel/vendor/autoload.php');

if(isset($_POST['itemsPerRow']) && strcmp($_POST['itemsPerRow'],'')!=0){
    $itemsPerRow = trim($_POST['itemsPerRow']);
} else {
    $itemsPerRow = 4;
}

$imgWidth  =  100;
$imgHeight =  100;

$db = new mysqli('localhost', $username, $password, $database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");
$stm = $db->prepare("SELECT line1,line2,line3,line4,line5,line6,line7 FROM Companies LIMIT 1");
$stm->execute();
$stm->bind_result($line1, $line2, $line3, $line4, $line5, $line6, $line7);
while ($stm->fetch()) {}
$stm->close();

$columns = range('A', 'Z');

$objPHPExcel = new PHPExcel();

$objDrawing = new PHPExcel_Worksheet_Drawing();
IF(file_exists(ROOT . 'media/pdfimage/logo.png')) {
    $objDrawing->setName('logo');
    $objDrawing->setDescription('logo');
    $objDrawing->setPath(ROOT . 'media/pdfimage/logo.png');
    $objDrawing->setCoordinates('A1');
    $objDrawing->setWidthAndHeight(300, 300);
    $objDrawing->setOffsetY(100);
    $objDrawing->setWorksheet($objPHPExcel->getActiveSheet());
}

$details = $itemsPerRow*2;
$objPHPExcel->setActiveSheetIndex(0)
    //-- COMPANY DETAILS --//
    ->setCellValue($columns[$details].'1', $line1)
    ->setCellValue($columns[$details].'2', $line2)
    ->setCellValue($columns[$details].'3', $line3)
    ->setCellValue($columns[$details].'4', $line4)
    ->setCellValue($columns[$details].'5', $line5)
    ->setCellValue($columns[$details].'6', $line6)
    ->setCellValue($columns[$details].'7', $line7)
;




$vatsArray = Array();
$stm = $db->prepare("SELECT vat_id,vat_code,percentage FROM Vats");
$stm->execute();
$stm->bind_result($vatID,$vatCode,$percentage);
while ($stm->fetch()) {
    $vatObject="";
    $vatObject->id=$vatID;
    $vatObject->code=$vatCode;
    $vatObject->percentage=$percentage;
    $vatObject->vatAmount=0;
    $vatObject->goods=0;
    array_push($vatsArray,$vatObject);
}
$stm->close();


$counter = 0;
$stm = $db->prepare("SELECT Items.item_id,sales_units,thumbnail_url,subunits,Items.vat_id,Items.item_code,Items.name,price FROM Items, Prices, PriceTypes WHERE Prices.item_id=Items.item_id AND Prices.pricetype_id=PriceTypes.pricetype_id AND default_type = 'yes' AND NOT status = 'inactive' ");
$stm->execute();
$stm->bind_result($itemID, $uom,$image,$subunits, $vatID, $itemCode,$name, $unitPrice);


$items = array();
while ($stm->fetch()){

    $db2 = new mysqli('localhost', $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }

    $stm2 = $db2->prepare("SELECT barcode FROM Item_Barcode WHERE item_id='$itemID'");
    $stm2->execute();
    $stm2->bind_result($barcode);
    while ($stm2->fetch()){}
    $stm2->close();

    $counter++;

    $item = "";
    $item->counter   = $counter;
    $item->code      = $itemCode;
    $item->name      = $name;
    $item->uom       = $uom;
    $item->qty       = $qty;
    $item->barcode   = $barcode;
    $item->unitPrice = number_format($unitPrice,2);
    $item->vatCode   = $vatCode;
    $item->image     = $image;

    array_push($items, $item);

}
$stm->close();



$colCounter = 0;
$row = $objPHPExcel->getActiveSheet()->getHighestRow() + 4;
$firstRow = $row;

foreach ($items as $item) {
    if (strcmp($item->image, '') != 0) {
        $imageURL = ROOT . 'media/productImages/' . $item->image . '.jpg';
        if (!file_exists($imageURL)) {
            $imageURL = ROOT . "backend/themes/" . THEME_NAME . "/img/itemdefaulticon.jpg";
        }
    } else {
        $imageURL = ROOT . "backend/themes/" . THEME_NAME . "/img/itemdefaulticon.jpg";
    }

    $offSet = (100/$imgWidth)*30;
    $objDrawing = new PHPExcel_Worksheet_Drawing();
    $objDrawing->setName('item');
    $objDrawing->setDescription('item');
    $objDrawing->setPath($imageURL);
    $objDrawing->setCoordinates($columns[$colCounter] . $row);
    $objDrawing->setWidthAndHeight($imgWidth, $imgHeight); // Previous 50 , 50
    $objDrawing->setOffsetX($offSet); // Previous 62
   // $objDrawing->setOffsetY($imgHeight/10);
    $objDrawing->setWorksheet($objPHPExcel->getActiveSheet());

    //$objPHPExcel->getActiveSheet()->getRowDimension($row)->setRowHeight($imgHeight); // Previous 50
    $objPHPExcel->getActiveSheet()->getColumnDimension($columns[$colCounter])->setWidth(20);

    $mergeRow = $row + 3;
    $objPHPExcel->getActiveSheet()->mergeCells($columns[$colCounter] . $row.':'.$columns[$colCounter] . $mergeRow);

    $detailRow = $row;
    if(strcmp(currencySymbol,"&euro;")==0){
        $currencySymbol = '€';
    } else {
        $currencySymbol = '';
    }
    $item->unitPrice = $currencySymbol.number_format($item->unitPrice,2);
    $colCounter++;
    $objPHPExcel->setActiveSheetIndex(0)->setCellValue($columns[$colCounter] . $detailRow, "$item->name");
    $objPHPExcel->setActiveSheetIndex(0)->setCellValue($columns[$colCounter] . ++$detailRow, "Price: $item->unitPrice");
    $objPHPExcel->setActiveSheetIndex(0)->setCellValue($columns[$colCounter] . ++$detailRow, "$item->barcode");
    $objPHPExcel->getActiveSheet()->getStyle($columns[$colCounter] . $detailRow)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_NUMBER);
    $objPHPExcel->getActiveSheet()->getColumnDimension($columns[$colCounter])->setAutoSize(true);
    $colCounter++;
    if($colCounter/2 >= $itemsPerRow) {
        $colCounter = 0;
        $row = $objPHPExcel->getActiveSheet()->getHighestRow() + 4;
    }



}

$itemsPerRow *= 2;

$objPHPExcel->getActiveSheet()->getStyle('A8:'.$columns[$itemsPerRow].$row)->applyFromArray(
    array(
        'alignment' => array(
            'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_LEFT,
            'vertical'  => PHPExcel_Style_Alignment::VERTICAL_CENTER
        )
    )
);


$objPHPExcel->getActiveSheet()->getStyle('B1:D1')->applyFromArray(
    array(
        'alignment' => array(
            'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_RIGHT,
        )
    )
);


$objPHPExcel->getActiveSheet()->getStyle('A1:'.$columns[$itemsPerRow].$row)->applyFromArray(
    array(
        'borders' => array(
            'allborders' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN,
                'color' => array('rgb' => 'FFFFFF')
            )
        )
    )
);


$objPHPExcel->getActiveSheet()->getStyle($columns[$itemsPerRow].'1:'.$columns[$itemsPerRow].'7')->applyFromArray(
    array(
        'alignment' => array(
            'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_RIGHT,
        )
    )
);







// Redirect output to a client’s web browser (Excel2007)
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment;filename="ProductList.xlsx"');
header('Cache-Control: max-age=0');
// If you're serving to IE 9, then the following may be needed
header('Cache-Control: max-age=1');

// If you're serving to IE over SSL, then the following may be needed
header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT'); // always modified
header ('Cache-Control: cache, must-revalidate'); // HTTP/1.1
header ('Pragma: public'); // HTTP/1.0

$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
$objWriter->save('php://output');


?>