<?php
// Andreas Spanos @ 26/07/2019  Made the Image Larger

error_reporting(100);
include_once("../../../../param.php");
require_once(ROOT . 'libs/phpexcel/vendor/autoload.php');

$tenderID = trim(''.$_POST['tenderID']);
$tenderCode = trim(''.$_POST['tenderCode']);

$db = new mysqli('localhost', $username, $password, $database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

$stm = $db->prepare("SELECT tender_code,tender_date,salesperson_id,subtotal,grand_total,vat_amount,customer_id,company_id FROM Tenders WHERE tender_id='$tenderID'");
$stm->execute();
$stm->bind_result($tenderCode, $tenderDate, $salespersonID, $subtotal, $grandTotal, $vatAmount, $customerID, $companyID);
while ($stm->fetch()) {}
$stm->close();

if(strcmp("$tenderDate",'')!=0 && strcmp("$tenderDate",'0000-00-00')!=0) {
    $tenderDate = date_format(date_create_from_format('Y-m-d', "$tenderDate"), 'd-m-Y');
} else {
    $tenderDate = '';
}
$subtotal   = number_format(floatval($subtotal),2);
$grandTotal = number_format(floatval($grandTotal),2);
$vatAmount  = number_format(floatval($vatAmount),2);


$stm = $db->prepare("SELECT line1,line2,line3,line4,line5,line6,line7 FROM Companies WHERE company_id='$companyID'");
$stm->execute();
$stm->bind_result($line1, $line2, $line3, $line4, $line5, $line6, $line7);
while ($stm->fetch()) {}
$stm->close();


$stm = $db->prepare("SELECT customer_code,customer_company_name FROM Customers WHERE customer_id='$customerID'");
$stm->execute();
$stm->bind_result($customerCode, $customerName);
while ($stm->fetch()) {}
$stm->close();


$stm = $db->prepare("SELECT salesperson_code FROM SalesPersons WHERE salesperson_id='$salespersonID'");
$stm->execute();
$stm->bind_result($salespersonDisplayName);
while ($stm->fetch()) {}
$stm->close();


$stm = $db->prepare("SELECT pricetype_id FROM PriceTypes WHERE default_type='yes'");
$stm->execute();
$stm->bind_result($defaultPriceType);
while ($stm->fetch()) {}
$stm->close();

$displayDate = $tenderDate;


$objPHPExcel = new PHPExcel();

$objPHPExcel->getActiveSheet()->mergeCells('G1:G7');
$objPHPExcel->getActiveSheet()->mergeCells('A9:B9');
$objPHPExcel->getActiveSheet()->mergeCells('D9:G9');
$objPHPExcel->getActiveSheet()->mergeCells('B1:C1');
$objPHPExcel->getActiveSheet()->mergeCells('A2:B2');
$objPHPExcel->getActiveSheet()->mergeCells('D10:G10');

$objPHPExcel->setActiveSheetIndex(0)
    ->setCellValue('A1', $line1)
    ->setCellValue('A2', $line2)
    ->setCellValue('A3', $line3)
    ->setCellValue('A4', $line4)
    ->setCellValue('A5', $line5)
    ->setCellValue('A6', $line6)
    ->setCellValue('A7', $line7)
    ->setCellValue('A11', '')
    ->setCellValue('A9', 'Πληροφορίες Πελάτη / Customer Information')
    ->setCellValue('A10','Όνομα Πελάτη / Client Name: '.$customerName)
    ->setCellValue('B1', 'ΠΡΟΣΦΟΡΑ - SALES QUOTATION')
    ->setCellValue('D9', 'Ημερ. / Date: '.$tenderDate)
    ->setCellValue('D10', 'Αρ. Προσφοράς / Quotation No: '.$tenderCode)

;


$objDrawing = new PHPExcel_Worksheet_Drawing();
$objDrawing->setName('logo');
$objDrawing->setDescription('logo');
$objDrawing->setPath(ROOT . 'media/pdfimage/logo.png');
$objDrawing->setCoordinates('D1');
$objDrawing->setWidthAndHeight(300, 300);
$objDrawing->setOffsetY(100);
$objDrawing->setWorksheet($objPHPExcel->getActiveSheet());


$row = $objPHPExcel->getActiveSheet()->getHighestRow()+1;
$row2 = $objPHPExcel->getActiveSheet()->getHighestRow()+2;


$objPHPExcel->setActiveSheetIndex(0)
    ->setCellValue('A'.$row, "IMG")
    ->setCellValue('B'.$row, "ΓΡ. ΚΩΔΙΚΑΣ")
    ->setCellValue('B'.$row2, "BARCODE")
    ->setCellValue('C'.$row, "ΠΕΡΙΓΡΑΦΗ")
    ->setCellValue('C'.$row2, "DESCRIPTION")
    ->setCellValue('D'.$row, "ΠΟΣΩΤΗΤΑ")
    ->setCellValue('D'.$row2, "QTY")
    ->setCellValue('E'.$row, "ΤΙΜΗ")
    ->setCellValue('E'.$row2, "(€)PRICE")
    ->setCellValue('F'.$row, "ΕΚΠΤΩΣΗ")
    ->setCellValue('F'.$row2, "(%)DISC.")
    ->setCellValue('G'.$row, "ΠΟΣΟ")
    ->setCellValue('G'.$row2, "(€)AMOUNT")
;

$db2 = new mysqli('localhost', $username, $password, $database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}

$items = array();
$stm = $db->prepare("SELECT tender_item_id,tender_id,item_id,qty,unit_price,line_discount,global_discount,vat_amount,pricetype_id,vat_id,timestamp FROM Tender_Item WHERE tender_id='$tenderID'  ");
$stm-> execute();
$stm-> bind_result($tenderItemID,$tender_id,$itemID,$qty,$unitPrice,$lineDiscount,$globalDiscount,$vatAmount,$pricetypeID,$vatID,$timestamp);
while ($stm->fetch()) {

//    $stm2 = $db2->prepare("SELECT price FROM Prices WHERE pricetype_id='$defaultPriceType' AND item_id='$itemID'");
//    $stm2->execute();
//    $stm2->bind_result($defaultUnitPrice);
//    while ($stm2->fetch()) {}
//    $stm2->close();
//
//
//    if(strcmp($defaultUnitPrice,$unitPrice) != 0){
//        $priceDiscount = ($defaultUnitPrice-$unitPrice);
//        if($priceDiscount < 0){$priceDiscount = 0;}
//
//    } else {
//        $priceDiscount = 0;
//    }

    $item = new stdClass();
    $item->id = $itemID;
    $item->qty = $qty;
    $item->unitPrice = $unitPrice;
    $item->discount = $globalDiscount+$lineDiscount+$priceDiscount;
    array_push($items, $item);
}
$stm->close();

foreach ($items as $item){
    $stm = $db->prepare("SELECT name, thumbnail_url, subunits FROM Items WHERE item_id=$item->id ORDER BY item_id ASC LIMIT 1");
    $stm->execute();
    $stm->bind_result($itemDesc, $image, $subunits);
    while ($stm->fetch()) {}
    $stm->close();
    $file =  ROOT.'media/productImages/' . $image . '.jpg';
    if(strcmp($image,'')!=0 && file_exists($file)) {
        $imageURL = ROOT.'media/productImages/' . $image . '.jpg';
    } else {
        $imageURL = ROOT."backend/themes/" . THEME_NAME . "/img/itemdefaulticon.jpg";
    }
    $itemDesc = str_replace("="," ",$itemDesc);
    if(floatval($subunits) <= 0){$subunits = 1;}
    if(floatval($item->unitPrice) <= 0){
        $lineDiscount = 0;
    } else {
        $lineDiscount = $item->discount/($item->unitPrice*$item->qty/$subunits)*100;
    }

    $amount   = ($item->unitPrice*$item->qty/$subunits)-($item->discount);
    $discount = $lineDiscount;
    $discount = floatval($discount);
    $discount = number_format($discount, 2, '.', '');

    $stm = $db->prepare("SELECT barcode FROM Item_Barcode WHERE item_id=$item->id LIMIT 1" );
    $stm->execute();
    $stm->bind_result($barcode);
    while ($stm->fetch()) {}
    $stm->close();

    $row = $objPHPExcel->getActiveSheet()->getHighestRow()+1;
    $objPHPExcel->setActiveSheetIndex(0)
        ->setCellValue('B'.$row, ' '.$barcode)
        ->setCellValue('C'.$row, $itemDesc)
        ->setCellValue('D'.$row, $item->qty)
        ->setCellValue('E'.$row, '€'.number_format($item->unitPrice,2))
        ->setCellValue('F'.$row, $discount.'%')
        ->setCellValue('G'.$row, '€'.number_format($amount,2))
    ;

    $objDrawing = new PHPExcel_Worksheet_Drawing();
    $objDrawing->setName('logo');
    $objDrawing->setDescription('logo');
    $objDrawing->setPath($imageURL);
    $objDrawing->setCoordinates('A'.$row);
    $objDrawing->setWidthAndHeight(100, 100); // Previous 50, 50
    $objDrawing->setOffsetX(15); // Previous 45
    $objDrawing->setOffsetY(5);
    $objDrawing->setWorksheet($objPHPExcel->getActiveSheet());
    $objPHPExcel->getActiveSheet()->getRowDimension($row)->setRowHeight(80); // Previous 50

    $objPHPExcel->getActiveSheet()->getStyle('A'.$row.':G'.$row)->applyFromArray(
        array(
            'borders' => array(
                'outline' => array(
                    'style' => PHPExcel_Style_Border::BORDER_THIN,
                    'color' => array('rgb' => '000000')
                )
            )
        )
    );

    $objPHPExcel->getActiveSheet()->getStyle('D'.$row.':G'.$row)->applyFromArray(
        array(
            'alignment' => array(
                'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_RIGHT,
            )
        )
    );
    $objPHPExcel->getActiveSheet()->getStyle('A'.$row)->applyFromArray(
        array(
            'alignment' => array(
                'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
            )
        )
    );
    $objPHPExcel->getActiveSheet()->getStyle('D'.$row)->applyFromArray(
        array(
            'alignment' => array(
                'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
            )
        )
    );
    $objPHPExcel->getActiveSheet()->getStyle('B'.$row.':G'.$row)->applyFromArray(
        array(
            'alignment' => array(
                'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER,
            )
        )
    );
}


$stm = $db->prepare("SELECT subtotal,  discount_amount, vat_amount, grand_total FROM  Tenders WHERE tender_id='$tenderID'");
$stm->execute();
$stm->bind_result($sub_total, $discount_amount, $vat_amount, $grand_total);
while ($stm->fetch()) {}
$stm->close();

$styleRow = $objPHPExcel->getActiveSheet()->getHighestRow()+1;

$row = $objPHPExcel->getActiveSheet()->getHighestRow()+2;
$objPHPExcel->getActiveSheet()->mergeCells('D'.$row.':F'.$row);
$objPHPExcel->setActiveSheetIndex(0)
    ->setCellValue('A'.$row, 'ΠΑΡΑΤΗΡΗΣΕΙΣ / REMARKS')
    ->setCellValue('D'.$row, 'Μικτή Αξία / Gross Goods Value')
    ->setCellValue('G'.$row, '€'.number_format(floatval($sub_total),2));
;
$remarksRow = $objPHPExcel->getActiveSheet()->getHighestRow()+1;

$row = $objPHPExcel->getActiveSheet()->getHighestRow()+2;
$objPHPExcel->getActiveSheet()->mergeCells('D'.$row.':F'.$row);
$objPHPExcel->setActiveSheetIndex(0)
    ->setCellValue('D'.$row, 'Επιπλέον Έκπτωση / Extra Disc.')
    ->setCellValue('G'.$row, '- €'.number_format(floatval($discount_amount),2));
;

$net_total = $sub_total-$discount_amount;
$row = $objPHPExcel->getActiveSheet()->getHighestRow()+2;
$objPHPExcel->getActiveSheet()->mergeCells('D'.$row.':F'.$row);
$objPHPExcel->setActiveSheetIndex(0)
    ->setCellValue('D'.$row, 'Καθαρή Αξία / Net Goods Value')
    ->setCellValue('G'.$row, '€'.number_format(floatval($net_total),2));
;

$row = $objPHPExcel->getActiveSheet()->getHighestRow()+2;
$objPHPExcel->getActiveSheet()->mergeCells('D'.$row.':F'.$row);
$objPHPExcel->setActiveSheetIndex(0)
    ->setCellValue('D'.$row, 'Φ.Π.Α. / VAT Amount')
    ->setCellValue('G'.$row, '€'.number_format(floatval($vat_amount),2));
;

$row = $objPHPExcel->getActiveSheet()->getHighestRow()+2;
$objPHPExcel->getActiveSheet()->mergeCells('D'.$row.':F'.$row);
$objPHPExcel->setActiveSheetIndex(0)
    ->setCellValue('D'.$row, 'Γενικό Σύνολο / Grand Total')
    ->setCellValue('G'.$row, '€'.number_format(floatval($grand_total),2));
;

$objPHPExcel->getActiveSheet()->getStyle('B1:G1')->applyFromArray(
    array(
        'alignment' => array(
            'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_RIGHT,
        )
    )
);



$objPHPExcel->getActiveSheet()->getStyle('A'.$styleRow.':G'.$row)->applyFromArray(
    array(
        'borders' => array(
            'allborders' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN,
                'color' => array('rgb' => 'FFFFFF')
            )
        )
    )
);

$objPHPExcel->getActiveSheet()->getStyle('G'.$styleRow.':G'.$row)->applyFromArray(
    array(
        'alignment' => array(
            'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_RIGHT,
            'vertical'  => PHPExcel_Style_Alignment::VERTICAL_CENTER
        )
    )
);

$objPHPExcel->getActiveSheet()->getStyle('A1:G11')->applyFromArray(
    array(
        'borders' => array(
            'allborders' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN,
                'color' => array('rgb' => 'FFFFFF')
            )
        ),
        'alignment' => array(
            'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_LEFT,
            'vertical'  => PHPExcel_Style_Alignment::VERTICAL_CENTER
        )
    )
);

$objPHPExcel->getActiveSheet()->getStyle('A12:G13')->applyFromArray(
    array(
        'borders' => array(
            'allborders' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN,
                'color' => array('rgb' => '000000')
            )
        ),
        'alignment' => array(
            'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
        ),
        'fill' => array(
            'type' => PHPExcel_Style_Fill::FILL_SOLID,
            'color' => array('rgb' => '000000')
        ),
        'font'  => array(
            'bold'  => true,
            'color' => array('rgb' => 'FFFFFF'),
            'size'  => 10
        )
    )
);

$objPHPExcel->getActiveSheet()->mergeCells('A'.$remarksRow.':B'.$row);
$objPHPExcel->getActiveSheet()->getStyle('A'.$remarksRow.':B'.$row)->applyFromArray(
    array(
        'borders' => array(
            'outline' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN,
                'color' => array('rgb' => '000000')
            )
        )
    )
);

$objPHPExcel->getActiveSheet()->getStyle("A1:G".$row)->getFont()->setBold( true );
foreach(range('A','G') as $columnID) {
    $objPHPExcel->getActiveSheet()->getColumnDimension($columnID)
        ->setAutoSize(true);
}


// Redirect output to a client’s web browser (Excel2007)
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment;filename="Tender'.$tenderCode.'.xlsx"');
header('Cache-Control: max-age=0');
// If you're serving to IE 9, then the following may be needed
header('Cache-Control: max-age=1');

// If you're serving to IE over SSL, then the following may be needed
header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT'); // always modified
header ('Cache-Control: cache, must-revalidate'); // HTTP/1.1
header ('Pragma: public'); // HTTP/1.0

$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
$objWriter->save('php://output');


?>