<?php
error_reporting(0);
include_once("../../../../param.php");

require_once (ROOT . "libs/mPDF/vendor/autoload.php");


function getOrderPicklistPDFForPrinting($orderID)
{

    global $username, $password, $database;
    $db = new mysqli('localhost', $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");

    $stm = $db->prepare("SELECT order_code,order_date,delivery_date,salesperson_id,subtotal,grand_total,vat_amount,customer_id,company_id,order_address_id,delivery_address_id,deposit_amount,details,currency_id FROM Orders WHERE order_id='$orderID'");
    $stm->execute();
    $stm->bind_result($orderCode, $orderDate, $deliveryDate,$salespersonID,$subtotal, $grandTotal, $vatAmount,$customerID,$companyID,$orderAddressID,$deliveryAddress,$depositAmount,$details,$currencyID);

    while ($stm->fetch()) {

    }
    $stm->close();

    $stm = $db->prepare("SELECT currency_id,currency_code,currency_sign FROM Display_Currency WHERE currency_id='$currencyID' LIMIT 1");
    $stm->execute();
    $stm->bind_result($displayCurrencyID,$displayCurrencyCode,$displayCurrencySign);
    while ($stm->fetch()) {}
    $stm->close();

    if(strcmp($displayCurrencySign,'')==0){
        $stm = $db->prepare("SELECT currency_id,currency_code,currency_sign FROM Display_Currency ORDER BY default_currency DESC LIMIT 1");
        $stm->execute();
        $stm->bind_result($displayCurrencyID,$displayCurrencyCode,$displayCurrencySign);
        while ($stm->fetch()) {}
    }


    $orderDate = date_format( date_create_from_format('Y-m-d', $orderDate), 'd-m-Y');

    if(strcmp($deliveryDate,"0000-00-00") != 0) {
        $deliveryDate = date_format(date_create_from_format('Y-m-d', $deliveryDate), 'd-m-Y');
    }
    else
    {
        $deliveryDate = "Not Set";
    }

    $depositAmount = number_format($depositAmount,2);

    $subtotal = number_format($subtotal,2);
    $grandTotal = number_format($grandTotal,2);
    $vatAmount = number_format($vatAmount,2);
    if($companyID > 100){$companyID = 1;}

    $stm = $db->prepare("SELECT line1,line2,line3,line4,line5,line6,line7 FROM Companies WHERE company_id='$companyID'");
    $stm->execute();
    $stm->bind_result($line1, $line2, $line3, $line4, $line5, $line6, $line7);
    while ($stm->fetch()) {


    }
    $stm->close();


    $stm = $db->prepare("SELECT customer_code,customer_company_name FROM Customers WHERE customer_id='$customerID'");
    $stm->execute();
    $stm->bind_result($customerCode, $customerName);

    while ($stm->fetch()) {


    }
    $stm->close();


    $stm = $db->prepare("SELECT address_line_1,address_line_2,postcode,city,landline FROM CustomerAddress WHERE customer_address_id='$orderAddressID'");
    $stm->execute();
    $stm->bind_result($addressLine1, $addressLine2,$postcode,$city,$landline);

    while ($stm->fetch()) {


    }
    $stm->close();

    $stm = $db->prepare("SELECT address_line_1,address_line_2,postcode,city,landline FROM CustomerAddress WHERE customer_address_id='$deliveryAddress'");
    $stm->execute();
    $stm->bind_result($addressLine1D, $addressLine2D,$postcodeD,$cityD,$landlineD);
    while ($stm->fetch()) {


    }
    $stm->close();

    $stm = $db->prepare("SELECT salesperson_code FROM SalesPersons WHERE salesperson_id='$salespersonID'");
    $stm->execute();
    $stm->bind_result($salespersonDisplayName);

    while ($stm->fetch()) {


    }
    $stm->close();



    $displayDate =$orderDate;



    $result= "



<style>


        body
        {
           font-family: Helvetica Neue, Helvetica, Arial, sans-serif;

        }

        p
        {

        }

        #wrapper
        {
            width:180mm;
            margin:0 15mm;
        }

        .page
        {
            height:297mm;
            width:210mm;

            page-break-after:always;
        }

        table.bordered
        {
            border-left: 1px solid #ddd;
            border-top: 1px solid #ddd;

            border-spacing:0;
            border-collapse: collapse;

        }

        table.bordered td
        {
            border-right: 1px solid #ddd;
            border-bottom: 1px solid #ddd;
            padding: 2mm;
        }

        table.heading
        {

        }

        h1.heading
        {
            font-size:14pt;
            color:#000;
            font-weight:normal;
        }

        h2.heading
        {
            font-size:9pt;
            color:#000;
            font-weight:normal;
        }

        hr
        {
            color:#ccc;
            background:#ccc;
        }

        #invoice_body
        {

        }

        td {
          font-family: Helvetica Neue, Helvetica, Arial, sans-serif;
        }

        #invoice_body , #invoice_total, #tableHeader
        {
            width:100%;
        }
        #invoice_body table , #tableHeader table
        {
            width:100%;
            border-left: 1px solid #ccc;
            border-top: 1px solid #ccc;
        }

        #invoice_total table {
          width:100%;
        }

        #invoice_body table td , #tableHeader table td
        {
            text-align:center;
            font-size: 11px;
            border-right: 1px solid #ccc;
            border-bottom: 1px solid #ccc;
            padding:2mm 0;
        }

        #invoice_body table td.mono  , #invoice_total table td.mono, #tableHeader table td.mono
        {
            font-family: Helvetica Neue, Helvetica, Arial, sans-serif;
            text-align:right;
            padding-right:3mm;
            font-size:10pt;
        }

        #footer
        {
            width:180mm;
            margin:0 15mm;
            padding-bottom:3mm;
        }
        #footer table
        {
            width:100%;
            background:#eee;

        }
        #footer table td
        {
            width:25%;
            text-align:center;
            font-size:9pt;
        }


        @page
        {
        
             margin-left: 1.4cm;
             margin-right: 1.4cm;
        
            header: html_myHTMLHeader1;
            footer: html_myFooter1;
        }

        .customer {
           font-family: 'Helvetica Neue', Helvetica, Arial, sans-serif;
           font-weight: 400;
        }

        #table_info td {
           font-size: 12px;
           padding:0;

        }

    </style>


<htmlpageheader name='myHTMLHeader1'>
  <table class='heading' >
  <tr>
  <td valign='top' style='width:30%'>
      <img style='display:block;max-width: 200px;' src='//" . HTML_PATH . "/cop/media/pdfimage/logo.png'/>
  </td>
  <td  valign='top' style='width:40%' align='center'>
     <p style='display:block;font-weight:bold; font-size:20px; width:100%'>Order<br>Pick List</p>
  </td>
  <td valign='top' style='width:30%' align='right'>
     <h1 class='heading' style='display:block;padding-top:2px;padding-bottom:2px;'>$line1</h1>
                <h2 class='heading'>
                    $line2<br/>
                    $line3
                    
                </h2>
  </td>
   </tr>
  </table>

</htmlpageheader>

<table id='table_info' style='width:100%;margin-top:0;padding-top:0;'>
        <tr>
             <td rowspan='2' valign='top' align='left' style='width:33%'>
                <h4>Order Details</h4>
                <table>
                    <tr><td>Order No: </td><td>$orderCode</td></tr>
                    <tr><td>Order Date: </td><td>$displayDate</td></tr>
                    <tr><td>Delivery Date: </td><td>$deliveryDate</td></tr>
                    <tr><td >Salesperson Code: </td><td>$salespersonDisplayName</td></tr>
                </table>
            </td>
                     <td rowspan='1' valign='top' align='center' style='width:33%'>
                      <h4 >Customer Details</h4>
                <table>
                  <tr><td ><h3 style='font-weight: normal;'>$customerCode</h3></td></tr>
                    <tr><td style='text-align: center'><h3 style='font-weight: normal;'>$customerName</h3></td></tr>

                </table>
            </td>
             <td rowspan='1' valign='top' align='right' style='width:33%'>
              <h4 >Delivery Address</h4>
                <table>
                    <tr><td style='text-align: right'>$addressLine1D</td></tr>
                    <tr><td style='text-align: right'>$addressLine2D</td></tr>
                    <tr><td style='text-align: right'>$cityD</td></tr>
                    <tr><td style='text-align: right'>$landlineD</td></tr>
                </table>
            </td>

        </tr>

    </table>

   <div id='item_table' style='height:500px;'>

   <div style='height:500px;'>

     <table repeat_header='1' id='tableHeader' style='border-top: 1px solid #a7c6f9;border-bottom: 1px solid #a7c6f9;padding:0;background:#cadbf7;'>
            <tr>
                <td style='width:10%' ><b>No.</b></td>
                <td style='width:15%'><b>Code</b></td>
                <td style='width:30%'><b>Description</b></td>
                <td style='width:15%'><b>Barcode</b></td>
                <td style='width:10%;text-align:center;'><b>UOM</b></td>
                <td style='width:10%;text-align: center'><b>Quantity</b></td>
                <td style='width:10%;text-align: center'><b>Picked</b></td>
            </tr>
            </table>


            <table style='overflow:hidden;width:100%'>

            ";


    global $username, $password, $database;
    $db2 = new mysqli('localhost', $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db2->set_charset("utf8");


    $counter = 0;
    $stm = $db->prepare("SELECT Order_Item.item_id,Items.sales_units,qty,unit_price,Items.vat_id,Vats.vat_code,Order_Item.vat_amount,item_code,name,description FROM Order_Item,Items,Vats WHERE Vats.vat_id = Order_Item.vat_id AND Order_Item.item_id=Items.item_id AND Order_Item.order_id='$orderID'");
    $stm->execute();
    $stm->bind_result($itemID, $uom,$qty, $unitPrice, $vatID, $vatCode,$vatLineAmount,$itemCode, $name,$description);

    $unitPrice = number_format($unitPrice,2);

    while ($stm->fetch()) {
        $counter++;
        $lineTotal = $unitPrice * $qty;

        $unitPriceDisplay = number_format($unitPrice,2);
        $lineTotalDisplay = number_format($lineTotal,2);

        $barcode = getItemDefaultBarcodeForPDF($db2,$itemID);

        $result.= " <tr style='margin-top:4px;'>
                    <td style='width:10%;font-size:12px'><b>$counter</b></td >
                    <td style='width:15%;font-size:12px' > $itemCode  </td >
                    <td style='width:30%;font-size:12px'> $name </td >
                    <td style='width:15%;font-size:12px' > $barcode  </td >
                    <td style='width:10%;font-size:12px;text-align:center;'> $uom</td >
                    <td style='width:10%;font-size:12px;text-align:center;'> $qty</td >
                    <td style='width:10%;font-size:12px;text-align:center;'><div style='border: 1px solid black;height:auto;padding:5px;'>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</div></td >
                    </tr >";



        $result.= "<tr><td></td><td colspan='4' style='font-size:11px'>$description</td></tr>";





    }
    $stm->close();

    if(isset($details) && strcmp($details,"") != 0) {
        $result .=
            "  </table>
  
  <p style='font-size: 12px;'>Order Notes: $details </p>

        </div>";
    }
    else{
        $result .=
            "  </table> 

        </div>";
    }



    $result.=
        "




<htmlpagefooter name='myFooter1'>


        

        <div style='margin-top:30px;width:100%;'>
           <table style='width:100%;'>
               <tr>
                  <td style='width:25%;'>
                    <table style='width:100%;'>
                       <tr>
                       <td style='width:33%'>

                       </td>
                        <td style='width:33%'>
                           
                       </td>
                        <td style='width:33%'>

                       </td>
                       </tr>
                    </table>
                  </td>
                 <td style='width:50%;'>
                    <table style='width:100%;'>
                       <tr>
                       <td style='width:33%'>

                       </td>
                        <td style='border-top: 1px solid #000000;width:33%;text-align:center'>
                            <p style='font-size:11px;'>Picker Signature</p>
                       </td>
                        <td style='width:33%'>

                       </td>
                       </tr>
                    </table>
                  </td>
              </tr>
              <td style='width:25%;'>
                    <table style='width:100%;'>
                       <tr>
                       <td style='width:33%'>

                       </td>
                        <td style='width:33%'>
                           
                       </td>
                        <td style='width:33%'>

                       </td>
                       </tr>
                    </table>
                  </td>
           </table>

        </div>
        
        <div>
          <p style='margin:5px;font-size:10px;color:gray;font-family: Helvetica Neue, Helvetica, Arial, sans-serif'> Powered by Coprime Mobile Commerce: 25-311504<br><br> </p>
        </div>


            <table width='100%' style='vertical-align: bottom; font-family: Helvetica Neue, Helvetica, Arial, sans-serif; font-size: 8pt;
                color: #000000;  '><tr>
                <td width='33%'><span style=''>{DATE d-m-Y}</span></td>
                <td width='33%' align='center' style=''>{PAGENO} of {nbpg}</td>
                <td width='33%' style='text-align: right; '>$orderCode</td>
                </tr></table>
            </htmlpagefooter>



";


    return $result;
}


function getItemDefaultBarcodeForPDF($db2,$itemID){
    $barcodeCode = '';
    $stm2 =$db2->prepare("SELECT barcode FROM Item_Barcode WHERE item_id ='$itemID' ORDER BY default_barcode DESC,timestamp DESC LIMIT 1");
    $stm2-> execute();
    $stm2-> bind_result($barcodeCode);
    while ($stm2->fetch()) {}
    $stm2-> close();

    return $barcodeCode;
}

$orderID =$_POST['orderID'];
$orderCode =$_POST['orderCode'];
$result = getOrderPicklistPDFForPrinting($orderID);


$mpdf=new mPDF();

$mpdf->setAutoTopMargin='stretch';
$mpdf->setAutoBottomMargin='stretch';
$mpdf->keep_table_proportions=true;
$mpdf->DisplayDocTitle=true;
$mpdf->SetTitle("$orderCode Picklist PDF");
$mpdf->WriteHTML($result);
$mpdf->Output("$orderCode-Picklist.pdf","I");



?>