<?php

//********************MAPPING COMMANDS*************************
//  DISTINCT(int)
//  TEXT(text ; $int ; text ; $int )
//  CONCAT(int ; int)
//*************************************************************


class fileHelper
{

    private $inputFile;          // Name of the input file (eg. custom.txt)
    private $outputFile;         // Name of the output file (eg. export.txt)

    private $inputDirectory;     // Directory of input (eg. ./path/to/file/)
    private $outputDirectory;    // Directory of output (eg. ./path/to/file/)

    private $inputDelimiter;     // Delimiter of input file (eg. | or , )
    private $outputDelimiter;    // Delimiter of output file (eg. | or , )

    private $startingRow = 0;    // Start row of input file (eg. 0, 1, 2 ) IF 0 then from start.
    private $endingRow = 0;      // End row of input file (eg. 200, 5000, 100 ) IF 0 then until end.

    private $mapping;

    private $newLineDelimiter = "\n";


    function construct__(){

        require_once("../../../param.php");

        header('Content-Type: text/html; charset=UTF-8');
        mb_internal_encoding('UTF-8');
        mb_http_output('UTF-8');
        mb_http_input('UTF-8');
        mb_regex_encoding('UTF-8');

    }

//---------SET-----------

    function setInputDirectory($directory){
        $this->inputFile = basename($directory);
        $this->inputDirectory = dirname($directory)."/";
    }

    function setOutputDirectory($directory){
        $this->outputFile = basename($directory);
        $this->outputDirectory = dirname($directory)."/";
    }

    function setInputDelimiter($delimiter){
        $this->inputDelimiter = $delimiter;
    }

    function setOutputDelimiter($delimiter){
        $this->outputDelimiter = $delimiter;

    }

    function setNewLineDelimiter($delimiter){
        $this->newLineDelimiter = $delimiter;

    }

    function setStartRow($startingRow){
        $this->startingRow = $startingRow;

    }

    function setEndRow($endingRow){
        $this->endingRow = $endingRow;

    }

    function setMapping($mapping){
        $this->mapping = $mapping;

    }

//----------GET-----------

    function getMapping(){
        return $this->mapping;

    }

    function getStartRow(){
       return $this->startingRow;

    }

    function getEndRow(){
       return $this->endingRow;

    }

    function getInputFile(){
        return  $this->inputFile ;

    }

    function getInputDirectory(){
        return  $this->inputDirectory ;

    }

    function getOutputFile(){
        return  $this->outputFile ;

    }

    function getOutputDirectory(){
        return  $this->outputDirectory ;

    }

    function getInputDelimiter(){
       return $this->inputDelimiter;
    }

    function getOutputDelimiter(){
       return $this->outputDelimiter;

    }

//---------EXPORT---------

    function exportToFile()
    {
        echo "<table>";
        echo "<tr><td>Generating $this->outputFile </td>";
        $ColumnArray = $this->inputToArray("$this->mapping");
        $this->convert($this->inputFile, $this->outputFile, $this->inputDirectory, $this->outputDirectory, $this->inputDelimiter, $this->outputDelimiter, $this->startingRow, $this->endingRow, $ColumnArray);
    }

    function exportToHTML()
    {
        $inputFileDirectory = $this->inputDirectory.$this->inputFile;
        $ColumnArray = $this->inputToArray("$this->mapping");
        $txt_file = file_get_contents($inputFileDirectory);
        $rows = explode("\n", $txt_file);
        $records = 0;
        $prev = '';
        $unique = true;
        $distArray = array();
        $result = '<meta charset="UTF-8">';


        array_shift($rows);

        foreach ($rows as $row => $fields) {
            $row_data = explode($this->inputDelimiter, $fields);
            $data = array();

            if ($row >= $this->startingRow) {
                if ($row <= $this->endingRow || $this->endingRow == 0) {
                    foreach ($row_data as $field) {
                        array_push($data, $field);
                    }
                    $result .= ++$records . $this->outputDelimiter;

                    foreach ($ColumnArray as $col) {

                        if (strpos($col, 'CONCAT(') !== false) {

                            $col = ltrim($col, "CONCAT(");
                            $col = rtrim($col, ")");
                            $concat = explode(";", $col);

                            foreach ($concat as $concatCol) {

                                $result .= "$data[$concatCol] ";
                            }

                        } elseif (strpos($col, 'DISTINCT(') !== false) {
                            $col = ltrim($col, "DISTINCT(");
                            $col = rtrim($col, ")");


                            if (strcmp($prev, $data[$col]) != 0) {
                                $arrayMap = array_map(function ($piece) {
                                    return (string)$piece;
                                }, $distArray);
                                $prev = $data[$col];
                                if (!in_array($data[$col], $arrayMap)) {
                                    array_push($distArray, $data[$col]);
                                    $result .= $data[$col];
                                    $unique = true;
                                }
                            } else {
                                $unique = false;
                            }


                        } elseif (strpos($col, 'TEXT(') !== false) {
                            $col = ltrim($col, "TEXT(");
                            $col = rtrim($col, ")");

                            if (strpos($col, '.') !== false) {

                                $concat = explode(".", $col);

                                foreach ($concat as $concatCol) {
                                    if (strpos($concatCol, '$') !== false) {
                                        $concatCol = ltrim($concatCol, "$");
                                        $concatCol = rtrim($concatCol, "$");
                                        $result .= $data[$concatCol];
                                    } else {
                                        $result .= $concatCol;
                                    }
                                }
                            }
                        } else {
                            $result .= $data[$col];
                        }
                        if ($unique == true) {
                            $result .= $this->outputDelimiter;
                        }
                    }
                    if ($unique == true) {
                        $result .= "<br/>";

                    }
                }
            }
        }
        $result .= "<br/>Process Complete: $records records.<br/>";

        return $result;

    }

//-------FILE MANIPULATION--------

    function columnsToRows($columnInterval)
    {
        $newLineDelimiter = $this->newLineDelimiter;
        $directory = $this->inputDirectory.$this->inputFile;
        $ColumnArray = $this->inputToArray("$this->mapping");
        $txt_file = fopen("$directory", "r");
        $row = 0;
        $prev = '';
        $unique = true;
        $distArray = array();
        $counter = 0;
        $finalResult = '';


        while (!feof($txt_file)) {

            $fields = fgets($txt_file);
            $row_data = explode($this->inputDelimiter, $fields);
            $data = array();
            $result = '';
            $row++;


            if ($row >= $this->startingRow) {

                if ($row <= $this->endingRow || $this->endingRow == 0) {
                    foreach ($row_data as $field) {
                        array_push($data, $field);

                    }


                    foreach ($ColumnArray as $col) {

                        if (strpos($col, 'CONCAT(') !== false) {

                            $col = ltrim($col, "CONCAT(");
                            $col = rtrim($col, ")");
                            $concat = explode(";", $col);

                            foreach ($concat as $concatCol) {

                                $result .= "$data[$concatCol] ";
                            }

                        } elseif (strpos($col, 'DISTINCT(') !== false) {
                            $col = ltrim($col, "DISTINCT(");
                            $col = rtrim($col, ")");


                            if (strcmp($prev, $data[$col]) != 0) {
                                $arrayMap = array_map(function ($piece) {
                                    return (string)$piece;
                                }, $distArray);
                                $prev = $data[$col];
                                if (!in_array($data[$col], $arrayMap)) {
                                    array_push($distArray, $data[$col]);
                                    $result .= $data[$col];
                                    $unique = true;
                                }
                            } else {
                                $unique = false;
                            }


                        } elseif (strpos($col, 'TEXT(') !== false) {
                            $col = ltrim($col, "TEXT(");
                            $col = rtrim($col, ")");

                            if (strpos($col, '.') !== false) {

                                $concat = explode(".", $col);

                                foreach ($concat as $concatCol) {
                                    if (strpos($concatCol, '$') !== false) {
                                        $concatCol = ltrim($concatCol, "$");
                                        $concatCol = rtrim($concatCol, "$");
                                        $result .= $data[$concatCol];
                                    } else {
                                        $result .= $concatCol;
                                    }
                                }

                            }
                        } else {
                            $result .= $data[$col];
                        }
                        if ($counter >= $columnInterval) {

                            $result .= $newLineDelimiter;
                            $counter = 0;
                        }
                        if ($unique == true) {
                            $result .= $this->outputDelimiter;
                        }
                        $finalResult .= $result;
                    }
                    $counter++;
                }
            }
        }
        fclose($txt_file);


        return $finalResult;


    }

    function emptyFile($fileName){
        $file = fopen( $this->outputDirectory.$fileName, 'w' );
        fclose($file);
    }

    function removeOutputFile($fileName){
        unlink($this->outputDirectory.$fileName);
    }

    function appendToFile($fileName, $content){

        $filePointer = $this->outputDirectory.$fileName;

        if (file_exists($filePointer)) {
            $file = fopen( $this->outputDirectory.$fileName, 'a' );
        } else {
            $file = fopen( $this->outputDirectory.$fileName, 'w' );
        }

        fwrite($file, $content);
        fclose($file);
    }


//-------INNER FUNCTIONS-----------

    protected function convert($inputFile, $outputFile, $inputDirectory, $outputDirectory, $inputDelimiter, $outputDelimiter, $startingRow, $endingRow, $ColumnArray)
    {
        echo "<td> => </td>";
        $inputFileDirectory = $inputDirectory . $inputFile;
        $outputFileDirectory = $outputDirectory . $outputFile;

        $fileExt = substr($inputFile, ($pos = strpos($inputFile, '.')) === false ? 0 : $pos + 1);

        if (strcmp($fileExt, 'xlsx') == 0 || strcmp($fileExt, 'xls') == 0) {
            $this->XLSInput($inputFileDirectory, $startingRow, $endingRow, $ColumnArray, $outputDelimiter, $outputFileDirectory);
        } else {
            $this->TXTInput($inputFileDirectory, $startingRow, $endingRow, $ColumnArray, $inputDelimiter, $outputDelimiter, $outputFileDirectory);
        }
    }

    protected function XLSInput($inputFileDirectory, $startingRow, $endingRow, $ColumnArray, $outputDelimiter, $outputFileDirectory)
    {
        try {
            $file = fopen($outputFileDirectory, "w");
            if (!$file) throw new Exception('File could not be found', 404);
        } catch (Exception $e) {
            echo "Error : " . $e->getMessage();
        }
        try {
            require_once(ROOT."libs/phpexcel/vendor/autoload.php");
            require_once(ROOT."libs//platform/phpexcel/vendor/phpoffice/phpexcel/Classes/PHPExcel/IOFactory.php");

            $inputFileType = PHPExcel_IOFactory::identify($inputFileDirectory);
            $objReader = PHPExcel_IOFactory::createReader($inputFileType);
            //$objReader->setReadDataOnly(true);

            $objPHPExcel = $objReader->load($inputFileDirectory);
            $sheet = $objPHPExcel->getSheet(0);
            $highestRow = $sheet->getHighestRow();
            $highestColumn = $sheet->getHighestColumn();
            $colNumber = PHPExcel_Cell::columnIndexFromString($highestColumn);
            $records = 0;
            $prev = '';
            $unique = true;
            $distArray = array();
            if ($endingRow == 0) {
                $endingRow = $highestRow;
            }
        } catch ( Exception $e){
            echo "Error : " . $e->getMessage();
        }
//  Loop through each row of the worksheet in turn
        for ($row = $startingRow; $row <= $endingRow; $row++) {

            //  Read a row of data into an array
            $rowData = $sheet->rangeToArray('A' . $row . ':' . $highestColumn . $row, NULL, TRUE, FALSE);
            $position = 0;
            $temp = $startingRow;
            $data = array();

            foreach ($rowData[0] as $field) {
                if ($temp != $row) {
                    if ($unique == true) {
                        fwrite($file, "\n");
                        $records++;
                    }
                    $temp = $row;
                    $position = 0;
                    $data = array();
                }

                array_push($data, $field);

                if ($position == $colNumber - 1) {
                    foreach ($ColumnArray as $col) {

                        if (strpos($col, 'CONCAT(') !== false) {

                            $col = ltrim($col, "CONCAT(");
                            $col = rtrim($col, ")");
                            $concat = explode(";", $col);

                            foreach ($concat as $concatCol) {

                                fwrite($file, $data[$concatCol] . " ");
                            }

                        } elseif (strpos($col, 'DISTINCT(') !== false) {
                            $col = ltrim($col, "DISTINCT(");
                            $col = rtrim($col, ")");


                            if (strcmp($prev, $data[$col]) != 0) {
                                $arrayMap = array_map(function ($piece) {
                                    return (string)$piece;
                                }, $distArray);
                                $prev = $data[$col];
                                if (!in_array($data[$col], $arrayMap)) {
                                    array_push($distArray, $data[$col]);
                                    fwrite($file, $data[$col]);
                                    $unique = true;
                                }
                            } else {
                                $unique = false;
                            }

                        } elseif (strpos($col, 'TEXT(') !== false) {
                            $col = ltrim($col, "TEXT(");
                            $col = rtrim($col, ")");

                            if (strpos($col, ';') !== false) {

                                $concat = explode(";", $col);

                                foreach ($concat as $concatCol) {
                                    if (strpos($concatCol, '$') !== false) {
                                        $concatCol = ltrim($concatCol, "$");
                                        fwrite($file, $data[$concatCol]);
                                    } else {
                                        fwrite($file, $concatCol);
                                    }
                                }
                            }
                        } else {
                            fwrite($file, $data[$col]);
                        }
                        if ($unique == true) {
                            fwrite($file, $outputDelimiter);
                        }
                    }
                }
                $position++;
            }

        }
        fclose($file);
        echo "<td>Process Complete: $records records.<br/></td></tr>";
    }

    protected function TXTInput($inputFileDirectory, $startingRow, $endingRow, $ColumnArray, $inputDelimiter, $outputDelimiter, $outputFileDirectory)
    {
        try {
            $file = fopen($outputFileDirectory, "w");
            if (!$file) throw new Exception(': File could not be found. ', 404);
        } catch (Exception $e) {
            echo "error" . $e->getMessage();
        }
        $txt_file = file_get_contents($inputFileDirectory);
        $rows = explode($this->newLineDelimiter, $txt_file);
        $records = 0;
        $prev = '';
        $unique = true;
        $distArray = array();

        array_shift($rows);

        foreach ($rows as $row => $fields) {
            $row_data = explode($inputDelimiter, $fields);
            $data = array();

            if ($row >= $startingRow) {
                if ($row <= $endingRow || $endingRow == 0) {
                    foreach ($row_data as $field) {
                        array_push($data, $field);
                    }

                    foreach ($ColumnArray as $col) {

                        if (strpos($col, 'CONCAT(') !== false) {

                            $col = ltrim($col, "CONCAT(");
                            $col = rtrim($col, ")");
                            $concat = explode(";", $col);

                            foreach ($concat as $concatCol) {

                                fwrite($file, rtrim($data[$concatCol],'\n') . " ");
                            }

                        } elseif (strpos($col, 'DISTINCT(') !== false) {
                            $col = ltrim($col, "DISTINCT(");
                            $col = rtrim($col, ")");


                            if (strcmp($prev, $data[$col]) != 0) {
                                $arrayMap = array_map(function ($piece) {
                                    return (string)$piece;
                                }, $distArray);
                                $prev = $data[$col];
                                if (!in_array($data[$col], $arrayMap)) {
                                    array_push($distArray, $data[$col]);
                                    fwrite($file, rtrim($data[$col],'\n'));
                                    $unique = true;
                                }
                            } else {
                                $unique = false;
                            }


                        } elseif (strpos($col, 'TEXT(') !== false) {
                            $col = ltrim($col, "TEXT(");
                            $col = rtrim($col, ")");

                            if (strpos($col, '.') !== false) {

                                $concat = explode(".", $col);

                                foreach ($concat as $concatCol) {
                                    if (strpos($concatCol, '$') !== false) {
                                        $concatCol = ltrim($concatCol, "$");
                                        $concatCol = rtrim($concatCol, "$");
                                        fwrite($file, rtrim($data[$concatCol], '\n') );
                                    } else {
                                        fwrite($file, rtrim($concatCol, '\n'));
                                    }
                                }
                            }

                        } else {
                            fwrite($file, rtrim($data[$col], '\r\n'));
                        }

                        if ($unique == true ) {
                            

                                fwrite($file, $outputDelimiter);

                        }
                    }
                    if ($unique == true) {
                        fwrite($file, "\n");
                        $records++;
                    }
                }
            }
        }
        fclose($file);
        echo "<td>Process Complete: $records records processed.<br/></td></tr>";
    }

    protected function inputToArray($input)
    {

        $array = explode(",", $input);
        return $array;
    }

}
?>