<?php
class WarehouseTransaction{
    public $warehouseTransactionID;
    public $warehouseTransactionCode;
    public $warehouseIdFrom;
    public $warehouseIdTo;
    public $companyID;
    public $salespersonID;
    public $type;
    public $transactionDate;
    public $details;
    public $actionHash;
    public $actionTime;

    public $warehouseTransactionItems = array();

    public function __construct($warehouseTransactionID, $warehouseTransactionCode, $warehouseIdFrom, $warehouseIdTo, $companyID, $salespersonID, $type, $transactionDate, $details, $actionHash, $actionTime, $warehouseTransactionItems)
    {
        $this->warehouseTransactionID = $warehouseTransactionID;
        $this->warehouseTransactionCode = $warehouseTransactionCode;
        $this->warehouseIdFrom = $warehouseIdFrom;
        $this->warehouseIdTo = $warehouseIdTo;
        $this->companyID = $companyID;
        $this->salespersonID = $salespersonID;
        $this->type = $type;
        $this->transactionDate = $transactionDate;
        $this->details = $details;
        $this->actionHash = $actionHash;
        $this->actionTime = $actionTime;
        $this->warehouseTransactionItems = $warehouseTransactionItems;
    }

    /**
     * @return mixed
     */
    public function getWarehouseTransactionID()
    {
        return $this->warehouseTransactionID;
    }

    /**
     * @param mixed $warehouseTransactionID
     * @return WarehouseTransaction
     */
    public function setWarehouseTransactionID($warehouseTransactionID)
    {
        $this->warehouseTransactionID = $warehouseTransactionID;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getWarehouseTransactionCode()
    {
        return $this->warehouseTransactionCode;
    }

    /**
     * @param mixed $warehouseTransactionCode
     * @return WarehouseTransaction
     */
    public function setWarehouseTransactionCode($warehouseTransactionCode)
    {
        $this->warehouseTransactionCode = $warehouseTransactionCode;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getWarehouseIdFrom()
    {
        return $this->warehouseIdFrom;
    }

    /**
     * @param mixed $warehouseIdFrom
     * @return WarehouseTransaction
     */
    public function setWarehouseIdFrom($warehouseIdFrom)
    {
        $this->warehouseIdFrom = $warehouseIdFrom;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getWarehouseIdTo()
    {
        return $this->warehouseIdTo;
    }

    /**
     * @param mixed $warehouseIdTo
     * @return WarehouseTransaction
     */
    public function setWarehouseIdTo($warehouseIdTo)
    {
        $this->warehouseIdTo = $warehouseIdTo;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getCompanyID()
    {
        return $this->companyID;
    }

    /**
     * @param mixed $companyID
     * @return WarehouseTransaction
     */
    public function setCompanyID($companyID)
    {
        $this->companyID = $companyID;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getSalespersonID()
    {
        return $this->salespersonID;
    }

    /**
     * @param mixed $salespersonID
     * @return WarehouseTransaction
     */
    public function setSalespersonID($salespersonID)
    {
        $this->salespersonID = $salespersonID;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * @param mixed $type
     * @return WarehouseTransaction
     */
    public function setType($type)
    {
        $this->type = $type;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getTransactionDate()
    {
        return $this->transactionDate;
    }

    /**
     * @param mixed $transactionDate
     * @return WarehouseTransaction
     */
    public function setTransactionDate($transactionDate)
    {
        $this->transactionDate = $transactionDate;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getDetails()
    {
        return $this->details;
    }

    /**
     * @param mixed $details
     * @return WarehouseTransaction
     */
    public function setDetails($details)
    {
        $this->details = $details;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getActionHash()
    {
        return $this->actionHash;
    }

    /**
     * @param mixed $actionHash
     * @return WarehouseTransaction
     */
    public function setActionHash($actionHash)
    {
        $this->actionHash = $actionHash;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getActionTime()
    {
        return $this->actionTime;
    }

    /**
     * @param mixed $actionTime
     * @return WarehouseTransaction
     */
    public function setActionTime($actionTime)
    {
        $this->actionTime = $actionTime;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getWarehouseTransactionItems()
    {
        return $this->warehouseTransactionItems;
    }

    /**
     * @param mixed $warehouseTransactionItems
     * @return WarehouseTransaction
     */
    public function setWarehouseTransactionItems($warehouseTransactionItems)
    {
        $this->warehouseTransactionItems = $warehouseTransactionItems;
        return $this;
    }

    public function addWarehouseTransactionItem($warehouseTransactionItem)
    {
        array_push($this->warehouseTransactionItems,$warehouseTransactionItem);
        return $this;
    }




}
