<?php
class CustomForm
{
    private $linkedTable;
    private $linkedTableID;

    function __construct($linkedTable,$linkedTableID)
    {
        $this->linkedTable = $linkedTable;
        $this->linkedTableID = $linkedTableID;
	}

	function getFormCode(){
        global $username,$password,$database;
        $db= new mysqli(localhost,$username,$password,$database);
        if (mysqli_connect_errno())
        {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $stm = $db->prepare("SELECT custom_form_id,custom_form_code,custom_form_name FROM  ZA_Custom_Form_Definition,ZA_Custom_Form_Usage WHERE ZA_Custom_Form_Definition.custom_form_definition_id=ZA_Custom_Form_Usage.custom_form_id  AND linked_table='$this->linkedTable'");
        $stm->execute();
        $stm->bind_result($customFormID,$customFormCode,$customFormName);
        while ($stm->fetch()) {}
        $stm->close();

        return $customFormCode;
    }

    function getFormCodes(){
        global $username,$password,$database;
        $db= new mysqli(localhost,$username,$password,$database);
        if (mysqli_connect_errno())
        {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $codes = array();
        $stm = $db->prepare("SELECT custom_form_id,custom_form_code,custom_form_name FROM  ZA_Custom_Form_Definition,ZA_Custom_Form_Usage WHERE ZA_Custom_Form_Definition.custom_form_definition_id=ZA_Custom_Form_Usage.custom_form_id  AND linked_table='$this->linkedTable'");
        $stm->execute();
        $stm->bind_result($customFormID,$customFormCode,$customFormName);
        while ($stm->fetch()) {
            array_push($codes,$customFormCode);
        }
        $stm->close();

        return $codes;
    }

    function editCustomFormValues(){
        echo $this->createForm(true,false);
    }

    function addCustomFormValues(){
        echo $this->createForm(false,false);
    }

    function disabledCustomFormValues(){
        echo $this->createForm(true,true);
    }

    function viewCustomFormValues(){
        echo $this->createForm(true,true,true);
    }

    function copyCustomFormValues($to_ID){

        global $username,$password,$database;
        $db= new mysqli(localhost,$username,$password,$database);
        if (mysqli_connect_errno())
        {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $db->set_charset("utf8");
        $stm = $db->prepare("SELECT custom_form_id,custom_form_code,custom_form_name FROM  ZA_Custom_Form_Definition,ZA_Custom_Form_Usage WHERE ZA_Custom_Form_Definition.custom_form_definition_id=ZA_Custom_Form_Usage.custom_form_id  AND linked_table='$this->linkedTable'");
        $stm->execute();
        $stm->bind_result($customFormID,$customFormCode,$customFormName);
        while ($stm->fetch()) {

            $db2= new mysqli(localhost,$username,$password,$database);
            if (mysqli_connect_errno())
            {
                printf("Connect failed: %s\n", mysqli_connect_error());
                exit();
            }

            $customFormObjectID = getNextKey("ZA_Custom_Form_Object", "custom_form_object_id");
            $stmt2 = $db2->prepare("INSERT INTO ZA_Custom_Form_Object (custom_form_object_id,custom_form_id,custom_form_code,linked_table_id,timestamp) VALUES(?,?,?,?,NOW())");
            $stmt2->bind_param('iisi', $customFormObjectID, $customFormID, $customFormCode, $to_ID);
            $stmt2->execute();
            $stmt2->close();

            $db2->set_charset("utf8");
            $stm3 = $db2->prepare("SELECT ZA_Custom_Field_Definition.custom_field_id,custom_field_name,type,values_range,css_style,position,required,editable,class FROM  ZA_Custom_Field_Definition,ZA_Custom_Form_Custom_Field WHERE ZA_Custom_Field_Definition.custom_field_id=ZA_Custom_Form_Custom_Field.custom_field_id  AND ZA_Custom_Form_Custom_Field.custom_form_id='$customFormID' ORDER BY position");
            $stm3->execute();
            $stm3->bind_result($customFieldID, $customFieldName, $type, $valuesRange, $cssStyle, $position, $required, $editable, $class);
            while ($stm3->fetch()) {

                $value = $this->getLastValueOfCustomForm($customFormID, $customFieldID, $this->linkedTable, $this->linkedTableID);

                if(strcmp($value,'')!=0) {
                    $db3 = new mysqli(localhost, $username, $password, $database);
                    if (mysqli_connect_errno()) {
                        printf("Connect failed: %s\n", mysqli_connect_error());
                        exit();
                    }
                    $customFieldObjectID = getNextKey("ZA_Custom_Field_Object", "custom_field_object_id");
                    $db3->set_charset("utf8");
                    $stmt3 = $db3->prepare("INSERT INTO ZA_Custom_Field_Object (custom_field_object_id,custom_field_id,custom_form_object_id,value,timestamp) VALUES(?,?,?,?,NOW())");
                    $stmt3->bind_param('iiis', $customFieldObjectID, $customFieldID, $customFormObjectID, $value);
                    $stmt3->execute();
                    $stmt3->close();
                }
            }
            $stm3->close();
        }
        $stm->close();
    }

    function exportCustomForm(){
        global $username,$password,$database;
        $db= new mysqli(localhost,$username,$password,$database);
        if (mysqli_connect_errno())
        {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $stm = $db->prepare("SELECT line1,line2,line3,line4,line5,line6,line7 FROM Companies LIMIT 1");
        $stm->execute();
        $stm->bind_result($line1, $line2, $line3, $line4, $line5, $line6, $line7);
        while ($stm->fetch()) {}
        $stm->close();

        $table = rtrim(strtolower($this->linkedTable),'s');
        $tableCode = $table."_code";
        $tableId   = $table."_id";
        $stm = $db->prepare("SELECT $tableCode FROM $this->linkedTable WHERE $tableId=$this->linkedTableID");
        $stm->execute();
        $stm->bind_result($actionCode);
        while ($stm->fetch()) {}
        $stm->close();

        $result= "<style>
    
    
            body
            {
               font-family: Helvetica Neue, Helvetica, Arial, sans-serif;
    
            }
    
            p
            {
    
            }
    
            #wrapper
            {
                width:180mm;
                margin:0 15mm;
            }
    
            .page
            {
                height:297mm;
                width:210mm;
    
                page-break-after:always;
            }
            
            .custom-form{
                border-left: 1px solid #ddd;
                border-top: 1px solid #ddd;
    
                border-spacing:0;
                border-collapse: collapse;
            }
    
            table.bordered
            {
                border-left: 1px solid #ddd;
                border-top: 1px solid #ddd;
    
                border-spacing:0;
                border-collapse: collapse;
    
            }
    
            table.bordered td
            {
                border-right: 1px solid #ddd;
                border-bottom: 1px solid #ddd;
                padding: 2mm;
            }
    
            table.heading
            {
    
            }
    
            h1.heading
            {
                font-size:14pt;
                color:#000;
                font-weight:normal;
            }
    
            h2.heading
            {
                font-size:9pt;
                color:#000;
                font-weight:normal;
            }
    
            hr
            {
                color:#ccc;
                background:#ccc;
            }
    
            #invoice_body
            {
    
            }
    
            td {
              font-family: Helvetica Neue, Helvetica, Arial, sans-serif;
            }
    
            #invoice_body , #invoice_total, #tableHeader
            {
                width:100%;
            }
            #invoice_body table , #tableHeader table
            {
                width:100%;
                border-left: 1px solid #ccc;
                border-top: 1px solid #ccc;
            }
    
            #invoice_total table {
              width:100%;
            }
    
            #invoice_body table td , #tableHeader table td
            {
                text-align:center;
                font-size: 11px;
                border-right: 1px solid #ccc;
                border-bottom: 1px solid #ccc;
                padding:2mm 0;
            }
    
            #invoice_body table td.mono  , #invoice_total table td.mono, #tableHeader table td.mono
            {
                font-family: Helvetica Neue, Helvetica, Arial, sans-serif;
                text-align:right;
                padding-right:3mm;
                font-size:10pt;
            }
    
            #footer
            {
                width:180mm;
                margin:0 15mm;
                padding-bottom:3mm;
            }
            #footer table
            {
                width:100%;
                background:#eee;
    
            }
            #footer table td
            {
                width:25%;
                text-align:center;
                font-size:9pt;
            }
    
    
            @page
            {
            
                 margin-left: 1.4cm;
                 margin-right: 1.4cm;
            
                header: html_myHTMLHeader1;
                footer: html_myFooter1;
            }
    
            .customer {
               font-family: 'Helvetica Neue', Helvetica, Arial, sans-serif;
               font-weight: 400;
            }
    
            #table_info td {
               font-size: 12px;
               padding:0;
    
            }
    
        </style>
    
    
    <htmlpageheader name='myHTMLHeader1'>
      <table class='heading' >
      <tr>
      <td valign='top' style='width:30%'>
          <img style='display:block;max-width: 200px;' src='//" . HTML_PATH . "/cop/media/pdfimage/logo.png'/>
      </td>
      <td  valign='top' style='width:40%' align='center'>
         <p style='display:block;font-weight:bold; font-size:24px; width:100%'></p>
      </td>
      <td valign='top' style='width:30%' align='right'>
         <h1 class='heading' style='display:block;padding-top:2px;padding-bottom:2px;'>$line1</h1>
                    <h2 class='heading'>
                        $line2<br/>
                        $line3<br/>
                        $line4<br/>

                    </h2>
      </td>
       </tr>
      </table>
    
    </htmlpageheader>";

        $result.= $this->returnForm(true,true,true);

        $result.="<htmlpagefooter name='myFooter1'>
                    <table width='100%' style='vertical-align: bottom; font-family: Helvetica Neue, Helvetica, Arial, sans-serif; font-size: 8pt;
                    color: #000000;  '><tr>
                    <td width='33%'><span style=''>{DATE d-m-Y}</span></td>
                    <td width='33%' align='center' style=''>{PAGENO} of {nbpg}</td>
                    <td width='33%' style='text-align: right; '>Powered by Coprime Mobile Commerce: 25-311504</td>
                    </tr></table>
                </htmlpagefooter>";

        return $result;
    }

    function declareJsonVariables(){
        global $username, $password, $database;
        $db2 = new mysqli(localhost, $username, $password, $database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $db2->set_charset("utf8");

        $stm2 = $db2->prepare("SELECT custom_form_id,custom_form_code,custom_form_name FROM  ZA_Custom_Form_Definition,ZA_Custom_Form_Usage WHERE ZA_Custom_Form_Definition.custom_form_definition_id=ZA_Custom_Form_Usage.custom_form_id  AND linked_table='$this->linkedTable'");
        $stm2->execute();
        $stm2->bind_result($customFormID, $customFormCode, $customFormName);
        while ($stm2->fetch()) {
        echo "var $customFormCode = $('#$customFormCode').tableToJSON(
               {
                ignoreHiddenRows: false,
               	ignoreColumns: [0],
				textExtractor : {
						0 : function(cellIndex, cell) {
							return cell.find('input').val();
						},
						1 : function(cellIndex, cell) {
							return cell.find('input').val();
						},
						2 : function(cellIndex, cell) {
						    var valueTXT='';
						    var valueSLCT='';
						    var valueCHK='';
						    var valueTXTAREA='';
						    if(cell.find('input').val() != null){
						        if(cell.find('input').is(':checkbox')){
						            if(cell.find('input').prop('checked')){
						                valueTXT = 'yes';
						            } else {
						                valueTXT = 'no';
						            }
						        } else {
						            valueTXT = cell.find('input').val();
						        }
						    }
						    if(cell.find('select').val() != null){
						        valueSLCT = cell.find('select').val();
						    } 
						    if(cell.find('textarea').val() != null){
						        valueTXTAREA = cell.find('textarea').val();
						    }
						    var value = valueTXT+valueSLCT+valueTXTAREA;
							return value;
						}
                  }
               }
			  );
               ";
        }
        $stm2->close();
    }

    function passJsonVariables(){
        global $username, $password, $database;
        $db2 = new mysqli(localhost, $username, $password, $database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $db2->set_charset("utf8");

        $stm2 = $db2->prepare("SELECT custom_form_id,custom_form_code,custom_form_name FROM  ZA_Custom_Form_Definition,ZA_Custom_Form_Usage WHERE ZA_Custom_Form_Definition.custom_form_definition_id=ZA_Custom_Form_Usage.custom_form_id  AND linked_table='$this->linkedTable'");
        $stm2->execute();
        $stm2->bind_result($customFormID, $customFormCode, $customFormName);
        while ($stm2->fetch()) {
            echo ",";
            echo "'$customFormCode':$customFormCode";

        }
        $stm2->close();
    }

    function insertVariablesToCustomForm($post, $code=''){
    include_once (ROOT.'concc/dbhelpers/dbhelper.php');

        if(strcmp($code,'')!=0){$where = "AND custom_form_code='$code'" ;}else{$where='';}

        global $username,$password,$database;
        $db= new mysqli(localhost,$username,$password,$database);
        if (mysqli_connect_errno())
        {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }

        $stm = $db->prepare("SELECT custom_form_id,custom_form_code,custom_form_name FROM  ZA_Custom_Form_Definition,ZA_Custom_Form_Usage WHERE ZA_Custom_Form_Definition.custom_form_definition_id=ZA_Custom_Form_Usage.custom_form_id  AND linked_table='$this->linkedTable' $where");
        $stm->execute();
        $stm->bind_result($customFormID,$customFormCode,$customFormName);
        while ($stm->fetch()) {
            $db2= new mysqli(localhost,$username,$password,$database);
            if (mysqli_connect_errno())
            {
                printf("Connect failed: %s\n", mysqli_connect_error());
                exit();
            }
            $db2->set_charset("utf8");
            $stm5 = $db2->prepare("SELECT custom_form_object_id FROM  ZA_Custom_Form_Object,ZA_Custom_Form_Usage WHERE ZA_Custom_Form_Object.custom_form_id=ZA_Custom_Form_Usage.custom_form_id  AND linked_table='$this->linkedTable' AND linked_table_id='$this->linkedTableID' AND ZA_Custom_Form_Object.custom_form_id='$customFormID' ");
            $stm5->execute();
            $stm5->bind_result($customFormObjectID);
            while ($stm5->fetch())
            {
                $db3= new mysqli(localhost,$username,$password,$database);
                if (mysqli_connect_errno())
                {
                    printf("Connect failed: %s\n", mysqli_connect_error());
                    exit();
                }
                $db3->set_charset("utf8");

                $stmt5 = $db3->prepare("DELETE FROM ZA_Custom_Form_Object WHERE custom_form_object_id=?");
                $stmt5->bind_param('i',$customFormObjectID);
                $stmt5->execute();
                $stmt5->close();

                $deleteID = getNextKey("Deletes", "delete_id");
                $statement ="DELETE FROM ZA_Custom_Form_Object WHERE custom_form_object_id=$customFormObjectID";
                $stmt2 = $db3->prepare("INSERT INTO Deletes (delete_id,statement,timestamp) VALUES(?,?,NOW())");
                $stmt2->bind_param('is',$deleteID,$statement);
                $stmt2->execute();
                $stmt2->close();

                $stmt5 = $db3->prepare("DELETE FROM  ZA_Custom_Field_Object WHERE custom_form_object_id=?");
                $stmt5->bind_param('i',$customFormObjectID);
                $stmt5->execute();
                $stmt5->close();

                $deleteID = getNextKey("Deletes", "delete_id");
                $statement ="DELETE FROM  ZA_Custom_Field_Object WHERE custom_form_object_id=$customFormObjectID";
                $stmt2 = $db3->prepare("INSERT INTO Deletes (delete_id,statement,timestamp) VALUES(?,?,NOW())");
                $stmt2->bind_param('is',$deleteID,$statement);
                $stmt2->execute();
                $stmt2->close();
            }
            $stm5->close();

            $customFormObjectID = getNextKey("ZA_Custom_Form_Object","custom_form_object_id");
            $stmt2 = $db2->prepare("INSERT INTO ZA_Custom_Form_Object (custom_form_object_id,custom_form_id,custom_form_code,linked_table_id,timestamp) VALUES(?,?,?,?,NOW())");
            $stmt2->bind_param('iisi',$customFormObjectID,$customFormID,$customFormCode,$this->linkedTableID);
            $stmt2->execute();

            $stmt2->close();

            $customFormFields =array();

            $customFormFields = $post;


            foreach($customFormFields AS $field)
            {
                $customFieldID = $field['id'];
                $customFieldValue= $field['avalue'];

                    $db3 = new mysqli(localhost, $username, $password, $database);
                    if (mysqli_connect_errno()) {
                        printf("Connect failed: %s\n", mysqli_connect_error());
                        exit();
                    }

                    $customFieldObjectID = getNextKey("ZA_Custom_Field_Object", "custom_field_object_id");

                    $db3->set_charset("utf8");
                    $stmt3 = $db3->prepare("INSERT INTO ZA_Custom_Field_Object (custom_field_object_id,custom_field_id,custom_form_object_id,value,timestamp) VALUES(?,?,?,?,NOW())");
                    $stmt3->bind_param('iiis', $customFieldObjectID, $customFieldID, $customFormObjectID, $customFieldValue);
                    $stmt3->execute();
                    $stmt3->close();
                
            }
        }
        $stm->close();
    }

    public function getCustomUOM(){
        $uomID = 0;
        global $username, $password, $database;
        $db2 = new mysqli(localhost, $username, $password, $database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $db2->set_charset("utf8");
        $stm2 = $db2->prepare("SELECT ZA_Custom_Form_Usage.custom_form_id,ZA_Custom_Field_Definition.custom_field_id FROM ZA_Custom_Field_Definition,ZA_Custom_Form_Custom_Field,ZA_Custom_Form_Usage WHERE ZA_Custom_Field_Definition.custom_field_id=ZA_Custom_Form_Custom_Field.custom_field_id AND ZA_Custom_Form_Custom_Field.custom_form_id=ZA_Custom_Form_Usage.custom_form_id AND ZA_Custom_Form_Usage.linked_table='$this->linkedTable' AND (ZA_Custom_Field_Definition.custom_field_name LIKE 'selected uom' OR ZA_Custom_Field_Definition.custom_field_name LIKE 'selected uom id') ");
        $stm2->execute();
        $stm2->bind_result($customFormID,$customFieldID);
        while ($stm2->fetch()) {
                $value = $this->getLastValueOfCustomForm($customFormID,$customFieldID,$this->linkedTable,$this->linkedTableID);
                if(strcmp("$value","")!=0){
                    $uomID = $value;
                }
        }
        $stm2->close();

        return $uomID;

    }

    public function insertCustomUOM($customFieldValue,$db2){

        $customForms = array();
        $stm2 = $db2->prepare("SELECT ZA_Custom_Form_Usage.custom_form_id,ZA_Custom_Field_Definition.custom_field_id FROM ZA_Custom_Field_Definition,ZA_Custom_Form_Custom_Field,ZA_Custom_Form_Usage WHERE ZA_Custom_Field_Definition.custom_field_id=ZA_Custom_Form_Custom_Field.custom_field_id AND ZA_Custom_Form_Custom_Field.custom_form_id=ZA_Custom_Form_Usage.custom_form_id AND ZA_Custom_Form_Usage.linked_table='$this->linkedTable' AND ZA_Custom_Field_Definition.custom_field_name LIKE '%selected uom%'");
        $stm2->execute();
        $stm2->bind_result($customFormID,$customFieldID);
        while ($stm2->fetch()) {
            $form = new stdClass();
            $form->customFormID = $customFormID;
            $form->customFieldID = $customFieldID;
            $form->customFormObjectID = 0;
            array_push($customForms, $form);
        }
        $stm2->close();

        foreach($customForms AS $form) {
            $stm3 = $db2->prepare("SELECT custom_form_object_id FROM  ZA_Custom_Form_Object,ZA_Custom_Form_Usage WHERE ZA_Custom_Form_Object.custom_form_id=ZA_Custom_Form_Usage.custom_form_id  AND linked_table='$this->linkedTable' AND linked_table_id='$this->linkedTableID' AND ZA_Custom_Form_Object.custom_form_id='$customFormID' ");
            $stm3->execute();
            $stm3->bind_result($customFormObjectID);
            while ($stm3->fetch()) {
                $form->customFormObjectID = $customFormObjectID;
            }
            $stm3->close();
        }

        $deletedForms = array();
        foreach($customForms AS $form) {

            if(!in_array($form->customFormID, $deletedForms)) {

                array_push($deletedForms, $form->customFormID);

                $stm2 = $db2->prepare("DELETE FROM ZA_Custom_Form_Object WHERE custom_form_object_id=?");
                $stm2->bind_param('i', $form->customFormObjectID);
                $stm2->execute();
                $stm2->close();

                $deleteID = getNextKeySingleTransaction("Deletes", "delete_id",$db2);
                $statement = "DELETE FROM ZA_Custom_Form_Object WHERE custom_form_object_id=$form->customFormObjectID";
                $stm2 = $db2->prepare("INSERT INTO Deletes (delete_id,statement,timestamp) VALUES(?,?,NOW())");
                $stm2->bind_param('is', $deleteID, $statement);
                $stm2->execute();
                $stm2->close();

                $stm2 = $db2->prepare("DELETE FROM  ZA_Custom_Field_Object WHERE custom_form_object_id=?");
                $stm2->bind_param('i', $form->customFormObjectID);
                $stm2->execute();
                $stm2->close();

                $deleteID = getNextKeySingleTransaction("Deletes", "delete_id",$db2);
                $statement = "DELETE FROM  ZA_Custom_Field_Object WHERE custom_form_object_id=$form->customFormObjectID";
                $stm2 = $db2->prepare("INSERT INTO Deletes (delete_id,statement,timestamp) VALUES(?,?,NOW())");
                $stm2->bind_param('is', $deleteID, $statement);
                $stm2->execute();
                $stm2->close();
            }

            $stm2 = $db2->prepare("SELECT custom_form_code FROM ZA_Custom_Form_Definition WHERE custom_form_definition_id='$form->customFormID' LIMIT 1");
            $stm2->execute();
            $stm2->bind_result($customFormCode);
            while ($stm2->fetch()) {}
            $stm2->close();

            $customFormCode = "$customFormCode";
            $customFormObjectID = getNextKeySingleTransaction("ZA_Custom_Form_Object", "custom_form_object_id",$db2);
            $stm2 = $db2->prepare("INSERT INTO ZA_Custom_Form_Object (custom_form_object_id,custom_form_id,custom_form_code,linked_table_id,timestamp) VALUES(?,?,?,?,NOW())");
            $stm2->bind_param('iisi', $customFormObjectID, $form->customFormID, $customFormCode, $this->linkedTableID);
            $stm2->execute();
            $stm2->close();

            $customFieldObjectID = getNextKeySingleTransaction("ZA_Custom_Field_Object", "custom_field_object_id",$db2);
            $stm2 = $db2->prepare("INSERT INTO ZA_Custom_Field_Object (custom_field_object_id,custom_field_id,custom_form_object_id,value,timestamp) VALUES(?,?,?,?,NOW())");
            $stm2->bind_param('iiis', $customFieldObjectID, $form->customFieldID, $customFormObjectID, $customFieldValue);
            $stm2->execute();
            $stm2->close();

        }


    }

	private function createForm($edit,$disabled,$viewOnly=false){

        global $username, $password, $database;
        $db2 = new mysqli(localhost, $username, $password, $database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $emptyForms=true;
        $customForms = array();

        $stm2 = $db2->prepare("SELECT custom_form_id,custom_form_code,custom_form_name FROM  ZA_Custom_Form_Definition,ZA_Custom_Form_Usage WHERE ZA_Custom_Form_Definition.custom_form_definition_id=ZA_Custom_Form_Usage.custom_form_id  AND linked_table='$this->linkedTable'");
        $stm2->execute();
        $stm2->bind_result($customFormID, $customFormCode, $customFormName);
        $counter = 0;
        $lis = '';
        $tabs = '';
        while ($stm2->fetch()) {
            $hasValues = $this->formHasValues($customFormID);
            if($hasValues)
            {
                if($emptyForms){$active = 'active';} else {$active= '';}
                $emptyForms=false;
                $lis .="<li id='liactivation$counter' class='$active'>";
                $lis .="<a data-toggle='tab' href='#s$counter' id='slink$counter'><i class='fa fa-arrow-circle-down' style='margin-right: 5px;color: #0a0a0a;'></i><span class='hidden-mobile hidden-tablet' style='color: #0a0a0a;'>$customFormName</span></a>
                                    </li>";



                if(strcmp($active,'')!=0)$active .= " in";
                $tabs .= "<div class='tab-pane fade $active ' id='s$counter'><br/><br/><br/>";
                $tabs .= "<form>";
                $tabs .= "<table class='custom-form' id='$customFormCode' style='width: 100%;'>";
                $tabs .= "<thead> <tr> <th style='display:none'  class='text-center'>label</th> <th style='display:none' class='text-center'>id</th> <th style='display:none'  class='text-center'>avalue</th></tr></thead>";
                $tabs .= "<tbody>";
                $db3 = new mysqli(localhost, $username, $password, $database);
                if (mysqli_connect_errno()) {
                    printf("Connect failed: %s\n", mysqli_connect_error());
                    exit();
                }
                $db3->set_charset("utf8");
                $stm3 = $db3->prepare("SELECT ZA_Custom_Field_Definition.custom_field_id,custom_field_name,type,values_range,css_style,position,required,editable,class FROM  ZA_Custom_Field_Definition,ZA_Custom_Form_Custom_Field WHERE ZA_Custom_Field_Definition.custom_field_id=ZA_Custom_Form_Custom_Field.custom_field_id  AND ZA_Custom_Form_Custom_Field.custom_form_id='$customFormID' ORDER BY position");
                $stm3->execute();
                $stm3->bind_result($customFieldID, $customFieldName, $type, $valuesRange, $cssStyle, $position, $required, $editable, $class);
                while ($stm3->fetch()) {

                    if(strcmp($editable,'no' )==0){$editable = false;} else {$editable = true;}
                    if(strcmp($required,'yes')==0){$required = true;} else {$required = false;}
                    if (strcmp($class, '') == 0) {$class = 'form-control';}
                    if($viewOnly){$type = 'label';}

                    $lastValue = "";
                    if ($edit) {
                        $lastValue = $this->getLastValueOfCustomForm($customFormID, $customFieldID, $this->linkedTable, $this->linkedTableID);
                    }

                    $input = $this->getInputType($type,$cssStyle,$class,$customFieldName,$lastValue,$valuesRange,$disabled,$editable,$required);

                    $tabs .= "<tr>";
                    $tabs .= "<td style='border-bottom: 0.5px solid lightgrey;border-right: 0.5px solid lightgrey;'><label style='color:#222'>$customFieldName</label></td>";
                    $tabs .= "<td style='display:none;border-bottom: 0.5px solid lightgrey;'><input id='$customFormID|$customFieldID' name='$customFormID|$customFieldID' value='$customFieldID' hidden></td>";
                    $tabs .= "<td class='form-control' style='margin-left:5px;border-bottom: 0.5px solid lightgrey;'>$input</td>";
                    $tabs .= "</tr>";
                }
                $stm3->close();
                $tabs .= "</tbody>";
                $tabs .= "</table>";
                $tabs .= "</form>";

            }
            else
            {
                if($disabled){$readOnly = "style='pointer-events:none;opacity:0.6;'";} else {$readOnly='';}
                $lis .= "<li id='liactivation$counter' class='' $readOnly>";
                $lis .= "<a data-toggle='tab' href='#s$counter' id='slink$counter' onclick='loadCustomFormFromClass(\"$customFormID\",\"$customFormCode\",\"$counter\",\"$this->linkedTable\",\"$this->linkedTableID\")'><i class='fa fa-arrow-circle-down' style='margin-right: 5px;color: #0a0a0a;'></i><span class='hidden-mobile hidden-tablet' style='color: #0a0a0a;'>$customFormName</span></a>
                                    </li>";
                $active = "";
                $tabs .= "<div class='tab-pane fade $active ' id='s$counter'><br/><br/><br/>";
            }


            $tabs .= "</div>";
            $counter++;
            array_push($customForms, $customFormCode);


        }
        $stm2->close();

        echo "<ul class=\"nav nav-tabs pull-left in\" id=\"myTab\">";
        echo $lis;
        echo "</ul>";
        echo "<div id=\"myTabContent\" class=\"tab-content\">";
        echo $tabs;
        echo "</div>";

        if($emptyForms){
            echo "<script>
                    $(document).ready(function() {
                    $('#liactivation0').addClass('active');
                    $('#s0').addClass('active in');
                    $('#slink0').click();
                    });
                    </script>";
        }

        if(!$viewOnly || !$hasValues) {
            echo "<script>
                function loadCustomFormFromClass(customFormIDPost,customFormCodePost,formID,linkedTablePost,linkedTableIDPost){
                    $.ajax({
                        type: 'POST',
                        url: '//" . HTML_PATH . "/cop/backend/core/model/CustomForm.php',
                        data: {
                            'customFormIDPost': customFormIDPost,
                            'customFormCodePost': customFormCodePost,
                            'linkedTablePost': linkedTablePost,
                            'linkedTableIDPost': linkedTableIDPost,
                            
                            },
                        success: function (result) { 
                            $('#s'+formID).html(result);
                            $('#slink'+formID).prop(\"onclick\", null).off(\"click\");
                        }
			        });
                            
                }
              </script>";
        }
    }

    private function returnForm($edit,$disabled,$viewOnly=false){
        $result = '';
        $customForms = array();
        global $username, $password, $database;
        $db2 = new mysqli(localhost, $username, $password, $database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $db2->set_charset("utf8");

        $stm2 = $db2->prepare("SELECT custom_form_id,custom_form_code,custom_form_name FROM  ZA_Custom_Form_Definition,ZA_Custom_Form_Usage WHERE ZA_Custom_Form_Definition.custom_form_definition_id=ZA_Custom_Form_Usage.custom_form_id  AND linked_table='$this->linkedTable'");
        $stm2->execute();
        $stm2->bind_result($customFormID, $customFormCode, $customFormName);
        while ($stm2->fetch()) {

            if($this->formHasValues($customFormID)) {
                $result .= "<label style='color:black;font-weight:bold'><h2 style='display: inline;margin-left:6px;vertical-align: middle;' align='center'><u>$customFormName</h2></label>";
                $result .= "<table style='width: 100%;border-spacing: 0px;border-color: #0a0a0a;'>";
                $result .= "<thead>
                                <tr>
                                    <th style='border: 1px solid black;width: 5%' class='text-center'><b>A/A</th> 
                                    <th style='border: 1px solid black;width: 50%' class='text-center'><b>FIELD</th> 
                                    <th style='border: 1px solid black;' class='text-center'><b>VALUE</th>
                                </tr>
                            </thead>";
                $result .= "<tbody>";
                $db3 = new mysqli(localhost, $username, $password, $database);
                if (mysqli_connect_errno()) {
                    printf("Connect failed: %s\n", mysqli_connect_error());
                    exit();
                }
                $db3->set_charset("utf8");
                $stm3 = $db3->prepare("SELECT ZA_Custom_Field_Definition.custom_field_id,custom_field_name,type,values_range,css_style,position,required,editable,class FROM  ZA_Custom_Field_Definition,ZA_Custom_Form_Custom_Field WHERE ZA_Custom_Field_Definition.custom_field_id=ZA_Custom_Form_Custom_Field.custom_field_id  AND ZA_Custom_Form_Custom_Field.custom_form_id='$customFormID' ORDER BY position");
                $stm3->execute();
                $stm3->bind_result($customFieldID, $customFieldName, $type, $valuesRange, $cssStyle, $position, $required, $editable, $class);
                $counter = 0;
                while ($stm3->fetch()) {
                    $counter++;
                    if (strcmp($editable, 'no') == 0) {
                        $editable = false;
                    } else {
                        $editable = true;
                    }
                    if (strcmp($required, 'yes') == 0) {
                        $required = true;
                    } else {
                        $required = false;
                    }
                    if (strcmp($class, '') == 0) {
                        $class = 'form-control';
                    }
                    if ($viewOnly) {
                        $type = 'label';
                    }

                    $lastValue = "";
                    if ($edit) {
                        $lastValue = $this->getLastValueOfCustomForm($customFormID, $customFieldID, $this->linkedTable, $this->linkedTableID);
                    }

                    $input = $this->getInputType($type, $cssStyle, $class, $customFieldName, $lastValue, $valuesRange, $disabled, $editable, $required);

                    $result .= "<tr>";
                    $result .= "<td style='border: 1px solid black;padding: 3px;width: 5%' align='center'><label style='color:#222;'>$counter</label></td>";
                    $result .= "<td style='border: 1px solid black;padding: 3px;'><label style='color:#222;'>$customFieldName</label></td>";
                    $result .= "<td class='form-control' style='border: 1px solid black;padding: 3px;margin-left:5px;' align='center'>$input</td>";
                    $result .= "</tr>";
                }
                $stm3->close();


                $result .= "</tbody>";
                $result .= "</table>";

                array_push($customForms, $customFormCode);
            }

        }
        $stm2->close();

        return $result;
    }

    private function getLastValueOfCustomForm($customFormID,$customFieldID,$tableName,$tableID)
    {
        global $username, $password, $database;
        $db = new mysqli(localhost, $username, $password, $database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $db->set_charset("utf8");
        $value="";
        $stm = $db->prepare("SELECT value FROM ZA_Custom_Field_Object,ZA_Custom_Form_Object,ZA_Custom_Form_Usage WHERE ZA_Custom_Form_Object.custom_form_id='$customFormID' AND ZA_Custom_Form_Object.custom_form_id =ZA_Custom_Form_Usage.custom_form_id AND ZA_Custom_Form_Usage.linked_table='$tableName' AND  ZA_Custom_Form_Object.linked_table_id='$tableID' AND ZA_Custom_Form_Object.custom_form_object_id=ZA_Custom_Field_Object.custom_form_object_id AND ZA_Custom_Field_Object.custom_field_id='$customFieldID' LIMIT 1");
        $stm-> execute();
        $stm-> bind_result($value);
        while ($stm->fetch()) {


        }
        $stm-> close();

        return $value;
    }

    private function getInputType($type,$cssStyle,$class,$customFieldName,$lastValue,$valuesRange,$disabled,$editable,$required){
        if($disabled || !$editable){$disable = 'disabled';}else{$disable = '';}
        if($required){$required = 'required';}else{$required = '';}

        switch ($type){
            case 'text':
                $input = "<input type='$type' style='$cssStyle' class='$class' id='$customFieldName' name='$customFieldName' value='$lastValue' $disable $required/>";
                break;
            case 'combobox':


                $input = "<select style='$cssStyle' class='$class' id='$customFieldName' name='$customFieldName' $disable>";

                $values = explode(';',$valuesRange);
                $optionCount=0;
                foreach ($values as $value){
                    if(strcmp($lastValue,$value)==0){
                        $input.= "<option value='$lastValue' selected>$lastValue</option>";
                    }else{
                        $input.= "<option value='$value'>$value</option>";
                    }
                    $optionCount++;
                }
                $input.= "</select>";
                break;
            case 'checkbox':
                if(strcmp($lastValue,'yes')==0){$checked = "checked";} else {$checked = '';}
                $input = "<input type='$type' style='$cssStyle' class='$class' id='$customFieldName' name='$customFieldName' value='yes' $checked $disable/>";
                break;
            case 'label':
                $input = "<label class='label'>$lastValue</label>";
                break;
            case 'textarea':
                $input = "<textarea type='$type' style='$cssStyle' class='$class' id='$customFieldName' name='$customFieldName' $disable $required>$lastValue</textarea>";
                break;
            case 'JSONArray':

                $valuesJson = str_replace('#quote#','"',$valuesRange);
                $values = json_decode($valuesJson);
                $optionCount=0;
                $input = "<select style='$cssStyle' class='$class' id='$customFieldName' name='$customFieldName' $disable>";
                $input.= "<option value=''></option>";
                foreach ($values as $value){

                    $value = json_encode($value);
                    $value = str_replace('"','#quote#',$value);

                    $lastValueArray = str_replace('#quote#','"',$lastValue);
                    $lastValueArray = json_decode($lastValueArray);
                    $lastValueDisplay = '';
                    $lastValueArrayDB = array();
                    $firstValueOption = true;
                    foreach ($lastValueArray as $key => $data){
                        array_push($lastValueArrayDB,"#quote#$key#quote#:#quote#$data#quote#");
                        if($firstValueOption) {
                            $lastValueDisplay .= "$key: $data";
                            $firstValueOption = false;
                        } else {
                            $lastValueDisplay .= "</option><option disabled style='font-style:italic' >&nbsp;&#9679;&nbsp;$key: $data";
                        }
                    }
                    $lastValueDB = "{".implode(',',$lastValueArrayDB)."}";

                    $valueArray = str_replace('#quote#','"',$value);
                    $valueArray = json_decode($valueArray);
                    $valueDisplay = '';
                    $valueArrayDB = array();
                    $firstValueOption = true;
                    foreach ($valueArray as $key => $data){
                        array_push($valueArrayDB,"#quote#$key#quote#:#quote#$data#quote#");
                        if($firstValueOption) {
                            $valueDisplay .= "$key: $data";
                            $firstValueOption = false;
                        } else {
                            $valueDisplay .= "</option><option disabled style='font-style:italic' >&nbsp;&#9679;&nbsp;$key: $data";
                        }
                    }
                    $valueDB = "{".implode(',',$valueArrayDB)."}";

                    if(strcmp($lastValueDB,$valueDB)==0){
                        $input.= "<option value='$lastValueDB' selected>$lastValueDisplay</option>";
                    }else{
                        $input.= "<option value='$valueDB'>$valueDisplay</option>";
                    }
                    $optionCount++;
                }
                $input.= "</select>";

                break;
            default:
                $input = "<input type='$type' style='$cssStyle' class='$class' id='$customFieldName' name='$customFieldName' value='$lastValue' $disable $required/>";
        }

    return $input;
    }

    private function formHasValues($customFormID){
        $Value = '';
        $result=false;
        global $username, $password, $database;
        $db3 = new mysqli(localhost, $username, $password, $database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }

        $db3->set_charset("utf8");
        $stm3 = $db3->prepare("SELECT ZA_Custom_Field_Definition.custom_field_id FROM  ZA_Custom_Field_Definition,ZA_Custom_Form_Custom_Field WHERE ZA_Custom_Field_Definition.custom_field_id=ZA_Custom_Form_Custom_Field.custom_field_id  AND ZA_Custom_Form_Custom_Field.custom_form_id='$customFormID' ORDER BY position");
        $stm3->execute();
        $stm3->bind_result($customFieldID);
        while ($stm3->fetch()) {
            $Value = $this->getLastValueOfCustomForm($customFormID, $customFieldID, $this->linkedTable, $this->linkedTableID);
            if(strcmp($Value,'')!=0){
                $result=true;
                return $result;

            }
        }

        return $result;
    }

}

if(isset($_POST['customFormIDPost']) && isset($_POST['customFormCodePost'])){
    include_once('../../../param.php');
    $customFormCode = $_POST['customFormCodePost'];
    $customFormID = $_POST['customFormIDPost'];
    $linkedTable = $_POST['linkedTablePost'];
    $linkedTableID = $_POST['linkedTableIDPost'];
    echo "<br/><br/><br/><form>";
    echo "<table class='custom-form' id='$customFormCode' style='width: 100%;'>";
    echo "<thead> <tr> <th style='display:none'  class='text-center'>label</th> <th style='display:none' class='text-center'>id</th> <th style='display:none'  class='text-center'>avalue</th></tr></thead>";
    echo "<tbody>";

    $db3 = new mysqli(localhost, $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db3->set_charset("utf8");
    $stm3 = $db3->prepare("SELECT ZA_Custom_Field_Definition.custom_field_id,custom_field_name,type,values_range,css_style,position,required,editable,class FROM  ZA_Custom_Field_Definition,ZA_Custom_Form_Custom_Field WHERE ZA_Custom_Field_Definition.custom_field_id=ZA_Custom_Form_Custom_Field.custom_field_id  AND ZA_Custom_Form_Custom_Field.custom_form_id='$customFormID' ORDER BY position");
    $stm3->execute();
    $stm3->bind_result($customFieldID, $customFieldName, $type, $valuesRange, $cssStyle, $position, $required, $editable, $class);
    while ($stm3->fetch()) {

        if(strcmp($editable,'no' )==0){$editable = false;} else {$editable = true;}
        if(strcmp($required,'yes')==0){$required = true;} else {$required = false;}
        if (strcmp($class, '') == 0) {$class = 'form-control';}

        global $username, $password, $database;
        $db = new mysqli(localhost, $username, $password, $database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }

        $lastValue = '';
//        $db->set_charset("utf8");
//        $stm = $db->prepare("SELECT value FROM ZA_Custom_Field_Object,ZA_Custom_Form_Object,ZA_Custom_Form_Usage WHERE ZA_Custom_Form_Object.custom_form_id='$customFormID' AND ZA_Custom_Form_Object.custom_form_id =ZA_Custom_Form_Usage.custom_form_id AND ZA_Custom_Form_Usage.linked_table='$tableName' AND  ZA_Custom_Form_Object.linked_table_id='$tableID' AND ZA_Custom_Form_Object.custom_form_object_id=ZA_Custom_Field_Object.custom_form_object_id AND ZA_Custom_Field_Object.custom_field_id='$customFieldID' LIMIT 1");
//        $stm-> execute();
//        $stm-> bind_result($lastValue);
//        while ($stm->fetch()) {}
//        $stm-> close();

        $disabled = false;
        if($disabled || !$editable){$disable = 'disabled';}else{$disable = '';}
        if($required){$required = 'required';}else{$required = '';}

        switch ($type){
            case 'text':
                $input = "<input type='$type' style='$cssStyle' class='$class' id='$customFieldName' name='$customFieldName' value='$lastValue' $disable $required/>";
                break;
            case 'combobox':


                $input = "<select style='$cssStyle' class='$class' id='$customFieldName' name='$customFieldName' $disable>";

                $values = explode(';',$valuesRange);
                $optionCount=0;
                foreach ($values as $value){
                    if(strcmp($lastValue,$value)==0){
                        $input.= "<option value='$lastValue' selected>$lastValue</option>";
                    }else{
                        $input.= "<option value='$value'>$value</option>";
                    }
                    $optionCount++;
                }
                $input.= "</select>";
                break;
            case 'checkbox':
                if(strcmp($lastValue,'yes')==0){$checked = "checked";} else {$checked = '';}
                $input = "<input type='$type' style='$cssStyle' class='$class' id='$customFieldName' name='$customFieldName' value='yes' $checked $disable/>";
                break;
            case 'label':
                $input = "<label class='label'>$lastValue</label>";
                break;
            case 'textarea':
                $input = "<textarea type='$type' style='$cssStyle' class='$class' id='$customFieldName' name='$customFieldName' $disable $required>$lastValue</textarea>";

                break;
            case 'JSONArray':

                $valuesJson = str_replace('#quote#','"',$valuesRange);
                $values = json_decode($valuesJson);
                $optionCount=0;
                $input = "<select style='$cssStyle' class='$class' id='$customFieldName' name='$customFieldName' $disable>";
                $input.= "<option value=''></option>";

                foreach ($values as $value){

                    $value = json_encode($value);
                    $value = str_replace('"','#quote#',$value);

                    $lastValueArray = str_replace('#quote#','"',$lastValue);
                    $lastValueArray = json_decode($lastValueArray);
                    $lastValueDisplay = '';
                    $lastValueArrayDB = array();
                    $firstValueOption = true;
                    foreach ($lastValueArray as $key => $data){
                        array_push($lastValueArrayDB,"#quote#$key#quote#:#quote#$data#quote#");
                        if($firstValueOption) {
                            $lastValueDisplay .= "$key: $data";
                            $firstValueOption = false;
                        } else {
                            $lastValueDisplay .= "</option><option disabled style='font-style:italic' >&nbsp;&#9679;&nbsp;$key: $data";
                        }
                    }
                    $lastValueDB = "{".implode(',',$lastValueArrayDB)."}";

                    $valueArray = str_replace('#quote#','"',$value);
                    $valueArray = json_decode($valueArray);
                    $valueDisplay = '';
                    $valueArrayDB = array();
                    $firstValueOption = true;
                    foreach ($valueArray as $key => $data){
                        array_push($valueArrayDB,"#quote#$key#quote#:#quote#$data#quote#");
                        if($firstValueOption) {
                            $valueDisplay .= "$key: $data";
                            $firstValueOption = false;
                        } else {
                            $valueDisplay .= "</option><option disabled style='font-style:italic' >&nbsp;&#9679;&nbsp;$key: $data";
                        }
                    }
                    $valueDB = "{".implode(',',$valueArrayDB)."}";

                    if(strcmp($lastValueDB,$valueDB)==0){
                        $input.= "<option value='$lastValueDB' selected>$lastValueDisplay</option>";
                    }else{
                        $input.= "<option value='$valueDB'>$valueDisplay</option>";
                    }
                    $optionCount++;
                }
                $input.= "</select>";

                break;
            default:
                $input = "<input type='$type' style='$cssStyle' class='$class' id='$customFieldName' name='$customFieldName' value='$lastValue' $disable $required/>";
        }

        echo "<tr>";
        echo "<td style='border-bottom: 0.5px solid lightgrey;border-right: 0.5px solid lightgrey;'><label style='color:#222'>$customFieldName</label></td>";
        echo "<td style='display:none;border-bottom: 0.5px solid lightgrey;'><input id='$customFormID|$customFieldID' name='$customFormID|$customFieldID' value='$customFieldID' hidden></td>";
        echo "<td class='form-control' style='margin-left:5px;border-bottom: 0.5px solid lightgrey;'>$input</td>";
        echo "</tr>";



    }
    $stm3->close();
    echo "</tbody>";
    echo "</table>";
    echo "</form>";

    function getLastValueOfCustomFormPost($customFormID,$customFieldID,$tableName,$tableID)
    {
        global $username, $password, $database;
        $db = new mysqli(localhost, $username, $password, $database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $db->set_charset("utf8");
        $value="test";
        $stm = $db->prepare("SELECT value FROM ZA_Custom_Field_Object,ZA_Custom_Form_Object,ZA_Custom_Form_Usage WHERE ZA_Custom_Form_Object.custom_form_id='$customFormID' AND ZA_Custom_Form_Object.custom_form_id =ZA_Custom_Form_Usage.custom_form_id AND ZA_Custom_Form_Usage.linked_table='$tableName' AND  ZA_Custom_Form_Object.linked_table_id='$tableID' AND ZA_Custom_Form_Object.custom_form_object_id=ZA_Custom_Field_Object.custom_form_object_id AND ZA_Custom_Field_Object.custom_field_id='$customFieldID' LIMIT 1");
        $stm-> execute();
        $stm-> bind_result($value);
        while ($stm->fetch()) {


        }
        $stm-> close();

        return $value;
    }

    function getInputTypePost($type,$cssStyle,$class,$customFieldName,$lastValue,$valuesRange,$disabled,$editable,$required){
        if($disabled || !$editable){$disable = 'disabled';}else{$disable = '';}
        if($required){$required = 'required';}else{$required = '';}

        switch ($type){
            case 'text':
                $input = "<input type='$type' style='$cssStyle' class='$class' id='$customFieldName' name='$customFieldName' value='$lastValue' $disable $required/>";
                break;
            case 'combobox':


                $input = "<select style='$cssStyle' class='$class' id='$customFieldName' name='$customFieldName' $disable>";

                $values = explode(';',$valuesRange);
                $optionCount=0;
                foreach ($values as $value){
                    if(strcmp($lastValue,$value)==0){
                        $input.= "<option value='$lastValue' selected>$lastValue</option>";
                    }else{
                        $input.= "<option value='$value'>$value</option>";
                    }
                    $optionCount++;
                }
                $input.= "</select>";
                break;
            case 'checkbox':
                if(strcmp($lastValue,'yes')==0){$checked = "checked";} else {$checked = '';}
                $input = "<input type='$type' style='$cssStyle' class='$class' id='$customFieldName' name='$customFieldName' value='yes' $checked $disable/>";
                break;
            case 'label':
                $input = "<label class='label'>$lastValue</label>";
                break;
            case 'textarea':
                $input = "<textarea type='$type' style='$cssStyle' class='$class' id='$customFieldName' name='$customFieldName' $disable $required>$lastValue</textarea>";

                break;
            case 'JSONArray':

                $valuesJson = str_replace('#quote#','"',$valuesRange);
                $values = json_decode($valuesJson);
                $optionCount=0;
                $input = "<select style='$cssStyle' class='$class' id='$customFieldName' name='$customFieldName' $disable>";
                $input.= "<option value=''></option>";

                foreach ($values as $value){

                    $value = json_encode($value);
                    $value = str_replace('"','#quote#',$value);

                    $lastValueArray = str_replace('#quote#','"',$lastValue);
                    $lastValueArray = json_decode($lastValueArray);
                    $lastValueDisplay = '';
                    $lastValueArrayDB = array();
                    $firstValueOption = true;
                    foreach ($lastValueArray as $key => $data){
                        array_push($lastValueArrayDB,"#quote#$key#quote#:#quote#$data#quote#");
                        if($firstValueOption) {
                            $lastValueDisplay .= "$key: $data";
                            $firstValueOption = false;
                        } else {
                            $lastValueDisplay .= "</option><option disabled style='font-style:italic' >&nbsp;&#9679;&nbsp;$key: $data";
                        }
                    }
                    $lastValueDB = "{".implode(',',$lastValueArrayDB)."}";

                    $valueArray = str_replace('#quote#','"',$value);
                    $valueArray = json_decode($valueArray);
                    $valueDisplay = '';
                    $valueArrayDB = array();
                    $firstValueOption = true;
                    foreach ($valueArray as $key => $data){
                        array_push($valueArrayDB,"#quote#$key#quote#:#quote#$data#quote#");
                        if($firstValueOption) {
                            $valueDisplay .= "$key: $data";
                            $firstValueOption = false;
                        } else {
                            $valueDisplay .= "</option><option disabled style='font-style:italic' >&nbsp;&#9679;&nbsp;$key: $data";
                        }
                    }
                    $valueDB = "{".implode(',',$valueArrayDB)."}";

                    if(strcmp($lastValueDB,$valueDB)==0){
                        $input.= "<option value='$lastValueDB' selected>$lastValueDisplay</option>";
                    }else{
                        $input.= "<option value='$valueDB'>$valueDisplay</option>";
                    }
                    $optionCount++;
                }
                $input.= "</select>";

                break;
            default:
                $input = "<input type='$type' style='$cssStyle' class='$class' id='$customFieldName' name='$customFieldName' value='$lastValue' $disable $required/>";
        }

        return $input;
    }
}

?>