<?php

/**
 * Created by PhpStorm.
 * User: hp
 * Date: 11/02/2016
 * Time: 10:53
 */
class Category
{
    public $categoryID;
    public $categoryCode;
    public $categoryName;
    public $description;
    public $creationDate;
    public $allowSubcategories;
    public $allowItems;
    public $level;
    public $customOrder;

    public $subCategories;

    public function __construct($categoryID, $categoryCode, $categoryName,$description,$creationDate,$allowSubcategories,$allowItems,$level,$customOrder)
    {
        $this->categoryID = $categoryID;
        $this->categoryCode = $categoryCode;
        $this->categoryName = $categoryName;
        $this->description = $description;
        $this->creationDate = $creationDate;
        $this->allowSubcategories = $allowSubcategories;
        $this->allowItems = $allowItems;
        $this->level = $level;
        $this->customOrder = $customOrder;
        $this->subCategories = array();

    }

    /**
     * @return mixed
     */
    public function getCategoryID()
    {
        return $this->categoryID;
    }

    /**
     * @param mixed $categoryID
     * @return Category
     */
    public function setCategoryID($categoryID)
    {
        $this->categoryID = $categoryID;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getCategoryCode()
    {
        return $this->categoryCode;
    }

    /**
     * @param mixed $categoryCode
     * @return Category
     */
    public function setCategoryCode($categoryCode)
    {
        $this->categoryCode = $categoryCode;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getCategoryName()
    {
        return $this->categoryName;
    }

    /**
     * @param mixed $categoryName
     * @return Category
     */
    public function setCategoryName($categoryName)
    {
        $this->categoryName = $categoryName;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * @param mixed $description
     * @return Category
     */
    public function setDescription($description)
    {
        $this->description = $description;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getCreationDate()
    {
        return $this->creationDate;
    }

    /**
     * @param mixed $creationDate
     * @return Category
     */
    public function setCreationDate($creationDate)
    {
        $this->creationDate = $creationDate;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getAllowSubcategories()
    {
        return $this->allowSubcategories;
    }

    /**
     * @param mixed $allowSubcategories
     * @return Category
     */
    public function setAllowSubcategories($allowSubcategories)
    {
        $this->allowSubcategories = $allowSubcategories;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getAllowItems()
    {
        return $this->allowItems;
    }

    /**
     * @param mixed $allowItems
     * @return Category
     */
    public function setAllowItems($allowItems)
    {
        $this->allowItems = $allowItems;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getLevel()
    {
        return $this->level;
    }

    /**
     * @param mixed $level
     * @return Category
     */
    public function setLevel($level)
    {
        $this->level = $level;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getCustomOrder()
    {
        return $this->customOrder;
    }

    /**
     * @param mixed $customOrder
     * @return Category
     */
    public function setCustomOrder($customOrder)
    {
        $this->customOrder = $customOrder;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getSubCategories()
    {
        return $this->subCategories;
    }

    /**
     * @param mixed $subCategories
     * @return Category
     */
    public function setSubCategories($subCategories)
    {
        $this->subCategories = $subCategories;
        return $this;
    }

    public function addSubCategory($subCategory)
    {
        array_push($this->subCategories , $subCategory);
        return $this;
    }



}