<?php
 
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */
include_once('../../../../param.php');
// DB table to use
$table = 'Suppliers';
 
// Table's primary key
$primaryKey = "customer_code";
 
// Array of database columns which should be read and sent back to DataTables.
// The `db` parameter represents the column name in the database, while the `dt`
// parameter represents the DataTables column identifier. In this case object
// parameter names
$columns = array(
       array( 'db' => '`c`.`logo`', 'dt' => 'logo', 'formatter' => function( $d) {
              if(!isset($d) || !file_exists(ROOT.'media/customersLogos/' . $d ) || strcmp($d,'')==0) {
                  $image = "//" . HTML_PATH . "/cop/backend/themes/" . THEME_NAME . "/img/customerdefault.jpg";
              } else {
                  $image = '//' . HTML_PATH . '/cop/media/customersLogos/'.$d;
              }
                return '<img class="img-rounded img-responsive center-canvas" src="'.$image.'" width="25" height="25"></td>';},
            'field' => 'logo' ),
     array( 'db' => '`c`.`customer_code`',       'dt' =>  'code', 'field' =>'customer_code' ),
       array( 'db' => '`c`.`customer_company_name`',       'dt' => 'name', 'field' => 'customer_company_name' ),
     array( 'db' => '`a`.`landline`',       'dt' => 'phone' , 'field' => 'landline' ),
        array( 'db' => '`a`.`address_line_1`',       'dt' => 'address', 'field' => 'address_line_1' ),
     array( 'db' => '`c`.`customer_id`', 'dt' => 'form', 'formatter' => function( $d, $row ) {
                return '<form id="'.$d.'" action="//'.HTML_PATH .'/cop/backend/core/views/addedit/new_supplier.php" method="post">
           		<input type="hidden" name="customer_id" value="'.$d.'">	           			                   
			<input style="font-size:13px;" type="submit" class="btn btn-primary" value="Edit" style="width:60px">
			</form>';},
            'field' => 'customer_id' )
);
 
// SQL server connection information
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db'   => $database ,
    'host' => 'localhost'
);
 
 
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */
$joinQuery = "FROM `Suppliers` AS `c` LEFT JOIN `SupplierAddress` AS `a` ON (`c`.`customer_id` = `a`.`supplier_id`)";
require( ROOT.'backend/core/controllers/ssp2.class.php' );
 
echo json_encode(
       SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns,$joinQuery)
     );
     
     ?>