<?php

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */
include_once('../../../../param.php');
// DB table to use
$table = 'Serial_Numbers';

// Table's primary key
$primaryKey = "serial_number_transaction_log_id";

$serialNumberID =$_GET['serialNumberID'];

// Array of database columns which should be read and sent back to DataTables.
// The `db` parameter represents the column name in the database, while the `dt`
// parameter represents the DataTables column identifier. In this case object
// parameter names
$columns = array(
    array( 'db' => '`s`.`serial_number_transaction_log_id`', 'dt' => 'image', 'formatter' => function( $d, $row ) {
            $d = "//".HTML_PATH."/cop/backend/themes/".THEME_NAME."/img/asseticon.png";

        return '<img class="img-responsive img-rounded center-canvas" src="'.$d.'" width="32" height="32"></td>';},
        'field' => 'serial_number_transaction_log_id' ),
    array( 'db' => '`s`.`entry_date`', 'dt' => 'date' , 'formatter' => function( $d, $row ) {
        $date = date('d-m-Y',strtotime($d));
        return "<span style='color:#426384;font-weight:bold'>$date</span>";},'field' => 'entry_date' ),
    array( 'db' => '`t`.`serial_number_transaction_type_code`', 'dt' => 'transactionCode', 'field' => 'serial_number_transaction_type_code' ),
    array( 'db' => '`t`.`serial_number_transaction_type_name`', 'dt' =>  'transactionName', 'formatter' => function( $d, $row ) {
        return "<span style='font-weight:bold'>$d</span>";},'field' =>'serial_number_transaction_type_name' ),
    array( 'db' => '`c`.`customer_code`', 'dt' =>  'customerCode', 'field' =>'customer_code' ),
    array( 'db' => '`c`.`customer_company_name`', 'dt' =>  'customerName', 'formatter' => function( $d, $row ) {
        return "<span style='font-size:12px;'>$d</span>";}, 'field' =>'customer_company_name' ),
    array( 'db' => '`a`.`address_line_1`', 'dt' =>  'customerAddress', 'field' =>'address_line_1' ),
    array( 'db' => '`w`.`warehouse_code`', 'dt' =>  'warehouse', 'field' =>'warehouse_code' ),
    array( 'db' => '`s`.`start_date`', 'dt' => 'startDate' , 'formatter' => function( $d, $row ) {
        return date('d-m-Y',strtotime($d));},'field' => 'start_date' ),
    array( 'db' => '`s`.`end_date`', 'dt' => 'endDate' , 'formatter' => function( $d, $row ) {
        return date('d-m-Y',strtotime($d));},'field' => 'end_date' ),
    array( 'db' => '`s`.`action_type`', 'dt' =>  'actionType', 'field' =>'action_type' ),
    array( 'db' => '`s`.`action_id`', 'dt' =>  'actionCode', 'field' =>'action_id' ),
    array( 'db' => '`s`.`description`', 'dt' =>  'description', 'field' =>'description' ),
    array( 'db' => '`s`.`notes`', 'dt' =>  'notes', 'field' =>'notes' ),
    array( 'db' => '`s`.`status`', 'dt' =>  'status', 'field' =>'status' ),
    array( 'db' => '`s`.`serial_number_transaction_log_id`', 'dt' => 'form', 'formatter' => function( $d, $row ) {



        return '<form id="'.$d.'" action="//'.HTML_PATH .'/cop/backend/core/views/addedit/new_serial_number_transaction.php" method="post" style="display:inline;">
           		<input type="hidden" name="serial_number_transaction_log_id" value="'.$d.'">
			<input  type="submit" class="btn btn-primary" value="Edit" style="width:60px">
			</form>'

            ;},
        'field' => 'serial_number_transaction_log_id' )
);

// SQL server connection information
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db'   => $database ,
    'host' => 'localhost'
);

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */
$joinQuery = "FROM `Serial_Number_Transaction_Log` AS `s` LEFT JOIN `Serial_Number_Transaction_Type` AS `t` ON (`t`.`serial_number_transaction_type_id` = `s`.`serial_number_transaction_type_id`) LEFT JOIN `Customers` AS `c` ON (`c`.`customer_id` = `s`.`customer_id`) LEFT JOIN `CustomerAddress` AS `a` ON (`a`.`customer_address_id` = `s`.`customer_address_id`) LEFT JOIN `Warehouses` AS `w` ON (`w`.`warehouse_id` = `s`.`warehouse_id`)";
require( ROOT.'backend/core/controllers/ssp2.class.php' );
$where ="`s`.serial_number_id =$serialNumberID";
if(isset($_SESSION['Allow_Customers']) && strcmp($_SESSION['Allow_Customers'],'')!=0){
    if(strcmp($where,'')!=0){$where.= " AND ";}
    $where .= "`c`.`customer_id` IN (".$_SESSION['Allow_Customers'].")";
}
echo json_encode(
    SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns,$joinQuery,$where)
);

?>