<?php
 
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */
include_once('../../../../param.php');
// DB table to use
$table = 'Schedules';
 
// Table's primary key
$primaryKey = "name";
 
// Array of database columns which should be read and sent back to DataTables.
// The db parameter represents the column name in the database, while the dt
// parameter represents the DataTables column identifier. In this case object
// parameter names
$columns = array(

     array( 'db' => 's.name', 'dt' =>  'code', 'field' =>'name' ),
       array( 'db' => 's.type', 'dt' => 'name', 'field' => 'type' ),
    array( 'db' => 's.creation_date', 'formatter' => function( $d, $row ) {
        return date('d-m-Y',strtotime($d));}, 'dt' => 'date', 'field' => 'creation_date' ),
     array( 'db' => 's.schedule_id', 'dt' => 'assigned', 'formatter' => function( $d, $row ) {

         global $username,$password,$database;
         $db = new mysqli(localhost, $username, $password, $database);
         if (mysqli_connect_errno()) {
             printf("Connect failed: %s\n", mysqli_connect_error());
             exit();
         }
         $options = '';
         $first = true;
         $db->set_charset("utf8");
         $stm = $db->prepare("SELECT CONCAT(salesperson_code,' - ',first_name,' ',last_name) FROM Schedule_Salesperson,SalesPersons WHERE Schedule_Salesperson.salesperson_id=SalesPersons.salesperson_id AND schedule_id='$d'");
         $stm->execute();
         $stm->bind_result($assigned);

         while ($stm->fetch()) {
                 if($first){$options.= "$assigned";}
                 else{$options.= "<br>$assigned";}
                $first = false;
         }
         $stm->close();


                return $options;},
            'field' => 'schedule_id' ),
    array( 'db' => 's.creation_date', 'formatter' => function( $d, $row ) {
        return date('d-m-Y',strtotime($d));}, 'dt' => 'date', 'field' => 'creation_date' ),
     array( 'db' => 's.schedule_id', 'dt' => 'form', 'formatter' => function( $d, $row ) {
                return '<form id="'.$d.'" action="//'.HTML_PATH .'/cop/backend/core/views/addedit/edit_schedule.php" method="post">
           		<input type="hidden" name="schedule_id" value="'.$d.'">
			<input style="font-size:13px;" type="submit" class="btn btn-primary" value="View" style="width:60px">
			</form>';},
            'field' => 'schedule_id' )
);
 
// SQL server connection information
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db'   => $database ,
    'host' => 'localhost'
);
 
 
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */

require( ROOT.'backend/core/controllers/ssp2.class.php' );

$joinQuery = "FROM Schedules AS s ";
$where = '';

if (isset($_GET['assignedFilter']) && !empty($_GET['assignedFilter'])) {
    $assignedFilter = trim($_GET['assignedFilter']);
    if (!empty($where)) {
        $where .= " AND ";
    }
    $joinQuery .= "INNER JOIN Schedule_Salesperson AS ss ON ss.schedule_id = s.schedule_id 
                    INNER JOIN SalesPersons AS sp ON ss.salesperson_id = sp.salesperson_id";
    $where .= " CONCAT(sp.salesperson_code, ' - ', sp.first_name, ' ', sp.last_name) LIKE '%" . $assignedFilter . "%'";

}



echo json_encode(
       SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns,$joinQuery,$where)
     );
     
     ?>