<?php

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */
include_once("../../../../param.php");


// DB table to use
$table = 'Payment_Terms';

// Table's primary key
$primaryKey = "payment_term_id";

// Array of database columns which should be read and sent back to DataTables.
// The `db` parameter represents the column name in the database, while the `dt`
// parameter represents the DataTables column identifier. In this case object
// parameter names
$columns = array(
    array(
        'db' => 'payment_term_id',
        'dt' => 'payment_term_id',
        'field' => 'payment_term_id'
    ),

    array(
        'db' => 'payment_term_code',
        'dt' => 'code',
        'field' => 'payment_term_code'
    ),
    array(
        'db' => 'payment_term_text',
        'dt' => 'text',
        'field' => 'payment_term_text'
    ),
    array(
        'db' => 'payment_terms_days',
        'dt' => 'days',
        'field' => 'payment_terms_days'
    ),

    array( 'db' => '`payment_term_id`', 'dt' =>  'form', 'formatter' => function( $d, $row ) {
        $code = $row["payment_term_code"];
        $text = $row["payment_term_text"];
        $days= $row["payment_terms_days"];
        $button = "<a onclick='openEditModal(\"$d\",\"$code\",\"$text\",\"$days\");'>
                        <button type='submit' class='btn btn-primary' style='width:80px'> Edit</button>
                    </a>
                    ";
        return $button;
    }, 'field' =>'payment_term_id'

    )

);

global $username, $password, $database;
// SQL server connection information
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db'   => $database ,
    'host' => 'localhost'
);



$joinQuery = "FROM `Payment_Terms`";
$where='';

require(ROOT . 'backend/core/controllers/ssp2.class.php' );

echo json_encode(
    SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns,$joinQuery,$where)
);

?>