<?php
 
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */
 include_once('../../../../param.php');
// DB table to use
$table = 'Loyalty_Transactions';
 
// Table's primary key
$primaryKey = "transaction_id";
 
// Array of database columns which should be read and sent back to DataTables.
// The `db` parameter represents the column name in the database, while the `dt`
// parameter represents the DataTables column identifier. In this case object
// parameter names
$columns = array(

    array( 'db' => '`lt`.`name`', 'dt' =>  'name', 'field' =>'name' ),
    array( 'db' => '`l`.`action_type`', 'dt' =>  'action', 'formatter' => function( $d, $row ) {
        $displayType = $d;
        $displayType = str_replace("_", " ", $displayType);
        $displayType = ucwords($displayType);
        return $displayType;
        }, 'field' =>'action_type' ),
    array( 'db' => '`l`.`details`', 'dt' =>  'details', 'field' =>'details' ),
    array( 'db' => '`u`.`first_name`', 'dt' =>  'userName', 'formatter' => function( $d, $row ) {$GLOBALS['first_name']=$d;return $d;}, 'field' =>'first_name' ),
    array( 'db' => '`u`.`last_name`', 'dt' =>  'userLast', 'formatter' => function( $d, $row ) {$GLOBALS['last_name']=$d;return $d;}, 'field' =>'last_name' ),
    array( 'db' => '`u`.`username`', 'dt' =>  'userName', 'formatter' => function( $d, $row ) {$GLOBALS['userName']=$d;return $d;}, 'field' =>'username' ),
    array( 'db' => '`u`.`first_name`', 'dt' =>  'fullName', 'formatter' => function( $d, $row ) {
        $fullName = $GLOBALS['first_name'].' '.$GLOBALS['last_name'];
        if(strcmp(trim($fullName),'')==0){$fullName = $GLOBALS['userName'];}
        return $fullName;
        }, 'field' =>'first_name' ),
    array( 'db' => '`l`.`document_code`', 'dt' =>  'documentcode', 'field' =>'document_code' ),
    array( 'db' => '`l`.`document_total`', 'dt' =>  'documenttotal', 'formatter' => function( $d, $row ) {

        return number_format($d, 2, '.', ',');

    }, 'field' =>'document_total' ),
    array( 'db' => '`c`.`customer_code`', 'dt' =>  'cCode', 'field' =>'customer_code' ),
    array( 'db' => '`c`.`customer_company_name`', 'dt' =>  'cName', 'field' =>'customer_company_name' ),
    array( 'db' => '`l`.`entry_date`', 'dt' =>  'date', 'formatter' => function( $d, $row ) {
        $timezone = 'Europe/Athens';
        date_default_timezone_set($timezone);
        $timestamp = strtotime($d);
        $local_time = $timestamp + date('Z');
        $local_date = date('d-m-Y H:i:s', $local_time);
        return $local_date;
        }, 'field' =>'entry_date' ),
    array( 'db' => '`l`.`sign`', 'dt' =>  'sign', 'formatter' => function( $d, $row ) {
        $GLOBALS['sign']=$d;
        if($d==1){
            return 'Gain';
        } else {
            return 'Spend';
        }
        return $d;
        }, 'field' =>'sign' ),
    array( 'db' => '`l`.`points`', 'dt' =>  'points', 'formatter' => function( $d, $row ) {
        $sign = $GLOBALS['sign'];
        if($d!=0){
            return number_format($d*$sign, 0, '.', ',');
        } else {
            return 0;
        }

        }, 'field' =>'points' )
);
 
// SQL server connection information
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db'   => $database ,
    'host' => 'localhost'
);
 
 
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */
$where = '';
if(isset($_SESSION['Allow_Customers']) && strcmp($_SESSION['Allow_Customers'],'')!=0){
    if(strcmp($where,'')!=0){$where.= " AND ";}
    $where .= "`c`.`customer_id` IN (".$_SESSION['Allow_Customers'].")";
}

$joinQuery = "FROM `Loyalty_Transactions` AS `l` LEFT JOIN `Loyalty_Types` AS `lt` ON (`l`.`type_id` = `lt`.`loyalty_type_id`) LEFT JOIN `Customers` AS `c` ON (`l`.`customer_id` = `c`.`customer_id`) LEFT JOIN B2B_User AS `u` ON (`l`.`user_id` = `u`.`b2b_user_id`)";
require( ROOT.'backend/core/controllers/ssp2.class.php' );
 
echo json_encode(
       SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns,$joinQuery,$where)
     );
     
     ?>