<?php
 
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */
 include_once('../../../../param.php');
// DB table to use
$table = 'Visits';
 
// Table's primary key
$primaryKey = "visit_code";
 
// Array of database columns which should be read and sent back to DataTables.
// The `db` parameter represents the column name in the database, while the `dt`
// parameter represents the DataTables column identifier. In this case object
// parameter names
$columns = array(
    array( 'db' => '`o`.`visit_code`', 'dt' => 'img', 'formatter' => function( $d, $row ) {

        return '<img class="custom-rounded-image yearly center-canvas" src="//' . HTML_PATH . '/cop/backend/themes/' . THEME_NAME . '/img/visiticon.png" width="30" height="30"></td>';},
        'field' => 'visit_code' ),
     array( 'db' => '`o`.`visit_code`', 'dt' =>  'code', 'field' =>'visit_code' ),
       array( 'db' => '`c`.`customer_company_name`', 'dt' => 'customer', 'field' => 'customer_company_name' ),
       array( 'db' => '`c`.`customer_code`', 'dt' => 'customercode', 'field' => 'customer_code' ),
    array( 'db' => '`o`.`visit_date`', 'dt' => 'date' , 'formatter' => function( $d, $row ) {

        return date('d-m-Y',strtotime($d));},

        'field' => 'visit_date' ),

    array( 'db' => '`s`.`salesperson_code`', 'dt' => 'salesperson', 'field' => 'salesperson_code' ),
    array( 'db' => '`o`.`notes`', 'dt' => 'notes', 'field' => 'notes' ),
    array( 'db' => '`o`.`visit_id`', 'dt' => 'form' , 'formatter' => function( $d, $row ) {

        $buttons = '<form id="'.$d.'" action="//' . HTML_PATH . '/cop/backend/core/views/view/view_visit.php" method="post" target="_blank" style="display: inline-block; margin-bottom: 3px;">
                        <input type="hidden" name="visit_id" value="'.$d.'">	           			                   
                        <input style="font-size:13px;width:55px;" type="submit" class="btn btn-return yearly" value="View" >
			        </form>
                    <form id="'.$d.'" action="//' . HTML_PATH . '/cop/backend/core/views/addedit/create_visit.php" method="post" target="_blank" style="display: inline-block; margin-bottom: 3px;">
                        <input type="hidden" name="visit_id" value="'.$d.'">	           			                   
                        <input style="font-size:13px;width:55px;" type="submit" class="btn btn-primary" value="Edit" >
                    </form>';

        return $buttons;},

        'field' => 'visit_id' )
);
 
// SQL server connection information
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db'   => $database ,
    'host' => 'localhost'
);

$where = '';
if(isset($_SESSION['Allow_Customers']) && strcmp($_SESSION['Allow_Customers'],'')!=0){
    $where .= "`c`.`customer_id` IN (".$_SESSION['Allow_Customers'].")";
}
if(isset($_SESSION['Allow_Salespersons']) && strcmp($_SESSION['Allow_Salespersons'],'')!=0){
    if(strcmp($where,'')!=0){$where.= " AND ";}
    $where .= " `o`.`salesperson_id` IN (".$_SESSION['Allow_Salespersons'].")";
}
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */
$joinQuery = "FROM `Visits` AS `o` LEFT JOIN `Customers` AS `c` ON (`o`.`customer_id` = `c`.`customer_id`) LEFT JOIN `SalesPersons` AS `s` ON (`o`.`salesperson_id` = `s`.`salesperson_id`)";
require( ROOT.'backend/core/controllers/ssp2.class.php' );
 
echo json_encode(
       SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns,$joinQuery,$where)
     );
     
     ?>