<?php

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */
include_once("../../../../param.php");


// DB table to use
$table = 'Customer_Payment_Terms';

// Table's primary key
$primaryKey = "payment_term_text";

// Array of database columns which should be read and sent back to DataTables.
// The db parameter represents the column name in the database, while the dt
// parameter represents the DataTables column identifier. In this case object
// parameter names
$columns = array(
    array(
        'db' => "CONCAT(c.customer_code,' - ',c.customer_company_name)",
        'dt' => 'customer',
        'field' => 'customer',
        'as' => 'customer'
    ),

    array(
        'db' => 'payment_term_text',
        'dt' => 'text',
        'field' => 'payment_term_text'
    ),
    array(
        'db' => 'payment_term_days',
        'dt' => 'days',
        'field' => 'payment_term_days'
    ),

    array( 'db' => 'cp.customer_id', 'dt' =>  'form', 'formatter' => function( $d, $row ) {
        $customer = $d;
        $text = $row["payment_term_text"];
        $days= $row["payment_term_days"];
        $button = "<a onclick='openEditModal(\"$customer\",\"$text\",\"$days\");'>
                        <button type='submit' class='btn btn-primary' style='width:80px'> Edit</button>
                    </a>
                    ";
        return $button;
    }, 'field' =>'customer_id'

    )

);

global $username, $password, $database;
// SQL server connection information
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db'   => $database ,
    'host' => 'localhost'
);



$joinQuery = "FROM Customer_Payment_Terms AS cp 
                INNER JOIN Customers AS c ON c.customer_id = cp.customer_id";
$where='';

require(ROOT . 'backend/core/controllers/ssp2.class.php' );

echo json_encode(
    SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns,$joinQuery,$where)
);

?>