<?php
 
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */
 include_once('../../../../param.php');


// DB table to use
$table = 'ZA_Custom_Tables';
 
// Table's primary key
$primaryKey = "custom_table_id";
 
// Array of database columns which should be read and sent back to DataTables.
// The `db` parameter represents the column name in the database, while the `dt`
// parameter represents the DataTables column identifier. In this case object
// parameter names
$columns = array(

    array( 'db' => '`o`.`custom_table_code`', 'dt' => 'img', 'formatter' => function( $d, $row ) {
        return '<img class="custom-rounded-image yearly center-canvas" src="//' . HTML_PATH . '/cop/backend/themes/' . THEME_NAME . '/img/ordericon.png" width="30" height="30" title="Custom Form '.$d.'" ></td>';
    }, 'field' => 'custom_table_code' ),

    array( 'db' => '`o`.`custom_table_id`', 'dt' => 'id', 'formatter' => function( $d, $row ) {$GLOBALS['custom_table_id']=$d;return '';}, 'field' => 'custom_table_id' ),
    array( 'db' => '`o`.`custom_table_code`', 'dt' =>  'code', 'field' =>'custom_table_code' ),
    array( 'db' => '`o`.`custom_table_name`', 'dt' =>  'customTable', 'field' =>'custom_table_name' ),
    array( 'db' => '`o`.`linked_table`', 'dt' =>  'linkedTable', 'field' =>'linked_table' ),
    array( 'db' => '`o`.`display_name`', 'dt' =>  'name', 'field' =>'display_name' ),
    array( 'db' => '`o`.`position`', 'dt' =>  'position', 'field' =>'position' ),
    array( 'db' => '`o`.`type`', 'dt' =>  'type', 'field' =>'type' ),
    array( 'db' => '`o`.`status`', 'dt' =>  'status', 'field' =>'status' ),
    array( 'db' => '`o`.`update_app`', 'dt' =>  'updateApp', 'field' =>'update_app' ),

    array( 'db' => '`o`.`custom_table_id`', 'dt' => 'fields', 'formatter' => function( $d, $row ) {
        $fields = '';

        global $username, $password, $database;
        $db2 = new mysqli(localhost, $username, $password, $database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $db2->set_charset("utf8");
        $stm2 = $db2->prepare("SELECT custom_table_field, display_name, type,  position, default_values, css_style, class,visible FROM ZA_Custom_Table_Fields WHERE custom_table_id='$d'");
        $stm2->execute();
        $stm2->bind_result($customTableField, $displayName,$type,$position,$defaultValues,$css,$class,$visible);
        while ($stm2->fetch()) {
            $displayName = "[$displayName]";
            if(strcmp($visible,'yes')!=0){$displayName = "<del>$displayName</del>";}
            $fields .= "$displayName<br>";

        }
        $stm2->close();
        if(strcmp($fields,'')!=0){
            $fields = "<div style='display: none;' id='fields_$d'>$fields</div><button class='btn btn-return' onclick='viewInput(\"fields_$d\",this);'>View Fields</button>";
        }
        return $fields;
    }, 'field' => 'custom_table_id' ),

    array( 'db' => '`o`.`custom_table_id`', 'dt' => 'actions', 'formatter' => function( $d, $row ) {

        $buttons = "
                    <form method='post' action='//".HTML_PATH."/cop/backend/core/views/addedit/create_custom_table.php' target='_blank'>
                    <input type='hidden' name='custom_table_id' value='$d'>
                    <button type='submit' class='btn btn-primary' >Edit Form</button>
                    </form>";
        return $buttons;
    }, 'field' => 'custom_table_id' ),


);
 
// SQL server connection information
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db'   => $database ,
    'host' => 'localhost'
);
$where = '';
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */
$joinQuery = "FROM `ZA_Custom_Tables` AS `o` ";
require( ROOT.'backend/core/controllers/ssp2.class.php' );
 
echo json_encode(
       SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns,$joinQuery,$where)
     );
     
     ?>