<?php

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */
include_once('../../../../param.php');



global $username, $password, $database;
$db = new mysqli("localhost", $username, $password, $database);
if ($db->connect_errno) {
    return "Database connection failed: " . $db->connect_error;
}

$db->set_charset("utf8");

// DB table to use
$table = 'ContractPrices';

// Table's primary key
$primaryKey = "min_qty";

// Global variable to store the unique identifier
$uniqueID = '';

// Array of database columns which should be read and sent back to DataTables.
$columns = array(

    array(
        'db' => 'cp.customer_id',
        'dt' => 'customerID',
        'field' => 'customer_id'
    ),
    array(
        'db' => 'cp.customer_id',
        'dt' => 'deleteImg',
        'field' => 'deleteImg',
        'formatter' => function($d, $row) {
            $uniqueID = $row['customer_id'] . "-" . $row['item_id'] . "-" . $row['min_qty'];
            return '<img class="deletRowButton" src="/cop/backend/themes/' . THEME_NAME . '/img/deleteicon.png" style="width:20px;height:20px;cursor: pointer;" onclick="deleteRow(\'' . $uniqueID . '\')"/>';
        }
    ),

    array(
        'db' => 'cp.item_id',
        'dt' => 'itemID',
        'field' => 'item_id'
    ),

    array(
        'db' => 'c.customer_code',
        'dt' => 'customer_code',
        'field' => 'customer_code'
    ),

    array(
        'db' => 'c.customer_company_name',
        'dt' => 'customer_name',
        'field' => 'customer_company_name'
    ),

    array(
        'db' => 'i.item_code',
        'dt' => 'item_code',
        'field' => 'item_code'
    ),

    array(
        'db' => 'i.name',
        'dt' => 'item_name',
        'field' => 'item_name',
        'as' => 'item_name'
    ),


    array(
        'db' => 'CONCAT(c.customer_code, " ", c.customer_company_name)',
        'dt' => 'customer',
        'field' => 'customer',
        'formatter' => function($d, $row) use($db) {
            if (!empty($row['customer_code']) || !empty($row['customer_company_name'])) {
                $displayValue = $row['customer_code'] . " " . $row['customer_company_name'];
                
            } else {
                $displayValue = '&nbsp;';
            }
            $uniqueID = $row['customer_id'] . "-" . $row['item_id'] . "-" . $row['min_qty'];
            $dataID = $row['customer_id'] ;

            $stm = $db->prepare("SELECT customer_id, customer_code, customer_company_name FROM Customers ORDER BY customer_code ASC");
            $stm->execute();
            $stm->bind_result($customerID, $code, $name);

            $options = "";
            while ($stm->fetch()) {
                $selected = ($displayValue == "$code $name") ? "selected" : "";
                $options .= "<option value='$customerID' $selected>$code $name</option>";
            }
            $stm->close();


            return "
            <div 
                 data-field-name='customer' 
                 data-id='$dataID' 
                 style='position: relative; cursor: pointer;'
                 onmouseover='$(this).find(\".fa-pencil\").show();'
                 onmouseleave='$(this).find(\".fa-pencil\").hide();'
                 onclick='openEditField(\"$uniqueID\", \"customer\", this);'>
                <span id='value-customer-$uniqueID'>$displayValue</span>
                <span id='pen-customer-$uniqueID'><i class='fa fa-pencil' style='display:none; cursor:pointer; margin-left:4px;'></i></span>
            </div>
            <div  style='white-space: nowrap;' id = 'div-input-customer-$uniqueID'>
                <input type='text' class=' text-center form-control' id='input-customer-$uniqueID'  style='display:none;width:80%'>
                <input type='hidden' class=' text-center' id='inputID-customer-$uniqueID'  style='display:none;width:80%'>           
                   <button id='save-customer-$uniqueID' class='btn btn-success' style='display:none;'><i class='fa fa-save' style='cursor:pointer; margin-left:4px;'></i></button>
            </div>
             <script>
           $('#input-customer-$uniqueID').autocomplete({
            source: '//".HTML_PATH."/cop/backend/core/controllers/autocomplete/customer_autocomplete.php',
            autoFocus: true,
            open: function(){
                $('.ui-autocomplete').css('width', '400px');
            },
            select: function (event, ui) {
                $('#inputID-customer-$uniqueID').val(ui.item.customer_id);

            }
        });
</script>
         
        ";
        },
        'field' => 'customer'
    ),
    array(
        'db' => 'CONCAT(i.item_code, " ", i.name)',
        'dt' => 'item',
        'field' => 'item',
        'formatter' => function($d, $row) use($db){
            if (!empty($row['item_code']) || !empty($row['item_name'])) {
                $displayValue = $row['item_code'] . " " . $row['item_name'];
            } else {
                $displayValue = '&nbsp;';
            }
            $uniqueID = $row['customer_id'] . "-" . $row['item_id'] . "-" . $row['min_qty'];
            $dataID = $row['item_id'];

//            $stm = $db->prepare("SELECT item_id,item_code,name FROM Items ORDER BY item_code ASC");
//            $stm->execute();
//            $stm->bind_result($itemID, $code, $name);
//
//            $options = "";
//            while ($stm->fetch()) {
//                $selected = ($displayValue == "$code $name") ? "selected" : "";
//                $options .= "<option value='$itemID' $selected>$code $name</option>";
//            }
//            $stm->close();

            return "
            <div 
                 data-field-name='item' 
                 data-id='$dataID' 
                 style='position: relative; cursor: pointer;'
                 onmouseover='$(this).find(\".fa-pencil\").show();'
                 onmouseleave='$(this).find(\".fa-pencil\").hide();'
                 onclick='openEditField(\"$uniqueID\", \"item\", this);'>
                <span id='value-item-$uniqueID'>$displayValue</span>
                <span id='pen-item-$uniqueID'><i class='fa fa-pencil' style='display:none; cursor:pointer; margin-left:4px;'></i></span>
            </div>
            <div  style='white-space: nowrap;'>
                <input type='text' class=' text-center form-control' id='input-item-$uniqueID'  style='display:none;width:80%'>
                <input type='hidden' class=' text-center' id='inputID-item-$uniqueID'  style='display:none;width:80%'>

                <button id='save-item-$uniqueID' class='btn btn-success' style='display:none;'><i class='fa fa-save' style='cursor:pointer; margin-left:4px;'></i></button>
           </div>
           <script>
           $('#input-item-$uniqueID').autocomplete({
            source: '//".HTML_PATH."/cop/backend/core/controllers/autocomplete/item_autocomplete.php',
            autoFocus: true,
            open: function(){
                $('.ui-autocomplete').css('width', '400px');
            },
            select: function (event, ui) {
                $('#inputID-item-$uniqueID').val(ui.item.item_id);

            }
        });
</script>
        ";
        },
        'field' => 'item'
    ),
    array(
        'db' => 'cp.min_qty',
        'dt' => 'min_qty',
        'field' => 'min_qty',
        'formatter' => function($d, $row) {
            $displayValue = !empty($d) ? $d : '&nbsp;';
            $uniqueID = $row['customer_id'] . "-" . $row['item_id'] . "-" . $row['min_qty'];

            return "
            <div 
                 data-field-name='min_qty' 
                 style='position: relative; cursor: pointer;'
                 onmouseover='$(this).find(\".fa-pencil\").show();'
                 onmouseleave='$(this).find(\".fa-pencil\").hide();'
                 onclick='openEditField(\"$uniqueID\", \"min_qty\", this);'>
                <span id='value-min_qty-$uniqueID'>$displayValue</span>
                <span id='pen-min_qty-$uniqueID'><i class='fa fa-pencil' style='display:none; cursor:pointer; margin-left:4px;'></i></span>
            </div>
            <div  style='white-space: nowrap;'>
                <input  type='number' step='1' min ='0' class='form-control text-center' id='input-min_qty-$uniqueID' value='' style='display:none;'>
                <button id='save-min_qty-$uniqueID' class='btn btn-success' style='display:none;'><i class='fa fa-save' style='cursor:pointer; margin-left:4px;'></i></button>
             </div>
        ";
        },
        'field' => 'min_qty'
    ),

    array(
        'db' => 'cp.price',
        'dt' => 'price',
        'field' => 'price',
        'formatter' => function($d, $row) {
            $uniqueID = $row['customer_id'] . "-" . $row['item_id'] . "-" . $row['min_qty'];
            $displayValue = !empty($d) ? $d : '&nbsp;';

            return "
            <div 
                 data-field-name='price' 
                 style='position: relative; cursor: pointer;'
                 onmouseover='$(this).find(\".fa-pencil\").show();'
                 onmouseleave='$(this).find(\".fa-pencil\").hide();'
                 onclick='openEditField(\"$uniqueID\", \"price\", this);'>
                <span id='value-price-$uniqueID'>$displayValue</span>
                <span id='pen-price-$uniqueID'><i class='fa fa-pencil' style='display:none; cursor:pointer; margin-left:4px;'></i></span>
            </div>
            <div  style='white-space: nowrap;'>
                <input type='number' step='0.01' min ='0' class='form-control text-center' id='input-price-$uniqueID' value='' style='display:none;'>
                <button id='save-price-$uniqueID' class='btn btn-success' style='display:none;'><i class='fa fa-save' style='cursor:pointer; margin-left:4px;'></i></button>
            </div>
        ";
        },
        'field' => 'price'
    ),


    array(
        'db' => 'cp.percentage',
        'dt' => 'percentage',
        'field' => 'percentage',
        'formatter' => function($d, $row) {
            $uniqueID = $row['customer_id'] . "-" . $row['item_id'] . "-" . $row['min_qty'];
            $displayValue = !empty($d) ? $d : '&nbsp;';
            return "
            <div 
                 data-field-name='percentage' 
                 style='position: relative; cursor: pointer;'
                 onmouseover='$(this).find(\".fa-pencil\").show();'
                 onmouseleave='$(this).find(\".fa-pencil\").hide();'
                 onclick='openEditField(\"$uniqueID\", \"percentage\", this);'>
                <span id='value-percentage-$uniqueID'>$displayValue</span>
                <span id='pen-percentage-$uniqueID'><i class='fa fa-pencil' style='display:none; cursor:pointer; margin-left:4px;'></i></span>
            </div>
            <div  style='white-space: nowrap;'>
                <input  type='number' step='0.01' min ='0' class='form-control text-center' id='input-percentage-$uniqueID' value='' style='display:none;'>
                <button id='save-percentage-$uniqueID' class='btn btn-success' style='display:none;'><i class='fa fa-save' style='cursor:pointer; margin-left:4px;'></i></button>
             </div>
        ";
        },
        'field' => 'percentage'
    ),

    array(
        'db' =>' p.pricetype_id',
        'dt' => 'pricetype_id',
        'field' => 'pricetype_id'
    ),

    array(
        'db' =>' p.price_code',
        'dt' => 'price_code',
        'field' => 'price_code'
    ),


    array(
        'db' =>' p.name',
        'dt' => 'price_name',
        'field' => 'price_name',
        'as' => 'price_name'
    ),



    array(
        'db' => 'CONCAT(p.price_code, " ", p.name)',
        'dt' => 'price_type',
        'field' => 'price_type',
        'formatter' => function($d, $row) use ($db) {
            $itemID = $row['item_id'];
            $uniqueID = $row['customer_id'] . "-" . $row['item_id'] . "-" . $row['min_qty'];
            $dataID = $row['pricetype_id'];
            if (!empty($row['price_code']) || !empty($row['price_name'])) {
                $displayValue = $row['price_code'] . " " . $row['price_name'];
                

            } else {
                $displayValue = '&nbsp;';
            }

            $stm = $db->prepare("SELECT distinct (pt.pricetype_id), price_code, name FROM PriceTypes as pt INNER JOIN Prices as p
                                        ON pt.pricetype_id = p.pricetype_id ORDER BY  price_code ASC");
            $stm->execute();
            $stm->bind_result($priceTypeID, $code, $name);

            $options = "<option value='0' selected='selected'> </option>";
            while ($stm->fetch()) {
                $selected = ($displayValue == "$code $name") ? "selected" : "";
                $options .= "<option value='$priceTypeID' $selected>$code $name</option>";
            }
            $stm->close();

            return "
        <div data-id='$dataID' style='position: relative; cursor: pointer;' 
             data-field-name='price_type' 
             onmouseover='$(this).find(\".fa-pencil\").show();'
             onmouseleave='$(this).find(\".fa-pencil\").hide();'
                 onclick='openEditField(\"$uniqueID\", \"price_type\", this);'>
            <span id='value-price_type-$uniqueID'>$displayValue</span>
            <span id='pen-price_type-$uniqueID'><i class='fa fa-pencil' style='display:none; cursor:pointer; margin-left:4px;'></i></span>
        </div>
        <div  style='white-space: nowrap;'>
            <select id='input-price_type-$uniqueID'  class='form-control text-center'  style='display:none;'>$options</select>
            <button id='save-price_type-$uniqueID' class='btn btn-success' style='display:none;'><i class='fa fa-save' style='cursor:pointer; margin-left:4px;'></i></button></button>
       </div>

            ";
        }
    ),

array(
    'db' => "DATE_FORMAT(cp.valid_from, '%d/%m/%Y') AS valid_from",
        'dt' => 'valid_from',
        'field' => 'valid_from',
        'formatter' => function($d, $row) {
            $uniqueID = $row['customer_id'] . "-" . $row['item_id'] . "-" . $row['min_qty'];
            $displayValue = $d;
            if(empty($displayValue) || strcmp($displayValue,"00/00/0000") == 0) {
                $displayValue = '&nbsp;';
            }
            return "
            <div 
                 data-field-name='valid_from' 
                 style='position: relative; cursor: pointer;'
                 onmouseover='$(this).find(\".fa-pencil\").show();'
                 onmouseleave='$(this).find(\".fa-pencil\").hide();'
                 onclick='openEditField(\"$uniqueID\", \"valid_from\", this);'>
                <span id='value-valid_from-$uniqueID'>  $displayValue </span>
                <span id='pen-valid_from-$uniqueID'><i class='fa fa-pencil' style='display:none; cursor:pointer; margin-left:4px;'></i></span>
            </div>
            <div  style='white-space: nowrap;'>
                <input type='date' class='form-control text-center' id='input-valid_from-$uniqueID' value='' style='display:none;'>
                <button id='save-valid_from-$uniqueID' class='btn btn-success' style='display:none;'><i class='fa fa-save' style='cursor:pointer; margin-left:4px;'></i></button>
            </div>
        ";
        },
        'field' => 'valid_from'
    ),

    array(
        'db' => "DATE_FORMAT(cp.valid_until, '%d/%m/%Y') AS valid_until",
        'dt' => 'valid_until',
        'field' => 'valid_until',
        'formatter' => function($d, $row) {
            $uniqueID = $row['customer_id'] . "-" . $row['item_id'] . "-" . $row['min_qty'];
            $displayValue = $d;
            if(empty($displayValue)){
                $displayValue = '&nbsp;';
            }
            return "
            <div 
                 data-field-name='valid_until' 
                 style='position: relative; cursor: pointer;'
                 onmouseover='$(this).find(\".fa-pencil\").show();'
                 onmouseleave='$(this).find(\".fa-pencil\").hide();'
                 onclick='openEditField(\"$uniqueID\", \"valid_until\", this);'>
                <span id='value-valid_until-$uniqueID'>$displayValue</span>
                <span id='pen-valid_until-$uniqueID'><i class='fa fa-pencil' style='display:none; cursor:pointer; margin-left:4px;'></i></span>
            </div>
            <div  style='white-space: nowrap;'>
                <input type='date' class='form-control text-center' id='input-valid_until-$uniqueID' value='' style='display:none;'>
                <button id='save-valid_until-$uniqueID' class='btn btn-success' style='display:none;'><i class='fa fa-save' style='cursor:pointer; margin-left:4px;'></i></button>
            </div>
        ";
        },
        'field' => 'valid_until'
    )



);

global   $username,$password,$database;
// SQL server connection information
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db'   => $database,
    'host' => 'localhost'
);

$joinQuery = "FROM ContractPrices AS cp
               INNER JOIN Customers AS c ON cp.customer_id = c.customer_id
               INNER JOIN Items AS i ON i.item_id = cp.item_id
               LEFT JOIN PriceTypes as p ON p.pricetype_id = cp.pricetype_id";
$where = "";

require( ROOT.'backend/core/controllers/ssp2.class.php' );

echo json_encode(
    SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns, $joinQuery, $where )
);

?>
