<?php
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */
include_once('../../../../param.php');

// DB table to use
$table = 'Barcode_Schema';

// Table's primary key
$primaryKey = "barcode_schema_id";

// Array of database columns which should be read and sent back to DataTables.
$columns = array(
    array(
        'db' => 'barcode_schema_code',
        'dt' => 'code',
        'field' => 'barcode_schema_code'
    ),
    array(
        'db' => 'barcode_schema_text',
        'dt' => 'text',
        'field' => 'barcode_schema_text'
    ),
    array(
        'db' => 'prefix',
        'dt' => 'prefix',
        'field' => 'prefix'
    ),
    array(
        'db' => 'code_start',
        'dt' => 'codeStart',
        'field' => 'code_start'
    ),
    array(
        'db' => 'code_end',
        'dt' => 'codeEnd',
        'field' => 'code_end'
    ),
    array(
        'db' => 'qty_start',
        'dt' => 'qtyStart',
        'field' => 'qty_start'
    ),
    array(
        'db' => 'qty_end',
        'dt' => 'qtyEnd',
        'field' => 'qty_end'
    ),
    array(
        'db' => 'price_start',
        'dt' => 'priceStart',
        'field' => 'price_start'
    ),
    array(
        'db' => 'price_end',
        'dt' => 'priceEnd',
        'field' => 'price_end'
    ),
    array(
        'db' => 'qty_factor',
        'dt' => 'qtyFactor',
        'field' => 'qty_factor'
    ),
    array(
        'db' => 'price_factor',
        'dt' => 'priceFactor',
        'field' => 'price_factor'
    ),
    array(
        'db' => 'barcode_schema_id',
        'dt' => 'form',
        'formatter' => function ($d, $row) {
            $editButton = '<form id="edit_' . $d . '" action="//' . HTML_PATH . '/cop/backend/core/views/addedit/new_barcode_schema.php" method="post" style="display:inline;">
                <input type="hidden" name="barcodeSchemaID" value="' . $d . '">
                <input type="submit" class="btn btn-primary" value="Edit"> 
            </form>';

            return $editButton;
        },
        'field' => 'barcode_schema_id'
    )
);

// SQL server connection information
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db'   => $database,
    'host' => 'localhost'
);

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */
$joinQuery = "FROM Barcode_Schema";
$where = ''; // Add any specific where clauses if needed

require(ROOT . 'backend/core/controllers/ssp2.class.php');

echo json_encode(
    SSP::simple($_GET, $sql_details, $table, $primaryKey, $columns, $joinQuery, $where)
);
?>