<?php

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */

include_once("../../../../param.php");

// DB table to use
$table = 'Promotions';

// Table's primary key
$primaryKey = "promotion_id";

global $username, $password, $database;
$db = new mysqli(localhost, $username, $password, $database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

$columns = array(
    array(
        'db' => 'p.promotion_code',
        'dt' => 'code',
        'field' => 'promotion_code'
    ),
    array(
        'db' => 'promotion_name',
        'dt' => 'name',
        'field' => 'promotion_name'
    ),
    array(
        'db' => 'valid_from',
        'dt' => 'valid_from',
        'field' => 'valid_from',
        'formatter' => function($d, $row) {
            return date('d/m/Y', strtotime($d));
        }
    ),
    array(
        'db' => 'valid_until',
        'dt' => 'valid_until',
        'field' => 'valid_until',
        'formatter' => function($d, $row) {
            return date('d/m/Y', strtotime($d));
        }
    ),
    array(
        'db' => 'item_id',
        'dt' => 'item',
        'field' => 'item_id',
        'formatter' => function($d, $row) use ($db) {
            $stm = $db->prepare("SELECT CONCAT(item_code, ' - ', name) FROM Items WHERE item_id = ?");
            $stm->bind_param("i", $d);
            $stm->execute();
            $stm->bind_result($itemName);
            $stm->fetch();
            $stm->close();
            return $itemName;
        }
    ),
    array(
        'db' => 'type',
        'dt' => 'type',
        'field' => 'type',
        'formatter' => function($d) {
            switch ($d) {
                case 0: return "Quantity Discount";
                case 1: return "Multy Items Promotion";
                case 3: return "Category promotions";
                case 7: return "Category promotions with Extra Item";
                default: return "Unknown Promotion type";
            }
        }
    ),
    array(
        'db' => 'p.promotion_id',
        'dt' => 'form',
        'field' => 'promotion_id',
        'formatter' => function($d, $row) use ($db) {


            $stm = $db->prepare("SELECT status FROM Promotions WHERE promotion_id = ?");
            $stm->bind_param("i", $d);
            $stm->execute();
            $stm->bind_result($status);
            $stm->fetch();
            $stm->close();

            if (strcmp("$status", "yes") == 0) {
                $statusButton = '
                <button id="a' . $d . '" class="btn btn-danger" onclick="deactivateButtonClicked(' . $d . ');" style="width:100px;margin-top:5px;padding-top:2px;">Deactivate</button>
            ';
            } else {
                $statusButton = '
                <button id="a' . $d . '" class="btn btn-success" onclick="activateButtonClicked(' . $d . ');" style="width:100px;margin-top:5px;padding-top:2px;">Activate</button>
            ';
            }


            $editButton ='<a href="//' . HTML_PATH . '/cop/backend/core/views/addedit/new_promotion.php?promotionID=' . $d . '" class="btn btn-primary" style="margin-top:5px;padding-top:2px;">Edit</a> ' ;
            $viewButton= '<a href="//' . HTML_PATH . '/cop/backend/core/views/addedit/view_promotion.php?promotionID=' . $d . '" class="btn btn-success" style="margin-top:5px;padding-top:2px;margin-right:2px;">View</a>' ;

            return $viewButton. $editButton. $statusButton;


        }
    )
);



// SQL server connection information
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db'   => $database,
    'host' => 'localhost'
);

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */
$customersIDs      = $_GET['customerFilter'];
$salesPersonsIDs    = $_GET['salesPersonFilter'];
$customerGroupsIDs     = $_GET['customerGroupFilter'];
$extraItemsIDs    = $_GET['extraItemFilter'];


$joinQuery="FROM Promotions as p";
$where = '';

if (!empty($customersIDs)) {
    $where = "p.promotion_id IN (SELECT promotion_id FROM Promotion_Customer WHERE customer_id IN ($customersIDs))";
}

if (!empty($salesPersonsIDs)) {
    if(!empty($where)){
        $where.=" AND ";
    }
    $where = "p.promotion_id IN (SELECT promotion_id FROM Promotion_Salesperson WHERE salesperson_id IN ($salesPersonsIDs))";
}

if (!empty($customerGroupsIDs)) {
    if(!empty($where)){
        $where.=" AND ";
    }
    $where = "p.promotion_id IN (SELECT promotion_id FROM Promotion_Customer_Group WHERE group_id IN ($customerGroupsIDs))";
}

if (!empty($extraItemsIDs)) {
    if(!empty($where)){
        $where.=" AND ";
    }
    $where = "p.promotion_id IN (SELECT promotion_id FROM Promotion_Extra_Item WHERE item_id IN ($extraItemsIDs))";
}


require(ROOT . 'backend/core/controllers/ssp2.class.php');

echo json_encode(
    SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns, $joinQuery, $where )
);


?>